/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.ArrayType;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.NewArrayInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.ExprSwitch;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.NewArrayExpr;
import soot.tagkit.Tag;
import soot.util.Switch;

public abstract class AbstractNewArrayExpr
implements NewArrayExpr,
ConvertToBaf {
    Type baseType;
    ValueBox sizeBox;

    protected AbstractNewArrayExpr(Type type, ValueBox sizeBox) {
        this.baseType = type;
        this.sizeBox = sizeBox;
    }

    public boolean equivTo(Object o) {
        if (o instanceof AbstractNewArrayExpr) {
            AbstractNewArrayExpr ae = (AbstractNewArrayExpr)o;
            return this.sizeBox.getValue().equivTo(ae.sizeBox.getValue()) && this.baseType.equals(ae.baseType);
        }
        return false;
    }

    public int equivHashCode() {
        return this.sizeBox.getValue().equivHashCode() * 101 + this.baseType.hashCode() * 17;
    }

    public abstract Object clone();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        StringBuffer stringBuffer = new StringBuffer();
        Jimple.v();
        buffer.append(stringBuffer.append("newarray").append(" (").append(this.getBaseTypeString()).append(")").toString());
        buffer.append("[" + this.sizeBox.getValue().toString() + "]");
        return buffer.toString();
    }

    public void toString(UnitPrinter up) {
        Jimple.v();
        up.literal("newarray");
        up.literal(" ");
        up.literal("(");
        up.type(this.baseType);
        up.literal(")");
        up.literal("[");
        this.sizeBox.toString(up);
        up.literal("]");
    }

    private String getBaseTypeString() {
        return this.baseType.toString();
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public void setBaseType(Type type) {
        this.baseType = type;
    }

    public ValueBox getSizeBox() {
        return this.sizeBox;
    }

    public Value getSize() {
        return this.sizeBox.getValue();
    }

    public void setSize(Value size) {
        this.sizeBox.setValue(size);
    }

    public List getUseBoxes() {
        ArrayList<ValueBox> useBoxes = new ArrayList<ValueBox>();
        useBoxes.addAll(this.sizeBox.getValue().getUseBoxes());
        useBoxes.add(this.sizeBox);
        return useBoxes;
    }

    public Type getType() {
        if (this.baseType instanceof ArrayType) {
            return ArrayType.v(((ArrayType)this.baseType).baseType, ((ArrayType)this.baseType).numDimensions + 1);
        }
        return ArrayType.v(this.baseType, 1);
    }

    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseNewArrayExpr(this);
    }

    public void convertToBaf(JimpleToBafContext context, List out) {
        ((ConvertToBaf)((Object)this.getSize())).convertToBaf(context, out);
        NewArrayInst u = Baf.v().newNewArrayInst(this.getBaseType());
        out.add(u);
        Unit currentUnit = context.getCurrentUnit();
        Iterator it = currentUnit.getTags().iterator();
        while (it.hasNext()) {
            u.addTag((Tag)it.next());
        }
    }
}

