/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.Iterator;
import java.util.List;
import soot.DoubleType;
import soot.LongType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.ValueBox;
import soot.VoidType;
import soot.baf.Baf;
import soot.baf.InterfaceInvokeInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.ExprSwitch;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.JimpleToBafContext;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.tagkit.Tag;
import soot.util.Switch;

public abstract class AbstractInterfaceInvokeExpr
extends AbstractInstanceInvokeExpr
implements InterfaceInvokeExpr,
ConvertToBaf {
    protected AbstractInterfaceInvokeExpr(ValueBox baseBox, SootMethod method, ValueBox[] argBoxes) {
        this.baseBox = baseBox;
        this.method = method;
        this.argBoxes = argBoxes;
    }

    public boolean equivTo(Object o) {
        if (o instanceof AbstractInterfaceInvokeExpr) {
            AbstractInterfaceInvokeExpr ie = (AbstractInterfaceInvokeExpr)o;
            if (!this.baseBox.getValue().equivTo(ie.baseBox.getValue()) || !this.method.equals(ie.method) || this.argBoxes.length != ie.argBoxes.length) {
                return false;
            }
            for (int i = 0; i < this.argBoxes.length; ++i) {
                if (this.argBoxes[i].getValue().equivTo(ie.argBoxes[i].getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int equivHashCode() {
        return this.baseBox.getValue().equivHashCode() * 101 + this.method.equivHashCode() * 17;
    }

    public abstract Object clone();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("interfaceinvoke " + this.baseBox.getValue().toString() + "." + this.method.getSignature() + "(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.argBoxes[i].getValue().toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    public void toString(UnitPrinter up) {
        up.literal("interfaceinvoke");
        up.literal(" ");
        this.baseBox.toString(up);
        up.literal(".");
        up.method(this.method);
        up.literal("(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                up.literal(", ");
            }
            this.argBoxes[i].toString(up);
        }
        up.literal(")");
    }

    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseInterfaceInvokeExpr(this);
    }

    int sizeOfType(Type t) {
        if (t instanceof DoubleType || t instanceof LongType) {
            return 2;
        }
        if (t instanceof VoidType) {
            return 0;
        }
        return 1;
    }

    int argCountOf(SootMethod m) {
        int argCount = 0;
        Iterator typeIt = m.getParameterTypes().iterator();
        while (typeIt.hasNext()) {
            Type t = (Type)typeIt.next();
            argCount += this.sizeOfType(t);
        }
        return argCount;
    }

    public void convertToBaf(JimpleToBafContext context, List out) {
        ((ConvertToBaf)((Object)this.getBase())).convertToBaf(context, out);
        for (int i = 0; i < this.argBoxes.length; ++i) {
            ((ConvertToBaf)((Object)this.argBoxes[i].getValue())).convertToBaf(context, out);
        }
        InterfaceInvokeInst u = Baf.v().newInterfaceInvokeInst(this.method, this.argCountOf(this.method));
        out.add(u);
        Unit currentUnit = context.getCurrentUnit();
        Iterator it = currentUnit.getTags().iterator();
        while (it.hasNext()) {
            u.addTag((Tag)it.next());
        }
    }
}

