/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.Scene;
import soot.SootField;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.FieldGetInst;
import soot.grimp.PrecedenceTest;
import soot.jimple.ConvertToBaf;
import soot.jimple.InstanceFieldRef;
import soot.jimple.JimpleToBafContext;
import soot.jimple.RefSwitch;
import soot.tagkit.Tag;
import soot.util.Switch;

public abstract class AbstractInstanceFieldRef
implements InstanceFieldRef,
ConvertToBaf {
    transient SootField field;
    ValueBox baseBox;

    protected AbstractInstanceFieldRef(ValueBox baseBox, SootField field) {
        this.baseBox = baseBox;
        this.field = field;
    }

    public abstract Object clone();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.field = Scene.v().getField((String)in.readObject());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.field.getSignature());
    }

    public String toString() {
        return this.baseBox.getValue().toString() + "." + this.field.getSignature();
    }

    public void toString(UnitPrinter up) {
        if (PrecedenceTest.needsBrackets(this.baseBox, this)) {
            up.literal("(");
        }
        this.baseBox.toString(up);
        if (PrecedenceTest.needsBrackets(this.baseBox, this)) {
            up.literal(")");
        }
        up.literal(".");
        up.fieldRef(this.field);
    }

    public Value getBase() {
        return this.baseBox.getValue();
    }

    public ValueBox getBaseBox() {
        return this.baseBox;
    }

    public void setBase(Value base) {
        this.baseBox.setValue(base);
    }

    public SootField getField() {
        return this.field;
    }

    public void setField(SootField field) {
        this.field = field;
    }

    public List getUseBoxes() {
        ArrayList<ValueBox> useBoxes = new ArrayList<ValueBox>();
        useBoxes.addAll(this.baseBox.getValue().getUseBoxes());
        useBoxes.add(this.baseBox);
        return useBoxes;
    }

    public Type getType() {
        return this.field.getType();
    }

    public void apply(Switch sw) {
        ((RefSwitch)sw).caseInstanceFieldRef(this);
    }

    public boolean equivTo(Object o) {
        if (o instanceof AbstractInstanceFieldRef) {
            AbstractInstanceFieldRef fr = (AbstractInstanceFieldRef)o;
            return fr.field.equals(this.field) && fr.baseBox.getValue().equivTo(this.baseBox.getValue());
        }
        return false;
    }

    public int equivHashCode() {
        return this.field.equivHashCode() * 101 + this.baseBox.getValue().equivHashCode() + 17;
    }

    public void convertToBaf(JimpleToBafContext context, List out) {
        ((ConvertToBaf)((Object)this.getBase())).convertToBaf(context, out);
        FieldGetInst u = Baf.v().newFieldGetInst(this.field);
        out.add(u);
        Unit currentUnit = context.getCurrentUnit();
        Iterator it = currentUnit.getTags().iterator();
        while (it.hasNext()) {
            u.addTag((Tag)it.next());
        }
    }
}

