/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.IntegerType;
import soot.Local;
import soot.LongType;
import soot.Modifier;
import soot.NullType;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.PrimType;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.StmtAddressType;
import soot.Timers;
import soot.Trap;
import soot.Type;
import soot.TypeSwitch;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.grimp.AbstractGrimpValueSwitch;
import soot.grimp.NewInvokeExpr;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GroupIntPair;
import soot.jimple.GtExpr;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.ParameterRef;
import soot.jimple.RemExpr;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.jimple.internal.StmtBox;
import soot.options.Options;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.scalar.FastColorer;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLocalDefs;
import soot.toolkits.scalar.SimpleLocalUses;

public class JasminClass {
    Map stmtToLabel;
    Map localToSlot;
    Map subroutineToReturnAddressSlot;
    List code;
    boolean isEmittingMethodCode;
    int labelCount;
    boolean isNextGotoAJsr;
    int returnAddressSlot;
    int currentStackHeight = 0;
    int maxStackHeight = 0;
    Map localToGroup;
    Map groupToColorCount;
    Map localToColor;
    Value plusPlusValue;
    Local plusPlusHolder;
    int plusPlusState;
    int plusPlusPlace;
    int plusPlusHeight;
    Stmt plusPlusIncrementer;

    static String slashify(String s) {
        return s.replace('.', '/');
    }

    static int sizeOfType(Type t) {
        if (t instanceof DoubleType || t instanceof LongType) {
            return 2;
        }
        if (t instanceof VoidType) {
            return 0;
        }
        return 1;
    }

    static int argCountOf(SootMethod m) {
        int argCount = 0;
        Iterator typeIt = m.getParameterTypes().iterator();
        while (typeIt.hasNext()) {
            Type t = (Type)typeIt.next();
            argCount += JasminClass.sizeOfType(t);
        }
        return argCount;
    }

    static String jasminDescriptorOf(Type type) {
        TypeSwitch sw = new TypeSwitch(){

            public void caseBooleanType(BooleanType t) {
                this.setResult("Z");
            }

            public void caseByteType(ByteType t) {
                this.setResult("B");
            }

            public void caseCharType(CharType t) {
                this.setResult("C");
            }

            public void caseDoubleType(DoubleType t) {
                this.setResult("D");
            }

            public void caseFloatType(FloatType t) {
                this.setResult("F");
            }

            public void caseIntType(IntType t) {
                this.setResult("I");
            }

            public void caseLongType(LongType t) {
                this.setResult("J");
            }

            public void caseShortType(ShortType t) {
                this.setResult("S");
            }

            public void defaultCase(Type t) {
                throw new RuntimeException("Invalid type: " + t);
            }

            public void caseArrayType(ArrayType t) {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < t.numDimensions; ++i) {
                    buffer.append("[");
                }
                this.setResult(buffer.toString() + JasminClass.jasminDescriptorOf(t.baseType));
            }

            public void caseRefType(RefType t) {
                this.setResult("L" + t.getClassName().replace('.', '/') + ";");
            }

            public void caseVoidType(VoidType t) {
                this.setResult("V");
            }
        };
        type.apply(sw);
        return (String)sw.getResult();
    }

    public static String jasminDescriptorOf(SootMethod m) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        Iterator typeIt = m.getParameterTypes().iterator();
        while (typeIt.hasNext()) {
            Type t = (Type)typeIt.next();
            buffer.append(JasminClass.jasminDescriptorOf(t));
        }
        buffer.append(")");
        buffer.append(JasminClass.jasminDescriptorOf(m.getReturnType()));
        return buffer.toString();
    }

    void emit(String s) {
        this.okayEmit(s);
    }

    void okayEmit(String s) {
        if (this.isEmittingMethodCode && !s.endsWith(":")) {
            this.code.add("    " + s);
        } else {
            this.code.add(s);
        }
    }

    void emit(String s, int stackChange) {
        this.modifyStackHeight(stackChange);
        this.okayEmit(s);
    }

    void modifyStackHeight(int stackChange) {
        this.currentStackHeight += stackChange;
        if (this.currentStackHeight < 0) {
            throw new RuntimeException("Stack height is negative!");
        }
        if (this.currentStackHeight > this.maxStackHeight) {
            this.maxStackHeight = this.currentStackHeight;
        }
    }

    public JasminClass(SootClass SootClass2) {
        HashMap options = new HashMap();
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.start();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + SootClass2.getName() + "] Constructing jimple.JasminClass...");
        }
        this.code = new LinkedList();
        int modifiers = SootClass2.getModifiers();
        if (Modifier.isInterface(modifiers)) {
            this.emit(".interface " + Modifier.toString(modifiers -= 512) + " " + JasminClass.slashify(SootClass2.getName()));
        } else {
            this.emit(".class " + Modifier.toString(modifiers) + " " + JasminClass.slashify(SootClass2.getName()));
        }
        if (SootClass2.hasSuperclass()) {
            this.emit(".super " + JasminClass.slashify(SootClass2.getSuperclass().getName()));
        } else {
            this.emit(".super " + JasminClass.slashify(SootClass2.getName()));
        }
        this.emit("");
        Iterator interfaceIt = SootClass2.getInterfaces().iterator();
        while (interfaceIt.hasNext()) {
            SootClass inter = (SootClass)interfaceIt.next();
            this.emit(".implements " + JasminClass.slashify(inter.getName()));
        }
        if (SootClass2.getInterfaceCount() != 0) {
            this.emit("");
        }
        Iterator fieldIt = SootClass2.getFields().iterator();
        while (fieldIt.hasNext()) {
            SootField field = (SootField)fieldIt.next();
            this.emit(".field " + Modifier.toString(field.getModifiers()) + " " + "\"" + field.getName() + "\"" + " " + JasminClass.jasminDescriptorOf(field.getType()));
        }
        if (SootClass2.getFieldCount() != 0) {
            this.emit("");
        }
        Iterator methodIt = SootClass2.methodIterator();
        while (methodIt.hasNext()) {
            this.emitMethod((SootMethod)methodIt.next(), options);
            this.emit("");
        }
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.end();
        }
    }

    void assignColorsToLocals(StmtBody body) {
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Assigning colors to locals...");
        }
        if (Options.v().time()) {
            Timers.v().packTimer.start();
        }
        this.localToGroup = new HashMap(body.getLocalCount() * 2 + 1, 0.7f);
        this.groupToColorCount = new HashMap(body.getLocalCount() * 2 + 1, 0.7f);
        this.localToColor = new HashMap(body.getLocalCount() * 2 + 1, 0.7f);
        Iterator localIt = body.getLocals().iterator();
        while (localIt.hasNext()) {
            Local l = (Local)localIt.next();
            PrimType g = JasminClass.sizeOfType(l.getType()) == 1 ? IntType.v() : LongType.v();
            this.localToGroup.put(l, g);
            if (this.groupToColorCount.containsKey(g)) continue;
            this.groupToColorCount.put(g, new Integer(0));
        }
        Iterator codeIt = body.getUnits().iterator();
        while (codeIt.hasNext()) {
            Stmt s = (Stmt)codeIt.next();
            if (!(s instanceof IdentityStmt) || !(((IdentityStmt)s).getLeftOp() instanceof Local)) continue;
            Local l = (Local)((IdentityStmt)s).getLeftOp();
            Object group = this.localToGroup.get(l);
            int count = (Integer)this.groupToColorCount.get(group);
            this.localToColor.put(l, new Integer(count));
            this.groupToColorCount.put(group, new Integer(++count));
        }
        FastColorer.assignColorsToLocals(body, this.localToGroup, this.localToColor, this.groupToColorCount);
        if (Options.v().time()) {
            Timers.v().packTimer.end();
        }
    }

    void emitMethod(SootMethod method, Map options) {
        if (method.isPhantom()) {
            return;
        }
        this.emit(".method " + Modifier.toString(method.getModifiers()) + " " + method.getName() + JasminClass.jasminDescriptorOf(method));
        if (method.isConcrete()) {
            if (!method.hasActiveBody()) {
                throw new RuntimeException("method: " + method.getName() + " has no active body!");
            }
            this.emitMethodBody(method, options);
        }
        this.emit(".end method");
    }

    void emitMethodBody(SootMethod method, Map options) {
        Body activeBody;
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.end();
        }
        if (!((activeBody = method.getActiveBody()) instanceof StmtBody)) {
            throw new RuntimeException("method: " + method.getName() + " has an invalid active body!");
        }
        StmtBody body = (StmtBody)activeBody;
        body.validate();
        if (body == null && Options.v().time()) {
            Timers.v().buildJasminTimer.start();
        }
        PatchingChain units = body.getUnits();
        CompleteUnitGraph stmtGraph = null;
        SimpleLocalDefs ld = null;
        SimpleLocalUses lu = null;
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Performing peephole optimizations...");
        }
        boolean disablePeephole = PhaseOptions.getBoolean(options, "no-peephole");
        disablePeephole = true;
        if (!disablePeephole) {
            stmtGraph = new CompleteUnitGraph(body);
            ld = new SimpleLocalDefs(stmtGraph);
            lu = new SimpleLocalUses(stmtGraph, (LocalDefs)ld);
        }
        int stackLimitIndex = -1;
        this.subroutineToReturnAddressSlot = new HashMap(10, 0.7f);
        Iterator boxIt = body.getUnitBoxes(true).iterator();
        this.stmtToLabel = new HashMap(units.size() * 2 + 1, 0.7f);
        this.labelCount = 0;
        while (boxIt.hasNext()) {
            StmtBox box = (StmtBox)boxIt.next();
            if (this.stmtToLabel.containsKey(box.getUnit())) continue;
            this.stmtToLabel.put(box.getUnit(), "label" + this.labelCount++);
        }
        Iterator trapIt = body.getTraps().iterator();
        while (trapIt.hasNext()) {
            Trap trap = (Trap)trapIt.next();
            if (trap.getBeginUnit() == trap.getEndUnit()) continue;
            this.emit(".catch " + JasminClass.slashify(trap.getException().getName()) + " from " + this.stmtToLabel.get(trap.getBeginUnit()) + " to " + this.stmtToLabel.get(trap.getEndUnit()) + " using " + this.stmtToLabel.get(trap.getHandlerUnit()));
        }
        int localCount = 0;
        int[] paramSlots = new int[method.getParameterCount()];
        int thisSlot = 0;
        HashSet<Local> assignedLocals = new HashSet<Local>();
        HashMap<GroupIntPair, Integer> groupColorPairToSlot = new HashMap<GroupIntPair, Integer>(body.getLocalCount() * 2 + 1, 0.7f);
        this.localToSlot = new HashMap(body.getLocalCount() * 2 + 1, 0.7f);
        this.assignColorsToLocals(body);
        List paramTypes = method.getParameterTypes();
        if (!method.isStatic()) {
            thisSlot = 0;
            ++localCount;
        }
        for (int i = 0; i < paramTypes.size(); ++i) {
            paramSlots[i] = localCount;
            localCount += JasminClass.sizeOfType((Type)paramTypes.get(i));
        }
        Iterator stmtIt = units.iterator();
        while (stmtIt.hasNext()) {
            Stmt s = (Stmt)stmtIt.next();
            if (!(s instanceof IdentityStmt) || !(((IdentityStmt)s).getLeftOp() instanceof Local)) continue;
            Local l = (Local)((IdentityStmt)s).getLeftOp();
            IdentityRef identity = (IdentityRef)((IdentityStmt)s).getRightOp();
            int slot = 0;
            if (identity instanceof ThisRef) {
                if (method.isStatic()) {
                    throw new RuntimeException("Attempting to use 'this' in static method");
                }
                slot = thisSlot;
            } else {
                if (!(identity instanceof ParameterRef)) continue;
                slot = paramSlots[((ParameterRef)identity).getIndex()];
            }
            GroupIntPair pair = new GroupIntPair(this.localToGroup.get(l), (Integer)this.localToColor.get(l));
            groupColorPairToSlot.put(pair, new Integer(slot));
            this.localToSlot.put(l, new Integer(slot));
            assignedLocals.add(l);
        }
        Iterator localIt = body.getLocals().iterator();
        while (localIt.hasNext()) {
            int slot;
            Local local = (Local)localIt.next();
            if (assignedLocals.contains(local)) continue;
            GroupIntPair pair = new GroupIntPair(this.localToGroup.get(local), (Integer)this.localToColor.get(local));
            if (groupColorPairToSlot.containsKey(pair)) {
                slot = (Integer)groupColorPairToSlot.get(pair);
            } else {
                slot = localCount;
                localCount += JasminClass.sizeOfType(local.getType());
                groupColorPairToSlot.put(pair, new Integer(slot));
            }
            this.localToSlot.put(local, new Integer(slot));
            assignedLocals.add(local);
        }
        if (!Modifier.isNative(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers())) {
            this.emit("    .limit stack ?");
            stackLimitIndex = this.code.size() - 1;
            this.emit("    .limit locals " + localCount);
        }
        Iterator codeIt = units.iterator();
        this.isEmittingMethodCode = true;
        this.maxStackHeight = 0;
        this.isNextGotoAJsr = false;
        while (codeIt.hasNext()) {
            boolean contFlag;
            Stmt s;
            block32: {
                Value rvalue;
                Value lvalue;
                Stmt nextNextStmt;
                AssignStmt nextStmt;
                AssignStmt stmt;
                block34: {
                    block33: {
                        Value added;
                        AddExpr addexp;
                        ValueBox box;
                        List l;
                        Stmt ns;
                        s = (Stmt)codeIt.next();
                        if (this.stmtToLabel.containsKey(s)) {
                            this.emit(this.stmtToLabel.get(s) + ":");
                        }
                        if (this.subroutineToReturnAddressSlot.containsKey(s)) {
                            AssignStmt assignStmt = (AssignStmt)s;
                            this.modifyStackHeight(1);
                            int slot = (Integer)this.localToSlot.get(assignStmt.getLeftOp());
                            if (slot >= 0 && slot <= 3) {
                                this.emit("astore_" + slot, -1);
                            } else {
                                this.emit("astore " + slot, -1);
                            }
                        }
                        contFlag = false;
                        if (disablePeephole || !(s instanceof AssignStmt)) break block32;
                        stmt = (AssignStmt)s;
                        if (!codeIt.hasNext() || !((ns = (Stmt)stmtGraph.getSuccsOf(stmt).get(0)) instanceof AssignStmt) || (l = stmtGraph.getSuccsOf(nextStmt = (AssignStmt)ns)).size() != 1) break block32;
                        nextNextStmt = (Stmt)l.get(0);
                        lvalue = stmt.getLeftOp();
                        rvalue = stmt.getRightOp();
                        if (!(lvalue instanceof Local) || !(lvalue instanceof Local) || !nextStmt.getLeftOp().equivTo(rvalue) || !(nextStmt.getRightOp() instanceof AddExpr)) break block32;
                        Iterator boxIt2 = nextNextStmt.getUseBoxes().iterator();
                        boolean foundExactlyOnce = false;
                        while (boxIt2.hasNext()) {
                            box = (ValueBox)boxIt2.next();
                            if (box.getValue() != lvalue) continue;
                            if (!foundExactlyOnce) {
                                foundExactlyOnce = true;
                                continue;
                            }
                            foundExactlyOnce = false;
                            break;
                        }
                        if (!foundExactlyOnce) break block32;
                        boxIt2 = nextNextStmt.getDefBoxes().iterator();
                        boolean found = false;
                        while (boxIt2.hasNext()) {
                            box = (ValueBox)boxIt2.next();
                            if (!box.getValue().equivTo(rvalue)) continue;
                            found = true;
                        }
                        if (found || !(addexp = (AddExpr)nextStmt.getRightOp()).getOp1().equivTo(lvalue) && !addexp.getOp1().equivTo(rvalue) || !((added = addexp.getOp2()) instanceof IntConstant) || ((IntConstant)added).value != 1) break block32;
                        if (!addexp.getOp1().equivTo(lvalue)) break block33;
                        if (lu.getUsesOf(stmt).size() != 2 || ld.getDefsOfAt((Local)lvalue, nextStmt).size() != 1 || ld.getDefsOfAt((Local)lvalue, nextNextStmt).size() != 1) break block32;
                        this.plusPlusState = 0;
                        break block34;
                    }
                    if (lu.getUsesOf(stmt).size() != 1 || ld.getDefsOfAt((Local)lvalue, nextNextStmt).size() != 1) break block32;
                    this.plusPlusState = 10;
                }
                if (lvalue.getType() == IntType.v()) {
                    this.currentStackHeight = 0;
                    this.plusPlusValue = rvalue;
                    this.plusPlusHolder = (Local)lvalue;
                    this.plusPlusIncrementer = nextStmt;
                    this.emitStmt(nextNextStmt);
                    if (this.plusPlusHolder != null) {
                        this.emitStmt(stmt);
                        this.emitStmt(nextStmt);
                    }
                    if (this.currentStackHeight != 0) {
                        throw new RuntimeException("Stack has height " + this.currentStackHeight + " after execution of stmt: " + s);
                    }
                    contFlag = true;
                    codeIt.next();
                    codeIt.next();
                }
            }
            if (contFlag) continue;
            this.currentStackHeight = 0;
            this.emitStmt(s);
            if (this.currentStackHeight == 0) continue;
            throw new RuntimeException("Stack has height " + this.currentStackHeight + " after execution of stmt: " + s);
        }
        this.isEmittingMethodCode = false;
        if (!Modifier.isNative(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers())) {
            this.code.set(stackLimitIndex, "    .limit stack " + this.maxStackHeight);
        }
    }

    public void print(PrintWriter out) {
        Iterator it = this.code.iterator();
        while (it.hasNext()) {
            out.println(it.next());
        }
    }

    void emitAssignStmt(AssignStmt stmt) {
        Value lvalue = stmt.getLeftOp();
        final Value rvalue = stmt.getRightOp();
        if (lvalue instanceof Local && (rvalue instanceof AddExpr || rvalue instanceof SubExpr)) {
            Local l = (Local)lvalue;
            BinopExpr expr = (BinopExpr)rvalue;
            Value op1 = expr.getOp1();
            Value op2 = expr.getOp2();
            if (lvalue == this.plusPlusHolder) {
                this.emitValue(lvalue);
                this.plusPlusHolder = null;
                this.plusPlusState = 0;
            }
            if (l.getType().equals(IntType.v())) {
                boolean isValidCase = false;
                int x = 0;
                if (op1 == l && op2 instanceof IntConstant) {
                    x = ((IntConstant)op2).value;
                    isValidCase = true;
                } else if (expr instanceof AddExpr && op2 == l && op1 instanceof IntConstant) {
                    x = ((IntConstant)op1).value;
                    isValidCase = true;
                }
                if (isValidCase && x >= Short.MIN_VALUE && x <= Short.MAX_VALUE) {
                    this.emit("iinc " + (Integer)this.localToSlot.get(l) + " " + (expr instanceof AddExpr ? x : -x), 0);
                    return;
                }
            }
        }
        lvalue.apply(new AbstractJimpleValueSwitch(){

            public void caseArrayRef(ArrayRef v) {
                JasminClass.this.emitValue(v.getBase());
                JasminClass.this.emitValue(v.getIndex());
                JasminClass.this.emitValue(rvalue);
                v.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void caseArrayType(ArrayType t) {
                        2.access$000(this.this$1).emit("aastore", -3);
                    }

                    public void caseDoubleType(DoubleType t) {
                        2.access$000(this.this$1).emit("dastore", -4);
                    }

                    public void caseFloatType(FloatType t) {
                        2.access$000(this.this$1).emit("fastore", -3);
                    }

                    public void caseIntType(IntType t) {
                        2.access$000(this.this$1).emit("iastore", -3);
                    }

                    public void caseLongType(LongType t) {
                        2.access$000(this.this$1).emit("lastore", -4);
                    }

                    public void caseRefType(RefType t) {
                        2.access$000(this.this$1).emit("aastore", -3);
                    }

                    public void caseByteType(ByteType t) {
                        2.access$000(this.this$1).emit("bastore", -3);
                    }

                    public void caseBooleanType(BooleanType t) {
                        2.access$000(this.this$1).emit("bastore", -3);
                    }

                    public void caseCharType(CharType t) {
                        2.access$000(this.this$1).emit("castore", -3);
                    }

                    public void caseShortType(ShortType t) {
                        2.access$000(this.this$1).emit("sastore", -3);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid type: " + t);
                    }
                });
            }

            public void defaultCase(Value v) {
                throw new RuntimeException("Can't store in value " + v);
            }

            public void caseInstanceFieldRef(InstanceFieldRef v) {
                JasminClass.this.emitValue(v.getBase());
                JasminClass.this.emitValue(rvalue);
                JasminClass.this.emit("putfield " + JasminClass.slashify(v.getField().getDeclaringClass().getName()) + "/" + v.getField().getName() + " " + JasminClass.jasminDescriptorOf(v.getField().getType()), -1 + -JasminClass.sizeOfType(v.getField().getType()));
            }

            public void caseLocal(Local v) {
                int slot = (Integer)JasminClass.this.localToSlot.get(v);
                v.getType().apply(new TypeSwitch(this, slot){
                    private final /* synthetic */ int val$slot;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$slot = val$slot;
                    }

                    private void handleIntegerType(IntegerType t) {
                        2.access$000(this.this$1).emitValue(2.access$100(this.this$1));
                        if (this.val$slot >= 0 && this.val$slot <= 3) {
                            2.access$000(this.this$1).emit("istore_" + this.val$slot, -1);
                        } else {
                            2.access$000(this.this$1).emit("istore " + this.val$slot, -1);
                        }
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntegerType(t);
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntegerType(t);
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntegerType(t);
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntegerType(t);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntegerType(t);
                    }

                    public void caseArrayType(ArrayType t) {
                        2.access$000(this.this$1).emitValue(2.access$100(this.this$1));
                        if (this.val$slot >= 0 && this.val$slot <= 3) {
                            2.access$000(this.this$1).emit("astore_" + this.val$slot, -1);
                        } else {
                            2.access$000(this.this$1).emit("astore " + this.val$slot, -1);
                        }
                    }

                    public void caseDoubleType(DoubleType t) {
                        2.access$000(this.this$1).emitValue(2.access$100(this.this$1));
                        if (this.val$slot >= 0 && this.val$slot <= 3) {
                            2.access$000(this.this$1).emit("dstore_" + this.val$slot, -2);
                        } else {
                            2.access$000(this.this$1).emit("dstore " + this.val$slot, -2);
                        }
                    }

                    public void caseFloatType(FloatType t) {
                        2.access$000(this.this$1).emitValue(2.access$100(this.this$1));
                        if (this.val$slot >= 0 && this.val$slot <= 3) {
                            2.access$000(this.this$1).emit("fstore_" + this.val$slot, -1);
                        } else {
                            2.access$000(this.this$1).emit("fstore " + this.val$slot, -1);
                        }
                    }

                    public void caseLongType(LongType t) {
                        2.access$000(this.this$1).emitValue(2.access$100(this.this$1));
                        if (this.val$slot >= 0 && this.val$slot <= 3) {
                            2.access$000(this.this$1).emit("lstore_" + this.val$slot, -2);
                        } else {
                            2.access$000(this.this$1).emit("lstore " + this.val$slot, -2);
                        }
                    }

                    public void caseRefType(RefType t) {
                        2.access$000(this.this$1).emitValue(2.access$100(this.this$1));
                        if (this.val$slot >= 0 && this.val$slot <= 3) {
                            2.access$000(this.this$1).emit("astore_" + this.val$slot, -1);
                        } else {
                            2.access$000(this.this$1).emit("astore " + this.val$slot, -1);
                        }
                    }

                    public void caseStmtAddressType(StmtAddressType t) {
                        2.access$000(this.this$1).isNextGotoAJsr = true;
                        2.access$000(this.this$1).returnAddressSlot = this.val$slot;
                    }

                    public void caseNullType(NullType t) {
                        2.access$000(this.this$1).emitValue(2.access$100(this.this$1));
                        if (this.val$slot >= 0 && this.val$slot <= 3) {
                            2.access$000(this.this$1).emit("astore_" + this.val$slot, -1);
                        } else {
                            2.access$000(this.this$1).emit("astore " + this.val$slot, -1);
                        }
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid local type: " + t);
                    }
                });
            }

            public void caseStaticFieldRef(StaticFieldRef v) {
                SootField field = v.getField();
                JasminClass.this.emitValue(rvalue);
                JasminClass.this.emit("putstatic " + JasminClass.slashify(field.getDeclaringClass().getName()) + "/" + field.getName() + " " + JasminClass.jasminDescriptorOf(field.getType()), -JasminClass.sizeOfType(v.getField().getType()));
            }

            static /* synthetic */ JasminClass access$000(2 x0) {
                return x0.JasminClass.this;
            }

            static /* synthetic */ Value access$100(2 x0) {
                return x0.rvalue;
            }
        });
    }

    void emitIfStmt(IfStmt stmt) {
        Value cond = stmt.getCondition();
        final Value op1 = ((BinopExpr)cond).getOp1();
        Value op2 = ((BinopExpr)cond).getOp2();
        final String label = (String)this.stmtToLabel.get(stmt.getTarget());
        if (op2 instanceof NullConstant || op1 instanceof NullConstant) {
            if (op2 instanceof NullConstant) {
                this.emitValue(op1);
            } else {
                this.emitValue(op2);
            }
            if (cond instanceof EqExpr) {
                this.emit("ifnull " + label, -1);
            } else if (cond instanceof NeExpr) {
                this.emit("ifnonnull " + label, -1);
            } else {
                throw new RuntimeException("invalid condition");
            }
            return;
        }
        if (op2 instanceof IntConstant && ((IntConstant)op2).value == 0) {
            this.emitValue(op1);
            cond.apply(new AbstractJimpleValueSwitch(){

                public void caseEqExpr(EqExpr expr) {
                    JasminClass.this.emit("ifeq " + label, -1);
                }

                public void caseNeExpr(NeExpr expr) {
                    JasminClass.this.emit("ifne " + label, -1);
                }

                public void caseLtExpr(LtExpr expr) {
                    JasminClass.this.emit("iflt " + label, -1);
                }

                public void caseLeExpr(LeExpr expr) {
                    JasminClass.this.emit("ifle " + label, -1);
                }

                public void caseGtExpr(GtExpr expr) {
                    JasminClass.this.emit("ifgt " + label, -1);
                }

                public void caseGeExpr(GeExpr expr) {
                    JasminClass.this.emit("ifge " + label, -1);
                }

                public void defaultCase(Value v) {
                    throw new RuntimeException("invalid condition " + v);
                }
            });
            return;
        }
        if (op1 instanceof IntConstant && ((IntConstant)op1).value == 0) {
            this.emitValue(op2);
            cond.apply(new AbstractJimpleValueSwitch(){

                public void caseEqExpr(EqExpr expr) {
                    JasminClass.this.emit("ifeq " + label, -1);
                }

                public void caseNeExpr(NeExpr expr) {
                    JasminClass.this.emit("ifne " + label, -1);
                }

                public void caseLtExpr(LtExpr expr) {
                    JasminClass.this.emit("ifgt " + label, -1);
                }

                public void caseLeExpr(LeExpr expr) {
                    JasminClass.this.emit("ifge " + label, -1);
                }

                public void caseGtExpr(GtExpr expr) {
                    JasminClass.this.emit("iflt " + label, -1);
                }

                public void caseGeExpr(GeExpr expr) {
                    JasminClass.this.emit("ifle " + label, -1);
                }

                public void defaultCase(Value v) {
                    throw new RuntimeException("invalid condition " + v);
                }
            });
            return;
        }
        this.emitValue(op1);
        this.emitValue(op2);
        cond.apply(new AbstractJimpleValueSwitch(){

            public void caseEqExpr(EqExpr expr) {
                op1.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void caseIntType(IntType t) {
                        7.access$300(this.this$1).emit("if_icmpeq " + 7.access$200(this.this$1), -2);
                    }

                    public void caseBooleanType(BooleanType t) {
                        7.access$300(this.this$1).emit("if_icmpeq " + 7.access$200(this.this$1), -2);
                    }

                    public void caseShortType(ShortType t) {
                        7.access$300(this.this$1).emit("if_icmpeq " + 7.access$200(this.this$1), -2);
                    }

                    public void caseCharType(CharType t) {
                        7.access$300(this.this$1).emit("if_icmpeq " + 7.access$200(this.this$1), -2);
                    }

                    public void caseByteType(ByteType t) {
                        7.access$300(this.this$1).emit("if_icmpeq " + 7.access$200(this.this$1), -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        7.access$300(this.this$1).emit("dcmpg", -3);
                        7.access$300(this.this$1).emit("ifeq " + 7.access$200(this.this$1), -1);
                    }

                    public void caseLongType(LongType t) {
                        7.access$300(this.this$1).emit("lcmp", -3);
                        7.access$300(this.this$1).emit("ifeq " + 7.access$200(this.this$1), -1);
                    }

                    public void caseFloatType(FloatType t) {
                        7.access$300(this.this$1).emit("fcmpg", -1);
                        7.access$300(this.this$1).emit("ifeq " + 7.access$200(this.this$1), -1);
                    }

                    public void caseArrayType(ArrayType t) {
                        7.access$300(this.this$1).emit("if_acmpeq " + 7.access$200(this.this$1), -2);
                    }

                    public void caseRefType(RefType t) {
                        7.access$300(this.this$1).emit("if_acmpeq " + 7.access$200(this.this$1), -2);
                    }

                    public void caseNullType(NullType t) {
                        7.access$300(this.this$1).emit("if_acmpeq " + 7.access$200(this.this$1), -2);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseNeExpr(NeExpr expr) {
                op1.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void caseIntType(IntType t) {
                        7.access$300(this.this$1).emit("if_icmpne " + 7.access$200(this.this$1), -2);
                    }

                    public void caseBooleanType(BooleanType t) {
                        7.access$300(this.this$1).emit("if_icmpne " + 7.access$200(this.this$1), -2);
                    }

                    public void caseShortType(ShortType t) {
                        7.access$300(this.this$1).emit("if_icmpne " + 7.access$200(this.this$1), -2);
                    }

                    public void caseCharType(CharType t) {
                        7.access$300(this.this$1).emit("if_icmpne " + 7.access$200(this.this$1), -2);
                    }

                    public void caseByteType(ByteType t) {
                        7.access$300(this.this$1).emit("if_icmpne " + 7.access$200(this.this$1), -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        7.access$300(this.this$1).emit("dcmpg", -3);
                        7.access$300(this.this$1).emit("ifne " + 7.access$200(this.this$1), -1);
                    }

                    public void caseLongType(LongType t) {
                        7.access$300(this.this$1).emit("lcmp", -3);
                        7.access$300(this.this$1).emit("ifne " + 7.access$200(this.this$1), -1);
                    }

                    public void caseFloatType(FloatType t) {
                        7.access$300(this.this$1).emit("fcmpg", -1);
                        7.access$300(this.this$1).emit("ifne " + 7.access$200(this.this$1), -1);
                    }

                    public void caseArrayType(ArrayType t) {
                        7.access$300(this.this$1).emit("if_acmpne " + 7.access$200(this.this$1), -2);
                    }

                    public void caseRefType(RefType t) {
                        7.access$300(this.this$1).emit("if_acmpne " + 7.access$200(this.this$1), -2);
                    }

                    public void caseNullType(NullType t) {
                        7.access$300(this.this$1).emit("if_acmpne " + 7.access$200(this.this$1), -2);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type for NeExpr: " + t);
                    }
                });
            }

            public void caseLtExpr(LtExpr expr) {
                op1.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void caseIntType(IntType t) {
                        7.access$300(this.this$1).emit("if_icmplt " + 7.access$200(this.this$1), -2);
                    }

                    public void caseBooleanType(BooleanType t) {
                        7.access$300(this.this$1).emit("if_icmplt " + 7.access$200(this.this$1), -2);
                    }

                    public void caseShortType(ShortType t) {
                        7.access$300(this.this$1).emit("if_icmplt " + 7.access$200(this.this$1), -2);
                    }

                    public void caseCharType(CharType t) {
                        7.access$300(this.this$1).emit("if_icmplt " + 7.access$200(this.this$1), -2);
                    }

                    public void caseByteType(ByteType t) {
                        7.access$300(this.this$1).emit("if_icmplt " + 7.access$200(this.this$1), -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        7.access$300(this.this$1).emit("dcmpg", -3);
                        7.access$300(this.this$1).emit("iflt " + 7.access$200(this.this$1), -1);
                    }

                    public void caseLongType(LongType t) {
                        7.access$300(this.this$1).emit("lcmp", -3);
                        7.access$300(this.this$1).emit("iflt " + 7.access$200(this.this$1), -1);
                    }

                    public void caseFloatType(FloatType t) {
                        7.access$300(this.this$1).emit("fcmpg", -1);
                        7.access$300(this.this$1).emit("iflt " + 7.access$200(this.this$1), -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseLeExpr(LeExpr expr) {
                op1.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void caseIntType(IntType t) {
                        7.access$300(this.this$1).emit("if_icmple " + 7.access$200(this.this$1), -2);
                    }

                    public void caseBooleanType(BooleanType t) {
                        7.access$300(this.this$1).emit("if_icmple " + 7.access$200(this.this$1), -2);
                    }

                    public void caseShortType(ShortType t) {
                        7.access$300(this.this$1).emit("if_icmple " + 7.access$200(this.this$1), -2);
                    }

                    public void caseCharType(CharType t) {
                        7.access$300(this.this$1).emit("if_icmple " + 7.access$200(this.this$1), -2);
                    }

                    public void caseByteType(ByteType t) {
                        7.access$300(this.this$1).emit("if_icmple " + 7.access$200(this.this$1), -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        7.access$300(this.this$1).emit("dcmpg", -3);
                        7.access$300(this.this$1).emit("ifle " + 7.access$200(this.this$1), -1);
                    }

                    public void caseLongType(LongType t) {
                        7.access$300(this.this$1).emit("lcmp", -3);
                        7.access$300(this.this$1).emit("ifle " + 7.access$200(this.this$1), -1);
                    }

                    public void caseFloatType(FloatType t) {
                        7.access$300(this.this$1).emit("fcmpg", -1);
                        7.access$300(this.this$1).emit("ifle " + 7.access$200(this.this$1), -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseGtExpr(GtExpr expr) {
                op1.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void caseIntType(IntType t) {
                        7.access$300(this.this$1).emit("if_icmpgt " + 7.access$200(this.this$1), -2);
                    }

                    public void caseBooleanType(BooleanType t) {
                        7.access$300(this.this$1).emit("if_icmpgt " + 7.access$200(this.this$1), -2);
                    }

                    public void caseShortType(ShortType t) {
                        7.access$300(this.this$1).emit("if_icmpgt " + 7.access$200(this.this$1), -2);
                    }

                    public void caseCharType(CharType t) {
                        7.access$300(this.this$1).emit("if_icmpgt " + 7.access$200(this.this$1), -2);
                    }

                    public void caseByteType(ByteType t) {
                        7.access$300(this.this$1).emit("if_icmpgt " + 7.access$200(this.this$1), -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        7.access$300(this.this$1).emit("dcmpg", -3);
                        7.access$300(this.this$1).emit("ifgt " + 7.access$200(this.this$1), -1);
                    }

                    public void caseLongType(LongType t) {
                        7.access$300(this.this$1).emit("lcmp", -3);
                        7.access$300(this.this$1).emit("ifgt " + 7.access$200(this.this$1), -1);
                    }

                    public void caseFloatType(FloatType t) {
                        7.access$300(this.this$1).emit("fcmpg", -1);
                        7.access$300(this.this$1).emit("ifgt " + 7.access$200(this.this$1), -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseGeExpr(GeExpr expr) {
                op1.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void caseIntType(IntType t) {
                        7.access$300(this.this$1).emit("if_icmpge " + 7.access$200(this.this$1), -2);
                    }

                    public void caseBooleanType(BooleanType t) {
                        7.access$300(this.this$1).emit("if_icmpge " + 7.access$200(this.this$1), -2);
                    }

                    public void caseShortType(ShortType t) {
                        7.access$300(this.this$1).emit("if_icmpge " + 7.access$200(this.this$1), -2);
                    }

                    public void caseCharType(CharType t) {
                        7.access$300(this.this$1).emit("if_icmpge " + 7.access$200(this.this$1), -2);
                    }

                    public void caseByteType(ByteType t) {
                        7.access$300(this.this$1).emit("if_icmpge " + 7.access$200(this.this$1), -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        7.access$300(this.this$1).emit("dcmpg", -3);
                        7.access$300(this.this$1).emit("ifge " + 7.access$200(this.this$1), -1);
                    }

                    public void caseLongType(LongType t) {
                        7.access$300(this.this$1).emit("lcmp", -3);
                        7.access$300(this.this$1).emit("ifge " + 7.access$200(this.this$1), -1);
                    }

                    public void caseFloatType(FloatType t) {
                        7.access$300(this.this$1).emit("fcmpg", -1);
                        7.access$300(this.this$1).emit("ifge " + 7.access$200(this.this$1), -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void defaultCase(Value v) {
                throw new RuntimeException("invalid condition " + v);
            }

            static /* synthetic */ String access$200(7 x0) {
                return x0.label;
            }

            static /* synthetic */ JasminClass access$300(7 x0) {
                return x0.JasminClass.this;
            }
        });
    }

    void emitStmt(Stmt stmt) {
        stmt.apply(new AbstractStmtSwitch(){

            public void caseAssignStmt(AssignStmt s) {
                JasminClass.this.emitAssignStmt(s);
            }

            public void caseIdentityStmt(IdentityStmt s) {
                if (s.getRightOp() instanceof CaughtExceptionRef && s.getLeftOp() instanceof Local) {
                    int slot = (Integer)JasminClass.this.localToSlot.get(s.getLeftOp());
                    JasminClass.this.modifyStackHeight(1);
                    if (slot >= 0 && slot <= 3) {
                        JasminClass.this.emit("astore_" + slot, -1);
                    } else {
                        JasminClass.this.emit("astore " + slot, -1);
                    }
                }
            }

            public void caseBreakpointStmt(BreakpointStmt s) {
                JasminClass.this.emit("breakpoint", 0);
            }

            public void caseInvokeStmt(InvokeStmt s) {
                JasminClass.this.emitValue(s.getInvokeExpr());
                Type returnType = s.getInvokeExpr().getMethod().getReturnType();
                if (!returnType.equals(VoidType.v())) {
                    if (JasminClass.sizeOfType(returnType) == 1) {
                        JasminClass.this.emit("pop", -1);
                    } else {
                        JasminClass.this.emit("pop2", -2);
                    }
                }
            }

            public void defaultCase(Stmt s) {
                throw new RuntimeException("invalid stmt: " + s);
            }

            public void caseEnterMonitorStmt(EnterMonitorStmt s) {
                JasminClass.this.emitValue(s.getOp());
                JasminClass.this.emit("monitorenter", -1);
            }

            public void caseExitMonitorStmt(ExitMonitorStmt s) {
                JasminClass.this.emitValue(s.getOp());
                JasminClass.this.emit("monitorexit", -1);
            }

            public void caseGotoStmt(GotoStmt s) {
                if (JasminClass.this.isNextGotoAJsr) {
                    JasminClass.this.emit("jsr " + JasminClass.this.stmtToLabel.get(s.getTarget()));
                    JasminClass.this.isNextGotoAJsr = false;
                    JasminClass.this.subroutineToReturnAddressSlot.put(s.getTarget(), new Integer(JasminClass.this.returnAddressSlot));
                } else {
                    JasminClass.this.emit("goto " + JasminClass.this.stmtToLabel.get(s.getTarget()));
                }
            }

            public void caseIfStmt(IfStmt s) {
                JasminClass.this.emitIfStmt(s);
            }

            public void caseLookupSwitchStmt(LookupSwitchStmt s) {
                JasminClass.this.emitValue(s.getKey());
                JasminClass.this.emit("lookupswitch", -1);
                List lookupValues = s.getLookupValues();
                List targets = s.getTargets();
                for (int i = 0; i < lookupValues.size(); ++i) {
                    JasminClass.this.emit("  " + lookupValues.get(i) + " : " + JasminClass.this.stmtToLabel.get(targets.get(i)));
                }
                JasminClass.this.emit("  default : " + JasminClass.this.stmtToLabel.get(s.getDefaultTarget()));
            }

            public void caseNopStmt(NopStmt s) {
                JasminClass.this.emit("nop", 0);
            }

            public void caseRetStmt(RetStmt s) {
                JasminClass.this.emit("ret " + JasminClass.this.localToSlot.get(s.getStmtAddress()), 0);
            }

            public void caseReturnStmt(ReturnStmt s) {
                JasminClass.this.emitValue(s.getOp());
                Value returnValue = s.getOp();
                returnValue.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 14 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid return type " + t.toString());
                    }

                    public void caseDoubleType(DoubleType t) {
                        14.access$400(this.this$1).emit("dreturn", -2);
                    }

                    public void caseFloatType(FloatType t) {
                        14.access$400(this.this$1).emit("freturn", -1);
                    }

                    public void caseIntType(IntType t) {
                        14.access$400(this.this$1).emit("ireturn", -1);
                    }

                    public void caseByteType(ByteType t) {
                        14.access$400(this.this$1).emit("ireturn", -1);
                    }

                    public void caseShortType(ShortType t) {
                        14.access$400(this.this$1).emit("ireturn", -1);
                    }

                    public void caseCharType(CharType t) {
                        14.access$400(this.this$1).emit("ireturn", -1);
                    }

                    public void caseBooleanType(BooleanType t) {
                        14.access$400(this.this$1).emit("ireturn", -1);
                    }

                    public void caseLongType(LongType t) {
                        14.access$400(this.this$1).emit("lreturn", -2);
                    }

                    public void caseArrayType(ArrayType t) {
                        14.access$400(this.this$1).emit("areturn", -1);
                    }

                    public void caseRefType(RefType t) {
                        14.access$400(this.this$1).emit("areturn", -1);
                    }

                    public void caseNullType(NullType t) {
                        14.access$400(this.this$1).emit("areturn", -1);
                    }
                });
            }

            public void caseReturnVoidStmt(ReturnVoidStmt s) {
                JasminClass.this.emit("return", 0);
            }

            public void caseTableSwitchStmt(TableSwitchStmt s) {
                JasminClass.this.emitValue(s.getKey());
                JasminClass.this.emit("tableswitch " + s.getLowIndex() + " ; high = " + s.getHighIndex(), -1);
                List targets = s.getTargets();
                for (int i = 0; i < targets.size(); ++i) {
                    JasminClass.this.emit("  " + JasminClass.this.stmtToLabel.get(targets.get(i)));
                }
                JasminClass.this.emit("default : " + JasminClass.this.stmtToLabel.get(s.getDefaultTarget()));
            }

            public void caseThrowStmt(ThrowStmt s) {
                JasminClass.this.emitValue(s.getOp());
                JasminClass.this.emit("athrow", -1);
            }

            static /* synthetic */ JasminClass access$400(14 x0) {
                return x0.JasminClass.this;
            }
        });
    }

    void emitLocal(Local v) {
        final int slot = (Integer)this.localToSlot.get(v);
        final Local vAlias = v;
        v.getType().apply(new TypeSwitch(){

            public void caseArrayType(ArrayType t) {
                if (slot >= 0 && slot <= 3) {
                    JasminClass.this.emit("aload_" + slot, 1);
                } else {
                    JasminClass.this.emit("aload " + slot, 1);
                }
            }

            public void defaultCase(Type t) {
                throw new RuntimeException("invalid local type to load" + t);
            }

            public void caseDoubleType(DoubleType t) {
                if (slot >= 0 && slot <= 3) {
                    JasminClass.this.emit("dload_" + slot, 2);
                } else {
                    JasminClass.this.emit("dload " + slot, 2);
                }
            }

            public void caseFloatType(FloatType t) {
                if (slot >= 0 && slot <= 3) {
                    JasminClass.this.emit("fload_" + slot, 1);
                } else {
                    JasminClass.this.emit("fload " + slot, 1);
                }
            }

            public void caseBooleanType(BooleanType t) {
                this.handleIntegerType(t);
            }

            public void caseByteType(ByteType t) {
                this.handleIntegerType(t);
            }

            public void caseShortType(ShortType t) {
                this.handleIntegerType(t);
            }

            public void caseCharType(CharType t) {
                this.handleIntegerType(t);
            }

            public void caseIntType(IntType t) {
                this.handleIntegerType(t);
            }

            public void handleIntegerType(IntegerType t) {
                if (vAlias.equals(JasminClass.this.plusPlusHolder)) {
                    switch (JasminClass.this.plusPlusState) {
                        case 0: {
                            JasminClass.this.plusPlusState = 1;
                            JasminClass.this.emitStmt(JasminClass.this.plusPlusIncrementer);
                            int diff = JasminClass.this.plusPlusHeight - JasminClass.this.currentStackHeight + 1;
                            if (diff > 0) {
                                JasminClass.this.code.set(JasminClass.this.plusPlusPlace, "    dup_x" + diff);
                            }
                            JasminClass.this.plusPlusHolder = null;
                            return;
                        }
                        case 1: {
                            JasminClass.this.plusPlusHeight = JasminClass.this.currentStackHeight;
                            JasminClass.this.plusPlusHolder = null;
                            JasminClass.this.emitValue(JasminClass.this.plusPlusValue);
                            JasminClass.this.plusPlusPlace = JasminClass.this.code.size();
                            JasminClass.this.emit("dup", 1);
                            return;
                        }
                        case 10: {
                            JasminClass.this.plusPlusState = 11;
                            JasminClass.this.plusPlusHolder = (Local)JasminClass.this.plusPlusValue;
                            JasminClass.this.emitStmt(JasminClass.this.plusPlusIncrementer);
                            int diff = JasminClass.this.plusPlusHeight - JasminClass.this.currentStackHeight + 1;
                            if (diff > 0 && JasminClass.this.plusPlusState == 11) {
                                JasminClass.this.code.set(JasminClass.this.plusPlusPlace, "    dup_x" + diff);
                            }
                            JasminClass.this.plusPlusHolder = null;
                            return;
                        }
                        case 11: {
                            JasminClass.this.plusPlusHeight = JasminClass.this.currentStackHeight;
                            JasminClass.this.plusPlusHolder = null;
                            JasminClass.this.emitValue(JasminClass.this.plusPlusValue);
                            if (JasminClass.this.plusPlusState != 11) {
                                JasminClass.this.emit("dup", 1);
                            }
                            JasminClass.this.plusPlusPlace = JasminClass.this.code.size();
                            return;
                        }
                    }
                }
                if (slot >= 0 && slot <= 3) {
                    JasminClass.this.emit("iload_" + slot, 1);
                } else {
                    JasminClass.this.emit("iload " + slot, 1);
                }
            }

            public void caseLongType(LongType t) {
                if (slot >= 0 && slot <= 3) {
                    JasminClass.this.emit("lload_" + slot, 2);
                } else {
                    JasminClass.this.emit("lload " + slot, 2);
                }
            }

            public void caseRefType(RefType t) {
                if (slot >= 0 && slot <= 3) {
                    JasminClass.this.emit("aload_" + slot, 1);
                } else {
                    JasminClass.this.emit("aload " + slot, 1);
                }
            }

            public void caseNullType(NullType t) {
                if (slot >= 0 && slot <= 3) {
                    JasminClass.this.emit("aload_" + slot, 1);
                } else {
                    JasminClass.this.emit("aload " + slot, 1);
                }
            }
        });
    }

    void emitValue(Value value) {
        value.apply(new AbstractGrimpValueSwitch(){

            public void caseAddExpr(AddExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("iadd", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("ladd", -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        17.access$500(this.this$1).emit("dadd", -2);
                    }

                    public void caseFloatType(FloatType t) {
                        17.access$500(this.this$1).emit("fadd", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for add");
                    }
                });
            }

            public void caseAndExpr(AndExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("iand", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("land", -2);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for and");
                    }
                });
            }

            public void caseArrayRef(ArrayRef v) {
                JasminClass.this.emitValue(v.getBase());
                JasminClass.this.emitValue(v.getIndex());
                v.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void caseArrayType(ArrayType ty) {
                        17.access$500(this.this$1).emit("aaload", -1);
                    }

                    public void caseBooleanType(BooleanType ty) {
                        17.access$500(this.this$1).emit("baload", -1);
                    }

                    public void caseByteType(ByteType ty) {
                        17.access$500(this.this$1).emit("baload", -1);
                    }

                    public void caseCharType(CharType ty) {
                        17.access$500(this.this$1).emit("caload", -1);
                    }

                    public void defaultCase(Type ty) {
                        throw new RuntimeException("invalid base type");
                    }

                    public void caseDoubleType(DoubleType ty) {
                        17.access$500(this.this$1).emit("daload", 0);
                    }

                    public void caseFloatType(FloatType ty) {
                        17.access$500(this.this$1).emit("faload", -1);
                    }

                    public void caseIntType(IntType ty) {
                        17.access$500(this.this$1).emit("iaload", -1);
                    }

                    public void caseLongType(LongType ty) {
                        17.access$500(this.this$1).emit("laload", 0);
                    }

                    public void caseNullType(NullType ty) {
                        17.access$500(this.this$1).emit("aaload", -1);
                    }

                    public void caseRefType(RefType ty) {
                        17.access$500(this.this$1).emit("aaload", -1);
                    }

                    public void caseShortType(ShortType ty) {
                        17.access$500(this.this$1).emit("saload", -1);
                    }
                });
            }

            public void caseCastExpr(CastExpr v) {
                Type toType = v.getCastType();
                Type fromType = v.getOp().getType();
                JasminClass.this.emitValue(v.getOp());
                if (toType instanceof RefType) {
                    JasminClass.this.emit("checkcast " + JasminClass.slashify(toType.toString()), 0);
                } else if (toType instanceof ArrayType) {
                    JasminClass.this.emit("checkcast " + JasminClass.jasminDescriptorOf(toType), 0);
                } else {
                    fromType.apply(new TypeSwitch(this, fromType, toType, v){
                        private final /* synthetic */ Type val$fromType;
                        private final /* synthetic */ Type val$toType;
                        private final /* synthetic */ CastExpr val$v;
                        private final /* synthetic */ 17 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$fromType = val$fromType;
                            this.val$toType = val$toType;
                            this.val$v = val$v;
                        }

                        public void defaultCase(Type ty) {
                            throw new RuntimeException("invalid fromType " + this.val$fromType);
                        }

                        public void caseDoubleType(DoubleType ty) {
                            if (this.val$toType.equals(IntType.v())) {
                                17.access$500(this.this$1).emit("d2i", -1);
                            } else if (this.val$toType.equals(LongType.v())) {
                                17.access$500(this.this$1).emit("d2l", 0);
                            } else if (this.val$toType.equals(FloatType.v())) {
                                17.access$500(this.this$1).emit("d2f", -1);
                            } else {
                                throw new RuntimeException("invalid toType from double: " + this.val$toType);
                            }
                        }

                        public void caseFloatType(FloatType ty) {
                            if (this.val$toType.equals(IntType.v())) {
                                17.access$500(this.this$1).emit("f2i", 0);
                            } else if (this.val$toType.equals(LongType.v())) {
                                17.access$500(this.this$1).emit("f2l", 1);
                            } else if (this.val$toType.equals(DoubleType.v())) {
                                17.access$500(this.this$1).emit("f2d", 1);
                            } else {
                                throw new RuntimeException("invalid toType from float: " + this.val$toType);
                            }
                        }

                        public void caseIntType(IntType ty) {
                            this.emitIntToTypeCast();
                        }

                        public void caseBooleanType(BooleanType ty) {
                            this.emitIntToTypeCast();
                        }

                        public void caseByteType(ByteType ty) {
                            this.emitIntToTypeCast();
                        }

                        public void caseCharType(CharType ty) {
                            this.emitIntToTypeCast();
                        }

                        public void caseShortType(ShortType ty) {
                            this.emitIntToTypeCast();
                        }

                        private void emitIntToTypeCast() {
                            if (this.val$toType.equals(ByteType.v())) {
                                17.access$500(this.this$1).emit("i2b", 0);
                            } else if (this.val$toType.equals(CharType.v())) {
                                17.access$500(this.this$1).emit("i2c", 0);
                            } else if (this.val$toType.equals(ShortType.v())) {
                                17.access$500(this.this$1).emit("i2s", 0);
                            } else if (this.val$toType.equals(FloatType.v())) {
                                17.access$500(this.this$1).emit("i2f", 0);
                            } else if (this.val$toType.equals(LongType.v())) {
                                17.access$500(this.this$1).emit("i2l", 1);
                            } else if (this.val$toType.equals(DoubleType.v())) {
                                17.access$500(this.this$1).emit("i2d", 1);
                            } else if (!this.val$toType.equals(IntType.v()) && !this.val$toType.equals(BooleanType.v())) {
                                throw new RuntimeException("invalid toType from int: " + this.val$toType + " " + this.val$v.toString());
                            }
                        }

                        public void caseLongType(LongType ty) {
                            if (this.val$toType.equals(IntType.v())) {
                                17.access$500(this.this$1).emit("l2i", -1);
                            } else if (this.val$toType.equals(FloatType.v())) {
                                17.access$500(this.this$1).emit("l2f", -1);
                            } else if (this.val$toType.equals(DoubleType.v())) {
                                17.access$500(this.this$1).emit("l2d", 0);
                            } else if (this.val$toType.equals(ByteType.v())) {
                                17.access$500(this.this$1).emit("l2i", -1);
                                this.emitIntToTypeCast();
                            } else if (this.val$toType.equals(ShortType.v())) {
                                17.access$500(this.this$1).emit("l2i", -1);
                                this.emitIntToTypeCast();
                            } else if (this.val$toType.equals(CharType.v())) {
                                17.access$500(this.this$1).emit("l2i", -1);
                                this.emitIntToTypeCast();
                            } else if (this.val$toType.equals(BooleanType.v())) {
                                17.access$500(this.this$1).emit("l2i", -1);
                                this.emitIntToTypeCast();
                            } else {
                                throw new RuntimeException("invalid toType from long: " + this.val$toType);
                            }
                        }
                    });
                }
            }

            public void caseCmpExpr(CmpExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                JasminClass.this.emit("lcmp", -3);
            }

            public void caseCmpgExpr(CmpgExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                if (v.getOp1().getType().equals(FloatType.v())) {
                    JasminClass.this.emit("fcmpg", -1);
                } else {
                    JasminClass.this.emit("dcmpg", -3);
                }
            }

            public void caseCmplExpr(CmplExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                if (v.getOp1().getType().equals(FloatType.v())) {
                    JasminClass.this.emit("fcmpl", -1);
                } else {
                    JasminClass.this.emit("dcmpl", -3);
                }
            }

            public void defaultCase(Value v) {
                throw new RuntimeException("Can't load value: " + v);
            }

            public void caseDivExpr(DivExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("idiv", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("ldiv", -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        17.access$500(this.this$1).emit("ddiv", -2);
                    }

                    public void caseFloatType(FloatType t) {
                        17.access$500(this.this$1).emit("fdiv", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for div");
                    }
                });
            }

            public void caseDoubleConstant(DoubleConstant v) {
                if (v.value == 0.0) {
                    JasminClass.this.emit("dconst_0", 2);
                } else if (v.value == 1.0) {
                    JasminClass.this.emit("dconst_1", 2);
                } else {
                    String s = v.toString();
                    if (s.equals("#Infinity")) {
                        s = "+DoubleInfinity";
                    }
                    if (s.equals("#-Infinity")) {
                        s = "-DoubleInfinity";
                    }
                    if (s.equals("#NaN")) {
                        s = "+DoubleNaN";
                    }
                    JasminClass.this.emit("ldc2_w " + s, 2);
                }
            }

            public void caseFloatConstant(FloatConstant v) {
                if (v.value == 0.0f) {
                    JasminClass.this.emit("fconst_0", 1);
                } else if (v.value == 1.0f) {
                    JasminClass.this.emit("fconst_1", 1);
                } else if (v.value == 2.0f) {
                    JasminClass.this.emit("fconst_2", 1);
                } else {
                    String s = v.toString();
                    if (s.equals("#InfinityF")) {
                        s = "+FloatInfinity";
                    }
                    if (s.equals("#-InfinityF")) {
                        s = "-FloatInfinity";
                    }
                    if (s.equals("#NaNF")) {
                        s = "+FloatNaN";
                    }
                    JasminClass.this.emit("ldc " + s, 1);
                }
            }

            public void caseInstanceFieldRef(InstanceFieldRef v) {
                JasminClass.this.emitValue(v.getBase());
                JasminClass.this.emit("getfield " + JasminClass.slashify(v.getField().getDeclaringClass().getName()) + "/" + v.getField().getName() + " " + JasminClass.jasminDescriptorOf(v.getField().getType()), -1 + JasminClass.sizeOfType(v.getField().getType()));
            }

            public void caseInstanceOfExpr(InstanceOfExpr v) {
                JasminClass.this.emitValue(v.getOp());
                Type checkType = v.getCheckType();
                if (checkType instanceof RefType) {
                    JasminClass.this.emit("instanceof " + JasminClass.slashify(checkType.toString()), 0);
                } else if (checkType instanceof ArrayType) {
                    JasminClass.this.emit("instanceof " + JasminClass.jasminDescriptorOf(checkType), 0);
                }
            }

            public void caseIntConstant(IntConstant v) {
                if (v.value == -1) {
                    JasminClass.this.emit("iconst_m1", 1);
                } else if (v.value >= 0 && v.value <= 5) {
                    JasminClass.this.emit("iconst_" + v.value, 1);
                } else if (v.value >= -128 && v.value <= 127) {
                    JasminClass.this.emit("bipush " + v.value, 1);
                } else if (v.value >= Short.MIN_VALUE && v.value <= Short.MAX_VALUE) {
                    JasminClass.this.emit("sipush " + v.value, 1);
                } else {
                    JasminClass.this.emit("ldc " + v.toString(), 1);
                }
            }

            public void caseInterfaceInvokeExpr(InterfaceInvokeExpr v) {
                SootMethod m = v.getMethod();
                JasminClass.this.emitValue(v.getBase());
                for (int i = 0; i < m.getParameterCount(); ++i) {
                    JasminClass.this.emitValue(v.getArg(i));
                }
                JasminClass.this.emit("invokeinterface " + JasminClass.slashify(m.getDeclaringClass().getName()) + "/" + m.getName() + JasminClass.jasminDescriptorOf(m) + " " + (JasminClass.argCountOf(m) + 1), -(JasminClass.argCountOf(m) + 1) + JasminClass.sizeOfType(m.getReturnType()));
            }

            public void caseLengthExpr(LengthExpr v) {
                JasminClass.this.emitValue(v.getOp());
                JasminClass.this.emit("arraylength", 0);
            }

            public void caseLocal(Local v) {
                JasminClass.this.emitLocal(v);
            }

            public void caseLongConstant(LongConstant v) {
                if (v.value == 0L) {
                    JasminClass.this.emit("lconst_0", 2);
                } else if (v.value == 1L) {
                    JasminClass.this.emit("lconst_1", 2);
                } else {
                    JasminClass.this.emit("ldc2_w " + v.toString(), 2);
                }
            }

            public void caseMulExpr(MulExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("imul", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lmul", -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        17.access$500(this.this$1).emit("dmul", -2);
                    }

                    public void caseFloatType(FloatType t) {
                        17.access$500(this.this$1).emit("fmul", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for mul");
                    }
                });
            }

            public void caseLtExpr(LtExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void caseDoubleType(DoubleType t) {
                        17.access$500(this.this$1).emit("dcmpg", -3);
                        17.access$500(this.this$1).emitBooleanBranch("iflt");
                    }

                    public void caseFloatType(FloatType t) {
                        17.access$500(this.this$1).emit("fcmpg", -1);
                        17.access$500(this.this$1).emitBooleanBranch("iflt");
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("if_icmplt", -2);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lcmp", -3);
                        17.access$500(this.this$1).emitBooleanBranch("iflt");
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseLeExpr(LeExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void caseDoubleType(DoubleType t) {
                        17.access$500(this.this$1).emit("dcmpg", -3);
                        17.access$500(this.this$1).emitBooleanBranch("ifle");
                    }

                    public void caseFloatType(FloatType t) {
                        17.access$500(this.this$1).emit("fcmpg", -1);
                        17.access$500(this.this$1).emitBooleanBranch("ifle");
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("if_icmple", -2);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lcmp", -3);
                        17.access$500(this.this$1).emitBooleanBranch("ifle");
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseGtExpr(GtExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void caseDoubleType(DoubleType t) {
                        17.access$500(this.this$1).emit("dcmpg", -3);
                        17.access$500(this.this$1).emitBooleanBranch("ifgt");
                    }

                    public void caseFloatType(FloatType t) {
                        17.access$500(this.this$1).emit("fcmpg", -1);
                        17.access$500(this.this$1).emitBooleanBranch("ifgt");
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("if_icmpgt", -2);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lcmp", -3);
                        17.access$500(this.this$1).emitBooleanBranch("ifgt");
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseGeExpr(GeExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void caseDoubleType(DoubleType t) {
                        17.access$500(this.this$1).emit("dcmpg", -3);
                        17.access$500(this.this$1).emitBooleanBranch("ifge");
                    }

                    public void caseFloatType(FloatType t) {
                        17.access$500(this.this$1).emit("fcmpg", -1);
                        17.access$500(this.this$1).emitBooleanBranch("ifge");
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("if_icmpge", -2);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lcmp", -3);
                        17.access$500(this.this$1).emitBooleanBranch("ifge");
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseNeExpr(NeExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void caseDoubleType(DoubleType t) {
                        17.access$500(this.this$1).emit("dcmpg", -3);
                        17.access$500(this.this$1).emit("iconst_0", 1);
                        17.access$500(this.this$1).emitBooleanBranch("if_icmpne");
                    }

                    public void caseFloatType(FloatType t) {
                        17.access$500(this.this$1).emit("fcmpg", -1);
                        17.access$500(this.this$1).emit("iconst_0", 1);
                        17.access$500(this.this$1).emitBooleanBranch("if_icmpne");
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("if_icmpne", -2);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lcmp", -3);
                        17.access$500(this.this$1).emit("iconst_0", 1);
                        17.access$500(this.this$1).emitBooleanBranch("if_icmpne");
                    }

                    public void caseArrayType(ArrayType t) {
                        17.access$500(this.this$1).emitBooleanBranch("if_acmpne");
                    }

                    public void caseRefType(RefType t) {
                        17.access$500(this.this$1).emitBooleanBranch("if_acmpne");
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseEqExpr(EqExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void caseDoubleType(DoubleType t) {
                        17.access$500(this.this$1).emit("dcmpg", -3);
                        17.access$500(this.this$1).emit("iconst_0", 1);
                        17.access$500(this.this$1).emitBooleanBranch("if_icmpeq");
                    }

                    public void caseFloatType(FloatType t) {
                        17.access$500(this.this$1).emit("fcmpg", -3);
                        17.access$500(this.this$1).emit("iconst_0", 1);
                        17.access$500(this.this$1).emitBooleanBranch("if_icmpeq");
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("if_icmpeq", -2);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lcmp", -3);
                        17.access$500(this.this$1).emit("iconst_0", 1);
                        17.access$500(this.this$1).emitBooleanBranch("if_icmpeq");
                    }

                    public void caseArrayType(ArrayType t) {
                        17.access$500(this.this$1).emitBooleanBranch("if_acmpeq");
                    }

                    public void casbeRefType(RefType t) {
                        17.access$500(this.this$1).emitBooleanBranch("if_acmpeq");
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseNegExpr(NegExpr v) {
                JasminClass.this.emitValue(v.getOp());
                v.getType().apply(new TypeSwitch(this, v){
                    private final /* synthetic */ NegExpr val$v;
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$v = val$v;
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("ineg", 0);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lneg", 0);
                    }

                    public void caseDoubleType(DoubleType t) {
                        17.access$500(this.this$1).emit("dneg", 0);
                    }

                    public void caseFloatType(FloatType t) {
                        17.access$500(this.this$1).emit("fneg", 0);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for neg: " + t + ": " + this.val$v);
                    }
                });
            }

            public void caseNewArrayExpr(NewArrayExpr v) {
                Value size = v.getSize();
                JasminClass.this.emitValue(size);
                if (v.getBaseType() instanceof RefType) {
                    JasminClass.this.emit("anewarray " + JasminClass.slashify(v.getBaseType().toString()), 0);
                } else if (v.getBaseType() instanceof ArrayType) {
                    JasminClass.this.emit("anewarray " + JasminClass.jasminDescriptorOf(v.getBaseType()), 0);
                } else {
                    JasminClass.this.emit("newarray " + v.getBaseType().toString(), 0);
                }
            }

            public void caseNewMultiArrayExpr(NewMultiArrayExpr v) {
                List sizes = v.getSizes();
                for (int i = 0; i < sizes.size(); ++i) {
                    JasminClass.this.emitValue((Value)sizes.get(i));
                }
                JasminClass.this.emit("multianewarray " + JasminClass.jasminDescriptorOf(v.getBaseType()) + " " + sizes.size(), -sizes.size() + 1);
            }

            public void caseNewExpr(NewExpr v) {
                JasminClass.this.emit("new " + JasminClass.slashify(v.getBaseType().toString()), 1);
            }

            public void caseNewInvokeExpr(NewInvokeExpr v) {
                JasminClass.this.emit("new " + JasminClass.slashify(v.getBaseType().toString()), 1);
                JasminClass.this.emit("dup", 1);
                SootMethod m = v.getMethod();
                for (int i = 0; i < m.getParameterCount(); ++i) {
                    JasminClass.this.emitValue(v.getArg(i));
                }
                JasminClass.this.emit("invokespecial " + JasminClass.slashify(m.getDeclaringClass().getName()) + "/" + m.getName() + JasminClass.jasminDescriptorOf(m), -(JasminClass.argCountOf(m) + 1) + JasminClass.sizeOfType(m.getReturnType()));
            }

            public void caseNullConstant(NullConstant v) {
                JasminClass.this.emit("aconst_null", 1);
            }

            public void caseOrExpr(OrExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("ior", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lor", -2);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for or");
                    }
                });
            }

            public void caseRemExpr(RemExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("irem", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lrem", -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        17.access$500(this.this$1).emit("drem", -2);
                    }

                    public void caseFloatType(FloatType t) {
                        17.access$500(this.this$1).emit("frem", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for rem");
                    }
                });
            }

            public void caseShlExpr(ShlExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("ishl", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lshl", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for shl");
                    }
                });
            }

            public void caseShrExpr(ShrExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("ishr", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lshr", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for shr");
                    }
                });
            }

            public void caseSpecialInvokeExpr(SpecialInvokeExpr v) {
                SootMethod m = v.getMethod();
                JasminClass.this.emitValue(v.getBase());
                for (int i = 0; i < m.getParameterCount(); ++i) {
                    JasminClass.this.emitValue(v.getArg(i));
                }
                JasminClass.this.emit("invokespecial " + JasminClass.slashify(m.getDeclaringClass().getName()) + "/" + m.getName() + JasminClass.jasminDescriptorOf(m), -(JasminClass.argCountOf(m) + 1) + JasminClass.sizeOfType(m.getReturnType()));
            }

            public void caseStaticInvokeExpr(StaticInvokeExpr v) {
                SootMethod m = v.getMethod();
                for (int i = 0; i < m.getParameterCount(); ++i) {
                    JasminClass.this.emitValue(v.getArg(i));
                }
                JasminClass.this.emit("invokestatic " + JasminClass.slashify(m.getDeclaringClass().getName()) + "/" + m.getName() + JasminClass.jasminDescriptorOf(m), -JasminClass.argCountOf(m) + JasminClass.sizeOfType(m.getReturnType()));
            }

            public void caseStaticFieldRef(StaticFieldRef v) {
                JasminClass.this.emit("getstatic " + JasminClass.slashify(v.getField().getDeclaringClass().getName()) + "/" + v.getField().getName() + " " + JasminClass.jasminDescriptorOf(v.getField().getType()), JasminClass.sizeOfType(v.getField().getType()));
            }

            public void caseStringConstant(StringConstant v) {
                JasminClass.this.emit("ldc " + v.toString(), 1);
            }

            public void caseSubExpr(SubExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("isub", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lsub", -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        17.access$500(this.this$1).emit("dsub", -2);
                    }

                    public void caseFloatType(FloatType t) {
                        17.access$500(this.this$1).emit("fsub", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for sub");
                    }
                });
            }

            public void caseUshrExpr(UshrExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("iushr", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lushr", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for ushr");
                    }
                });
            }

            public void caseVirtualInvokeExpr(VirtualInvokeExpr v) {
                SootMethod m = v.getMethod();
                JasminClass.this.emitValue(v.getBase());
                for (int i = 0; i < m.getParameterCount(); ++i) {
                    JasminClass.this.emitValue(v.getArg(i));
                }
                JasminClass.this.emit("invokevirtual " + JasminClass.slashify(m.getDeclaringClass().getName()) + "/" + m.getName() + JasminClass.jasminDescriptorOf(m), -(JasminClass.argCountOf(m) + 1) + JasminClass.sizeOfType(m.getReturnType()));
            }

            public void caseXorExpr(XorExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    private void handleIntCase() {
                        17.access$500(this.this$1).emit("ixor", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        17.access$500(this.this$1).emit("lxor", -2);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for xor");
                    }
                });
            }

            static /* synthetic */ JasminClass access$500(17 x0) {
                return x0.JasminClass.this;
            }
        });
    }

    public void emitBooleanBranch(String s) {
        int count = s.indexOf("icmp") != -1 || s.indexOf("acmp") != -1 ? -2 : -1;
        this.emit(s + " label" + this.labelCount, count);
        this.emit("iconst_0", 1);
        this.emit("goto label" + this.labelCount + 1, 0);
        this.emit("label" + this.labelCount++ + ":");
        this.emit("iconst_1", 1);
        this.emit("label" + this.labelCount++ + ":");
    }
}

