/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import polyglot.ast.Node;
import polyglot.types.ClassType;
import polyglot.types.Flags;
import polyglot.util.Position;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.NullType;
import soot.RefType;
import soot.ShortType;
import soot.Type;
import soot.VoidType;
import soot.javaToJimple.jj.DPosition;
import soot.options.Options;
import soot.tagkit.Host;
import soot.tagkit.SourceLineNumberTag;
import soot.tagkit.SourceLnPosTag;
import soot.tagkit.SourcePositionTag;

public class Util {
    public static void addLnPosTags(Host host, Position pos) {
        if (pos != null && pos instanceof DPosition) {
            DPosition dpos = (DPosition)pos;
            Util.addLnPosTags(host, dpos.line(), dpos.endLine(), dpos.column(), dpos.endCol());
        }
    }

    public static void addLnPosTags(Host host, int sline, int eline, int spos, int epos) {
        if (Options.v().keep_line_number()) {
            host.addTag(new SourceLnPosTag(sline, eline, spos, epos));
        }
    }

    public static void addPosTag(Host host, Position pos) {
        if (pos != null) {
            if (pos instanceof DPosition) {
                DPosition dpos = (DPosition)pos;
                Util.addPosTag(host, dpos.column(), dpos.endCol());
            } else {
                System.out.println("not a dpos");
            }
        }
    }

    public static void addMethodPosTag(Host meth, int start, int end) {
        meth.addTag(new SourcePositionTag(start, end));
    }

    public static void addPosTag(Host host, int sc, int ec) {
        host.addTag(new SourcePositionTag(sc, ec));
    }

    public static void addMethodLineTag(Host host, int sline, int eline) {
        if (Options.v().keep_line_number()) {
            host.addTag(new SourceLineNumberTag(sline, eline));
        }
    }

    public static void addLineTag(Host host, Node node) {
        if (Options.v().keep_line_number() && node.position() != null && node.position() instanceof DPosition) {
            DPosition dpos = (DPosition)node.position();
            host.addTag(new SourceLineNumberTag(dpos.line(), dpos.line()));
        }
    }

    public static void addLineTag(Host host, int sLine, int eLine) {
        host.addTag(new SourceLineNumberTag(sLine, eLine));
    }

    public static Type getSootType(polyglot.types.Type type) {
        Type sootType = null;
        if (type.isInt()) {
            sootType = IntType.v();
        } else if (type.isArray()) {
            polyglot.types.Type polyglotBase = ((polyglot.types.ArrayType)type).base();
            while (polyglotBase instanceof polyglot.types.ArrayType) {
                polyglotBase = ((polyglot.types.ArrayType)polyglotBase).base();
            }
            Type baseType = Util.getSootType(polyglotBase);
            int dims = ((polyglot.types.ArrayType)type).dims();
            sootType = ArrayType.v(baseType, dims);
        } else if (type.isBoolean()) {
            sootType = BooleanType.v();
        } else if (type.isByte()) {
            sootType = ByteType.v();
        } else if (type.isChar()) {
            sootType = CharType.v();
        } else if (type.isDouble()) {
            sootType = DoubleType.v();
        } else if (type.isFloat()) {
            sootType = FloatType.v();
        } else if (type.isLong()) {
            sootType = LongType.v();
        } else if (type.isShort()) {
            sootType = ShortType.v();
        } else if (type.isNull()) {
            sootType = NullType.v();
        } else if (type.isVoid()) {
            sootType = VoidType.v();
        } else if (type.isClass()) {
            String className;
            ClassType classType = (ClassType)type;
            if (classType.isNested()) {
                if (classType.isAnonymous()) {
                    // empty if block
                }
                className = classType.fullName();
                StringBuffer sb = new StringBuffer(className);
                int lastDot = className.lastIndexOf(".");
                if (lastDot != -1) {
                    sb.replace(lastDot, lastDot + 1, "$");
                    className = sb.toString();
                }
            } else {
                className = classType.fullName();
            }
            sootType = RefType.v(className);
        } else {
            throw new RuntimeException("Unknown Type");
        }
        return sootType;
    }

    public static int getModifier(Flags flags) {
        int modifier = 0;
        if (flags.isPublic()) {
            modifier |= 1;
        }
        if (flags.isPrivate()) {
            modifier |= 2;
        }
        if (flags.isProtected()) {
            modifier |= 4;
        }
        if (flags.isFinal()) {
            modifier |= 0x10;
        }
        if (flags.isStatic()) {
            modifier |= 8;
        }
        if (flags.isNative()) {
            modifier |= 0x100;
        }
        if (flags.isAbstract()) {
            modifier |= 0x400;
        }
        if (flags.isVolatile()) {
            modifier |= 0x40;
        }
        if (flags.isTransient()) {
            modifier |= 0x80;
        }
        if (flags.isSynchronized()) {
            modifier |= 0x20;
        }
        if (flags.isInterface()) {
            modifier |= 0x200;
        }
        return modifier;
    }
}

