/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import java.util.ArrayList;
import java.util.Iterator;
import polyglot.types.MethodInstance;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.MethodSource;
import soot.RefLikeType;
import soot.ShortType;
import soot.SootMethod;
import soot.Type;
import soot.VoidType;
import soot.javaToJimple.Util;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;

public class PrivateMethodAccMethodSource
implements MethodSource {
    private MethodInstance methodInst;
    private int tempInt = -1;
    private int tempVoid = -1;
    private int tempBoolean = -1;
    private int tempLong = -1;
    private int tempDouble = -1;
    private int tempFloat = -1;
    private int tempRefLikeType = -1;
    private int tempByte = -1;
    private int tempShort = -1;

    public void setMethodInst(MethodInstance mi) {
        this.methodInst = mi;
    }

    private boolean isCallParamType(Type sootType) {
        Iterator it = this.methodInst.formalTypes().iterator();
        while (it.hasNext()) {
            Type compareType = Util.getSootType((polyglot.types.Type)it.next());
            if (!compareType.equals(sootType)) continue;
            return true;
        }
        return false;
    }

    public Body getBody(SootMethod sootMethod, String phaseName) {
        JimpleBody body = Jimple.v().newBody(sootMethod);
        Local base = null;
        ArrayList<Local> methParams = new ArrayList<Local>();
        ArrayList<Type> methParamsTypes = new ArrayList<Type>();
        Iterator paramIt = sootMethod.getParameterTypes().iterator();
        int paramCounter = 0;
        while (paramIt.hasNext()) {
            Type sootType = (Type)paramIt.next();
            Local paramLocal = this.generateLocal(sootType);
            body.getLocals().add(paramLocal);
            ParameterRef paramRef = Jimple.v().newParameterRef(sootType, paramCounter);
            IdentityStmt stmt = Jimple.v().newIdentityStmt(paramLocal, paramRef);
            body.getUnits().add(stmt);
            if (!this.isCallParamType(sootType)) {
                base = paramLocal;
            } else {
                methParams.add(paramLocal);
                methParamsTypes.add(paramLocal.getType());
            }
            ++paramCounter;
        }
        Type type = Util.getSootType(this.methodInst.returnType());
        Local returnLocal = null;
        if (!(type instanceof VoidType)) {
            returnLocal = this.generateLocal(type);
            body.getLocals().add(returnLocal);
        }
        SootMethod meth = sootMethod.getDeclaringClass().getMethod(this.methodInst.name(), methParamsTypes, Util.getSootType(this.methodInst.returnType()));
        InvokeExpr invoke = null;
        invoke = this.methodInst.flags().isStatic() ? Jimple.v().newStaticInvokeExpr(meth, methParams) : Jimple.v().newSpecialInvokeExpr(base, meth, methParams);
        Stmt stmt = null;
        stmt = !(type instanceof VoidType) ? Jimple.v().newAssignStmt(returnLocal, invoke) : Jimple.v().newInvokeStmt(invoke);
        body.getUnits().add(stmt);
        Stmt retStmt = null;
        retStmt = !(type instanceof VoidType) ? Jimple.v().newReturnStmt(returnLocal) : Jimple.v().newReturnVoidStmt();
        body.getUnits().add(retStmt);
        return body;
    }

    private Local generateLocal(Type type) {
        String name = "v";
        if (type instanceof IntType) {
            name = this.nextIntName();
        } else if (type instanceof ByteType) {
            name = this.nextByteName();
        } else if (type instanceof ShortType) {
            name = this.nextShortName();
        } else if (type instanceof BooleanType) {
            name = this.nextBooleanName();
        } else if (type instanceof VoidType) {
            name = this.nextVoidName();
        } else if (type instanceof CharType) {
            name = this.nextIntName();
            type = IntType.v();
        } else if (type instanceof DoubleType) {
            name = this.nextDoubleName();
        } else if (type instanceof FloatType) {
            name = this.nextFloatName();
        } else if (type instanceof LongType) {
            name = this.nextLongName();
        } else if (type instanceof RefLikeType) {
            name = this.nextRefLikeTypeName();
        } else {
            throw new RuntimeException("Unhandled Type of Local variable to Generate - Not Implemented");
        }
        return Jimple.v().newLocal(name, type);
    }

    private String nextIntName() {
        ++this.tempInt;
        return "$i" + this.tempInt;
    }

    private String nextVoidName() {
        ++this.tempVoid;
        return "$v" + this.tempVoid;
    }

    private String nextByteName() {
        ++this.tempByte;
        return "$b" + this.tempByte;
    }

    private String nextShortName() {
        ++this.tempShort;
        return "$s" + this.tempShort;
    }

    private String nextBooleanName() {
        ++this.tempBoolean;
        return "$z" + this.tempBoolean;
    }

    private String nextDoubleName() {
        ++this.tempDouble;
        return "$d" + this.tempDouble;
    }

    private String nextFloatName() {
        ++this.tempFloat;
        return "$f" + this.tempFloat;
    }

    private String nextLongName() {
        ++this.tempLong;
        return "$l" + this.tempLong;
    }

    private String nextRefLikeTypeName() {
        ++this.tempRefLikeType;
        return "$r" + this.tempRefLikeType;
    }
}

