/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import java.util.Iterator;
import polyglot.types.FieldInstance;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.MethodSource;
import soot.RefLikeType;
import soot.ShortType;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.VoidType;
import soot.javaToJimple.Util;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;

public class PrivateFieldAccMethodSource
implements MethodSource {
    private FieldInstance fieldInst;

    public void setFieldInst(FieldInstance fi) {
        this.fieldInst = fi;
    }

    public Body getBody(SootMethod sootMethod, String phaseName) {
        JimpleBody body = Jimple.v().newBody(sootMethod);
        Local fieldBase = null;
        Iterator paramIt = sootMethod.getParameterTypes().iterator();
        while (paramIt.hasNext()) {
            Type sootType = (Type)paramIt.next();
            Local paramLocal = Jimple.v().newLocal("$r0", sootType);
            body.getLocals().add(paramLocal);
            ParameterRef paramRef = Jimple.v().newParameterRef(sootType, 0);
            IdentityStmt stmt = Jimple.v().newIdentityStmt(paramLocal, paramRef);
            body.getUnits().add(stmt);
            fieldBase = paramLocal;
        }
        Type type = Util.getSootType(this.fieldInst.type());
        String name = "";
        if (type instanceof IntType) {
            name = "$i0";
        } else if (type instanceof ByteType) {
            name = "$b0";
        } else if (type instanceof ShortType) {
            name = "$s0";
        } else if (type instanceof BooleanType) {
            name = "$z0";
        } else if (type instanceof VoidType) {
            name = "$v0";
        } else if (type instanceof CharType) {
            name = "$i0";
            type = IntType.v();
        } else if (type instanceof DoubleType) {
            name = "$d0";
        } else if (type instanceof FloatType) {
            name = "$f0";
        } else if (type instanceof LongType) {
            name = "$l0";
        } else if (type instanceof RefLikeType) {
            name = "$r1";
        } else {
            throw new RuntimeException("Unhandled type");
        }
        Local fieldLocal = Jimple.v().newLocal(name, type);
        body.getLocals().add(fieldLocal);
        SootField field = sootMethod.getDeclaringClass().getField(this.fieldInst.name(), Util.getSootType(this.fieldInst.type()));
        FieldRef fieldRef = null;
        fieldRef = this.fieldInst.flags().isStatic() ? Jimple.v().newStaticFieldRef(field) : Jimple.v().newInstanceFieldRef(fieldBase, field);
        AssignStmt assign = Jimple.v().newAssignStmt(fieldLocal, fieldRef);
        body.getUnits().add(assign);
        ReturnStmt retStmt = Jimple.v().newReturnStmt(fieldLocal);
        body.getUnits().add(retStmt);
        return body;
    }
}

