/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Initializer;
import polyglot.ast.MethodDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.ProcedureDecl;
import polyglot.ast.Receiver;
import polyglot.ast.SourceFile;
import polyglot.ast.TypeNode;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.util.IdentityKey;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;
import soot.BooleanType;
import soot.MethodSource;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootResolver;
import soot.Type;
import soot.VoidType;
import soot.javaToJimple.AnonClassChecker;
import soot.javaToJimple.AnonClassInitMethodSource;
import soot.javaToJimple.AssertClassMethodSource;
import soot.javaToJimple.AssertStmtChecker;
import soot.javaToJimple.ClassLiteralChecker;
import soot.javaToJimple.ClassLiteralMethodSource;
import soot.javaToJimple.JavaToJimple;
import soot.javaToJimple.LocalClassChecker;
import soot.javaToJimple.LocalUsesChecker;
import soot.javaToJimple.MethodFinalsChecker;
import soot.javaToJimple.NestedClassListBuilder;
import soot.javaToJimple.PolyglotMethodSource;
import soot.javaToJimple.PrivateAccessChecker;
import soot.javaToJimple.PrivateFieldAccMethodSource;
import soot.javaToJimple.PrivateMethodAccMethodSource;
import soot.javaToJimple.TypeListBuilder;
import soot.javaToJimple.Util;
import soot.javaToJimple.jj.DPosition;
import soot.util.SourceLocator;

public class InitialResolver {
    private Node astNode;
    private SootClass sootClass;
    private ArrayList staticFieldInits;
    private ArrayList fieldInits;
    private HashMap fieldMap;
    private HashMap sourceToClassMap;
    private ArrayList initializerBlocks;
    private ArrayList staticInitializerBlocks;
    private Compiler compiler;
    private Position currentClassDeclPos;
    private HashMap anonClassMap;
    private HashMap localClassMap;
    private int privateAccessCounter = 0;
    private HashMap privateAccessMap;
    private HashMap finalsMap;
    private HashMap newToOuterMap;

    public void formAst(String fullPath, List locations) {
        JavaToJimple jtj = new JavaToJimple();
        ExtensionInfo extInfo = jtj.initExtInfo(fullPath, locations);
        if (this.compiler == null) {
            this.compiler = new Compiler(extInfo);
        }
        this.astNode = jtj.compile(this.compiler, fullPath, extInfo);
    }

    public void resolveFromJavaFile(SootClass sc, SootResolver resolver) {
        this.sootClass = sc;
        TypeListBuilder typeListBuilder = new TypeListBuilder();
        this.astNode.visit((NodeVisitor)typeListBuilder);
        Iterator it = typeListBuilder.getList().iterator();
        while (it.hasNext()) {
            String className;
            ClassType classType;
            polyglot.types.Type type = (polyglot.types.Type)it.next();
            if (type.isPrimitive() || !type.isClass() || (classType = (ClassType)type).isLocal() || classType.isAnonymous()) continue;
            if (classType.isNested()) {
                className = classType.fullName();
                while (classType.isNested()) {
                    resolver.assertResolvedClass(classType.outer().toString());
                    StringBuffer sb = new StringBuffer(className);
                    int lastDot = className.lastIndexOf(".");
                    if (lastDot != -1) {
                        sb.replace(lastDot, lastDot + 1, "$");
                        className = sb.toString();
                    }
                    classType = classType.outer();
                }
            } else {
                className = classType.fullName();
            }
            if (className.equals("java.lang.String[]")) continue;
            resolver.assertResolvedClass(className);
        }
        resolver.assertResolvedClass("java.lang.Object");
        resolver.assertResolvedClass("java.lang.StringBuffer");
        resolver.assertResolvedClass("java.lang.Throwable");
        this.resolveAnonClasses(resolver);
        this.resolveLocalClasses(resolver);
        ClassLiteralChecker classLitChecker = new ClassLiteralChecker();
        this.astNode.visit((NodeVisitor)classLitChecker);
        ArrayList classLitList = classLitChecker.getList();
        if (!classLitList.isEmpty()) {
            String methodName = "class$";
            RefType methodRetType = RefType.v("java.lang.Class");
            ArrayList<RefType> paramTypes = new ArrayList<RefType>();
            paramTypes.add(RefType.v("java.lang.String"));
            if (!sc.declaresMethod(methodName, paramTypes, methodRetType)) {
                SootMethod sootMethod = new SootMethod(methodName, paramTypes, methodRetType, 8);
                ClassLiteralMethodSource mSrc = new ClassLiteralMethodSource();
                sootMethod.setSource(mSrc);
                sc.addMethod(sootMethod);
            }
        }
        Iterator classLitIt = classLitList.iterator();
        while (classLitIt.hasNext()) {
            Field classLitField = (Field)classLitIt.next();
            Receiver receiver = classLitField.target();
            String fieldName = "class$";
            if (!(receiver instanceof TypeNode)) {
                throw new RuntimeException("class literal only valid on type nodes");
            }
            String type = ((TypeNode)receiver).type().toString();
            type = type.replace('.', '$');
            fieldName = fieldName + type;
            RefType fieldType = RefType.v("java.lang.Class");
            if (sc.declaresField(fieldName, fieldType)) continue;
            SootField sootField = new SootField(fieldName, fieldType, 8);
            sc.addField(sootField);
        }
        AssertStmtChecker asc = new AssertStmtChecker();
        this.astNode.visit((NodeVisitor)asc);
        if (asc.isHasAssert()) {
            this.handleAssert();
        }
        if (this.astNode instanceof SourceFile) {
            this.createSource((SourceFile)this.astNode);
        }
    }

    private void handleAssert() {
        MethodSource mSrc;
        SootMethod sootMethod;
        this.sootClass.addField(new SootField("$assertionsDisabled", BooleanType.v(), 24));
        this.sootClass.addField(new SootField("class$" + this.sootClass.getName(), RefType.v("java.lang.Class"), 8));
        String methodName = "class$";
        Type methodRetType = RefType.v("java.lang.Class");
        ArrayList<RefType> paramTypes = new ArrayList<RefType>();
        paramTypes.add(RefType.v("java.lang.String"));
        if (!this.sootClass.declaresMethod(methodName, paramTypes, methodRetType)) {
            sootMethod = new SootMethod(methodName, paramTypes, methodRetType, 8);
            mSrc = new AssertClassMethodSource();
            sootMethod.setSource(mSrc);
            this.sootClass.addMethod(sootMethod);
        }
        if (!this.sootClass.declaresMethod(methodName = "<clinit>", paramTypes = new ArrayList(), methodRetType = VoidType.v())) {
            sootMethod = new SootMethod(methodName, paramTypes, methodRetType, 8);
            mSrc = new PolyglotMethodSource();
            ((PolyglotMethodSource)mSrc).hasAssert(true);
            sootMethod.setSource(mSrc);
            this.sootClass.addMethod(sootMethod);
        } else {
            ((PolyglotMethodSource)this.sootClass.getMethod(methodName, paramTypes, methodRetType).getSource()).hasAssert(true);
        }
    }

    private void resolveAnonClasses(SootResolver resolver) {
        AnonClassChecker anonClassChecker = new AnonClassChecker();
        this.astNode.visit((NodeVisitor)anonClassChecker);
        Iterator keysIt = anonClassChecker.getMap().keySet().iterator();
        while (keysIt.hasNext()) {
            ClassType outer = (ClassType)keysIt.next();
            for (int i = 0; i < (Integer)anonClassChecker.getMap().get(outer); ++i) {
                String className = outer.toString() + "$" + (i + 1);
                resolver.assertResolvedClass(className);
            }
        }
        this.anonClassMap = anonClassChecker.getBodyNameMap();
    }

    private void resolveLocalClasses(SootResolver resolver) {
        LocalClassChecker localClassChecker = new LocalClassChecker();
        this.astNode.visit((NodeVisitor)localClassChecker);
        Iterator keysIt = localClassChecker.getMap().keySet().iterator();
        while (keysIt.hasNext()) {
            ClassType outer = (ClassType)keysIt.next();
            HashMap innerMap = (HashMap)localClassChecker.getMap().get(outer);
            Iterator valsIt = innerMap.keySet().iterator();
            while (valsIt.hasNext()) {
                String innerName = (String)valsIt.next();
                int count = (Integer)innerMap.get(innerName);
                for (int i = 0; i < count; ++i) {
                    String className = outer.toString() + "$" + count + "$" + innerName;
                    resolver.assertResolvedClass(className);
                }
            }
        }
        this.localClassMap = localClassChecker.getClassMap();
    }

    private void createSource(SourceFile source) {
        String simpleName = this.sootClass.getName();
        if (this.sootClass.getPackageName() != null) {
            simpleName = simpleName.substring(simpleName.lastIndexOf(".") + 1, simpleName.length());
        }
        Iterator declsIt = source.decls().iterator();
        boolean found = false;
        while (declsIt.hasNext()) {
            Object next = declsIt.next();
            if (!(next instanceof ClassDecl)) continue;
            if (((ClassDecl)next).name().equals(simpleName)) {
                this.createClassDecl((ClassDecl)next);
                found = true;
                continue;
            }
            this.addToClassToSourceMap(((ClassDecl)next).name(), this.sootClass.getName());
        }
        if (!found) {
            NestedClassListBuilder nestedClassBuilder = new NestedClassListBuilder();
            source.visit((NodeVisitor)nestedClassBuilder);
            Iterator nestedDeclsIt = nestedClassBuilder.getClassDeclsList().iterator();
            while (nestedDeclsIt.hasNext() && !found) {
                ClassDecl nextDecl = (ClassDecl)nestedDeclsIt.next();
                ParsedClassType type = nextDecl.type();
                if (type.isLocal() && !type.isAnonymous()) {
                    if (!this.localClassMap.containsKey(this.sootClass.getName())) continue;
                    this.createClassDecl((ClassDecl)this.localClassMap.get(this.sootClass.getName()));
                    found = true;
                    continue;
                }
                String outerName = type.outer().toString();
                while (type.outer().isNested() || type.outer().isInnerClass()) {
                    outerName = type.outer().outer().toString() + "$" + outerName;
                    type = type.outer();
                }
                String realName = outerName + "$" + nextDecl.name();
                if (!realName.equals(this.sootClass.getName())) continue;
                this.createClassDecl(nextDecl);
                found = true;
            }
            if (!found) {
                int index = this.sootClass.getName().indexOf("$");
                int length = this.sootClass.getName().length();
                int count = new Integer(this.sootClass.getName().substring(index + 1, length));
                int counter = 1;
                Iterator anonIt = nestedClassBuilder.getAnonClassBodyList().iterator();
                while (anonIt.hasNext()) {
                    New next = (New)anonIt.next();
                    String outerName = (String)this.newToOuterMap.get(next);
                    if (counter == count) {
                        this.createAnonClassDecl(next.objectType().type(), outerName, next);
                        this.createClassBody(next.body());
                    }
                    ++counter;
                }
            }
        }
    }

    private void addToClassToSourceMap(String className, String sourceName) {
        if (this.sourceToClassMap == null) {
            this.sourceToClassMap = new HashMap();
        }
        if (SourceLocator.v().getSourceToClassMap() == null) {
            SourceLocator.v().setSourceToClassMap(this.sourceToClassMap);
        }
        if (!SourceLocator.v().getSourceToClassMap().containsKey(className)) {
            SourceLocator.v().addToSourceToClassMap(className, sourceName);
        }
    }

    private void createAnonClassDecl(polyglot.types.Type type, String outerName, New next) {
        SootClass typeClass = Scene.v().getSootClass(type.toString());
        if (typeClass.isInterface()) {
            this.sootClass.addInterface(typeClass);
            this.sootClass.setSuperclass(Scene.v().getSootClass("java.lang.Object"));
        } else {
            this.sootClass.setSuperclass(typeClass);
        }
        SootField field = new SootField("this$0", Scene.v().getSootClass(outerName).getType(), 18);
        this.sootClass.addField(field);
        ArrayList<SootField> finalLocalsFields = new ArrayList<SootField>();
        if (this.finalsMap != null && this.finalsMap.containsKey(next)) {
            ArrayList finalLocals = (ArrayList)this.finalsMap.get(next);
            Iterator fIt = finalLocals.iterator();
            while (fIt.hasNext()) {
                LocalInstance li = (LocalInstance)((IdentityKey)fIt.next()).object();
                SootField sf = new SootField("val$" + li.name(), Util.getSootType(li.type()), 18);
                finalLocalsFields.add(sf);
                this.sootClass.addField(sf);
            }
        }
        ArrayList<Type> params = new ArrayList<Type>();
        params.add(Scene.v().getSootClass(outerName).getType());
        if (this.finalsMap != null && this.finalsMap.containsKey(next)) {
            ArrayList finalLocals = (ArrayList)this.finalsMap.get(next);
            Iterator fIt = finalLocals.iterator();
            while (fIt.hasNext()) {
                params.add(Util.getSootType(((LocalInstance)((IdentityKey)fIt.next()).object()).type()));
            }
        }
        if (typeClass.isInterface()) {
            SootMethod method = new SootMethod("<init>", params, VoidType.v());
            AnonClassInitMethodSource src = new AnonClassInitMethodSource();
            src.outerClassType(Scene.v().getSootClass(outerName).getType());
            method.setSource(src);
            this.sootClass.addMethod(method);
        } else {
            ArrayList<Type> allParams = new ArrayList<Type>();
            allParams.add(Scene.v().getSootClass(outerName).getType());
            Iterator aIt = next.arguments().iterator();
            while (aIt.hasNext()) {
                polyglot.types.Type pType = ((Expr)aIt.next()).type();
                allParams.add(Util.getSootType(pType));
            }
            if (this.finalsMap != null && this.finalsMap.containsKey(next)) {
                ArrayList finalLocals = (ArrayList)this.finalsMap.get(next);
                Iterator fIt = finalLocals.iterator();
                while (fIt.hasNext()) {
                    allParams.add(Util.getSootType(((LocalInstance)((IdentityKey)fIt.next()).object()).type()));
                }
            }
            SootMethod method = new SootMethod("<init>", allParams, VoidType.v());
            AnonClassInitMethodSource src = new AnonClassInitMethodSource();
            src.outerClassType(Scene.v().getSootClass(outerName).getType());
            src.setFieldList(finalLocalsFields);
            method.setSource(src);
            this.sootClass.addMethod(method);
        }
    }

    private void createClassDecl(ClassDecl cDecl) {
        Flags flags = cDecl.flags();
        this.addModifiers(flags);
        if (cDecl.superClass() == null) {
            SootClass superClass = Scene.v().getSootClass("java.lang.Object");
            this.sootClass.setSuperclass(superClass);
        } else {
            String superClassName = cDecl.superClass().toString();
            if (((ClassType)cDecl.superClass().type()).isNested()) {
                superClassName = this.fixInnerClassName((ClassType)cDecl.superClass().type());
            }
            SootClass superClass = Scene.v().getSootClass(superClassName);
            this.sootClass.setSuperclass(superClass);
        }
        Iterator interfacesIt = cDecl.interfaces().iterator();
        while (interfacesIt.hasNext()) {
            TypeNode next = (TypeNode)interfacesIt.next();
            this.sootClass.addInterface(Scene.v().getSootClass(next.toString()));
        }
        this.currentClassDeclPos = cDecl.position();
        this.createClassBody(cDecl.body());
        if (this.fieldInits != null || this.initializerBlocks != null) {
            Iterator methodsIt = this.sootClass.getMethods().iterator();
            while (methodsIt.hasNext()) {
                SootMethod next = (SootMethod)methodsIt.next();
                if (!next.getName().equals("<init>")) continue;
                ((PolyglotMethodSource)next.getSource()).setInitializerBlocks(this.initializerBlocks);
                ((PolyglotMethodSource)next.getSource()).setFieldInits(this.fieldInits);
            }
        }
        if (this.staticFieldInits != null || this.staticInitializerBlocks != null) {
            SootMethod clinitMethod;
            if (!this.sootClass.declaresMethod("<clinit>", new ArrayList(), VoidType.v())) {
                clinitMethod = new SootMethod("<clinit>", new ArrayList(), VoidType.v(), 8, new ArrayList());
                this.sootClass.addMethod(clinitMethod);
                clinitMethod.setSource(new PolyglotMethodSource());
            } else {
                clinitMethod = this.sootClass.getMethod("<clinit>", new ArrayList(), VoidType.v());
            }
            ((PolyglotMethodSource)clinitMethod.getSource()).setStaticFieldInits(this.staticFieldInits);
            ((PolyglotMethodSource)clinitMethod.getSource()).setStaticInitializerBlocks(this.staticInitializerBlocks);
        }
        if (cDecl.type().isNested() && !cDecl.flags().isStatic()) {
            ClassType outerType = cDecl.type().outer();
            Type outerSootType = Util.getSootType((polyglot.types.Type)outerType);
            Iterator it = this.sootClass.getMethods().iterator();
            while (it.hasNext()) {
                SootMethod meth = (SootMethod)it.next();
                if (!meth.getName().equals("<init>")) continue;
                meth.getParameterTypes().add(0, outerSootType);
            }
            SootField field = new SootField("this$0", outerSootType, 18);
            this.sootClass.addField(field);
        }
        Util.addLineTag(this.sootClass, (Node)cDecl);
    }

    private String fixInnerClassName(ClassType innerClass) {
        String fullName = innerClass.fullName();
        while (innerClass.isNested()) {
            StringBuffer sb = new StringBuffer(fullName);
            int lastDot = fullName.lastIndexOf(".");
            if (lastDot != -1) {
                sb.replace(lastDot, lastDot + 1, "$");
                fullName = sb.toString();
            }
            innerClass = innerClass.outer();
        }
        return fullName;
    }

    private void addModifiers(Flags flags) {
        int modifiers = Util.getModifier(flags);
        this.sootClass.setModifiers(modifiers);
    }

    private void createClassBody(ClassBody classBody) {
        this.staticFieldInits = null;
        this.fieldInits = null;
        this.initializerBlocks = null;
        this.staticInitializerBlocks = null;
        Iterator it = classBody.members().iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof MethodDecl) {
                this.createMethodDecl((MethodDecl)next);
                continue;
            }
            if (next instanceof FieldDecl) {
                this.createFieldDecl((FieldDecl)next);
                continue;
            }
            if (next instanceof ConstructorDecl) {
                this.createConstructorDecl((ConstructorDecl)next);
                continue;
            }
            if (next instanceof ClassDecl) {
                this.handlePrivateAccessors((ClassDecl)next);
                continue;
            }
            if (next instanceof Initializer) {
                this.createInitializer((Initializer)next);
                continue;
            }
            throw new RuntimeException("Class Body Member no implemented");
        }
    }

    private void handlePrivateAccessors(ClassDecl cDecl) {
        PrivateAccessChecker privateAccessChecker = new PrivateAccessChecker();
        cDecl.visit((NodeVisitor)privateAccessChecker);
        ArrayList privateAccessList = new ArrayList();
        Iterator listIt = privateAccessChecker.getList().iterator();
        while (listIt.hasNext()) {
            Object nextInst = listIt.next();
            if (nextInst instanceof FieldInstance && Util.getSootType((polyglot.types.Type)((FieldInstance)nextInst).container()).equals(this.sootClass.getType())) {
                privateAccessList.add(nextInst);
            }
            if (!(nextInst instanceof MethodInstance) || !Util.getSootType((polyglot.types.Type)((MethodInstance)nextInst).container()).equals(this.sootClass.getType())) continue;
            privateAccessList.add(nextInst);
        }
        Iterator it = privateAccessList.iterator();
        while (it.hasNext()) {
            MemberInstance inst = (MemberInstance)it.next();
            String name = "access$" + this.privateAccessCounter + "00";
            ArrayList<Type> paramTypesList = new ArrayList<Type>();
            if (inst instanceof MethodInstance) {
                Iterator paramsIt = ((MethodInstance)inst).formalTypes().iterator();
                while (paramsIt.hasNext()) {
                    paramTypesList.add(Util.getSootType((polyglot.types.Type)paramsIt.next()));
                }
            }
            if (!inst.flags().isStatic()) {
                paramTypesList.add(this.sootClass.getType());
            }
            Type returnType = null;
            returnType = inst instanceof MethodInstance ? Util.getSootType(((MethodInstance)inst).returnType()) : Util.getSootType(((FieldInstance)inst).type());
            SootMethod accessMeth = new SootMethod(name, paramTypesList, returnType, 8);
            if (inst instanceof MethodInstance) {
                PrivateMethodAccMethodSource pmams = new PrivateMethodAccMethodSource();
                pmams.setMethodInst((MethodInstance)inst);
                accessMeth.setSource(pmams);
            } else {
                PrivateFieldAccMethodSource pfams = new PrivateFieldAccMethodSource();
                pfams.setFieldInst((FieldInstance)inst);
                accessMeth.setSource(pfams);
            }
            this.sootClass.addMethod(accessMeth);
            if (this.privateAccessMap == null) {
                this.privateAccessMap = new HashMap();
            }
            this.privateAccessMap.put(inst, accessMeth);
            ++this.privateAccessCounter;
        }
    }

    private String createName(ProcedureDecl procedure) {
        return procedure.name();
    }

    private ArrayList createParameters(ProcedureDecl procedure) {
        ArrayList<Type> parameters = new ArrayList<Type>();
        Iterator formalsIt = procedure.formals().iterator();
        while (formalsIt.hasNext()) {
            Formal next = (Formal)formalsIt.next();
            parameters.add(Util.getSootType(next.type().type()));
        }
        return parameters;
    }

    private ArrayList createExceptions(ProcedureDecl procedure) {
        ArrayList<SootClass> exceptions = new ArrayList<SootClass>();
        Iterator throwsIt = procedure.throwTypes().iterator();
        while (throwsIt.hasNext()) {
            polyglot.types.Type throwType = ((TypeNode)throwsIt.next()).type();
            String nextException = throwType.toString();
            if (((ClassType)throwType).isNested()) {
                nextException = this.fixInnerClassName((ClassType)throwType);
            }
            exceptions.add(Scene.v().getSootClass(nextException));
        }
        return exceptions;
    }

    private void finishProcedure(ProcedureDecl procedure, SootMethod sootMethod) {
        this.addProcedureToClass(sootMethod);
        if (procedure.position() != null && procedure.position() instanceof DPosition) {
            DPosition dpos = (DPosition)procedure.position();
            if (procedure.body() != null && procedure.body().position() != null && procedure.body().position() instanceof DPosition) {
                DPosition bodyDpos = (DPosition)procedure.body().position();
                Util.addLnPosTags(sootMethod, dpos.line(), bodyDpos.endLine(), dpos.column(), bodyDpos.endCol());
            }
        }
        MethodFinalsChecker mfc = new MethodFinalsChecker();
        mfc.setCurrentSootClass(this.sootClass.getName());
        if (procedure.body() != null) {
            procedure.body().visit((NodeVisitor)mfc);
        }
        if (this.newToOuterMap == null) {
            this.newToOuterMap = new HashMap();
        }
        if (mfc.getNewToOuter().keySet() != null) {
            Iterator newIt = mfc.getNewToOuter().keySet().iterator();
            while (newIt.hasNext()) {
                Object next = newIt.next();
                this.newToOuterMap.put(next, mfc.getNewToOuter().get(next));
            }
        }
        if (mfc.getLocals() != null && mfc.getClassNames() != null) {
            if (this.finalsMap == null) {
                this.finalsMap = new HashMap();
            }
            Iterator it = mfc.getClassNames().iterator();
            while (it.hasNext()) {
                ArrayList<IdentityKey> finalLocals = new ArrayList<IdentityKey>();
                New key = (New)it.next();
                LocalUsesChecker luc = new LocalUsesChecker();
                key.body().visit((NodeVisitor)luc);
                Iterator localsIt = luc.getLocals().iterator();
                while (localsIt.hasNext()) {
                    LocalInstance testLocal = (LocalInstance)((IdentityKey)localsIt.next()).object();
                    if (luc.getLocalDecls().contains(new IdentityKey((Object)testLocal))) continue;
                    finalLocals.add(new IdentityKey((Object)testLocal));
                }
                this.finalsMap.put(key, finalLocals);
            }
        }
        PolyglotMethodSource mSrc = new PolyglotMethodSource(procedure.body(), procedure.formals());
        mSrc.setFinalsMap(this.finalsMap);
        mSrc.setNewToOuterMap(this.newToOuterMap);
        mSrc.setPrivateAccessMap(this.privateAccessMap);
        if (this.localClassMap != null) {
            mSrc.setLocalClassMap(this.localClassMap);
        }
        if (this.anonClassMap != null) {
            mSrc.setAnonClassMap(this.anonClassMap);
        }
        sootMethod.setSource(mSrc);
    }

    private void addProcedureToClass(SootMethod method) {
        this.sootClass.addMethod(method);
    }

    private void createMethodDecl(MethodDecl method) {
        String name = this.createName((ProcedureDecl)method);
        ArrayList parameters = this.createParameters((ProcedureDecl)method);
        ArrayList exceptions = this.createExceptions((ProcedureDecl)method);
        SootMethod sootMethod = this.createSootMethod(name, method.flags(), method.returnType().type(), parameters, exceptions);
        this.finishProcedure((ProcedureDecl)method, sootMethod);
    }

    private SootMethod createSootMethod(String name, Flags flags, polyglot.types.Type returnType, ArrayList parameters, ArrayList exceptions) {
        int modifier = Util.getModifier(flags);
        Type sootReturnType = Util.getSootType(returnType);
        SootMethod method = new SootMethod(name, parameters, sootReturnType, modifier, exceptions);
        return method;
    }

    private void createFieldDecl(FieldDecl field) {
        int modifiers = Util.getModifier(field.fieldInstance().flags());
        String name = field.fieldInstance().name();
        Type sootType = Util.getSootType(field.fieldInstance().type());
        SootField sootField = new SootField(name, sootType, modifiers);
        this.sootClass.addField(sootField);
        if (this.fieldMap == null) {
            this.fieldMap = new HashMap();
        }
        this.fieldMap.put(field.fieldInstance(), sootField);
        if (field.fieldInstance().flags().isStatic()) {
            if (field.init() != null) {
                if (this.staticFieldInits == null) {
                    this.staticFieldInits = new ArrayList();
                }
                this.staticFieldInits.add(field);
            }
        } else if (field.init() != null) {
            if (this.fieldInits == null) {
                this.fieldInits = new ArrayList();
            }
            this.fieldInits.add(field);
        }
        Util.addLnPosTags(sootField, field.position());
    }

    private void createInitializer(Initializer initializer) {
        if (initializer.flags().isStatic()) {
            if (this.staticInitializerBlocks == null) {
                this.staticInitializerBlocks = new ArrayList();
            }
            this.staticInitializerBlocks.add(initializer.body());
        } else {
            if (this.initializerBlocks == null) {
                this.initializerBlocks = new ArrayList();
            }
            this.initializerBlocks.add(initializer.body());
        }
    }

    private void createConstructorDecl(ConstructorDecl constructor) {
        String name = "<init>";
        ArrayList parameters = this.createParameters((ProcedureDecl)constructor);
        ArrayList exceptions = this.createExceptions((ProcedureDecl)constructor);
        SootMethod sootMethod = this.createSootConstructor(name, constructor.flags(), parameters, exceptions);
        this.finishProcedure((ProcedureDecl)constructor, sootMethod);
    }

    private SootMethod createSootConstructor(String name, Flags flags, ArrayList parameters, ArrayList exceptions) {
        int modifier = Util.getModifier(flags);
        SootMethod method = new SootMethod(name, parameters, VoidType.v(), modifier);
        return method;
    }
}

