/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.finders;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import soot.G;
import soot.Singletons;
import soot.Value;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.RetriggerAnalysisException;
import soot.dava.internal.SET.SETNode;
import soot.dava.internal.SET.SETSwitchNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.asg.AugmentedStmtGraph;
import soot.dava.toolkits.base.finders.ExceptionNode;
import soot.dava.toolkits.base.finders.FactFinder;
import soot.dava.toolkits.base.finders.IndexComparator;
import soot.dava.toolkits.base.finders.SwitchNode;
import soot.dava.toolkits.base.finders.SwitchNodeGraph;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.util.IterableSet;

public class SwitchFinder
implements FactFinder {
    private IterableSet junkBody;
    private HashSet targetSet;
    private LinkedList targetList;
    private LinkedList snTargetList;
    private LinkedList tSuccList;
    private HashMap index2target;
    private HashMap tSucc2indexSet;
    private HashMap tSucc2target;
    private HashMap tSucc2Body;

    public SwitchFinder(Singletons.Global g) {
    }

    public static SwitchFinder v() {
        return G.v().SwitchFinder();
    }

    public void find(DavaBody davaBody, AugmentedStmtGraph asg, SETNode SET) throws RetriggerAnalysisException {
        Dava.v().log("SwitchFinder::find()");
        String defaultStr = "default";
        Iterator asgit = asg.iterator();
        while (asgit.hasNext()) {
            SwitchNode sn;
            AugmentedStmt as = (AugmentedStmt)asgit.next();
            Stmt s = as.get_Stmt();
            if (!(s instanceof TableSwitchStmt) && !(s instanceof LookupSwitchStmt)) continue;
            Value key = null;
            this.junkBody = new IterableSet();
            this.targetSet = new HashSet();
            this.targetList = new LinkedList();
            this.snTargetList = new LinkedList();
            this.tSuccList = new LinkedList();
            this.index2target = new HashMap();
            this.tSucc2indexSet = new HashMap();
            this.tSucc2target = new HashMap();
            this.tSucc2Body = new HashMap();
            if (s instanceof TableSwitchStmt) {
                TableSwitchStmt tss = (TableSwitchStmt)s;
                int target_count = tss.getHighIndex() - tss.getLowIndex() + 1;
                for (int i = 0; i < target_count; ++i) {
                    this.build_Bindings(as, new Integer(i + tss.getLowIndex()), asg.get_AugStmt((Stmt)tss.getTarget(i)));
                }
                this.build_Bindings(as, "default", asg.get_AugStmt((Stmt)tss.getDefaultTarget()));
                key = tss.getKey();
            } else if (s instanceof LookupSwitchStmt) {
                LookupSwitchStmt lss = (LookupSwitchStmt)s;
                int target_count = lss.getTargetCount();
                for (int i = 0; i < target_count; ++i) {
                    this.build_Bindings(as, new Integer(lss.getLookupValue(i)), asg.get_AugStmt((Stmt)lss.getTarget(i)));
                }
                this.build_Bindings(as, "default", asg.get_AugStmt((Stmt)lss.getDefaultTarget()));
                key = lss.getKey();
            }
            Iterator tsit = this.tSuccList.iterator();
            while (tsit.hasNext()) {
                AugmentedStmt tSucc = (AugmentedStmt)tsit.next();
                AugmentedStmt target = (AugmentedStmt)this.tSucc2target.get(tSucc);
                this.snTargetList.addLast(new SwitchNode(target, (TreeSet)this.tSucc2indexSet.get(tSucc), (IterableSet)this.tSucc2Body.get(tSucc)));
            }
            TreeSet targetHeads = new TreeSet();
            TreeSet killBodies = new TreeSet();
            asg.calculate_Reachability((Collection)this.targetList, this.targetSet, as);
            SwitchNodeGraph sng = new SwitchNodeGraph(this.snTargetList);
            killBodies.addAll(this.snTargetList);
            this.snTargetList = new LinkedList();
            LinkedList<SwitchNode> worklist = new LinkedList<SwitchNode>();
            worklist.addAll(sng.getHeads());
            while (!worklist.isEmpty()) {
                SwitchNode sn2 = (SwitchNode)worklist.removeFirst();
                this.snTargetList.addLast(sn2);
                killBodies.remove(sn2);
                SwitchNode champ = null;
                Iterator sit = sn2.get_Succs().iterator();
                while (sit.hasNext()) {
                    SwitchNode ssn = (SwitchNode)sit.next();
                    if (champ != null && champ.get_Score() >= ssn.get_Score()) continue;
                    champ = ssn;
                }
                if (champ == null || champ.get_Score() <= 0) continue;
                worklist.addLast(champ);
            }
            Iterator kit = killBodies.iterator();
            while (kit.hasNext()) {
                sn = (SwitchNode)kit.next();
                IterableSet snBody = sn.get_Body();
                snBody.clear();
                snBody.add(sn.get_AugStmt());
            }
            sng = new SwitchNodeGraph(this.snTargetList);
            targetHeads.addAll(sng.getHeads());
            LinkedList<SwitchNode> switchNodeList = new LinkedList<SwitchNode>();
            block7: while (!targetHeads.isEmpty() || !killBodies.isEmpty()) {
                SwitchNode nextNode;
                if (targetHeads.isEmpty() || !targetHeads.isEmpty() && !killBodies.isEmpty() && ((SwitchNode)targetHeads.first()).compareTo(killBodies.first()) > 0) {
                    nextNode = (SwitchNode)killBodies.first();
                    killBodies.remove(nextNode);
                    switchNodeList.addLast(nextNode);
                    continue;
                }
                nextNode = (SwitchNode)targetHeads.first();
                targetHeads.remove(nextNode);
                while (true) {
                    switchNodeList.addLast(nextNode);
                    if (nextNode.get_Succs().isEmpty()) continue block7;
                    nextNode = (SwitchNode)nextNode.get_Succs().get(0);
                }
            }
            IterableSet body = new IterableSet();
            body.add(as);
            Iterator snlit = switchNodeList.iterator();
            while (snlit.hasNext()) {
                sn = (SwitchNode)snlit.next();
                body.addAll(sn.get_Body());
                if (!sn.get_IndexSet().contains("default")) continue;
                sn.get_IndexSet().clear();
                sn.get_IndexSet().add("default");
            }
            body.addAll(this.junkBody);
            Iterator enlit = davaBody.get_ExceptionFacts().iterator();
            while (enlit.hasNext()) {
                ExceptionNode en = (ExceptionNode)enlit.next();
                IterableSet tryBody = en.get_TryBody();
                if (!tryBody.contains(as)) continue;
                Iterator fbit = body.snapshotIterator();
                block11: while (fbit.hasNext()) {
                    AugmentedStmt fbas = (AugmentedStmt)fbit.next();
                    if (tryBody.contains(fbas)) continue;
                    body.remove(fbas);
                    snlit = switchNodeList.iterator();
                    while (snlit.hasNext()) {
                        IterableSet switchBody = ((SwitchNode)snlit.next()).get_Body();
                        if (!switchBody.contains(fbas)) continue;
                        switchBody.remove(fbas);
                        continue block11;
                    }
                }
            }
            SET.nest(new SETSwitchNode(as, key, body, switchNodeList, this.junkBody));
        }
    }

    private IterableSet find_SubBody(AugmentedStmt switchAS, AugmentedStmt branchS) {
        IterableSet subBody = new IterableSet();
        LinkedList<AugmentedStmt> worklist = new LinkedList<AugmentedStmt>();
        subBody.add(branchS);
        branchS = (AugmentedStmt)branchS.bsuccs.get(0);
        if (branchS.get_Dominators().contains(switchAS)) {
            worklist.addLast(branchS);
            subBody.add(branchS);
        }
        while (!worklist.isEmpty()) {
            AugmentedStmt as = (AugmentedStmt)worklist.removeFirst();
            Iterator sit = as.csuccs.iterator();
            while (sit.hasNext()) {
                AugmentedStmt sas = (AugmentedStmt)sit.next();
                if (subBody.contains(sas) || !sas.get_Dominators().contains(branchS)) continue;
                worklist.addLast(sas);
                subBody.add(sas);
            }
        }
        return subBody;
    }

    private void build_Bindings(AugmentedStmt swAs, Object index, AugmentedStmt target) {
        AugmentedStmt tSucc = (AugmentedStmt)target.bsuccs.get(0);
        if (this.targetSet.add(tSucc)) {
            this.targetList.addLast(tSucc);
        }
        this.index2target.put(index, target);
        TreeSet<Object> indices = null;
        indices = (TreeSet<Object>)this.tSucc2indexSet.get(tSucc);
        if (indices == null) {
            indices = new TreeSet<Object>(new IndexComparator());
            this.tSucc2indexSet.put(tSucc, indices);
            this.tSucc2target.put(tSucc, target);
            this.tSucc2Body.put(tSucc, this.find_SubBody(swAs, target));
            this.tSuccList.add(tSucc);
        } else {
            this.junkBody.add(target);
            Iterator sit = target.bsuccs.iterator();
            while (sit.hasNext()) {
                ((AugmentedStmt)sit.next()).bpreds.remove(target);
            }
            sit = target.csuccs.iterator();
            while (sit.hasNext()) {
                ((AugmentedStmt)sit.next()).cpreds.remove(target);
            }
            target.bsuccs.clear();
            target.csuccs.clear();
        }
        indices.add(index);
    }
}

