/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.internal.AST;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.dava.internal.AST.ASTLabeledNode;
import soot.dava.internal.SET.SETNodeLabel;
import soot.dava.toolkits.base.AST.ASTAnalysis;
import soot.dava.toolkits.base.AST.ASTWalker;
import soot.dava.toolkits.base.AST.TryContentsFinder;
import soot.jimple.Jimple;

public class ASTSwitchNode
extends ASTLabeledNode {
    private ValueBox keyBox;
    private List indexList;
    private Map index2BodyList;

    public ASTSwitchNode(SETNodeLabel label, Value key, List indexList, Map index2BodyList) {
        super(label);
        this.keyBox = Jimple.v().newRValueBox(key);
        this.indexList = indexList;
        this.index2BodyList = index2BodyList;
        Iterator it = indexList.iterator();
        while (it.hasNext()) {
            List body = (List)index2BodyList.get(it.next());
            if (body == null) continue;
            this.subBodies.add(body);
        }
    }

    public Value get_Key() {
        return this.keyBox.getValue();
    }

    public Object clone() {
        return new ASTSwitchNode(this.get_Label(), this.get_Key(), this.indexList, this.index2BodyList);
    }

    public void perform_Analysis(ASTAnalysis a) {
        ASTWalker.v().walk_value(a, this.get_Key());
        if (a instanceof TryContentsFinder) {
            TryContentsFinder tcf = (TryContentsFinder)a;
            tcf.v().add_ExceptionSet(this, tcf.v().remove_CurExceptionSet());
        }
        this.perform_AnalysisOnSubBodies(a);
    }

    public void toString(UnitPrinter up) {
        this.label_toString(up);
        up.literal("switch");
        up.literal(" ");
        up.literal("(");
        this.keyBox.toString(up);
        up.literal(")");
        up.newline();
        up.literal("{");
        up.newline();
        Iterator it = this.indexList.iterator();
        while (it.hasNext()) {
            Object index = it.next();
            up.incIndent();
            if (index instanceof String) {
                up.literal("default");
            } else {
                up.literal("case");
                up.literal(" ");
                up.literal(index.toString());
            }
            up.literal(":");
            up.newline();
            List subBody = (List)this.index2BodyList.get(index);
            if (subBody != null) {
                up.incIndent();
                this.body_toString(up, subBody);
                if (it.hasNext()) {
                    up.newline();
                }
                up.decIndent();
            }
            up.decIndent();
        }
        up.literal("}");
        up.newline();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.label_toString());
        b.append("switch (");
        b.append(this.get_Key());
        b.append(")");
        b.append("\n");
        b.append("{");
        b.append("\n");
        Iterator it = this.indexList.iterator();
        while (it.hasNext()) {
            Object index = it.next();
            b.append("    ");
            if (index instanceof String) {
                b.append("default");
            } else {
                b.append("case ");
                b.append(((Integer)index).toString());
            }
            b.append(":");
            b.append("\n");
            List subBody = (List)this.index2BodyList.get(index);
            if (subBody == null) continue;
            b.append(this.body_toString(subBody));
            if (!it.hasNext()) continue;
            b.append("\n");
        }
        b.append("}");
        b.append("\n");
        return b.toString();
    }
}

