/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import soot.G;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.tagkit.Host;
import soot.tagkit.JimpleLineNumberTag;
import soot.tagkit.LineNumberTag;
import soot.tagkit.SourceLineNumberTag;
import soot.tagkit.Tag;
import soot.util.StringTools;
import soot.xml.TagCollector;

public class XMLAttributesPrinter {
    private String inFilename;
    private String useFilename;
    private SootClass sootClass;
    private String outputDir;
    private ArrayList attributes;
    FileOutputStream streamOut = null;
    PrintWriter writerOut = null;

    private void setOutputDir(String dir) {
        this.outputDir = dir;
    }

    private String getOutputDir() {
        return this.outputDir;
    }

    public XMLAttributesPrinter(String filename, String outputDir) {
        this.setInFilename(filename);
        this.setOutputDir(outputDir);
        this.initAttributesDir();
        this.createUseFilename();
        this.initFile();
    }

    private void initFile() {
        this.attributes = new ArrayList();
        try {
            this.streamOut = new FileOutputStream(this.getUseFilename());
            this.writerOut = new PrintWriter(new OutputStreamWriter(this.streamOut));
            this.writerOut.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            this.writerOut.println("<attributes>");
        }
        catch (IOException e1) {
            G.v().out.println(e1.getMessage());
        }
    }

    private void finishFile() {
        this.writerOut.println("</attributes>");
        this.writerOut.close();
    }

    public void printAttrs(SootClass c, TagCollector tc) {
        tc.collectKeyTags(c);
        Iterator fIt = c.getFields().iterator();
        while (fIt.hasNext()) {
            SootField sf = (SootField)fIt.next();
            tc.collectFieldTags(sf);
        }
        Iterator mIt = c.getMethods().iterator();
        while (mIt.hasNext()) {
            SootMethod sm = (SootMethod)mIt.next();
            tc.collectMethodTags(sm);
        }
        tc.printTags(this.writerOut);
        tc.printKeys(this.writerOut);
        this.finishFile();
    }

    public void printAttrs(SootClass c) {
        TagCollector tc = new TagCollector();
        tc.collectKeyTags(c);
        tc.collectTags(c);
        tc.printTags(this.writerOut);
        tc.printKeys(this.writerOut);
        this.finishFile();
    }

    private int getJavaLnOfHost(Host h) {
        Iterator it = h.getTags().iterator();
        while (it.hasNext()) {
            Tag t = (Tag)it.next();
            if (t instanceof SourceLineNumberTag) {
                return ((SourceLineNumberTag)t).getStartLineNumber();
            }
            if (!(t instanceof LineNumberTag)) continue;
            return new Integer(((LineNumberTag)t).toString());
        }
        return 0;
    }

    private int getJimpleLnOfHost(Host h) {
        Iterator it = h.getTags().iterator();
        while (it.hasNext()) {
            Tag t = (Tag)it.next();
            if (!(t instanceof JimpleLineNumberTag)) continue;
            return ((JimpleLineNumberTag)t).getStartLineNumber();
        }
        return 0;
    }

    private void initAttributesDir() {
        StringBuffer sb = new StringBuffer();
        String attrDir = "attributes";
        sb.append(this.getOutputDir());
        sb.append(System.getProperty("file.separator"));
        sb.append(attrDir);
        File dir = new File(sb.toString());
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (SecurityException se) {
                G.v().out.println("Unable to create " + attrDir);
            }
        }
    }

    private String formatForXML(String in) {
        in = StringTools.replaceAll(in, "<", "&lt;");
        in = StringTools.replaceAll(in, ">", "&gt;");
        in = StringTools.replaceAll(in, "&", "&amp;");
        return in;
    }

    private void createUseFilename() {
        String tmp = this.getInFilename();
        int slash = (tmp = tmp.substring(0, tmp.lastIndexOf(46))).lastIndexOf(System.getProperty("file.separator"));
        if (slash != -1) {
            tmp = tmp.substring(slash + 1, tmp.length());
        }
        StringBuffer sb = new StringBuffer();
        String attrDir = "attributes";
        sb.append(this.getOutputDir());
        sb.append(System.getProperty("file.separator"));
        sb.append(attrDir);
        sb.append(System.getProperty("file.separator"));
        sb.append(tmp);
        sb.append(".xml");
        this.setUseFilename(sb.toString());
    }

    private void setInFilename(String file) {
        this.useFilename = file;
    }

    private String getInFilename() {
        return this.useFilename;
    }

    private void setUseFilename(String file) {
        this.useFilename = file;
    }

    private String getUseFilename() {
        return this.useFilename;
    }
}

