/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.Iterator;
import soot.G;
import soot.options.Options;

public class Timer {
    private long duration;
    private long startTime;
    private boolean hasStarted;
    private String name;

    public Timer(String name) {
        this.name = name;
        this.duration = 0L;
    }

    public Timer() {
        this("unnamed");
    }

    public void start() {
        if (!G.v().Timer_isGarbageCollecting && Options.v() != null && Options.v().subtract_gc() && G.v().Timer_count++ % 4 == 0) {
            Timer t;
            G.v().Timer_isGarbageCollecting = true;
            G.v().Timer_forcedGarbageCollectionTimer.start();
            Iterator timerIt = G.v().Timer_outstandingTimers.iterator();
            while (timerIt.hasNext()) {
                t = (Timer)timerIt.next();
                t.end();
            }
            System.gc();
            timerIt = G.v().Timer_outstandingTimers.iterator();
            while (timerIt.hasNext()) {
                t = (Timer)timerIt.next();
                t.start();
            }
            G.v().Timer_forcedGarbageCollectionTimer.end();
            G.v().Timer_isGarbageCollecting = false;
        }
        this.startTime = System.currentTimeMillis();
        if (this.hasStarted) {
            throw new RuntimeException("timer " + this.name + " has already been started!");
        }
        this.hasStarted = true;
        if (!G.v().Timer_isGarbageCollecting) {
            G.v().Timer_outstandingTimers.add(this);
        }
    }

    public String toString() {
        return this.name;
    }

    public void end() {
        if (!this.hasStarted) {
            throw new RuntimeException("timer " + this.name + " has not been started!");
        }
        this.hasStarted = false;
        this.duration += System.currentTimeMillis() - this.startTime;
        if (!G.v().Timer_isGarbageCollecting) {
            G.v().Timer_outstandingTimers.remove(this);
        }
    }

    public long getTime() {
        return this.duration;
    }
}

