/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import soot.ArrayType;
import soot.G;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.coffi.Util;
import soot.javaToJimple.InitialResolver;
import soot.jimple.JimpleMethodSource;
import soot.jimple.parser.JimpleAST;
import soot.options.Options;
import soot.util.ClassInputStream;
import soot.util.JavaInputStream;
import soot.util.JimpleInputStream;
import soot.util.SourceLocator;

public class SootResolver {
    private Set markedClasses = new HashSet();
    private LinkedList classesToResolve = new LinkedList();
    private boolean mIsResolving = false;
    private InitialResolver initSourceResolver;

    public SootClass getResolvedClass(String className) {
        SootClass newClass;
        if (Scene.v().containsClass(className)) {
            return Scene.v().getSootClass(className);
        }
        if (this.mIsResolving) {
            newClass = new SootClass(className);
            Scene.v().addClass(newClass);
            this.markedClasses.add(newClass);
            this.classesToResolve.addLast(newClass);
        } else {
            newClass = this.resolveClassAndSupportClasses(className);
        }
        return newClass;
    }

    public SootClass resolveClassAndSupportClasses(String className) {
        this.mIsResolving = true;
        SootClass resolvedClass = this.getResolvedClass(className);
        while (!this.classesToResolve.isEmpty()) {
            InputStream is = null;
            SootClass sc = (SootClass)this.classesToResolve.removeFirst();
            className = sc.getName();
            try {
                is = SourceLocator.v().getInputStreamOf(className);
            }
            catch (ClassNotFoundException e) {
                if (!Scene.v().allowsPhantomRefs()) {
                    throw new RuntimeException("couldn't find type: " + className + " (is your soot-class-path set properly?)");
                }
                G.v().out.println("Warning: " + className + " is a phantom class!");
                sc.setPhantomClass();
                continue;
            }
            Object s = null;
            if (is instanceof ClassInputStream) {
                if (Options.v().verbose()) {
                    G.v().out.println("resolving [from .class]: " + className);
                }
                Util.v().resolveFromClassFile(sc, is, this, Scene.v());
            } else if (is instanceof JimpleInputStream) {
                if (Options.v().verbose()) {
                    G.v().out.println("resolving [from .jimple]: " + className);
                }
                if (sc == null) {
                    throw new RuntimeException("sc is null!!");
                }
                JimpleAST jimpAST = new JimpleAST((JimpleInputStream)is, this);
                jimpAST.getSkeleton(sc);
                JimpleMethodSource mtdSrc = new JimpleMethodSource(jimpAST);
                Iterator mtdIt = sc.methodIterator();
                while (mtdIt.hasNext()) {
                    SootMethod sm = (SootMethod)mtdIt.next();
                    sm.setSource(mtdSrc);
                }
                Iterator it = jimpAST.getCstPool().iterator();
                while (it.hasNext()) {
                    String nclass = (String)it.next();
                    this.assertResolvedClass(nclass);
                }
            } else if (is instanceof JavaInputStream) {
                if (Options.v().verbose()) {
                    G.v().out.println("resolving [from .java]: " + className);
                }
                if (this.initSourceResolver == null) {
                    this.initSourceResolver = new InitialResolver();
                }
                this.initSourceResolver.formAst(SourceLocator.v().getFullPathFound(), SourceLocator.v().getLocationsFound());
                this.initSourceResolver.resolveFromJavaFile(sc, this);
            } else {
                throw new RuntimeException("could not resolve class: " + is + " (is your soot-class-path correct?)");
            }
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException("!?");
            }
        }
        this.mIsResolving = false;
        return resolvedClass;
    }

    public void assertResolvedClassForType(Type type) {
        if (type instanceof RefType) {
            this.assertResolvedClass(((RefType)type).getClassName());
        } else if (type instanceof ArrayType) {
            this.assertResolvedClassForType(((ArrayType)type).baseType);
        }
    }

    public void assertResolvedClass(String className) {
        if (!Scene.v().containsClass(className)) {
            SootClass newClass = new SootClass(className);
            Scene.v().addClass(newClass);
            this.markedClasses.add(newClass);
            this.classesToResolve.addLast(newClass);
        }
    }
}

