/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.ClassMember;
import soot.DoubleType;
import soot.ErroneousType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.MethodSource;
import soot.Modifier;
import soot.NullType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.StmtAddressType;
import soot.Type;
import soot.dava.DavaBody;
import soot.jimple.JasminClass;
import soot.jimple.toolkits.callgraph.MethodOrMethodContext;
import soot.tagkit.AbstractHost;
import soot.util.Numberable;
import soot.util.NumberedString;

public class SootMethod
extends AbstractHost
implements ClassMember,
Numberable,
MethodOrMethodContext {
    public static final String constructorName = "<init>";
    public static final String staticInitializerName = "<clinit>";
    String name;
    List parameterTypes;
    Type returnType;
    boolean isDeclared;
    SootClass declaringClass;
    int modifiers;
    boolean isPhantom = false;
    List exceptions = null;
    Body activeBody;
    protected MethodSource ms;
    private NumberedString subsignature;
    private int number = 0;

    private Body getBodyFromMethodSource(String phaseName) {
        return this.ms.getBody(this, phaseName);
    }

    public void setSource(MethodSource ms) {
        this.ms = ms;
    }

    public MethodSource getSource() {
        return this.ms;
    }

    public int equivHashCode() {
        return this.returnType.hashCode() * 101 + this.modifiers * 17 + this.name.hashCode();
    }

    public SootMethod(String name, List parameterTypes, Type returnType) {
        this.name = name;
        this.parameterTypes = new ArrayList();
        this.parameterTypes.addAll(parameterTypes);
        this.returnType = returnType;
        Scene.v().getMethodNumberer().add(this);
        this.subsignature = Scene.v().getSubSigNumberer().findOrAdd(this.getSubSignature());
    }

    public SootMethod(String name, List parameterTypes, Type returnType, int modifiers) {
        this.name = name;
        this.parameterTypes = new ArrayList();
        this.parameterTypes.addAll(parameterTypes);
        this.returnType = returnType;
        this.modifiers = modifiers;
        Scene.v().getMethodNumberer().add(this);
        this.subsignature = Scene.v().getSubSigNumberer().findOrAdd(this.getSubSignature());
    }

    public SootMethod(String name, List parameterTypes, Type returnType, int modifiers, List thrownExceptions) {
        this.name = name;
        this.parameterTypes = new ArrayList();
        this.parameterTypes.addAll(parameterTypes);
        this.returnType = returnType;
        this.modifiers = modifiers;
        if (this.exceptions == null && !thrownExceptions.isEmpty()) {
            this.exceptions = new ArrayList();
            this.exceptions.addAll(thrownExceptions);
        }
        Scene.v().getMethodNumberer().add(this);
        this.subsignature = Scene.v().getSubSigNumberer().findOrAdd(this.getSubSignature());
    }

    public String getName() {
        return this.name;
    }

    public SootClass getDeclaringClass() {
        if (!this.isDeclared) {
            throw new RuntimeException("not declared: " + this.getName());
        }
        return this.declaringClass;
    }

    public void setDeclared(boolean isDeclared) {
        this.isDeclared = isDeclared;
    }

    public boolean isDeclared() {
        return this.isDeclared;
    }

    public boolean isPhantom() {
        return this.isPhantom;
    }

    public boolean isConcrete() {
        return !this.isPhantom() && !this.isAbstract() && !this.isNative();
    }

    public void setPhantom(boolean value) {
        if (value) {
            if (!Scene.v().allowsPhantomRefs()) {
                throw new RuntimeException("Phantom refs not allowed");
            }
            if (this.declaringClass != null && !this.declaringClass.isPhantom()) {
                throw new RuntimeException("Declaring class would have to be phantom");
            }
        }
        this.isPhantom = value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        if (this.declaringClass != null && !this.declaringClass.isApplicationClass()) {
            throw new RuntimeException("Cannot set modifiers of a method from a non-app class!");
        }
        this.modifiers = modifiers;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Type t) {
        this.returnType = t;
    }

    public int getParameterCount() {
        return this.parameterTypes.size();
    }

    public Type getParameterType(int n) {
        return (Type)this.parameterTypes.get(n);
    }

    public List getParameterTypes() {
        return this.parameterTypes;
    }

    public Body getActiveBody() {
        if (this.declaringClass.isPhantomClass()) {
            throw new RuntimeException("cannot get active body for phantom class: " + this.getSignature());
        }
        if (!this.hasActiveBody()) {
            throw new RuntimeException("no active body present for method " + this.getSignature());
        }
        return this.activeBody;
    }

    public Body retrieveActiveBody() {
        if (this.declaringClass.isPhantomClass()) {
            throw new RuntimeException("cannot get resident body for phantom class : " + this.getSignature() + "; maybe you want to call c.setApplicationClass() on this class!");
        }
        if (!this.hasActiveBody()) {
            this.setActiveBody(this.getBodyFromMethodSource("jb"));
            this.ms = null;
        }
        return this.getActiveBody();
    }

    public void setActiveBody(Body body) {
        if (this.declaringClass != null && this.declaringClass.isPhantomClass()) {
            throw new RuntimeException("cannot set active body for phantom class! " + this);
        }
        if (!this.isConcrete()) {
            throw new RuntimeException("cannot set body for non-concrete method! " + this);
        }
        if (body.getMethod() != this) {
            body.setMethod(this);
        }
        this.activeBody = body;
    }

    public boolean hasActiveBody() {
        return this.activeBody != null;
    }

    public void releaseActiveBody() {
        this.activeBody = null;
    }

    public void addExceptionIfAbsent(SootClass e) {
        if (!this.throwsException(e)) {
            this.addException(e);
        }
    }

    public void addException(SootClass e) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        } else if (this.exceptions.contains(e)) {
            throw new RuntimeException("already throws exception " + e.getName());
        }
        this.exceptions.add(e);
    }

    public void removeException(SootClass e) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        if (!this.exceptions.contains(e)) {
            throw new RuntimeException("does not throw exception " + e.getName());
        }
        this.exceptions.remove(e);
    }

    public boolean throwsException(SootClass e) {
        return this.exceptions != null && this.exceptions.contains(e);
    }

    public void setExceptions(List exceptions) {
        this.exceptions = new ArrayList();
        this.exceptions.addAll(exceptions);
    }

    public List getExceptions() {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        return this.exceptions;
    }

    public void setParameterTypes(List parameterTypes) {
        this.parameterTypes = new ArrayList();
        this.parameterTypes.addAll(parameterTypes);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isNative() {
        return Modifier.isNative(this.getModifiers());
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.getModifiers());
    }

    public String getBytecodeSignature() {
        String name = this.getName();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<" + Scene.v().quotedNameOf(this.getDeclaringClass().getName()) + ": ");
        buffer.append(name);
        buffer.append(JasminClass.jasminDescriptorOf(this));
        buffer.append(">");
        return new String(buffer.toString());
    }

    public String getSignature() {
        String name = this.getName();
        List params = this.getParameterTypes();
        Type returnType = this.getReturnType();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<" + Scene.v().quotedNameOf(this.getDeclaringClass().getName()) + ": ");
        buffer.append(SootMethod.getSubSignatureImpl(name, params, returnType));
        buffer.append(">");
        return new String(buffer.toString());
    }

    public String getSubSignature() {
        String name = this.getName();
        List params = this.getParameterTypes();
        Type returnType = this.getReturnType();
        return SootMethod.getSubSignatureImpl(name, params, returnType);
    }

    public static String getSubSignature(String name, List params, Type returnType) {
        return SootMethod.getSubSignatureImpl(name, params, returnType);
    }

    private static String getSubSignatureImpl(String name, List params, Type returnType) {
        StringBuffer buffer = new StringBuffer();
        Type t = returnType;
        buffer.append(t.toString() + " " + Scene.v().quotedNameOf(name) + "(");
        Iterator typeIt = params.iterator();
        if (typeIt.hasNext()) {
            t = (Type)typeIt.next();
            buffer.append(t);
            while (typeIt.hasNext()) {
                buffer.append(",");
                t = (Type)typeIt.next();
                buffer.append(t);
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    public NumberedString getNumberedSubSignature() {
        return this.subsignature;
    }

    public String toString() {
        return this.getSignature();
    }

    public String getDavaDeclaration() {
        Iterator exceptionIt;
        if (this.getName().equals(staticInitializerName)) {
            return "static";
        }
        StringBuffer buffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(Modifier.toString(this.getModifiers()));
        if (st.hasMoreTokens()) {
            buffer.append(st.nextToken());
        }
        while (st.hasMoreTokens()) {
            buffer.append(" " + st.nextToken());
        }
        if (buffer.length() != 0) {
            buffer.append(" ");
        }
        if (this.getName().equals(constructorName)) {
            buffer.append(this.getDeclaringClass().getShortJavaStyleName());
        } else {
            Type t = this.getReturnType();
            buffer.append(t + " ");
            buffer.append(Scene.v().quotedNameOf(this.getName()));
        }
        buffer.append("(");
        Iterator typeIt = this.getParameterTypes().iterator();
        int count = 0;
        while (typeIt.hasNext()) {
            Type t = (Type)typeIt.next();
            buffer.append(t);
            buffer.append(" ");
            if (this.hasActiveBody()) {
                buffer.append(((DavaBody)this.getActiveBody()).get_ParamMap().get(new Integer(count++)));
            } else if (t == BooleanType.v()) {
                buffer.append("z" + count++);
            } else if (t == ByteType.v()) {
                buffer.append("b" + count++);
            } else if (t == ShortType.v()) {
                buffer.append("s" + count++);
            } else if (t == CharType.v()) {
                buffer.append("c" + count++);
            } else if (t == IntType.v()) {
                buffer.append("i" + count++);
            } else if (t == LongType.v()) {
                buffer.append("l" + count++);
            } else if (t == DoubleType.v()) {
                buffer.append("d" + count++);
            } else if (t == FloatType.v()) {
                buffer.append("f" + count++);
            } else if (t == StmtAddressType.v()) {
                buffer.append("a" + count++);
            } else if (t == ErroneousType.v()) {
                buffer.append("e" + count++);
            } else if (t == NullType.v()) {
                buffer.append("n" + count++);
            } else {
                buffer.append("r" + count++);
            }
            if (!typeIt.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        if (this.exceptions != null && (exceptionIt = this.getExceptions().iterator()).hasNext()) {
            buffer.append(" throws " + ((SootClass)exceptionIt.next()).getName());
            while (exceptionIt.hasNext()) {
                buffer.append(", " + ((SootClass)exceptionIt.next()).getName());
            }
        }
        return buffer.toString();
    }

    public String getDeclaration() {
        Iterator exceptionIt;
        StringBuffer buffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(Modifier.toString(this.getModifiers()));
        if (st.hasMoreTokens()) {
            buffer.append(st.nextToken());
        }
        while (st.hasMoreTokens()) {
            buffer.append(" " + st.nextToken());
        }
        if (buffer.length() != 0) {
            buffer.append(" ");
        }
        buffer.append(this.getReturnType() + " ");
        buffer.append(Scene.v().quotedNameOf(this.getName()));
        buffer.append("(");
        Iterator typeIt = this.getParameterTypes().iterator();
        boolean count = false;
        while (typeIt.hasNext()) {
            Type t = (Type)typeIt.next();
            buffer.append(t);
            if (!typeIt.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        if (this.exceptions != null && (exceptionIt = this.getExceptions().iterator()).hasNext()) {
            buffer.append(" throws " + ((SootClass)exceptionIt.next()).getName());
            while (exceptionIt.hasNext()) {
                buffer.append(", " + ((SootClass)exceptionIt.next()).getName());
            }
        }
        return buffer.toString();
    }

    public final int getNumber() {
        return this.number;
    }

    public final void setNumber(int number) {
        this.number = number;
    }

    public SootMethod method() {
        return this;
    }

    public Object context() {
        return null;
    }
}

