/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.Modifier;
import soot.RefType;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.baf.BafBody;
import soot.dava.toolkits.base.misc.PackageNamer;
import soot.tagkit.AbstractHost;
import soot.util.Chain;
import soot.util.HashChain;
import soot.util.Numberable;
import soot.util.NumberedString;
import soot.util.SmallNumberedMap;

public class SootClass
extends AbstractHost
implements Numberable {
    protected String name;
    protected String shortName;
    protected String fixedShortName;
    protected String packageName;
    protected String fixedPackageName;
    protected int modifiers;
    protected Chain fields = new HashChain();
    protected SmallNumberedMap subSigToMethods = new SmallNumberedMap(Scene.v().getSubSigNumberer());
    protected Chain interfaces = new HashChain();
    protected boolean isInScene;
    protected SootClass superClass;
    protected boolean isPhantom;
    private RefType refType;
    private int number = 0;

    public SootClass(String name, int modifiers) {
        this.setName(name);
        this.modifiers = modifiers;
        this.refType = RefType.v(name);
        this.refType.setSootClass(this);
    }

    public SootClass(String name) {
        this(name, 0);
    }

    public boolean isInScene() {
        return this.isInScene;
    }

    public void setInScene(boolean isInScene) {
        this.isInScene = isInScene;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public Chain getFields() {
        return this.fields;
    }

    public void addField(SootField f) {
        if (f.isDeclared()) {
            throw new RuntimeException("already declared: " + f.getName());
        }
        if (this.declaresField(f.getName())) {
            throw new RuntimeException("Field already exists : " + f.getName());
        }
        this.fields.add(f);
        f.isDeclared = true;
        f.declaringClass = this;
    }

    public void removeField(SootField f) {
        if (!f.isDeclared() || f.getDeclaringClass() != this) {
            throw new RuntimeException("did not declare: " + f.getName());
        }
        this.fields.remove(f);
        f.isDeclared = false;
    }

    private SootField findFieldInClass(String name, Type type) {
        Iterator fieldIt = this.getFields().iterator();
        while (fieldIt.hasNext()) {
            SootField field = (SootField)fieldIt.next();
            if (!field.name.equals(name) || !field.type.equals(type)) continue;
            return field;
        }
        return null;
    }

    public SootField getField(String name, Type type) {
        SootField ret = null;
        ret = this.findFieldInClass(name, type);
        if (ret != null) {
            return ret;
        }
        if (Scene.v().allowsPhantomRefs() && this.isPhantom()) {
            SootField f = new SootField(name, type);
            f.setPhantom(true);
            this.addField(f);
            return f;
        }
        LinkedList queue = new LinkedList();
        queue.addAll(this.getInterfaces());
        while (!queue.isEmpty()) {
            SootClass iface = (SootClass)queue.removeFirst();
            ret = iface.findFieldInClass(name, type);
            if (ret != null) {
                return ret;
            }
            queue.addAll(iface.getInterfaces());
        }
        if (this.hasSuperclass()) {
            return this.getSuperclass().getField(name, type);
        }
        throw new RuntimeException("No field " + name + " in class " + this.getName());
    }

    public SootField getFieldByName(String name) {
        boolean found = false;
        SootField foundField = null;
        Iterator fieldIt = this.getFields().iterator();
        while (fieldIt.hasNext()) {
            SootField field = (SootField)fieldIt.next();
            if (!field.name.equals(name)) continue;
            if (found) {
                throw new RuntimeException("ambiguous field: " + name);
            }
            found = true;
            foundField = field;
        }
        if (found) {
            return foundField;
        }
        throw new RuntimeException("No field " + name + " in class " + this.getName());
    }

    public SootField getField(String subsignature) {
        Iterator fieldIt = this.getFields().iterator();
        while (fieldIt.hasNext()) {
            SootField field = (SootField)fieldIt.next();
            if (!field.getSubSignature().equals(subsignature)) continue;
            return field;
        }
        throw new RuntimeException("No field " + subsignature + " in class " + this.getName());
    }

    public boolean declaresField(String subsignature) {
        Iterator fieldIt = this.getFields().iterator();
        while (fieldIt.hasNext()) {
            SootField field = (SootField)fieldIt.next();
            if (!field.getSubSignature().equals(subsignature)) continue;
            return true;
        }
        return false;
    }

    public SootMethod getMethod(NumberedString subsignature) {
        SootMethod ret = (SootMethod)this.subSigToMethods.get(subsignature);
        if (ret == null) {
            throw new RuntimeException("No method " + subsignature + " in class " + this.getName());
        }
        return ret;
    }

    public boolean declaresMethod(NumberedString subsignature) {
        SootMethod ret = (SootMethod)this.subSigToMethods.get(subsignature);
        return ret != null;
    }

    public SootMethod getMethod(String subsignature) {
        return this.getMethod(Scene.v().getSubSigNumberer().findOrAdd(subsignature));
    }

    public boolean declaresMethod(String subsignature) {
        return this.declaresMethod(Scene.v().getSubSigNumberer().findOrAdd(subsignature));
    }

    public boolean declaresFieldByName(String name) {
        Iterator fieldIt = this.getFields().iterator();
        while (fieldIt.hasNext()) {
            SootField field = (SootField)fieldIt.next();
            if (!field.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean declaresField(String name, Type type) {
        Iterator fieldIt = this.getFields().iterator();
        while (fieldIt.hasNext()) {
            SootField field = (SootField)fieldIt.next();
            if (!field.name.equals(name) || !field.type.equals(type)) continue;
            return true;
        }
        return false;
    }

    public int getMethodCount() {
        return this.subSigToMethods.nonNullSize();
    }

    public Iterator methodIterator() {
        return this.subSigToMethods.iterator();
    }

    public List getMethods() {
        ArrayList ret = new ArrayList();
        Iterator it = this.methodIterator();
        while (it.hasNext()) {
            ret.add(it.next());
        }
        return ret;
    }

    private SootMethod findMethodInClass(String name, List parameterTypes, Type returnType) {
        Iterator methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod method = (SootMethod)methodIt.next();
            if (!method.getName().equals(name) || !((Object)parameterTypes).equals(method.getParameterTypes()) || !returnType.equals(method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    public SootMethod getMethod(String name, List parameterTypes, Type returnType) {
        SootMethod ret = null;
        SootClass cl = this;
        while (true) {
            if ((ret = cl.findMethodInClass(name, parameterTypes, returnType)) != null) {
                return ret;
            }
            if (Scene.v().allowsPhantomRefs() && cl.isPhantom()) {
                SootMethod m = new SootMethod(name, parameterTypes, returnType);
                m.setPhantom(true);
                cl.addMethod(m);
                return m;
            }
            if (!cl.hasSuperclass()) break;
            cl = cl.getSuperclass();
        }
        cl = this;
        while (true) {
            LinkedList queue = new LinkedList();
            queue.addAll(cl.getInterfaces());
            while (!queue.isEmpty()) {
                SootClass iface = (SootClass)queue.removeFirst();
                ret = iface.findMethodInClass(name, parameterTypes, returnType);
                if (ret != null) {
                    return ret;
                }
                queue.addAll(iface.getInterfaces());
            }
            if (!cl.hasSuperclass()) break;
            cl = cl.getSuperclass();
        }
        throw new RuntimeException("Class " + this.getName() + " doesn't have method " + name + "(" + parameterTypes + ")" + " : " + returnType + "; failed to resolve in superclasses and interfaces");
    }

    public SootMethod getMethod(String name, List parameterTypes) {
        boolean found = false;
        SootMethod foundMethod = null;
        Iterator methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod method = (SootMethod)methodIt.next();
            if (!method.getName().equals(name) || !((Object)parameterTypes).equals(method.getParameterTypes())) continue;
            if (found) {
                throw new RuntimeException("ambiguous method");
            }
            found = true;
            foundMethod = method;
        }
        if (found) {
            return foundMethod;
        }
        throw new RuntimeException("couldn't find method");
    }

    public SootMethod getMethodByName(String name) {
        boolean found = false;
        SootMethod foundMethod = null;
        Iterator methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod method = (SootMethod)methodIt.next();
            if (!method.getName().equals(name)) continue;
            if (found) {
                throw new RuntimeException("ambiguous method");
            }
            found = true;
            foundMethod = method;
        }
        if (found) {
            return foundMethod;
        }
        throw new RuntimeException("couldn't find method");
    }

    public boolean declaresMethod(String name, List parameterTypes) {
        Iterator methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod method = (SootMethod)methodIt.next();
            if (!method.getName().equals(name) || !((Object)method.getParameterTypes()).equals(parameterTypes)) continue;
            return true;
        }
        return false;
    }

    public boolean declaresMethod(String name, List parameterTypes, Type returnType) {
        Iterator methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod method = (SootMethod)methodIt.next();
            if (!method.getName().equals(name) || !((Object)method.getParameterTypes()).equals(parameterTypes) || !method.getReturnType().equals(returnType)) continue;
            return true;
        }
        return false;
    }

    public boolean declaresMethodByName(String name) {
        Iterator methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod method = (SootMethod)methodIt.next();
            if (!method.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addMethod(SootMethod m) {
        if (m.isDeclared()) {
            throw new RuntimeException("already declared: " + m.getName());
        }
        this.subSigToMethods.put(m.getNumberedSubSignature(), m);
        m.isDeclared = true;
        m.declaringClass = this;
    }

    public void removeMethod(SootMethod m) {
        if (!m.isDeclared() || m.getDeclaringClass() != this) {
            throw new RuntimeException("incorrect declarer for remove: " + m.getName());
        }
        this.subSigToMethods.put(m.getNumberedSubSignature(), null);
        m.isDeclared = false;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getInterfaceCount() {
        return this.interfaces.size();
    }

    public Chain getInterfaces() {
        return this.interfaces;
    }

    public boolean implementsInterface(String name) {
        Iterator interfaceIt = this.getInterfaces().iterator();
        while (interfaceIt.hasNext()) {
            SootClass SootClass2 = (SootClass)interfaceIt.next();
            if (!SootClass2.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addInterface(SootClass interfaceClass) {
        if (this.implementsInterface(interfaceClass.getName())) {
            throw new RuntimeException("duplicate interface: " + interfaceClass.getName());
        }
        this.interfaces.add(interfaceClass);
    }

    public void removeInterface(SootClass interfaceClass) {
        if (!this.implementsInterface(interfaceClass.getName())) {
            throw new RuntimeException("no such interface: " + interfaceClass.getName());
        }
        this.interfaces.remove(interfaceClass);
    }

    public boolean hasSuperclass() {
        return this.superClass != null;
    }

    public SootClass getSuperclass() {
        if (this.superClass == null) {
            throw new RuntimeException("no superclass");
        }
        return this.superClass;
    }

    public void setSuperclass(SootClass c) {
        this.superClass = c;
    }

    public String getName() {
        return this.name;
    }

    public String getJavaStyleName() {
        if (PackageNamer.v().has_FixedNames()) {
            if (this.fixedShortName == null) {
                this.fixedShortName = PackageNamer.v().get_FixedClassName(this.name);
            }
            if (!PackageNamer.v().use_ShortName(this.getJavaPackageName(), this.fixedShortName)) {
                return this.getJavaPackageName() + "." + this.fixedShortName;
            }
            return this.fixedShortName;
        }
        return this.shortName;
    }

    public String getShortJavaStyleName() {
        if (PackageNamer.v().has_FixedNames()) {
            if (this.fixedShortName == null) {
                this.fixedShortName = PackageNamer.v().get_FixedClassName(this.name);
            }
            return this.fixedShortName;
        }
        return this.shortName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getJavaPackageName() {
        if (PackageNamer.v().has_FixedNames()) {
            if (this.fixedPackageName == null) {
                this.fixedPackageName = PackageNamer.v().get_FixedPackageName(this.packageName);
            }
            return this.fixedPackageName;
        }
        return this.packageName;
    }

    private void setName(String name) {
        this.name = name;
        this.shortName = name;
        this.packageName = "";
        int index = name.lastIndexOf(46);
        if (index > 0) {
            this.shortName = name.substring(index + 1);
            this.packageName = name.substring(0, index);
        }
        this.fixedShortName = null;
        this.fixedPackageName = null;
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean containsBafBody() {
        Iterator methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod m = (SootMethod)methodIt.next();
            if (!m.hasActiveBody() || !(m.getActiveBody() instanceof BafBody)) continue;
            return true;
        }
        return false;
    }

    void setRefType(RefType refType) {
        this.refType = refType;
    }

    public boolean hasRefType() {
        return this.refType != null;
    }

    public RefType getType() {
        return this.refType;
    }

    public String toString() {
        return this.getName();
    }

    public void renameFieldsAndMethods(boolean privateOnly) {
        Iterator fieldIt = this.getFields().iterator();
        int fieldCount = 0;
        if (fieldIt.hasNext()) {
            while (fieldIt.hasNext()) {
                SootField f = (SootField)fieldIt.next();
                if (privateOnly && !Modifier.isPrivate(f.getModifiers())) continue;
                String newFieldName = "__field" + fieldCount++;
                f.setName(newFieldName);
            }
        }
        Iterator methodIt = this.methodIterator();
        int methodCount = 0;
        if (methodIt.hasNext()) {
            while (methodIt.hasNext()) {
                SootMethod m = (SootMethod)methodIt.next();
                if (privateOnly && !Modifier.isPrivate(m.getModifiers())) continue;
                String newMethodName = "__method" + methodCount++;
                m.setName(newMethodName);
            }
        }
    }

    public boolean isApplicationClass() {
        return Scene.v().getApplicationClasses().contains(this);
    }

    public void setApplicationClass() {
        Chain c = Scene.v().getContainingChain(this);
        if (c != null) {
            c.remove(this);
        }
        Scene.v().getApplicationClasses().add(this);
        this.isPhantom = false;
    }

    public boolean isLibraryClass() {
        return Scene.v().getLibraryClasses().contains(this);
    }

    public void setLibraryClass() {
        Chain c = Scene.v().getContainingChain(this);
        if (c != null) {
            c.remove(this);
        }
        Scene.v().getLibraryClasses().add(this);
        this.isPhantom = false;
    }

    public boolean isPhantomClass() {
        return Scene.v().getPhantomClasses().contains(this);
    }

    public void setPhantomClass() {
        Chain c = Scene.v().getContainingChain(this);
        if (c != null) {
            c.remove(this);
        }
        Scene.v().getPhantomClasses().add(this);
        this.isPhantom = true;
    }

    public boolean isPhantom() {
        return this.isPhantom;
    }

    public void setPhantom(boolean value) {
        if (!value) {
            if (this.isPhantom) {
                throw new RuntimeException("don't know how to de-phantomize this class");
            }
            return;
        }
        this.setPhantomClass();
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public final int getNumber() {
        return this.number;
    }

    public final void setNumber(int number) {
        this.number = number;
    }
}

