/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.Date;
import java.util.Iterator;
import soot.CompilationDeathException;
import soot.G;
import soot.Pack;
import soot.PackManager;
import soot.Scene;
import soot.Singletons;
import soot.Timers;
import soot.Transform;
import soot.options.Options;

public class Main {
    public final String versionString = "2.1.0";
    private Date start;
    private Date finish;
    public String[] cmdLineArgs;

    public Main(Singletons.Global g) {
    }

    public static Main v() {
        return G.v().Main();
    }

    private void printVersion() {
        G.v().out.println("Soot version 2.1.0");
        G.v().out.println("Copyright (C) 1997-2003 Raja Vallee-Rai and others.");
        G.v().out.println("All rights reserved.");
        G.v().out.println("");
        G.v().out.println("Contributions are copyright (C) 1997-2003 by their respective contributors.");
        G.v().out.println("See the file 'credits' for a list of contributors.");
        G.v().out.println("See individual source files for details.");
        G.v().out.println("");
        G.v().out.println("Soot comes with ABSOLUTELY NO WARRANTY.  Soot is free software,");
        G.v().out.println("and you are welcome to redistribute it under certain conditions.");
        G.v().out.println("See the accompanying file 'COPYING-LESSER.txt' for details.");
        G.v().out.println();
        G.v().out.println("Visit the Soot website:");
        G.v().out.println("  http://www.sable.mcgill.ca/soot/");
        G.v().out.println();
        G.v().out.println("For a list of command line options, enter:");
        G.v().out.println("  java soot.Main --help");
    }

    private void processCmdLine(String[] args) {
        if (!Options.v().parse(args)) {
            throw new CompilationDeathException(0, "Option parse error");
        }
        if (PackManager.v().onlyStandardPacks()) {
            Iterator packIt = PackManager.v().allPacks().iterator();
            while (packIt.hasNext()) {
                Pack pack = (Pack)packIt.next();
                Options.v().warnForeignPhase(pack.getPhaseName());
                Iterator trIt = pack.iterator();
                while (trIt.hasNext()) {
                    Transform tr = (Transform)trIt.next();
                    Options.v().warnForeignPhase(tr.getPhaseName());
                }
            }
        }
        Options.v().warnNonexistentPhase();
        if (Options.v().help()) {
            G.v().out.println(Options.v().getUsage());
            throw new CompilationDeathException(1);
        }
        if (Options.v().phase_list()) {
            G.v().out.println(Options.v().getPhaseList());
            throw new CompilationDeathException(1);
        }
        if (!Options.v().phase_help().isEmpty()) {
            Iterator phaseIt = Options.v().phase_help().iterator();
            while (phaseIt.hasNext()) {
                String phase = (String)phaseIt.next();
                G.v().out.println(Options.v().getPhaseHelp(phase));
            }
            throw new CompilationDeathException(1);
        }
        if (args.length == 0 || Options.v().version()) {
            this.printVersion();
            throw new CompilationDeathException(1);
        }
        this.postCmdLineCheck();
    }

    private void exitCompilation(int status) {
        this.exitCompilation(status, "");
    }

    private void exitCompilation(int status, String msg) {
        if (status == 0) {
            G.v().out.println("compilation failed: " + msg);
        }
    }

    private void postCmdLineCheck() {
        if (Options.v().classes().isEmpty() && (Options.v().whole_program() || Options.v().process_dir().isEmpty())) {
            throw new CompilationDeathException(0, "No main class specified!");
        }
    }

    public static void main(String[] args) {
        try {
            Main.v().run(args);
        }
        catch (OutOfMemoryError e) {
            G.v().out.println("Soot has run out of the memory allocated to it by the Java VM.");
            G.v().out.println("To allocate more memory to Soot, use the -Xmx switch to Java.");
            G.v().out.println("For example (for 400MB): java -Xmx400m soot.Main ...");
            throw e;
        }
    }

    public int run(String[] args) {
        this.cmdLineArgs = args;
        this.start = new Date();
        try {
            Timers.v().totalTimer.start();
            this.processCmdLine(this.cmdLineArgs);
            G.v().out.println("Soot started on " + this.start);
            Scene.v().loadNecessaryClasses();
            PackManager.v().runPacks();
            PackManager.v().writeOutput();
            Timers.v().totalTimer.end();
            if (Options.v().time()) {
                Timers.v().printProfilingInformation();
            }
        }
        catch (CompilationDeathException e) {
            Timers.v().totalTimer.end();
            this.exitCompilation(e.getStatus(), e.getMessage());
            return e.getStatus();
        }
        this.finish = new Date();
        G.v().out.println("Soot finished on " + this.finish);
        long runtime = this.finish.getTime() - this.start.getTime();
        G.v().out.println("Soot has run for " + runtime / 60000L + " min. " + runtime % 60000L / 1000L + " sec.");
        this.exitCompilation(1);
        return 1;
    }
}

