/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import soot.Local;
import soot.PatchingChain;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.ValueBox;
import soot.jimple.IdentityStmt;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.options.Options;
import soot.tagkit.AbstractHost;
import soot.tagkit.CodeAttribute;
import soot.tagkit.Tag;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.scalar.SimpleLocalDefs;
import soot.util.Chain;
import soot.util.HashChain;

public abstract class Body
extends AbstractHost
implements Serializable {
    protected transient SootMethod method = null;
    protected Chain localChain = new HashChain();
    protected Chain trapChain = new HashChain();
    protected PatchingChain unitChain = new PatchingChain(new HashChain());

    public abstract Object clone();

    protected Body(SootMethod m) {
        this.method = m;
    }

    protected Body() {
    }

    public SootMethod getMethod() {
        if (this.method == null) {
            throw new RuntimeException("no method associated w/ body");
        }
        return this.method;
    }

    public void setMethod(SootMethod method) {
        this.method = method;
    }

    public int getLocalCount() {
        return this.localChain.size();
    }

    public void importBodyContentsFrom(Body b) {
        ValueBox vb;
        Object copy;
        Object original;
        HashMap<Object, Object> bindings = new HashMap<Object, Object>();
        Iterator it = b.getUnits().iterator();
        while (it.hasNext()) {
            original = (Unit)it.next();
            copy = (Unit)original.clone();
            this.unitChain.addLast(copy);
            bindings.put(original, copy);
        }
        it = b.getTraps().iterator();
        while (it.hasNext()) {
            original = (Trap)it.next();
            copy = (Trap)original.clone();
            this.trapChain.addLast(copy);
            bindings.put(original, copy);
        }
        it = b.getLocals().iterator();
        while (it.hasNext()) {
            original = (Value)it.next();
            copy = (Value)original.clone();
            this.localChain.addLast(copy);
            bindings.put(original, copy);
        }
        it = this.getAllUnitBoxes().iterator();
        while (it.hasNext()) {
            UnitBox box = (UnitBox)it.next();
            Unit oldObject = box.getUnit();
            Unit newObject = (Unit)bindings.get(oldObject);
            if (newObject == null) continue;
            box.setUnit(newObject);
        }
        it = this.getUseBoxes().iterator();
        while (it.hasNext()) {
            vb = (ValueBox)it.next();
            if (!(vb.getValue() instanceof Local)) continue;
            vb.setValue((Value)bindings.get(vb.getValue()));
        }
        it = this.getDefBoxes().iterator();
        while (it.hasNext()) {
            vb = (ValueBox)it.next();
            if (!(vb.getValue() instanceof Local)) continue;
            vb.setValue((Value)bindings.get(vb.getValue()));
        }
    }

    public void validate() {
        this.validateLocals();
        this.validateTraps();
        this.validateUnitBoxes();
        if (Options.v().debug()) {
            this.validateUses();
        }
    }

    public void validateLocals() {
        Iterator it = this.getUseBoxes().iterator();
        while (it.hasNext()) {
            this.validateLocal((ValueBox)it.next());
        }
        it = this.getDefBoxes().iterator();
        while (it.hasNext()) {
            this.validateLocal((ValueBox)it.next());
        }
    }

    private void validateLocal(ValueBox vb) {
        Value value = vb.getValue();
        if (value instanceof Local && !this.localChain.contains(value)) {
            throw new RuntimeException("Local not in chain : " + value);
        }
    }

    public void validateTraps() {
        Iterator it = this.getTraps().iterator();
        while (it.hasNext()) {
            Trap t = (Trap)it.next();
            if (!this.unitChain.contains(t.getBeginUnit())) {
                throw new RuntimeException("begin not in chain");
            }
            if (!this.unitChain.contains(t.getEndUnit())) {
                throw new RuntimeException("end not in chain");
            }
            if (this.unitChain.contains(t.getHandlerUnit())) continue;
            throw new RuntimeException("handler not in chain");
        }
    }

    public void validateUnitBoxes() {
        Iterator it = this.getAllUnitBoxes().iterator();
        while (it.hasNext()) {
            UnitBox ub = (UnitBox)it.next();
            if (this.unitChain.contains(ub.getUnit())) continue;
            throw new RuntimeException("Unitbox points outside unitChain! to unit : " + ub.getUnit());
        }
    }

    public void validateUses() {
        SimpleLocalDefs ld = new SimpleLocalDefs(new CompleteUnitGraph(this));
        Iterator unitsIt = this.getUnits().iterator();
        while (unitsIt.hasNext()) {
            Unit u = (Unit)unitsIt.next();
            Iterator useBoxIt = u.getUseBoxes().iterator();
            while (useBoxIt.hasNext()) {
                List l;
                Value v = ((ValueBox)useBoxIt.next()).getValue();
                if (!(v instanceof Local) || (l = ld.getDefsOfAt((Local)v, u)).size() != 0) continue;
                throw new RuntimeException("no defs for value!");
            }
        }
    }

    public Chain getLocals() {
        return this.localChain;
    }

    public Chain getTraps() {
        return this.trapChain;
    }

    public Local getThisLocal() {
        Iterator unitsIt = this.getUnits().iterator();
        while (unitsIt.hasNext()) {
            Stmt s = (Stmt)unitsIt.next();
            if (!(s instanceof IdentityStmt) || !(((IdentityStmt)s).getRightOp() instanceof ThisRef)) continue;
            return (Local)((IdentityStmt)s).getLeftOp();
        }
        throw new RuntimeException("couldn't find identityref!");
    }

    public Local getParameterLocal(int i) {
        Iterator unitsIt = this.getUnits().iterator();
        while (unitsIt.hasNext()) {
            IdentityStmt is;
            ParameterRef pr;
            Stmt s = (Stmt)unitsIt.next();
            if (!(s instanceof IdentityStmt) || !(((IdentityStmt)s).getRightOp() instanceof ParameterRef) || (pr = (ParameterRef)(is = (IdentityStmt)s).getRightOp()).getIndex() != i) continue;
            return (Local)is.getLeftOp();
        }
        throw new RuntimeException("couldn't find parameterref!");
    }

    public PatchingChain getUnits() {
        return this.unitChain;
    }

    public List getAllUnitBoxes() {
        Object item;
        ArrayList unitBoxList = new ArrayList();
        Iterator it = this.unitChain.iterator();
        while (it.hasNext()) {
            item = (Unit)it.next();
            unitBoxList.addAll(item.getUnitBoxes());
        }
        it = this.trapChain.iterator();
        while (it.hasNext()) {
            item = (Trap)it.next();
            unitBoxList.addAll(item.getUnitBoxes());
        }
        it = this.getTags().iterator();
        while (it.hasNext()) {
            Tag t = (Tag)it.next();
            if (!(t instanceof CodeAttribute)) continue;
            unitBoxList.addAll(((CodeAttribute)t).getUnitBoxes());
        }
        return unitBoxList;
    }

    public List getUnitBoxes(boolean branchTarget) {
        Object item;
        ArrayList unitBoxList = new ArrayList();
        Iterator it = this.unitChain.iterator();
        while (it.hasNext()) {
            item = (Unit)it.next();
            if (branchTarget) {
                if (!item.branches()) continue;
                unitBoxList.addAll(item.getUnitBoxes());
                continue;
            }
            if (item.branches()) continue;
            unitBoxList.addAll(item.getUnitBoxes());
        }
        it = this.trapChain.iterator();
        while (it.hasNext()) {
            item = (Trap)it.next();
            unitBoxList.addAll(item.getUnitBoxes());
        }
        it = this.getTags().iterator();
        while (it.hasNext()) {
            Tag t = (Tag)it.next();
            if (!(t instanceof CodeAttribute)) continue;
            unitBoxList.addAll(((CodeAttribute)t).getUnitBoxes());
        }
        return unitBoxList;
    }

    public List getUseBoxes() {
        ArrayList useBoxList = new ArrayList();
        Iterator it = this.unitChain.iterator();
        while (it.hasNext()) {
            Unit item = (Unit)it.next();
            useBoxList.addAll(item.getUseBoxes());
        }
        return useBoxList;
    }

    public List getDefBoxes() {
        ArrayList defBoxList = new ArrayList();
        Iterator it = this.unitChain.iterator();
        while (it.hasNext()) {
            Unit item = (Unit)it.next();
            defBoxList.addAll(item.getDefBoxes());
        }
        return defBoxList;
    }

    public List getUseAndDefBoxes() {
        ArrayList useAndDefBoxList = new ArrayList();
        Iterator it = this.unitChain.iterator();
        while (it.hasNext()) {
            Unit item = (Unit)it.next();
            useAndDefBoxList.addAll(item.getUseBoxes());
            useAndDefBoxList.addAll(item.getDefBoxes());
        }
        return useAndDefBoxList;
    }
}

