/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.CP;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.Insn;
import jas.InsnOperand;
import jas.RuntimeConstants;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;

class LdcOperand
extends InsnOperand
implements RuntimeConstants {
    CP cpe;
    Insn source;
    boolean wide;

    int size(ClassEnv classEnv, CodeAttr codeAttr) throws jasError {
        if (this.wide) {
            return 2;
        }
        short s = classEnv.getCPIndex(this.cpe);
        if (s > 255) {
            this.wide = true;
            this.source.opc = 19;
            return 2;
        }
        return 1;
    }

    LdcOperand(Insn insn, CP cP) {
        this.source = insn;
        this.cpe = cP;
        this.wide = true;
    }

    LdcOperand(Insn insn, CP cP, boolean bl) {
        this.source = insn;
        this.cpe = cP;
        this.wide = bl;
    }

    void resolve(ClassEnv classEnv) {
        classEnv.addCPItem(this.cpe);
    }

    void write(ClassEnv classEnv, CodeAttr codeAttr, DataOutputStream dataOutputStream) throws IOException, jasError {
        short s = classEnv.getCPIndex(this.cpe);
        if (this.wide) {
            dataOutputStream.writeShort(s);
        } else {
            if (s > 255) {
                throw new jasError("exceeded size for small cpidx" + this.cpe);
            }
            dataOutputStream.writeByte((byte)(0xFF & s));
        }
    }
}

