/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.ByteOperand;
import jas.CP;
import jas.CPOperand;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.InsnOperand;
import jas.Label;
import jas.LabelOperand;
import jas.LdcOperand;
import jas.RuntimeConstants;
import jas.ShortOperand;
import jas.UnsignedByteOperand;
import jas.UnsignedByteWideOperand;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;

public class Insn
implements RuntimeConstants {
    int opc;
    InsnOperand operand;

    Insn() {
    }

    public Insn(int n) throws jasError {
        if (RuntimeConstants.opcLengths[n] == 1) {
            this.operand = null;
            this.opc = n;
            return;
        }
        throw new jasError(RuntimeConstants.opcNames[n] + " cannot be used without more parameters");
    }

    public Insn(int n, int n2) throws jasError {
        this.opc = n;
        switch (n) {
            case 16: {
                this.operand = new ByteOperand(n2);
                break;
            }
            case 17: {
                this.operand = new ShortOperand(n2);
                break;
            }
            case 188: {
                this.operand = new UnsignedByteOperand(n2);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                this.operand = new UnsignedByteWideOperand(n2);
                break;
            }
            default: {
                throw new jasError(RuntimeConstants.opcNames[n] + " does not take a numeric argument");
            }
        }
    }

    public Insn(int n, Label label) throws jasError {
        this.opc = n;
        switch (n) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                this.operand = new LabelOperand(label, this);
                break;
            }
            case 200: 
            case 201: {
                this.operand = new LabelOperand(label, this, true);
                break;
            }
            default: {
                throw new jasError(RuntimeConstants.opcNames[n] + " does not take a label as its argument");
            }
        }
    }

    public Insn(int n, CP cP) throws jasError {
        this.opc = n;
        switch (n) {
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                this.operand = new CPOperand(cP);
                break;
            }
            case 19: 
            case 20: {
                this.operand = new LdcOperand(this, cP);
                break;
            }
            case 18: {
                this.operand = new LdcOperand(this, cP, false);
                break;
            }
            default: {
                throw new jasError(RuntimeConstants.opcNames[n] + " does not take a CP item as an argument");
            }
        }
    }

    void resolve(ClassEnv classEnv) {
        if (this.operand != null) {
            this.operand.resolve(classEnv);
        }
    }

    void write(ClassEnv classEnv, CodeAttr codeAttr, DataOutputStream dataOutputStream) throws IOException, jasError {
        if (this.operand != null) {
            this.operand.writePrefix(classEnv, codeAttr, dataOutputStream);
        }
        dataOutputStream.writeByte((byte)this.opc);
        if (this.operand != null) {
            this.operand.write(classEnv, codeAttr, dataOutputStream);
        }
    }

    int size(ClassEnv classEnv, CodeAttr codeAttr) throws jasError {
        if (this.operand == null) {
            return 1;
        }
        return 1 + this.operand.size(classEnv, codeAttr);
    }
}

