/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.AsciiCP;
import jas.CP;
import jas.Catchtable;
import jas.ClassEnv;
import jas.CodeAttributeDecoder;
import jas.GenericAttr;
import jas.Insn;
import jas.Label;
import jas.LineTableAttr;
import jas.LocalVarTableAttr;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class CodeAttr {
    static CP attr = new AsciiCP("Code");
    short stack_size = 1;
    short num_locals = 1;
    int code_size;
    Vector insns;
    Hashtable insn_pc;
    Catchtable ctb = null;
    LineTableAttr ltab;
    LocalVarTableAttr lvar;
    Vector generic;
    Vector sootAttrNames = new Vector();
    Vector sootAttrValues = new Vector();
    Hashtable labels;

    public CodeAttr() {
        this.insns = new Vector();
        this.generic = new Vector();
    }

    public void setCatchtable(Catchtable catchtable) {
        this.ctb = catchtable;
    }

    public void setLineTable(LineTableAttr lineTableAttr) {
        this.ltab = lineTableAttr;
    }

    public void setLocalVarTable(LocalVarTableAttr localVarTableAttr) {
        this.lvar = localVarTableAttr;
    }

    public void addGenericAttr(GenericAttr genericAttr) {
        this.generic.addElement(genericAttr);
    }

    public void addSootCodeAttr(String string, String string2) {
        this.sootAttrNames.addElement(string);
        this.sootAttrValues.addElement(string2);
    }

    Label getLabel(String string) {
        Label label = (Label)this.labels.get(string);
        if (label == null) {
            label = new Label(string);
            this.labels.put(string, label);
        }
        return label;
    }

    public void setLabelTable(Hashtable hashtable) {
        this.labels = hashtable;
    }

    private int processSootAttributes() {
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>();
        int n = 0;
        Enumeration enumeration = this.sootAttrValues.elements();
        Enumeration enumeration2 = this.sootAttrNames.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            String string = (String)enumeration.nextElement();
            String string2 = (String)enumeration2.nextElement();
            boolean bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "%", true);
            while (stringTokenizer.hasMoreTokens()) {
                object2 = (String)stringTokenizer.nextElement();
                if (((String)object2).equals("%")) {
                    bl = !bl;
                    continue;
                }
                if (!bl) continue;
                object = (Integer)hashtable.get(object2);
                try {
                    if (object != null) continue;
                    hashtable.put(object2, new Integer(this.getPc(this.getLabel((String)object2))));
                }
                catch (jasError jasError2) {
                    throw new RuntimeException(jasError2.toString());
                }
            }
            object2 = CodeAttributeDecoder.decode(string, hashtable);
            object = new GenericAttr(string2, (byte[])object2);
            n += ((GenericAttr)object).size();
            this.addGenericAttr((GenericAttr)object);
        }
        this.sootAttrNames.removeAllElements();
        this.sootAttrValues.removeAllElements();
        return n;
    }

    public void addInsn(Insn insn) {
        this.insns.addElement(insn);
    }

    public void setStackSize(short s) {
        this.stack_size = s;
    }

    public void setVarSize(short s) {
        this.num_locals = s;
    }

    void resolve(ClassEnv classEnv) {
        Object object;
        classEnv.addCPItem(attr);
        Enumeration enumeration = this.insns.elements();
        while (enumeration.hasMoreElements()) {
            object = (Insn)enumeration.nextElement();
            ((Insn)object).resolve(classEnv);
        }
        if (this.ctb != null) {
            this.ctb.resolve(classEnv);
        }
        if (this.ltab != null) {
            this.ltab.resolve(classEnv);
        }
        if (this.lvar != null) {
            this.lvar.resolve(classEnv);
        }
        object = this.generic.elements();
        while (object.hasMoreElements()) {
            GenericAttr genericAttr = (GenericAttr)object.nextElement();
            genericAttr.resolve(classEnv);
        }
    }

    public int getPc(Insn insn) throws jasError {
        if (this.insn_pc == null) {
            throw new jasError("Internal error, insn_pc has not been initialized");
        }
        Integer n = insn instanceof Label ? (Integer)this.insn_pc.get(((Label)insn).id) : (Integer)this.insn_pc.get(insn);
        if (n == null) {
            throw new jasError(insn + " has not been added to the code");
        }
        return n;
    }

    void write(ClassEnv classEnv, DataOutputStream dataOutputStream) throws IOException, jasError {
        Object object;
        int n = 0;
        this.insn_pc = new Hashtable();
        Enumeration enumeration = this.insns.elements();
        while (enumeration.hasMoreElements()) {
            Insn insn = (Insn)enumeration.nextElement();
            if (insn instanceof Label) {
                this.insn_pc.put(((Label)insn).id, new Integer(n));
            } else {
                this.insn_pc.put(insn, new Integer(n));
            }
            n += insn.size(classEnv, this);
        }
        int n2 = n;
        if (this.ctb != null) {
            n2 += this.ctb.size();
        }
        if (this.ltab != null) {
            n2 += this.ltab.size();
        }
        if (this.lvar != null) {
            n2 += this.lvar.size();
        }
        Enumeration enumeration2 = this.generic.elements();
        while (enumeration2.hasMoreElements()) {
            object = (GenericAttr)enumeration2.nextElement();
            n2 += ((GenericAttr)object).size();
        }
        n2 += this.processSootAttributes();
        dataOutputStream.writeShort(classEnv.getCPIndex(attr));
        dataOutputStream.writeInt(n2 += 12);
        dataOutputStream.writeShort(this.stack_size);
        dataOutputStream.writeShort(this.num_locals);
        dataOutputStream.writeInt(n);
        object = this.insns.elements();
        while (object.hasMoreElements()) {
            Insn insn = (Insn)object.nextElement();
            insn.write(classEnv, this, dataOutputStream);
        }
        if (this.ctb != null) {
            this.ctb.write(classEnv, this, dataOutputStream);
        } else {
            dataOutputStream.writeShort(0);
        }
        int n3 = 0;
        if (this.ltab != null) {
            n3 = (short)(n3 + 1);
        }
        if (this.lvar != null) {
            n3 = (short)(n3 + 1);
        }
        n3 = (short)(n3 + this.generic.size());
        dataOutputStream.writeShort(n3);
        if (this.ltab != null) {
            this.ltab.write(classEnv, this, dataOutputStream);
        }
        if (this.lvar != null) {
            this.lvar.write(classEnv, this, dataOutputStream);
        }
        Enumeration enumeration3 = this.generic.elements();
        while (enumeration3.hasMoreElements()) {
            GenericAttr genericAttr = (GenericAttr)enumeration3.nextElement();
            genericAttr.write(classEnv, dataOutputStream);
        }
    }

    public String toString() {
        return "<#code-attr>";
    }
}

