/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import polyglot.util.AllowBreak;
import polyglot.util.BlockItem;
import polyglot.util.Item;
import polyglot.util.Newline;
import polyglot.util.Overrun;
import polyglot.util.StringItem;

public class CodeWriter {
    BlockItem input;
    BlockItem current;
    Writer output;
    int width;
    public static final boolean debug = false;
    public static boolean precompute = false;

    public CodeWriter(OutputStream o, int width_) {
        this.output = new OutputStreamWriter(o);
        this.width = width_;
        this.current = this.input = new BlockItem(null, 0);
    }

    public CodeWriter(Writer w, int width_) {
        this.output = w;
        this.width = width_;
        this.current = this.input = new BlockItem(null, 0);
    }

    public void write(String s) {
        if (s.length() > 0) {
            this.current.add(new StringItem(s));
        }
    }

    public void newline() {
        this.newline(0);
    }

    public void begin(int n) {
        BlockItem b = new BlockItem(this.current, n);
        this.current.add(b);
        this.current = b;
    }

    public void end() {
        this.current = this.current.parent;
    }

    public void allowBreak(int n) {
        this.current.add(new AllowBreak(n, " "));
    }

    public void allowBreak(int n, String alt) {
        this.current.add(new AllowBreak(n, alt));
    }

    public void newline(int n) {
        this.current.add(new Newline(n));
    }

    public boolean flush() throws IOException {
        boolean success = true;
        try {
            Item.format(this.input, 0, 0, this.width, this.width, true, true);
        }
        catch (Overrun o) {
            success = false;
        }
        this.input.sendOutput(this.output, 0, 0);
        this.output.flush();
        this.input.free();
        this.current = this.input = new BlockItem(null, 0);
        return success;
    }

    public String toString() {
        return this.input.toString();
    }
}

