/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types.reflect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import polyglot.main.Report;
import polyglot.types.reflect.ClassFile;
import polyglot.util.InternalCompilerError;

public class ClassFileLoader {
    Map jarCache = new HashMap();
    Map dirContentsCache = new HashMap();
    static final Object not_found = new Object();
    static Collection verbose = new HashSet();

    public ClassFile loadClass(File dir, String name) {
        if (Report.should_report(verbose, 3)) {
            Report.report(3, "looking in " + dir + " for " + name.replace('.', File.separatorChar) + ".class");
        }
        try {
            if (dir.getName().endsWith(".jar")) {
                return this.loadFromJar(name, dir);
            }
            if (dir.getName().endsWith(".zip")) {
                return this.loadFromZip(name, dir);
            }
            return this.loadFromFile(name, dir);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new InternalCompilerError(e);
        }
        return null;
    }

    ClassFile loadFromJar(String name, File dir) throws IOException {
        Object o = this.jarCache.get(dir);
        if (o != not_found) {
            String entryName;
            JarEntry entry;
            JarFile jar = (JarFile)o;
            if (jar == null) {
                if (!dir.exists()) {
                    this.jarCache.put(dir, not_found);
                } else {
                    if (Report.should_report(verbose, 2)) {
                        Report.report(2, "Opening jar " + dir);
                    }
                    jar = new JarFile(dir);
                    this.jarCache.put(dir, jar);
                }
            }
            if (jar != null && (entry = jar.getJarEntry(entryName = name.replace('.', '/') + ".class")) != null) {
                if (Report.should_report(verbose, 3)) {
                    Report.report(3, "found jar entry " + entry);
                }
                InputStream in = jar.getInputStream(entry);
                ClassFile c = this.loadFromStream(in, name);
                in.close();
                return c;
            }
        }
        return null;
    }

    ClassFile loadFromZip(String name, File dir) throws IOException {
        Object o = this.jarCache.get(dir);
        if (o != not_found) {
            String entryName;
            ZipEntry entry;
            ZipFile zip = (ZipFile)o;
            if (zip == null) {
                if (!dir.exists()) {
                    this.jarCache.put(dir, not_found);
                } else {
                    if (Report.should_report(verbose, 2)) {
                        Report.report(2, "Opening zip " + dir);
                    }
                    zip = new ZipFile(dir);
                    this.jarCache.put(dir, zip);
                }
            }
            if (zip != null && (entry = zip.getEntry(entryName = name.replace('.', '/') + ".class")) != null) {
                if (Report.should_report(verbose, 3)) {
                    Report.report(3, "found zip entry " + entry);
                }
                InputStream in = zip.getInputStream(entry);
                ClassFile c = this.loadFromStream(in, name);
                in.close();
                return c;
            }
        }
        return null;
    }

    ClassFile loadFromFile(String name, File dir) throws IOException {
        String firstPart;
        HashSet<String> dirContents = (HashSet<String>)this.dirContentsCache.get(dir);
        if (dirContents == null) {
            dirContents = new HashSet<String>();
            this.dirContentsCache.put(dir, dirContents);
            if (dir.exists() && dir.isDirectory()) {
                String[] contents = dir.list();
                for (int j = 0; j < contents.length; ++j) {
                    dirContents.add(contents[j]);
                }
            }
        }
        StringBuffer filenameSB = new StringBuffer(name.length() + 8);
        int firstSeparator = -1;
        filenameSB.append(name);
        for (int i = 0; i < filenameSB.length(); ++i) {
            if (filenameSB.charAt(i) != '.') continue;
            filenameSB.setCharAt(i, File.separatorChar);
            if (firstSeparator != -1) continue;
            firstSeparator = i;
        }
        filenameSB.append(".class");
        String filename = filenameSB.toString();
        String string = firstPart = firstSeparator == -1 ? filename : filename.substring(0, firstSeparator);
        if (!dirContents.contains(firstPart)) {
            return null;
        }
        File file = new File(dir, filename);
        FileInputStream in = new FileInputStream(file);
        if (Report.should_report(verbose, 3)) {
            Report.report(3, "found " + file);
        }
        ClassFile c = this.loadFromStream(in, name);
        in.close();
        return c;
    }

    ClassFile loadFromStream(InputStream in, String name) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int n = 0;
        do {
            if ((n = in.read(buf)) < 0) continue;
            out.write(buf, 0, n);
        } while (n >= 0);
        byte[] bytecode = out.toByteArray();
        try {
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "defining class " + name);
            }
            return new ClassFile(bytecode);
        }
        catch (ClassFormatError e) {
            throw new IOException(e.getMessage());
        }
    }

    static {
        verbose.add("loader");
    }
}

