/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Report;
import polyglot.types.Named;
import polyglot.types.ParsedClassType;
import polyglot.types.Qualifier;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CollectionUtil;

public class CachingResolver
implements Resolver {
    Resolver inner;
    Map cache;
    ExtensionInfo extInfo;
    private static final Collection TOPICS = CollectionUtil.list(Report.types, Report.resolver);

    public CachingResolver(Resolver inner, ExtensionInfo extInfo) {
        this.inner = inner;
        this.cache = new HashMap();
        this.extInfo = extInfo;
    }

    public Resolver inner() {
        return this.inner;
    }

    public String toString() {
        return "(cache " + this.inner.toString() + ")";
    }

    public Named find(String name) throws SemanticException {
        Named q;
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, "CachingResolver: find: " + name);
        }
        if ((q = (Named)this.cache.get(name)) == null) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "CachingResolver: not cached: " + name);
            }
            q = this.inner.find(name);
            this.cache.put(name, q);
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "CachingResolver: loaded: " + name);
            }
        } else if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "CachingResolver: cached: " + name);
        }
        if (q instanceof ParsedClassType) {
            this.extInfo.addDependencyToCurrentJob(((ParsedClassType)q).fromSource());
        }
        return q;
    }

    public Type checkType(String name) {
        return (Type)this.cache.get(name);
    }

    public void install(String name, Qualifier q) {
        this.cache.put(name, q);
    }
}

