/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.IOException;
import java.io.Reader;
import polyglot.ast.Node;
import polyglot.frontend.AbstractPass;
import polyglot.frontend.Compiler;
import polyglot.frontend.FileSource;
import polyglot.frontend.Job;
import polyglot.frontend.Parser;
import polyglot.frontend.Pass;
import polyglot.main.Report;
import polyglot.util.ErrorQueue;

public class ParserPass
extends AbstractPass {
    Job job;
    Compiler compiler;

    public ParserPass(Pass.ID id, Compiler compiler, Job job) {
        super(id);
        this.compiler = compiler;
        this.job = job;
    }

    public boolean run() {
        ErrorQueue eq = this.compiler.errorQueue();
        FileSource source = (FileSource)this.job.source();
        try {
            Reader reader = source.open();
            Parser p = this.compiler.sourceExtension().parser(reader, source, eq);
            if (Report.should_report(Report.frontend, 2)) {
                Report.report(2, "Using parser " + p);
            }
            Node ast = p.parse();
            source.close();
            if (ast != null) {
                this.job.ast(ast);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            eq.enqueue(2, e.getMessage());
            return false;
        }
    }

    public String toString() {
        return this.id + "(" + this.job.source() + ")";
    }
}

