/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileSource;
import polyglot.frontend.SourceLoader;
import polyglot.main.Options;
import polyglot.types.reflect.ClassFileLoader;
import polyglot.util.ErrorLimitError;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.util.StdErrorQueue;

public class Compiler {
    private ExtensionInfo extensionInfo;
    private ErrorQueue eq;
    private ClassFileLoader loader;
    private Collection outputFiles = new HashSet();
    static /* synthetic */ Class class$polyglot$frontend$Compiler;

    public Compiler(ExtensionInfo extensionInfo) {
        this.extensionInfo = extensionInfo;
        Options options = extensionInfo.getOptions();
        this.eq = new StdErrorQueue(System.err, options.error_count, extensionInfo.compilerName());
        this.loader = new ClassFileLoader();
        extensionInfo.initCompiler(this);
    }

    public Collection outputFiles() {
        return this.outputFiles;
    }

    public boolean compile(Collection sources) {
        boolean okay = false;
        try {
            try {
                SourceLoader source_loader = this.sourceExtension().sourceLoader();
                Iterator i = sources.iterator();
                while (i.hasNext()) {
                    String sourceName = (String)i.next();
                    FileSource source = source_loader.fileSource(sourceName);
                    this.sourceExtension().addJob(source);
                }
                okay = this.sourceExtension().runToCompletion();
            }
            catch (FileNotFoundException e) {
                this.eq.enqueue(2, "Cannot find source file \"" + e.getMessage() + "\".");
            }
            catch (IOException e) {
                this.eq.enqueue(2, e.getMessage());
            }
            catch (InternalCompilerError e) {
                e.printStackTrace();
                this.eq.enqueue(1, e.message(), e.position());
            }
        }
        catch (ErrorLimitError errorLimitError) {
            // empty catch block
        }
        this.eq.flush();
        return okay;
    }

    public ClassFileLoader loader() {
        return this.loader;
    }

    public boolean useFullyQualifiedNames() {
        return this.extensionInfo.getOptions().fully_qualified_names;
    }

    public ExtensionInfo sourceExtension() {
        return this.extensionInfo;
    }

    public int outputWidth() {
        return this.extensionInfo.getOptions().output_width;
    }

    public boolean serializeClassInfo() {
        return this.extensionInfo.getOptions().serialize_type_info;
    }

    public ErrorQueue errorQueue() {
        return this.eq;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            ClassLoader loader = (class$polyglot$frontend$Compiler == null ? (class$polyglot$frontend$Compiler = Compiler.class$("polyglot.frontend.Compiler")) : class$polyglot$frontend$Compiler).getClassLoader();
            loader.loadClass("polyglot.util.StdErrorQueue");
        }
        catch (ClassNotFoundException e) {
            throw new InternalCompilerError(e.getMessage());
        }
    }
}

