/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.ImportTable;
import polyglot.types.LocalInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Named;
import polyglot.types.NoMemberException;
import polyglot.types.ParsedClassType;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;

public class Context_c
implements Context {
    protected Context outer;
    protected TypeSystem ts;
    protected ImportTable it;
    protected int kind;
    protected ClassType type;
    protected ParsedClassType scope;
    protected CodeInstance code;
    protected Map types;
    protected Map methods;
    protected Map vars;
    protected boolean inCode;
    protected boolean staticContext;
    public static final int BLOCK = 0;
    public static final int CLASS = 1;
    public static final int CODE = 2;
    public static final int OUTER = 3;
    public static final int SOURCE = 4;
    private static final Collection TOPICS = CollectionUtil.list(Report.types, Report.context);

    public Context_c(TypeSystem ts) {
        this.ts = ts;
        this.outer = null;
        this.kind = 3;
    }

    public TypeSystem typeSystem() {
        return this.ts;
    }

    public Object copy() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone() weirdness.");
        }
    }

    protected Context_c push() {
        Context_c v = (Context_c)this.copy();
        v.outer = this;
        v.types = null;
        v.methods = null;
        v.vars = null;
        return v;
    }

    private String kindStr() {
        if (this.kind == 0) {
            return "block";
        }
        if (this.kind == 1) {
            return "class";
        }
        if (this.kind == 2) {
            return "code";
        }
        if (this.kind == 3) {
            return "outer";
        }
        if (this.kind == 4) {
            return "source";
        }
        return "unknown-scope";
    }

    public Resolver outerResolver() {
        if (this.it != null) {
            return this.it;
        }
        return this.ts.systemResolver();
    }

    public ImportTable importTable() {
        return this.it;
    }

    public boolean isLocal(String name) {
        if (this.kind == 1) {
            return false;
        }
        if (!(this.kind != 0 && this.kind != 2 || this.findVariableInThisScope(name) == null && this.findInThisScope(name) == null)) {
            return true;
        }
        if (this.outer == null) {
            return false;
        }
        return this.outer.isLocal(name);
    }

    public MethodInstance findMethod(String name, List argTypes) throws SemanticException {
        ClassType rt;
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-method " + name + argTypes + " in " + this);
        }
        if ((rt = this.findMethodContainerInThisScope(name)) != null) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-method " + name + argTypes + " -> " + rt);
            }
            return this.ts.findMethod(rt, name, argTypes, this);
        }
        if (this.outer != null) {
            return this.outer.findMethod(name, argTypes);
        }
        throw new SemanticException("Method " + name + " not found.");
    }

    public LocalInstance findLocal(String name) throws SemanticException {
        VarInstance vi = this.findVariableSilent(name);
        if (vi instanceof LocalInstance) {
            return (LocalInstance)vi;
        }
        throw new SemanticException("Local " + name + " not found.");
    }

    public ClassType findFieldScope(String name) throws SemanticException {
        VarInstance vi;
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-field-scope " + name + " in " + this);
        }
        if ((vi = this.findVariableInThisScope(name)) instanceof FieldInstance) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-field-scope " + name + " in " + vi);
            }
            return this.type;
        }
        if (vi == null && this.outer != null) {
            return this.outer.findFieldScope(name);
        }
        throw new SemanticException("Field " + name + " not found.");
    }

    public ClassType findMethodScope(String name) throws SemanticException {
        ClassType container;
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-method-scope " + name + " in " + this);
        }
        if ((container = this.findMethodContainerInThisScope(name)) != null) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-method-scope " + name + " -> " + container);
            }
            return this.type;
        }
        if (this.outer != null) {
            return this.outer.findMethodScope(name);
        }
        throw new SemanticException("Method " + name + " not found.");
    }

    public FieldInstance findField(String name) throws SemanticException {
        VarInstance vi = this.findVariableSilent(name);
        if (vi instanceof FieldInstance) {
            FieldInstance fi = (FieldInstance)vi;
            if (!this.ts.isAccessible(fi, this)) {
                throw new SemanticException("Field " + name + " not accessible.");
            }
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-field " + name + " -> " + fi);
            }
            return fi;
        }
        throw new NoMemberException(3, "Field " + name + " not found.");
    }

    public VarInstance findVariable(String name) throws SemanticException {
        VarInstance vi = this.findVariableSilent(name);
        if (vi != null) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-var " + name + " -> " + vi);
            }
            return vi;
        }
        throw new SemanticException("Variable " + name + " not found.");
    }

    public VarInstance findVariableSilent(String name) {
        VarInstance vi;
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-var " + name + " in " + this);
        }
        if ((vi = this.findVariableInThisScope(name)) != null) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find-var " + name + " -> " + vi);
            }
            return vi;
        }
        if (this.outer != null) {
            return this.outer.findVariableSilent(name);
        }
        return null;
    }

    protected String mapsToString() {
        return "types=" + this.types + " vars=" + this.vars + " methods=" + this.methods;
    }

    public String toString() {
        return "(" + this.kindStr() + " " + this.mapsToString() + " " + this.outer + ")";
    }

    public Context pop() {
        return this.outer;
    }

    public Named find(String name) throws SemanticException {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "find-type " + name + " in " + this);
        }
        if (this.kind == 3) {
            return this.outerResolver().find(name);
        }
        if (this.kind == 4) {
            return this.it.find(name);
        }
        Named type = this.findInThisScope(name);
        if (type != null) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, "find " + name + " -> " + type);
            }
            return type;
        }
        if (this.outer != null) {
            return this.outer.find(name);
        }
        throw new SemanticException("Type " + name + " not found.");
    }

    public Context pushSource(ImportTable it) {
        Context_c v = this.push();
        v.kind = 4;
        v.it = it;
        v.inCode = false;
        v.staticContext = false;
        return v;
    }

    public Context pushClass(ParsedClassType c, ClassType t) {
        if (Report.should_report(TOPICS, 4)) {
            Report.report(4, "push class " + c + " " + c.position());
        }
        Context_c v = this.push();
        v.kind = 1;
        v.scope = c;
        v.type = t;
        v.inCode = false;
        v.staticContext = false;
        return v;
    }

    public Context pushBlock() {
        if (Report.should_report(TOPICS, 4)) {
            Report.report(4, "push block");
        }
        Context_c v = this.push();
        v.kind = 0;
        return v;
    }

    public Context pushStatic() {
        if (Report.should_report(TOPICS, 4)) {
            Report.report(4, "push static");
        }
        Context_c v = this.push();
        v.staticContext = true;
        return v;
    }

    public Context pushCode(CodeInstance ci) {
        if (Report.should_report(TOPICS, 4)) {
            Report.report(4, "push code " + ci + " " + ci.position());
        }
        Context_c v = this.push();
        v.kind = 2;
        v.code = ci;
        v.inCode = true;
        v.staticContext = ci.flags().isStatic();
        return v;
    }

    public CodeInstance currentCode() {
        return this.code;
    }

    public boolean inCode() {
        return this.inCode;
    }

    public boolean inStaticContext() {
        return this.staticContext;
    }

    public ClassType currentClass() {
        return this.type;
    }

    public ParsedClassType currentClassScope() {
        return this.scope;
    }

    public void addVariable(VarInstance vi) {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "Adding " + vi + " to context.");
        }
        this.addVariableToThisScope(vi);
    }

    public void addMethod(MethodInstance mi) {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "Adding " + mi + " to context.");
        }
        this.addMethodContainerToThisScope(mi);
    }

    public void addNamed(Named t) {
        if (Report.should_report(TOPICS, 3)) {
            Report.report(3, "Adding type " + t + " to context.");
        }
        this.addNamedToThisScope(t);
    }

    public Named findInThisScope(String name) {
        if (this.types == null) {
            return null;
        }
        return (Named)this.types.get(name);
    }

    public void addNamedToThisScope(Named type) {
        if (this.types == null) {
            this.types = new HashMap();
        }
        this.types.put(type.name(), type);
    }

    public ClassType findMethodContainerInThisScope(String name) {
        if (this.methods == null) {
            return null;
        }
        return (ClassType)this.methods.get(name);
    }

    public void addMethodContainerToThisScope(MethodInstance mi) {
        if (this.methods == null) {
            this.methods = new HashMap();
        }
        this.methods.put(mi.name(), mi.container());
    }

    public VarInstance findVariableInThisScope(String name) {
        if (this.vars == null) {
            return null;
        }
        return (VarInstance)this.vars.get(name);
    }

    public void addVariableToThisScope(VarInstance var) {
        if (this.vars == null) {
            this.vars = new HashMap();
        }
        this.vars.put(var.name(), var);
    }
}

