/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.ast;

import java.util.List;
import polyglot.ast.BooleanLit;
import polyglot.ast.Expr;
import polyglot.ast.IntLit;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.NumLit;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.ast.Variable;
import polyglot.ext.jl.ast.Expr_c;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ConstantFolder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Unary_c
extends Expr_c
implements Unary {
    protected Unary.Operator op;
    protected Expr expr;

    public Unary_c(Position pos, Unary.Operator op, Expr expr) {
        super(pos);
        this.op = op;
        this.expr = expr;
    }

    public Precedence precedence() {
        return Precedence.UNARY;
    }

    public Expr expr() {
        return this.expr;
    }

    public Unary expr(Expr expr) {
        Unary_c n = (Unary_c)this.copy();
        n.expr = expr;
        return n;
    }

    public Unary.Operator operator() {
        return this.op;
    }

    public Unary operator(Unary.Operator op) {
        Unary_c n = (Unary_c)this.copy();
        n.op = op;
        return n;
    }

    protected Unary_c reconstruct(Expr expr) {
        if (expr != this.expr) {
            Unary_c n = (Unary_c)this.copy();
            n.expr = expr;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr expr = (Expr)this.visitChild(this.expr, v);
        return this.reconstruct(expr);
    }

    protected Node num(NodeFactory nf, long value) {
        IntLit.Kind kind = IntLit.INT;
        if (this.expr instanceof IntLit) {
            kind = ((IntLit)this.expr).kind();
        }
        return nf.IntLit(this.position(), kind, value).type(this.type());
    }

    protected Node bool(NodeFactory nf, boolean value) {
        return nf.BooleanLit(this.position(), value).type(this.type());
    }

    public Node foldConstants(ConstantFolder cf) {
        NodeFactory nf = cf.nodeFactory();
        if (this.expr instanceof NumLit) {
            long x = ((NumLit)this.expr).longValue();
            if (this.op == Unary.BIT_NOT) {
                return this.num(nf, x ^ 0xFFFFFFFFFFFFFFFFL);
            }
            if (this.op == Unary.NEG) {
                return this.num(nf, -x);
            }
            if (this.op == Unary.POS) {
                return this.num(nf, x);
            }
        } else if (this.expr instanceof BooleanLit) {
            boolean x = ((BooleanLit)this.expr).value();
            if (this.op == Unary.NOT) {
                return this.bool(nf, !x);
            }
        }
        return this;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (this.op == Unary.POST_INC || this.op == Unary.POST_DEC || this.op == Unary.PRE_INC || this.op == Unary.PRE_DEC) {
            if (!this.expr.type().isNumeric()) {
                throw new SemanticException("Operand of " + this.op + " operator must be numeric.", this.expr.position());
            }
            if (!(this.expr instanceof Variable)) {
                throw new SemanticException("Operand of " + this.op + " operator must be a variable.", this.expr.position());
            }
            if (((Variable)this.expr).flags().isFinal()) {
                throw new SemanticException("Operand of " + this.op + " operator must be a non-final variable.", this.expr.position());
            }
            return this.type(this.expr.type());
        }
        if (this.op == Unary.BIT_NOT) {
            if (!ts.isImplicitCastValid(this.expr.type(), ts.Long())) {
                throw new SemanticException("Operand of " + this.op + " operator must be numeric.", this.expr.position());
            }
            return this.type(ts.promote(this.expr.type()));
        }
        if (this.op == Unary.NEG || this.op == Unary.POS) {
            if (!this.expr.type().isNumeric()) {
                throw new SemanticException("Operand of " + this.op + " operator must be numeric.", this.expr.position());
            }
            return this.type(ts.promote(this.expr.type()));
        }
        if (this.op == Unary.NOT) {
            if (!this.expr.type().isBoolean()) {
                throw new SemanticException("Operand of " + this.op + " operator must be boolean.", this.expr.position());
            }
            return this.type(this.expr.type());
        }
        return this;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        try {
            if (child == this.expr) {
                if (this.op == Unary.POST_INC || this.op == Unary.POST_DEC || this.op == Unary.PRE_INC || this.op == Unary.PRE_DEC) {
                    if (ts.isImplicitCastValid(child.type(), av.toType())) {
                        return ts.promote(child.type());
                    }
                    return av.toType();
                }
                if (this.op == Unary.NEG || this.op == Unary.POS) {
                    if (ts.isImplicitCastValid(child.type(), av.toType())) {
                        return ts.promote(child.type());
                    }
                    return av.toType();
                }
                if (this.op == Unary.BIT_NOT) {
                    if (ts.isImplicitCastValid(child.type(), av.toType())) {
                        return ts.promote(child.type());
                    }
                    return av.toType();
                }
                if (this.op == Unary.NOT) {
                    return ts.Boolean();
                }
            }
        }
        catch (SemanticException e) {
            // empty catch block
        }
        return child.type();
    }

    public String toString() {
        if (this.op.isPrefix()) {
            return this.op.toString() + this.expr.toString();
        }
        return this.expr.toString() + this.op.toString();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.op.isPrefix()) {
            w.write(this.op.toString());
            this.printSubExpr(this.expr, false, w, tr);
        } else {
            this.printSubExpr(this.expr, false, w, tr);
            w.write(this.op.toString());
        }
    }

    public Term entry() {
        return this.expr.entry();
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG((Term)this.expr, this);
        return succs;
    }

    public Object constantValue() {
        int vv;
        Object v = this.expr.constantValue();
        if (v instanceof Boolean) {
            vv = ((Boolean)v).booleanValue();
            if (this.op == Unary.NOT) {
                return new Boolean(vv == 0);
            }
        }
        if (v instanceof Double) {
            double vv2 = (Double)v;
            if (this.op == Unary.POS) {
                return new Double(vv2);
            }
            if (this.op == Unary.NEG) {
                return new Double(-vv2);
            }
        }
        if (v instanceof Float) {
            float vv3 = ((Float)v).floatValue();
            if (this.op == Unary.POS) {
                return new Float(vv3);
            }
            if (this.op == Unary.NEG) {
                return new Float(-vv3);
            }
        }
        if (v instanceof Long) {
            long vv4 = (Long)v;
            if (this.op == Unary.BIT_NOT) {
                return new Long(vv4 ^ 0xFFFFFFFFFFFFFFFFL);
            }
            if (this.op == Unary.POS) {
                return new Long(vv4);
            }
            if (this.op == Unary.NEG) {
                return new Long(-vv4);
            }
        }
        if (v instanceof Integer) {
            vv = (Integer)v;
            if (this.op == Unary.BIT_NOT) {
                return new Integer(~vv);
            }
            if (this.op == Unary.POS) {
                return new Integer(vv);
            }
            if (this.op == Unary.NEG) {
                return new Integer(-vv);
            }
        }
        if (v instanceof Character) {
            vv = ((Character)v).charValue();
            if (this.op == Unary.BIT_NOT) {
                return new Integer(~vv);
            }
            if (this.op == Unary.POS) {
                return new Integer(vv);
            }
            if (this.op == Unary.NEG) {
                return new Integer(-vv);
            }
        }
        if (v instanceof Short) {
            vv = ((Short)v).shortValue();
            if (this.op == Unary.BIT_NOT) {
                return new Integer(~vv);
            }
            if (this.op == Unary.POS) {
                return new Integer(vv);
            }
            if (this.op == Unary.NEG) {
                return new Integer(-vv);
            }
        }
        if (v instanceof Byte) {
            vv = ((Byte)v).byteValue();
            if (this.op == Unary.BIT_NOT) {
                return new Integer(~vv);
            }
            if (this.op == Unary.POS) {
                return new Integer(vv);
            }
            if (this.op == Unary.NEG) {
                return new Integer(-vv);
            }
        }
        return null;
    }
}

