/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.ast;

import polyglot.ast.IntLit;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ext.jl.ast.NumLit_c;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class IntLit_c
extends NumLit_c
implements IntLit {
    protected IntLit.Kind kind;

    public IntLit_c(Position pos, IntLit.Kind kind, long value) {
        super(pos, value);
        this.kind = kind;
    }

    public long value() {
        return this.longValue();
    }

    public IntLit value(long value) {
        IntLit_c n = (IntLit_c)this.copy();
        n.value = value;
        return n;
    }

    public IntLit.Kind kind() {
        return this.kind;
    }

    public IntLit kind(IntLit.Kind kind) {
        IntLit_c n = (IntLit_c)this.copy();
        n.kind = kind;
        return n;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        IntLit.Kind kind = this.kind();
        if (kind == IntLit.INT) {
            return this.type(ts.Int());
        }
        if (kind == IntLit.LONG) {
            return this.type(ts.Long());
        }
        throw new InternalCompilerError("Unrecognized IntLit kind " + kind);
    }

    public String toString() {
        if (this.kind() == IntLit.LONG) {
            return Long.toString(this.value) + "L";
        }
        return Long.toString(this.value);
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.kind() == IntLit.LONG) {
            w.write(Long.toString(this.value) + "L");
        } else {
            w.write(Long.toString(this.value));
        }
    }

    public boolean isConstant() {
        return true;
    }

    public Object constantValue() {
        if (this.kind() == IntLit.LONG) {
            return new Long(this.value);
        }
        return new Integer((int)this.value);
    }

    public Precedence precedence() {
        if (this.value < 0L) {
            return Precedence.UNARY;
        }
        return Precedence.LITERAL;
    }
}

