/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.ast;

import polyglot.ast.Import;
import polyglot.ast.Node;
import polyglot.ext.jl.ast.Node_c;
import polyglot.main.Options;
import polyglot.types.ImportTable;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;

public class Import_c
extends Node_c
implements Import {
    protected Import.Kind kind;
    protected String name;

    public Import_c(Position pos, Import.Kind kind, String name) {
        super(pos);
        this.name = name;
        this.kind = kind;
    }

    public String name() {
        return this.name;
    }

    public Import name(String name) {
        Import_c n = (Import_c)this.copy();
        n.name = name;
        return n;
    }

    public Import.Kind kind() {
        return this.kind;
    }

    public Import kind(Import.Kind kind) {
        Import_c n = (Import_c)this.copy();
        n.kind = kind;
        return n;
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        ImportTable it = tb.importTable();
        if (this.kind == Import.CLASS) {
            it.addClassImport(this.name);
        } else if (this.kind == Import.PACKAGE) {
            it.addPackageImport(this.name);
        }
        return this;
    }

    public String toString() {
        return "import " + this.name + (this.kind == Import.PACKAGE ? ".*" : "");
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (!Options.global.fully_qualified_names) {
            w.write("import ");
            w.write(this.name);
            if (this.kind == Import.PACKAGE) {
                w.write(".*");
            }
            w.write(";");
            w.newline(0);
        }
    }
}

