/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.Node;
import polyglot.ext.jl.ast.Term_c;
import polyglot.frontend.Job;
import polyglot.frontend.Pass;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class ClassBody_c
extends Term_c
implements ClassBody {
    protected List members;
    private static final Collection TOPICS = CollectionUtil.list(Report.types, Report.context);
    static /* synthetic */ Class class$polyglot$ast$ClassMember;

    public ClassBody_c(Position pos, List members) {
        super(pos);
        this.members = TypedList.copyAndCheck(members, class$polyglot$ast$ClassMember == null ? (class$polyglot$ast$ClassMember = ClassBody_c.class$("polyglot.ast.ClassMember")) : class$polyglot$ast$ClassMember, true);
    }

    public List members() {
        return this.members;
    }

    public ClassBody members(List members) {
        ClassBody_c n = (ClassBody_c)this.copy();
        n.members = TypedList.copyAndCheck(members, class$polyglot$ast$ClassMember == null ? (class$polyglot$ast$ClassMember = ClassBody_c.class$("polyglot.ast.ClassMember")) : class$polyglot$ast$ClassMember, true);
        return n;
    }

    public ClassBody addMember(ClassMember member) {
        ClassBody_c n = (ClassBody_c)this.copy();
        ArrayList<ClassMember> l = new ArrayList<ClassMember>(this.members.size() + 1);
        l.addAll(this.members);
        l.add(member);
        n.members = TypedList.copyAndCheck(l, class$polyglot$ast$ClassMember == null ? (class$polyglot$ast$ClassMember = ClassBody_c.class$("polyglot.ast.ClassMember")) : class$polyglot$ast$ClassMember, true);
        return n;
    }

    protected ClassBody_c reconstruct(List members) {
        if (!CollectionUtil.equals(members, this.members)) {
            ClassBody_c n = (ClassBody_c)this.copy();
            n.members = TypedList.copyAndCheck(members, class$polyglot$ast$ClassMember == null ? (class$polyglot$ast$ClassMember = ClassBody_c.class$("polyglot.ast.ClassMember")) : class$polyglot$ast$ClassMember, true);
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        List members = this.visitList(this.members, v);
        return this.reconstruct(members);
    }

    public Context enterScope(Context c) {
        return this.enterScope(c, true);
    }

    public Context enterScope(Context c, boolean inherit) {
        c = c.pushBlock();
        ClassType type = c.currentClass();
        this.addMembers(c, type, new HashSet(), inherit);
        return c;
    }

    public NodeVisitor disambiguateEnter(AmbiguityRemover ar) throws SemanticException {
        if (ar.kind() == AmbiguityRemover.SUPER || ar.kind() == AmbiguityRemover.SIGNATURES) {
            return ar.bypassChildren(this);
        }
        return ar;
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (ar.kind() == AmbiguityRemover.SIGNATURES) {
            ArrayList<Node> l = new ArrayList<Node>(this.members.size());
            Job j = ar.job();
            Iterator i = this.members.iterator();
            while (i.hasNext()) {
                ClassMember n = (ClassMember)i.next();
                if (n instanceof ClassDecl) {
                    ClassDecl m = (ClassDecl)j.spawn(ar.context(), n, Pass.CLEAN_SUPER, Pass.CLEAN_SUPER_ALL);
                    if (m == null) {
                        throw new SemanticException("Could not disambiguate class member.", n.position());
                    }
                    l.add(m.visit(ar.visitChildren()));
                    continue;
                }
                l.add(n.visit(ar.visitChildren()));
            }
            return this.members(l);
        }
        return this;
    }

    protected void addMembers(Context c, ReferenceType type, Set visited, boolean inherit) {
        Iterator i;
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, "addMembers(" + type + ")");
        }
        if (visited.contains(type)) {
            return;
        }
        visited.add(type);
        if (inherit) {
            if (type.superType() != null) {
                if (!type.superType().isReference()) {
                    throw new InternalCompilerError("Super class \"" + type.superType() + "\" of \"" + type + "\" is ambiguous.  " + "An error must have occurred earlier.", type.position());
                }
                this.addMembers(c, type.superType().toReference(), visited, true);
            }
            i = type.interfaces().iterator();
            while (i.hasNext()) {
                Type t = (Type)i.next();
                if (!t.isReference()) {
                    throw new InternalCompilerError("Interface \"" + t + "\" of \"" + type + "\" is ambiguous.  " + "An error must have occurred earlier.", type.position());
                }
                this.addMembers(c, t.toReference(), visited, true);
            }
        }
        i = type.methods().iterator();
        while (i.hasNext()) {
            MethodInstance mi = (MethodInstance)i.next();
            c.addMethod(mi);
        }
        i = type.fields().iterator();
        while (i.hasNext()) {
            FieldInstance fi = (FieldInstance)i.next();
            c.addVariable(fi);
        }
        if (type.isClass()) {
            i = type.toClass().memberClasses().iterator();
            while (i.hasNext()) {
                ClassType mct = (ClassType)i.next();
                c.addNamed(mct);
            }
        }
    }

    public String toString() {
        return "{ ... }";
    }

    protected void duplicateFieldCheck(TypeChecker tc) throws SemanticException {
        ClassType type = tc.context().currentClass();
        TypeSystem ts = tc.typeSystem();
        ArrayList l = new ArrayList(type.fields());
        for (int i = 0; i < l.size(); ++i) {
            FieldInstance fi = (FieldInstance)l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                FieldInstance fj = (FieldInstance)l.get(j);
                if (!fi.name().equals(fj.name())) continue;
                throw new SemanticException("Duplicate field \"" + fj + "\".", fj.position());
            }
        }
    }

    protected void duplicateConstructorCheck(TypeChecker tc) throws SemanticException {
        ClassType type = tc.context().currentClass();
        TypeSystem ts = tc.typeSystem();
        ArrayList l = new ArrayList(type.constructors());
        for (int i = 0; i < l.size(); ++i) {
            ConstructorInstance ci = (ConstructorInstance)l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                ConstructorInstance cj = (ConstructorInstance)l.get(j);
                if (!ci.hasFormals(cj.formalTypes())) continue;
                throw new SemanticException("Duplicate constructor \"" + cj + "\".", cj.position());
            }
        }
    }

    protected void duplicateMethodCheck(TypeChecker tc) throws SemanticException {
        ClassType type = tc.context().currentClass();
        TypeSystem ts = tc.typeSystem();
        ArrayList l = new ArrayList(type.methods());
        for (int i = 0; i < l.size(); ++i) {
            MethodInstance mi = (MethodInstance)l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                MethodInstance mj = (MethodInstance)l.get(j);
                if (!this.isSameMethod(ts, mi, mj)) continue;
                throw new SemanticException("Duplicate method \"" + mj + "\".", mj.position());
            }
        }
    }

    protected boolean isSameMethod(TypeSystem ts, MethodInstance mi, MethodInstance mj) {
        return mi.isSameMethod(mj);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        this.duplicateFieldCheck(tc);
        this.duplicateConstructorCheck(tc);
        this.duplicateMethodCheck(tc);
        return this;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (!this.members.isEmpty()) {
            w.newline(4);
            w.begin(0);
            Iterator i = this.members.iterator();
            while (i.hasNext()) {
                ClassMember member = (ClassMember)i.next();
                this.printBlock(member, w, tr);
                if (!i.hasNext()) continue;
                w.newline(0);
                w.newline(0);
            }
            w.end();
            w.newline(0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

