/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.util.Enum;

public class Precedence
extends Enum {
    private int value;
    public static final Precedence LITERAL = new Precedence("literal", 0);
    public static final Precedence UNARY = new Precedence("unary", 1);
    public static final Precedence CAST = new Precedence("cast", 1);
    public static final Precedence MUL = new Precedence("*", 2);
    public static final Precedence STRING_ADD = new Precedence("string+", 3);
    public static final Precedence ADD = new Precedence("+", 4);
    public static final Precedence SHIFT = new Precedence("<<", 5);
    public static final Precedence RELATIONAL = new Precedence("<", 6);
    public static final Precedence INSTANCEOF = new Precedence("isa", 7);
    public static final Precedence EQUAL = new Precedence("==", 8);
    public static final Precedence BIT_AND = new Precedence("&", 9);
    public static final Precedence BIT_XOR = new Precedence("^", 10);
    public static final Precedence BIT_OR = new Precedence("|", 11);
    public static final Precedence COND_AND = new Precedence("&&", 12);
    public static final Precedence COND_OR = new Precedence("||", 13);
    public static final Precedence CONDITIONAL = new Precedence("?:", 14);
    public static final Precedence ASSIGN = new Precedence("=", 13);
    public static final Precedence UNKNOWN = new Precedence("unknown", 999);

    public Precedence(String name, int value) {
        super("prec_" + name);
        this.value = value;
    }

    public boolean equals(Object o) {
        return o instanceof Precedence && this.equals((Precedence)o);
    }

    public boolean equals(Precedence p) {
        return this.value == p.value;
    }

    public boolean isTighter(Precedence p) {
        return this.value < p.value;
    }
}

