/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.peq.queryglue;

import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamSelector;
import edu.ksu.cis.indus.peq.queryast.BaseAST;
import edu.ksu.cis.indus.peq.queryast.ConstructorAST;
import edu.ksu.cis.indus.peq.queryast.OrAST;
import edu.ksu.cis.indus.peq.queryglue.ConstructorNode;
import edu.ksu.cis.indus.peq.queryglue.OrNode;
import edu.ksu.cis.indus.peq.queryglue.QueryNode;
import edu.ksu.cis.indus.peq.queryglue.QueryObject;
import edu.ksu.cis.indus.peq.queryparser.IndusPeqLexer;
import edu.ksu.cis.indus.peq.queryparser.IndusPeqParser;
import edu.ksu.cis.indus.peq.queryparser.Level1Lexer;
import edu.ksu.cis.indus.peq.queryparser.Level1Parser;
import java.io.StringReader;

public class QueryConvertor {
    private String errorString;

    public QueryObject getQueryObject(String string) {
        QueryObject queryObject = null;
        TokenStreamSelector tokenStreamSelector = new TokenStreamSelector();
        Level1Lexer level1Lexer = new Level1Lexer(new StringReader(string));
        Level1Parser level1Parser = new Level1Parser((TokenStream)tokenStreamSelector);
        IndusPeqLexer indusPeqLexer = new IndusPeqLexer(level1Lexer.getInputState());
        IndusPeqParser indusPeqParser = new IndusPeqParser((TokenStream)tokenStreamSelector);
        tokenStreamSelector.addInputStream((TokenStream)level1Lexer, "level1lexer");
        tokenStreamSelector.addInputStream((TokenStream)indusPeqLexer, "level2lexer");
        tokenStreamSelector.select("level1lexer");
        level1Lexer.setSelector(tokenStreamSelector);
        level1Lexer.setLevel2LexerName("level2lexer");
        indusPeqLexer.setSelector(tokenStreamSelector);
        level1Parser.setLevel2Parser(indusPeqParser);
        try {
            level1Parser.firstRule();
            QueryNode queryNode = (QueryNode)level1Parser.getAST();
            if (queryNode != null) {
                queryObject = new QueryObject();
                queryObject.setQueryName(queryNode.getQueryName());
                queryObject.setExistential(queryNode.isExistentialQuery());
                ConstructorNode constructorNode = queryNode.getHeadConstructor();
                BaseAST baseAST = this.processConstructors(constructorNode);
                queryObject.setStartNode(baseAST);
            }
        }
        catch (RecognitionException recognitionException) {
            this.errorString = recognitionException.getMessage();
        }
        catch (TokenStreamException tokenStreamException) {
            this.errorString = tokenStreamException.getMessage();
        }
        return queryObject;
    }

    private BaseAST processConstructors(ConstructorNode constructorNode) {
        BaseAST baseAST = null;
        if (constructorNode != null) {
            if (constructorNode instanceof OrNode) {
                OrAST orAST = new OrAST();
                BaseAST baseAST2 = this.processConstructors(((OrNode)constructorNode).getLeftNode());
                BaseAST baseAST3 = this.processConstructors(((OrNode)constructorNode).getRightNode());
                orAST.setLeftNode(baseAST2);
                orAST.setRightNode(baseAST3);
                if (constructorNode.getNextConstructor() != null) {
                    orAST.setNextNode(this.processConstructors(constructorNode.getNextConstructor()));
                }
                baseAST = orAST;
            } else {
                ConstructorAST constructorAST = new ConstructorAST();
                constructorAST.setConstructType(constructorNode.getConstructorType());
                constructorAST.setRegexType(constructorNode.getRegexOperator());
                constructorAST.setVariableName(constructorNode.getVariableName());
                constructorAST.setNextNode(this.processConstructors(constructorNode.getNextConstructor()));
                baseAST = constructorAST;
            }
        }
        return baseAST;
    }

    public String getErrorString() {
        return this.errorString;
    }
}

