from django.urls import path
from django.urls import include
from django.contrib.auth import views as auth
from django.views.generic import RedirectView
from django.views.generic.base import TemplateView

from . import views
from .apps import LinkDatabase
from .viewspkg import (
    entries,
    sources,
    comments,
    backgroundjobs,
    system,
    export,
    domains,
    entryrules,
    apikeys,
    modelfiles,
    keywords,
    tools,
    custom,
    readmarkers,
    readlater,
    browsers,
    users,
    useractions,
    userhistory,
    blockentry,
)

# register app namespace
# TODO https://stackoverflow.com/questions/30494000/django-url-namespaces-the-template-has-to-know-its-namespace
app_name = str(LinkDatabase.name)

# fmt: off
urlpatterns = [
    path("", system.index, name="index"),
    path("entries/", entries.entries, name="entries"),
    path("entries-recent/", entries.entries_recent, name="entries-recent"),
    path("entries-bookmarked/", entries.entries_bookmarked, name="entries-bookmarked"),
    path("entries-user-bookmarked/", entries.entries_user_bookmarked, name="entries-user-bookmarked"),
    path("entries-archived/", entries.entries_archived, name="entries-archived"),
    path("entries-untagged/", entries.entries_untagged, name="entries-untagged"),

    path("entries-json/", entries.entries_json, name="entries-json"),
    path("entries-json-recent/", entries.entries_json_recent, name="entries-json-recent"),
    path("entries-json-bookmarked/", entries.entries_json_bookmarked, name="entries-json-bookmarked"),
    path("entries-json-user-bookmarked/", entries.entries_json_user_bookmarked, name="entries-json-user-bookmarked"),
    path("entries-json-archived/", entries.entries_json_archived, name="entries-json-archived"),
    path("entries-json-untagged/", entries.entries_json_untagged, name="entries-json-untagged"),

    path("entries-remove-all", entries.entries_remove_all, name="entries-remove-all"),
    path("entries-remove-nonbookmarked", entries.entries_remove_nonbookmarked, name="entries-remove-nonbookmarked"),
    # entry
    path("entry/<int:pk>/", entries.EntryDetailView.as_view(), name="entry-detail"),
    path("entry-json/<int:pk>/", entries.entry_json, name="entry-json"),
    path("entry-archived/<int:pk>/", entries.EntryArchivedDetailView.as_view(), name="entry-archived"),
    path("entry-add", entries.add_entry, name="entry-add"),
    path("entry-add-form", entries.add_entry_form, name="entry-add-form"),
    path("entry-is", entries.entry_is, name="entry-is"),
    path("entry-reset-data/<int:pk>/", entries.entry_reset_data, name="entry-reset-data"),
    path("entry-update-data/<int:pk>/", entries.entry_update_data, name="entry-update-data"),
    path("entry-reset-local-data/<int:pk>/", entries.entry_reset_local_data, name="entry-reset-local-data"),
    path("entry-add-simple", entries.add_simple_entry, name="entry-add-simple"),
    path("entry-edit/<int:pk>/", entries.edit_entry, name="entry-edit"),
    path("entry-remove/<int:pk>/", entries.entry_remove, name="entry-remove"),
    path("entry-show-dislikes/<int:pk>/", entries.entry_show_dislikes, name="entry-show-dislikes"),
    path("entry-dead/<int:pk>/", entries.entry_dead, name="entry-dead"),
    path("entry-active/<int:pk>/", entries.entry_active, name="entry-active"),
    path("entry-clear-status/<int:pk>/", entries.entry_clear_status, name="entry-clear-status"),
    path("entry-bookmark/<int:pk>/", entries.entry_bookmark, name="entry-bookmark"),
    path("entry-unbookmark/<int:pk>/", entries.entry_unbookmark, name="entry-unbookmark"),
    path("entry-download-music/<int:pk>/", tools.download_music_pk, name="entry-download-music",),
    path("entry-download-video/<int:pk>/", tools.download_video_pk, name="entry-download-video",),
    path("entry-download/<int:pk>/", entries.download_entry, name="entry-download"),
    path("entry-archive-edit/<int:pk>/", entries.archive_edit_entry, name="entry-archive-edit"),
    path("entry-archive-bookmark/<int:pk>/", entries.archive_make_bookmarked_entry, name="entry-archive-bookmark"),
    path("entry-archive-notbookmark/<int:pk>/", entries.archive_make_not_bookmarked_entry, name="entry-archive-notbookmark"),
    path("entry-archive-hide/<int:pk>/", entries.archive_hide_entry, name="entry-archive-hide"),
    path("entry-archive-remove/<int:pk>/", entries.archive_remove_entry, name="entry-archive-remove"),
    path("entries-archive-remove-all", entries.archive_entries_remove_all, name="entries-archive-remove-all"),
    path("entry-save/<int:pk>/", entries.wayback_save, name="entry-save"),
    path("get-entry-menu/<int:pk>/", entries.get_entry_menu, name="get-entry-menu"),
    # sources
    path("sources/", sources.sources, name="sources"),
    path("source/<int:pk>/", sources.SourceDetailView.as_view(), name="source-detail"),
    path("source-json/<int:pk>", sources.source_json, name="source-json"),
    path("sources-json-all/", sources.sources_json_all, name="sources-json-all"),
    path("sources-json-enabled/", sources.sources_json_enabled, name="sources-json-enabled"),
    path("sources-initialize/", sources.sources_initialize, name="sources-initialize"),
    path("source-is", sources.source_is, name="source-is"),
    path("source-add", sources.add_source, name="source-add"),
    path("source-add-form", sources.source_add_form, name="source-add-form"),
    path("source-add-simple", sources.add_source_simple, name="source-add-simple"),
    path("source-remove/<int:pk>/", sources.remove_source, name="source-remove"),
    path("source-remove-entries/<int:pk>/", sources.source_remove_entries, name="source-remove-entries"),
    path("source-edit/<int:pk>/", sources.edit_source, name="source-edit"),
    path("source-refresh/<int:pk>/", sources.refresh_source, name="source-refresh"),
    path("source-save/<int:pk>/", sources.wayback_save, name="source-save"),
    path("source-disable/<int:pk>/", sources.disable, name="source-disable"),
    path("source-enable/<int:pk>/", sources.enable, name="source-enable"),
    path("source-import-yt-links/<int:pk>/", sources.import_youtube_links_for_source, name="source-import-yt-links"),
    path("source-fix-entries/<int:source_pk>/", sources.source_fix_entries, name="source-fix-entries",),
    path("source-process-contents/<int:pk>/", sources.source_process_contents, name="source-process-contents",),
    path("sources-remove-all/", sources.remove_all_sources, name="sources-remove-all"),
    path("sources-enable-all/", sources.enable_all_sources, name="sources-enable-all"),
    path("sources-disable-all/", sources.disable_all_sources, name="sources-disable-all"),
    path("sources-manual-refresh/", sources.sources_manual_refresh, name="sources-manual-refresh"),
    path("categories-view", sources.categories_view, name="categories-view"),
    path("categories-reset", sources.categories_reset, name="categories-reset"),
    # tags
    path("entry-tag/<int:pk>/", useractions.entry_tag, name="entry-tag"),
    path("entry-tag-form/<int:pk>/", useractions.entry_tag_form, name="entry-tag-form"),
    path("tag-remove/<int:pk>/", useractions.tag_remove, name="tag-remove"),
    path("tag-remove-str/<str:tag>/", useractions.tag_remove_str, name="tag-remove-str"),
    path("tag-remove-form/", useractions.tag_remove_form, name="tag-remove-form"),
    path("tag-rename", useractions.tag_rename, name="tag-rename"),
    path("tags-entry-remove/<int:entrypk>/", useractions.tags_entry_remove, name="tags-entry-remove",),
    path("tags-show-all", useractions.CompactedTagsListView.as_view(), name="tags-show-all"),
    path("tags-show-actual", useractions.ActualTags.as_view(), name="tags-show-actual"),
    path("tags-many", useractions.tag_many, name="tag-many"),
    path("tags-remove-all/", useractions.tags_remove_all, name="tags-remove-all"),
    # comments
    path("entry-comment-add/<int:link_id>", comments.entry_add_comment, name="entry-comment-add",),
    path("entry-comment-edit/<int:pk>/", comments.entry_comment_edit, name="entry-comment-edit",),
    path("entry-comment-remove/<int:pk>/", comments.entry_comment_remove, name="entry-comment-remove",),
    path("comments-remove-all/", comments.remove_all, name="comments-remove-all"),
    # votes
    path("entry-vote/<int:pk>/", useractions.entry_vote, name="entry-vote"),
    path("entry-vote-form/<int:pk>/", useractions.entry_vote_form, name="entry-vote-form"),
    path("votes-remove-all/", useractions.votes_remove_all, name="votes-remove-all"),
    # files
    path("model-file/<int:pk>/", modelfiles.model_file, name="model-file"),
    path("model-file-remove/<int:pk>/", modelfiles.model_file_remove, name="model-file-remove"),
    path("model-files/", modelfiles.ModelFilesListView.as_view(), name="model-files"),
    path("model-files-remove/", modelfiles.model_files_remove, name="model-files-remove"),
    # read markers
    path("set-read-marker", readmarkers.set_read_marker, name="set-read-marker"),
    path("set-source-read-marker/<int:pk>/", readmarkers.set_source_read_marker, name="set-source-read-marker"),
    # background jobs
    path("backgroundjobs/", backgroundjobs.backgroundjobs, name="backgroundjobs",),
    path("backgroundjob-add", backgroundjobs.backgroundjob_add, name="backgroundjob-add",),
    path("backgroundjob-prio-up/<int:pk>/", backgroundjobs.backgroundjob_prio_up, name="backgroundjob-prio-up",),
    path("backgroundjob-prio-down/<int:pk>/", backgroundjobs.backgroundjob_prio_down, name="backgroundjob-prio-down",),
    path("backgroundjob-enable/<int:pk>/", backgroundjobs.backgroundjob_enable, name="backgroundjob-enable",),
    path("backgroundjob-disable/<int:pk>/", backgroundjobs.backgroundjob_disable, name="backgroundjob-disable",),
    path("backgroundjobs-check-new/", backgroundjobs.backgroundjobs_check_new, name="backgroundjobs-check-new",),
    path("backgroundjobs-perform-all/", backgroundjobs.backgroundjobs_perform_all, name="backgroundjobs-perform-all",),
    path("backgroundjobs-enable-all/", backgroundjobs.backgroundjobs_enable_all, name="backgroundjobs-enable-all",),
    path("backgroundjobs-disable-all/", backgroundjobs.backgroundjobs_disable_all, name="backgroundjobs-disable-all",),
    path("backgroundjob-remove/<int:pk>/", backgroundjobs.backgroundjob_remove, name="backgroundjob-remove",),
    path("backgroundjobs-remove/<str:job_type>/", backgroundjobs.backgroundjobs_remove, name="backgroundjobs-remove",),
    path("backgroundjobs-remove-all/", backgroundjobs.backgroundjobs_remove_all, name="backgroundjobs-remove-all",),
    # domains
    path("domains/", domains.domains, name="domains",),
    path("domain/<int:pk>/", domains.DomainsDetailView.as_view(), name="domain-detail",),
    path("domain-by-name/", domains.DomainsByNameDetailView.as_view(), name="domain-by-name",),
    path("domain-edit/<int:pk>/", domains.domain_edit, name="domain-edit",),
    path("domain-update-data/<int:pk>/", domains.domain_update_data, name="domain-update-data",),
    path("domain-json/<int:pk>/", domains.domain_json, name="domain-json",),
    path("domain-remove/<int:pk>/", domains.domain_remove, name="domain-remove",),
    path("domains-fix/", domains.domains_fix, name="domains-fix",),
    path("domains-read-bookmarks/", domains.domains_read_bookmarks, name="domains-read-bookmarks",),
    path("domains-json/", domains.domains_json, name="domains-json"),
    path("domains-reset-dynamic-data/", domains.domains_reset_dynamic_data, name="domains-reset-dynamic-data"),
    path("domains-remove-all/", domains.domains_remove_all, name="domains-remove-all",),
    # admin views
    path("admin-page/", system.admin_page, name="admin-page"),
    path("configuration-advanced/", system.configuration_advanced_page, name="configuration-advanced"),
    path("configuration-advanced-json/", system.configuration_advanced_json, name="configuration-advanced-json"),
    path("system-status/", system.system_status, name="system-status"),
    path("about/", system.about, name="about"),
    path("robots.txt", TemplateView.as_view(template_name="robots.txt", content_type="text/plain")), # https://en.wikipedia.org/wiki/Robots.txt
    path("opensearch.xml", system.opensearchxml, name="opensearchxml"), # https://developer.mozilla.org/en-US/docs/Web/OpenSearch
    path("missing-rights/", system.missing_rights, name="missing-rights"),
    path("reset-config/", system.reset_config, name="reset-config"),
    path("wizard", system.wizard_setup, name="wizard",),
    path("wizard-init", system.wizard_setup_init, name="wizard-init",),
    path("wizard-setup-news", system.wizard_setup_news, name="wizard-setup-news",),
    path("wizard-setup-gallery", system.wizard_setup_gallery, name="wizard-setup-gallery",),
    path("wizard-setup-search-engine", system.wizard_setup_search_engine, name="wizard-setup-search-engine",),
    path("setup-default-rules", system.setup_default_rules, name="setup-default-rules",),
    path("is-system-ok", system.is_system_ok, name="is-system-ok",),
    # users
    path("appusers/", users.UserListView.as_view(), name="appusers",),
    path("appuser-history/<int:user_id>/", users.UserEntryVisitHistoryListView.as_view(), name="appuser-history",),
    path("appuser-search-history/<int:user_id>/", users.UserSearchHistoryListView.as_view(), name="appuser-search-history",),
    path("user-personal/", users.user_personal, name="user-personal",),
    path("user-comments/", users.UserCommentsListView.as_view(), name="user-comments",),
    path("read-later-entries/", readlater.read_later_entries, name="read-later-entries"),
    path("read-later-add/<int:pk>/", readlater.read_later_add, name="read-later-add"),
    path("read-later-remove/<int:pk>/", readlater.read_later_remove, name="read-later-remove"),
    path("read-later-clear/", readlater.read_later_clear, name="read-later-clear"),
    path("user-tags-show", useractions.UserCompactedTagsListView.as_view(), name="user-tags-show"),
    path("user-browse-history/", userhistory.user_browse_history, name="user-browse-history"),
    path("user-search-history/", users.UserSearchHistoryListView.as_view(), name="user-search-history",),
    path("search-history-remove/<int:pk>/", userhistory.search_history_remove, name="search-history-remove"),
    path("user-config", system.user_config, name="user-config"),
    path("user-configs", users.UserConfigsListView.as_view(), name="user-configs"),
    # logging
    path("logs/", system.AppLoggingView.as_view(), name="logs",),
    path("json-logs/", system.json_logs, name="json-logs",),
    path("truncate-log", system.truncate_log, name="truncate-log"),
    path("truncate-log-errors", system.truncate_log_errors, name="truncate-log-errors"),
    path("truncate-log-warnings", system.truncate_log_warnings, name="truncate-log-warnings"),
    path("truncate-log-all", system.truncate_log_all, name="truncate-log-all"),
    # import / export
    path("data-export-add", export.data_export_add, name="data-export-add"),
    path("data-export-edit/<int:pk>/", export.data_export_edit, name="data-export-edit"),
    path("data-export-enable/<int:pk>/", export.enable, name="data-export-enable"),
    path("data-export-disable/<int:pk>/", export.disable, name="data-export-disable"),
    path("data-export-remove/<int:pk>/", export.data_export_remove, name="data-export-remove"),
    path("data-exports/", export.DataExportListView.as_view(), name="data-exports",),
    path("data-export/<int:pk>/", export.DataExportDetailsView.as_view(), name="data-export",),
    path("data-export-job-add/<int:pk>/", export.data_export_job_add, name="data-export-job-add",),
    path("write-bookmarks", export.write_bookmarks, name="write-bookmarks"),
    path("write-daily-data-form", export.write_daily_data_form, name="write-daily-data-form",),
    path("write-tag-form", export.write_tag_form, name="write-tag-form"),
    path("push-daily-data-form", export.push_daily_data_form, name="push-daily-data-form"),
    path("import-bookmarks", export.import_bookmarks, name="import-bookmarks"),
    path("import-daily-data", export.import_daily_data, name="import-daily-data"),
    path("import-sources", export.import_sources, name="import-sources"),
    path("import-reading-list", export.import_reading_list_view, name="import-reading-list",),
    path("import-from-instance", export.import_from_instance, name="import-from-instance",),
    path("import-from-files", export.import_from_files, name="import-from-files",),
    path("import-source-ia/<int:pk>/", export.import_source_from_ia, name="import-source-ia",),
    # keywords
    path("keywords/", keywords.keywords, name="keywords",),
    path("keyword-remove", keywords.keyword_remove, name="keyword-remove",),
    path("keywords-remove-all/", keywords.keywords_remove_all, name="keywords-remove-all",),
    # entry rules
    path("entry-rule-add", entryrules.entry_rule_add, name="entry-rule-add"),
    path("entry-rule-edit/<int:pk>/", entryrules.entry_rule_edit, name="entry-rule-edit"),
    path("entry-rule-remove/<int:pk>/", entryrules.entry_rule_remove, name="entry-rule-remove"),
    path("entry-rules/", entryrules.EntryRulesListView.as_view(), name="entry-rules",),
    path("entry-rules-json/", entryrules.entry_rules_json, name="entry-rules-json",),
    path("entry-rule/<int:pk>/", entryrules.EntryRulesDetailView.as_view(), name="entry-rule",),
    path("entry-rule-run/<int:pk>/", entryrules.entry_rule_run, name="entry-rule-run",),
    # API keys
    path("api-key-add", apikeys.add, name="api-key-add"),
    path("api-key-remove/<int:pk>/", apikeys.remove, name="api-key-remove"),
    path("api-keys/", apikeys.ListView.as_view(), name="api-keys",),
    # browser
    path("browsers/", browsers.BrowserListView.as_view(), name="browsers",),
    path("browser-read/", browsers.read_browser_setup, name="browser-read",),
    path("browser-apply/", browsers.apply_browser_setup, name="browser-apply",),
    path("browser-enable/<int:pk>/", browsers.enable, name="browser-enable",),
    path("browser-disable/<int:pk>/", browsers.disable, name="browser-disable",),
    path("browser-remove/<int:pk>/", browsers.remove, name="browser-remove",),
    path("browser-edit/<int:pk>/", browsers.edit, name="browser-edit"),
    path("browser-prio-up/<int:pk>/", browsers.prio_up, name="browser-prio-up"),
    path("browser-prio-down/<int:pk>/", browsers.prio_down, name="browser-prio-down"),
    # other, debug forms
    path("page-show-props", tools.page_show_properties, name="page-show-props",),
    path("page-scan-link", tools.page_scan_link, name="page-scan-link",),
    path("page-scan-contents", tools.page_scan_contents, name="page-scan-contents",),
    path("page-process-rss-contents", tools.page_process_rss_contents, name="page-process-rss-contents",),
    path("page-verify", tools.page_verify, name="page-verify",),
    path("page-add-many-links", tools.page_add_many_links, name="page-add-many-links",),
    path("download-music-url", tools.download_music, name="download-music-url",),
    path("download-video-url", tools.download_video, name="download-video-url",),
    path("download-url", tools.download_url, name="download-url",),
    path("is-url-allowed", tools.is_url_allowed, name="is-url-allowed",),
    path("gateways", tools.gateways, name="gateways",),
    path("gateways-initialize", tools.gateways_initialize, name="gateways-initialize",),
    path("search-engines", tools.search_engines, name="search-engines",),
    path("cleanup-link", tools.cleanup_link, name="cleanup-link",),
    path("initialize-block-lists", blockentry.initialize_block_lists, name="initialize-block-lists",),
    path("block-lists", blockentry.BlockEntryListListView.as_view(), name="block-lists",),
    path("block-entries", blockentry.BlockEntryListView.as_view(), name="block-entries",),
    path("block-lists-update", blockentry.block_lists_update, name="block-lists-update",),
    path("block-list-update/<int:pk>/", blockentry.block_list_update, name="block-list-update",),
    path("block-list-remove/<int:pk>/", blockentry.block_list_remove, name="block-list-remove",),
    path("block-lists-clear", blockentry.block_lists_clear, name="block-lists-clear",),
    # json and ajax
    path("get-search-suggestions-entries/<str:searchstring>/", userhistory.get_search_suggestions_entries, name="get-search-suggestions-entries"),
    path("get-search-suggestions-sources/<str:searchstring>/", userhistory.get_search_suggestions_sources, name="get-search-suggestions-sources"),
    path("get-indicators", system.get_indicators, name="get-indicators",),
    path("get-menu", system.get_menu, name="get-menu",),
    path("json-table-status/", system.json_table_status, name="json-table-status"),
    path("json-system-status/", system.json_system_status, name="json-system-status"),
    path("json-export-status/", system.json_export_status, name="json-export-status"),
    path("get-backgroundjobs/", backgroundjobs.get_backgroundjobs, name="get-backgroundjobs",),
    path("get-entry-details/<int:pk>/", entries.EntryDetailDetailView.as_view(), name="get-entry-details"),
    path("json-user-search-history", userhistory.json_user_search_history, name="json-user-search-history"),
    path("get-user-browse-history", userhistory.get_user_browse_history, name="get-user-browse-history"),
    path("is-entry-download/<int:pk>/", backgroundjobs.is_entry_download, name="is-entry-download"),
    path("entry-tags/<int:pk>/", useractions.entry_tags, name="entry-tags"),
    path("history-remove-all/", userhistory.history_remove_all, name="history-remove-all"),
    path("get-settings/", system.get_settings, name="get-settings"),
    path("get-read-later-queue/", readlater.get_read_later_queue, name="get-read-later-queue"),
    path("get-page-properties", tools.get_page_properties, name="get-page-properties",),
    # login
    path("accounts/", include("django.contrib.auth.urls")),
    path("rsshistory/accounts/logout/", RedirectView.as_view(url="rsshistory/")),
    path("accounts/logout/", RedirectView.as_view(url="rsshistory/")),
]
# fmt: on
