{% load static %}


let list_display_style = 0;
let highlight_bookmarks = false;


function getVotesBadge(page_rating_votes) {
    let badge_text = page_rating_votes > 0 ? `
        <span class="badge text-bg-warning" style="position: absolute; top: 5px; right: 30px; font-size: 0.8rem;">
            ${page_rating_votes}
        </span>` : '';

    return badge_text;
}


function getBookmarkBadge(entry) {
    let badge_star = entry.bookmarked ? `
        <span class="badge text-bg-warning" style="position: absolute; top: 5px; right: 5px; font-size: 0.8rem;">
            ★
        </span>` : '';
    return badge_star;
}


function getAgeBadge(entry) {
    let badge_text = entry.age > 0 ? `
        <span class="badge text-bg-warning" style="position: absolute; top: 30px; right: 5px; font-size: 0.8rem;">
            A
        </span>` : '';
    return badge_text;
}


function getDeadBadge(entry) {
    let badge_text = entry.date_dead_since ? `
        <span class="badge text-bg-warning" style="position: absolute; top: 30px; right: 30px; font-size: 0.8rem;">
            D
        </span>` : '';
    return badge_text;
}


function entryStandardTemplate(entry, show_icons = true, small_icons = false) {
    let page_rating_votes = entry.page_rating_votes;

    let badge_text = getVotesBadge(page_rating_votes);
    let badge_star = getBookmarkBadge(entry);
    let badge_age = getAgeBadge(entry);

    let bookmark_class = entry.bookmarked ? `list-group-item-primary` : '';
    let invalid_style = entry.is_valid ? `` : `style="opacity: 0.5"`;

    let img_text = '';
    if (show_icons) {
        const iconClass = small_icons ? 'icon-small' : 'icon-normal';
        img_text = `<img src="{thumbnail}" class="rounded ${iconClass}" />`;
    }
    
    let thumbnail_text = '';
    if (img_text) {
        thumbnail_text = `
            <div style="position: relative; display: inline-block;">
                ${img_text}
            </div>`;
    }

    return `
        <a 
            href="{entry_link}"
            title="{title}"
            ${invalid_style}
            class="my-1 p-1 list-group-item list-group-item-action ${bookmark_class}"
        >
            <div class="d-flex">
                ${thumbnail_text}
                <div class="mx-2">
                    <span style="font-weight:bold" class="text-reset">{title_safe}</span>
                    <div class="text-reset">
                        {source__title} {date_published}
                    </div>
                </div>
            </div>

            ${badge_text}
            ${badge_star}
            ${badge_age}
        </a>
    `;
}


function entrySearchEngineTemplate(entry, show_icons = true, small_icons = false) {
    let page_rating_votes = entry.page_rating_votes;

    let badge_text = getVotesBadge(page_rating_votes);
    let badge_star = highlight_bookmarks ? getBookmarkBadge(entry) : "";
    let badge_age = getAgeBadge(entry);
   
    let invalid_style = entry.is_valid ? `` : `style="opacity: 0.5"`;
    let bookmark_class = (entry.bookmarked && highlight_bookmarks) ? `list-group-item-primary` : '';

    let entry_link = list_display_style ? "${link_absolute}" : "${link_absolute}";

    let thumbnail_text = '';
    if (show_icons) {
        const iconClass = small_icons ? 'icon-small' : 'icon-normal';
        thumbnail_text = `
            <div style="position: relative; display: inline-block;">
                <img src="{thumbnail}" class="rounded ${iconClass}"/>
            </div>`;
    }

    return `
        <a 
            href="{entry_link}"
            title="{title}"
            ${invalid_style}
            class="my-1 p-1 list-group-item list-group-item-action ${bookmark_class}"
        >
            <div class="d-flex">
               ${thumbnail_text}
               <div class="mx-2">
                  <span style="font-weight:bold" class="text-reset">{title_safe}</span>
                  <div class="text-reset">@ {link}</div>
                  ${badge_text}
                  ${badge_star}
                  ${badge_age}
               </div>
            </div>
        </a>
    `;
}

function entryGalleryTemplate(entry, show_icons = true, small_icons = false) {
    let page_rating_votes = entry.page_rating_votes;
    
    let badge_text = getVotesBadge(page_rating_votes);
    let badge_star = getBookmarkBadge(entry);
    let badge_age = getAgeBadge(entry);

    let invalid_style = entry.is_valid ? `` : `style="opacity: 0.5"`;

    let thumbnail = entry.thumbnail;
    let thumbnail_text = `
        <img src="${thumbnail}" style="width:100%; max-height:100%; object-fit:cover"/>
        ${badge_text}
        ${badge_star}
        ${badge_age}
    `;

    return `
        <a 
            href="{entry_link}"
            title="{title}"
    ${invalid_style}
            class="element_${view_display_type} list-group-item list-group-item-action"
        >
            <div style="display: flex; flex-direction:column; align-content:normal; height:100%">
                <div style="flex: 0 0 70%; flex-shrink: 0;flex-grow:0;max-height:70%">
                    ${thumbnail_text}
                </div>
                <div style="flex: 0 0 30%; flex-shrink: 0;flex-grow:0;max-height:30%">
                    <span style="font-weight: bold" class="text-primary">{title_safe}</span>
                    <div class="link-list-item-description">{source__title}</div>
                </div>
            </div>
        </a>
    `;
}


function fillEntryList(entries) {
    let htmlOutput = '';

    if (entries && entries.length > 0) {
        entries.forEach(entry => {
            let datePublished = new Date(entry.date_published);
            if (isNaN(datePublished)) {
                datePublished = new Date();
            }

            const templateMap = {
                "standard": entryStandardTemplate,
                "gallery": entryGalleryTemplate,
                "search-engine": entrySearchEngineTemplate
            };

            const templateFunc = templateMap[view_display_type];
            if (!templateFunc) {
                return;
            }
            var template_text = templateFunc(entry, view_show_icons, view_small_icons);

            let thumbnail = entry.thumbnail;
            let page_rating_votes = entry.page_rating_votes;
            let page_rating_contents = entry.page_rating_contents;

            let entry_link = list_display_style ? entry.link : entry.link_absolute;

            // Replace all occurrences of the placeholders using a global regular expression
            let listItem = template_text
                .replace(/{link_absolute}/g, entry.link_absolute)
                .replace(/{link}/g, entry.link)
                .replace(/{entry_link}/g, entry_link)
                .replace(/{title}/g, entry.title)
                .replace(/{thumbnail}/g, entry.thumbnail)
                .replace(/{title_safe}/g, entry.title_safe)
                .replace(/{page_rating_votes}/g, entry.page_rating_votes)
                .replace(/{page_rating_contents}/g, entry.page_rating_contents)
                .replace(/{page_rating}/g, entry.page_rating)
                .replace(/{source__title}/g, entry.source__title)
                .replace(/{age}/g, entry.age)
                .replace(/{date_published}/g, datePublished.toLocaleString());

            htmlOutput += listItem;
        });
    } else {
        htmlOutput = '<li class="list-group-item">No entries found</li>';
    }

    return htmlOutput;
}


function fillListData() {
    let data = object_list_data;

    $('#listData').html("");

    let entries = data.entries;

    if (!entries || entries.length == 0) {
        $('#listData').html("No entries found");
        $('#pagination').html("");
        return;
    }

    var finished_text = fillEntryList(entries);
    $('#listData').html(finished_text);
    let pagination = GetPaginationNav(data);
    $('#pagination').html(pagination);
}


{% include "rsshistory/javascript_list_utilities.js" %}


$(document).on("click", '#showPureLinks', function(e) {
   if (list_display_style == 0) {
      list_display_style = 1;
   }
   else {
      list_display_style = 0;
   }

   fillListData();
});


$(document).on("click", '#highlightBookmarks', function(e) {
   if (!highlight_bookmarks) {
      highlight_bookmarks = true;
   }
   else {
      highlight_bookmarks = 0;
   }

   fillListData();
});


$(document).on("click", '#displayStandard', function(e) {
    view_display_type = "standard";
    fillListData();
});


$(document).on("click", '#displayGallery', function(e) {
    view_display_type = "gallery";
    fillListData();
});


$(document).on("click", '#displaySearchEngine', function(e) {
    view_display_type = "search-engine";
    fillListData();
});
