# $i18n 国际化转换

同 [useRxzI18n](../use/base/userxzi18n.html) 的 `i18n` 方法。

---

<div>{{ $i18n('custom_message') }}</div>
<div>{{ $i18n('max_custom', [10]) }}</div>
<div>{{ $i18n('custom_validator', { min: 0 }) }}</div>

----

在引入的时候添加选项

```ts
import { createApp } from 'vue'
import { RxzUI, RxzOption } from 'rxz-ui';
import 'rxz-ui/lib/rxz-ui.css';
import App from './App.vue';

const app = createApp(App);
app.use(RxzUI, {
  i18n: {
    zh: {
      custom_message: '我是自定义中文',
      max_custom: '最大值为{0}',
      custom_validator: '最小值为{min}',
    },
    en: {
      custom_message: 'I am custom English',
      max_custom: 'max value is {0}',
      custom_validator: 'min value is {min}',
    },
  },
} as RxzOption);
app.mount('#app');
```

```vue
<template>
  <div>{{ $i18n('custom_message') }}</div>
  <div>{{ $i18n('max_custom', [10]) }}</div>
  <div>{{ $i18n('custom_validator', { min: 0 }) }}</div>
</template>
```

