# CodeBucket
A beginner-friendly project to help you in open-source contributions. Made specifically for contributions in HACKTOBERFEST 2020! Please leave a star ⭐ to support this project! ✨ Join our discord server to be a part of our community. [Click Here To Join](https://discord.gg/HedjRMV).

#### Your Contributions would be counted towards Hacktoberfest if it has been approved or merged or has a "hacktoberfest-accepted" label. It is not mandatory to have all 3 on a particular PR.
![image](https://user-images.githubusercontent.com/53433312/95441866-49929200-0978-11eb-9fcb-adf3c935adba.png)
#### Don't add something if its already there in the same programming language. Try to add quality content. Your PRs won't be merged, if you are spamming with invalid PRs.




  [![Open Source Love svg1](https://badges.frapsoft.com/os/v1/open-source.svg?v=103)](https://github.com/ellerbrock/open-source-badges/) [![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](http://makeapullrequest.com) ![GitHub Hacktoberfest combined status](https://img.shields.io/github/hacktoberfest/2020/rudrajit1729/CodeBucket) ![contributions welcome](https://img.shields.io/static/v1.svg?label=Contributions&message=Welcome&color=0059b3&style=flat-square) ![](https://img.shields.io/github/repo-size/rudrajit1729/CodeBucket.svg?label=Repo%20size&style=flat-square)&nbsp;
  [![GitHub forks](https://img.shields.io/github/forks/rudrajit1729/CodeBucket.svg?style=social&label=Fork&maxAge=2592000)](https://gitHub.com/rudrajit1729/CodeBucket) [![GitHub followers](https://img.shields.io/github/followers/rudrajit1729.svg?style=social&label=Follow&maxAge=2592000)](https://github.com/rudrajit1729?tab=followers)

# Overview
The goal of this project is to celebrate open-source and to help the beginners with their contributions in Open Source. We aim to achieve this collaboratively, so feel free to contribute in any way you want, just make sure to follow the contribution guidelines. You can contribute to it in either of the following ways:

- Beginners:
	- Add Codes to LabBucket containing subjects you have covered in your CS labs.
  - Add mini Games/small web apps to respective buckets.
  - Improve documentation in the buckets so that further contributors can get a good idea about past works.
- Intermediate:
	- Add games/simulations/automation scripts/simple to complex web or mobile applications/simple ML scripts.
  - Improve documentation in the buckets so that further contributors can get a good idea about past works.
  - Add Algorithm Bucket and implement algorithms popular in CS and competitive programming(also maybe add a Competitive Programming Assistant bot).
- Expert:
	- Add new buckets and submit ideas.
  - Add AI projects(ranging from simple game automation to complex text/music/video generation)
  - Add deployable scripts which are fun to interact to(bots/interactive web/anything you feel is cool).
  - Add simulations or advanced algorithms.
  
## How to Contribute in this repo.

Contributing to open-source is easy.


- Star and Fork the repository
- Request maintainers to assign you to an existing issue(if you are willing to address an existing issue)
- Improve current program by
  - improving functionality
  - adding new feature
  - improving the documentation
- Add new scripts/ideas(if you have any)
- Push your work and Create a Pull Request

[Click Here To Join](https://discord.gg/HedjRMV) the discord server for interacting with reviewers and maintainers to know more about Contributing Guidelines and for help regarding this repo and open source in general. The Discord Server helps you interact with fellow developers and makes you a part of the community. Be sure to Join. 

[Click here for detailed explanation](/CONTRIBUTING.md)
  

# HacktoberFest-2020

Open source is changing the world - one pull request at a time. 


- [HacktoberFest-2020](#hacktoberfest-2020)
  - [What is Hacktoberfest?](#what-is-hacktoberfest)
  - [Why Should I Contribute?](#-why-should-i-contribute)
  - [What Can I Contribute?](#what-can-i-contribute)
  - [How to Contribute in this repo.](#how-to-contribute-in-this-repo)

## What is Hacktoberfest?

Hacktoberfest is a month long virtual festival event to celebrate open source contributions presented by Digital Ocean and DEV. It is the easiest way to get into open source!

During the entire month of October 2020, all you have to do is contribute to any open source projects and open at least 4 pull requests. Yes, any project and any kind of contributions.

## Why Should I Contribute?

The Hacktoberfest’s simple plain objective is:
Support open source and earn a limited edition T-shirt!
But, it’s not just about the t-shirts or stickers. Its about supporting open source. Its about celebrating open source, and giving it back. If you’ve never contributed to open source before, this is the perfect time to get started because Hacktoberfest provides a large list of available contribution opportunities.

## What Can I Contribute?

Hacktoberfest® is open to everyone in our global community. Whether you’re a developer, student learning to code. You can contribute to anything from code to simple fix, new feature to grammar mistake.


## What if my pull requests aren’t accepted?

Even if your pull requests aren’t accepted, they should still count toward your 4 pull requests necessary to earn the shirt. The only exception would be if the project maintainer chooses to mark your pull request as “invalid”. They may do this if they perceive your pull request to be low effort, or if it contains plagiarism.

## What kind of pull requests are accepted in Hacktoberfest?
Any pull request made to a public repo on GitHub will count. The pull request must contain commits you personally made yourself — not automated commits from bots.

You can contribute to any open source project hosted on Github.com and contribute anything between October 1 to October 31 midnight in 2020. You will find plenty of issues labeled with hacktoberfest or good-first-issue etc on Github. These will be the simple ones most probably and easy to fix.


---
## References

- [Hacktoberfest presented by DigitalOcean](https://hacktoberfest.digitalocean.com/)
- [A participation guide for Hacktoberfest](https://dev.to/zenika/a-participation-guide-for-hacktoberfest-19c1)
- [What is Hacktoberfest and How can a beginner contribute?](https://medium.com/@bawantharathnayaka/what-is-hacktoberfest-and-how-can-a-beginner-contribute-39cf2081804e)
