READY FOR REVIEW
# Exports

There are several exports available to allow you to use the information from the application in other apps.
These all export files in .csv format, which is importable by all common spreadsheet programs.
Many of these can be filtered down to the information you might need for a specific communication need.

The exports available include (in alphabetical order): 
- Adjustments
- Annual Survey
- Barcode Items
- Distributions
- Donations
- Donation Sites
- Items
- Partners
- Product Drives
- Product Drive Participants
- Purchases
- Requests
- Storage Locations
- Transfers
- Vendors

## Adjustments

### Navigating to export adjustments
Click "Inventory", then "Inventory Adjustments" in the left-hand menu.  Then click "Export Adjustments", 

### Contents of adjustment export
Creation date, Organization, Storage Area, Comment, # of changes.

[! NOTE]  We have improving the adjustments export to include the changes made in each adjustment on our todo list. We'll also remove the organization as redundant information. Please reach out if this is a priority for you.

## Annual Survey 
### Navigating to export annual survey
Click "Reports", then "Annual Survey" in the left-hand menu.  Then click the year of the report you want to export.  Then click "Export Report."
### Contents of annual report export

For more information on these, please see the [Annual Survey Report](reports_annual_survey.md)

- Disposable diapers distributed,
- Cloth diapers distributed,  
- Average monthly disposable diapers distributed,  
- Total Product Drives,  
- Disposable diapers collected from drives,  
- Cloth diapers collected from drives,  
- Money raised from Product Drives,  
- Total Product Drives (virtual),  
- Money raised from Product Drives (virtual),  
- Disposable diapers collected from drives (virtual),  
- Cloth diapers collected from drives (virtual), 
- Disposable diapers donated, 
- % disposable diapers donated, 
- % cloth diapers donated, 
- Disposable diapers Purchased,  
- % disposable diapers Purchased, 
- % cloth diapers Purchased, 
- Money spent purchasing diapers, 
- Purchased from, 
- Vendors diapers Purchased through, 
- Total Storage Locations, 
- Total square footage, 
- Largest storage site type, 
- Adult incontinence supplies distributed, 
- Adult incontinence supplies per adult per month, 
- Adult incontinence supplies, 
- % adult incontinence supplies donated, 
- % adult incontinence bought, 
- Money spent purchasing adult incontinence supplies, 
- Period supplies distributed,  
- Period supplies per adult per month,  
- Period supplies, 
- % period supplies donated, 
- % period supplies bought, 
- Money spent purchasing period supplies,  
- Other products distributed, 
- % other products donated, 
- % other products bought, 
- Money spent on other products, 
- List of other products, 
- Number of Partner Agencies, 
- Agency Type 
- Zip Codes Served,  
- Average children served monthly,  
- Total children served,  
- Repackages diapers?,  
- Monthly diaper distributions?,  
- % difference in yearly Donations,  
- % difference in total money donated,  
- % difference in disposable diaper Donations
## Barcode Items
### Navigating to export barcode Items
Click "Inventory" then "Barcode Items" in the left-hand menu.   Then click "Export Barcode Items."
### Contents of barcode Items export
For each Barcode Item:
- Item Type,
- Quantity in the Box, 
- Barcode
## Distributions
### Navigating to export distributions
Click "Distributions" in the left hand menu.  Click the "Export Distributions" button.
### Filtering the distributions export
The Distributions export shows the same Distributions as are in the main Distributions page, and the filtering works the same way.
Before clicking the export button, you can filter by any of:
- date range (we recommend you use the calendar-style selection rather than typing it in, as the format is a bit fussy.)
- Item
- Item Category
- Partner
- source inventory (i.e. Storage Location)
- status (i.e. scheduled or complete)

Specify the filtration you want, then click "filter".   

### Contents of distributions export
For each of the distributions in the filtered list:
- Partner,
- Initial Allocation (when the distribution was entered),
- Scheduled for,
- Source Inventory,
- Total Items,
- Total Value,
- Delivery Method,
- Shipping Cost,
- State,
- Agency Representative,
- Comments, 
- and the quantity in the distribution for each of your bank's Items.

[!NOTE] This includes inactive Items as well as active ones. 

## Donations

### Navigating to export Donations
Click "Donations", then "All Donations" in the left hand menu, then click 'Export Donations'.
### Filtering the Donations export
The Donations export shows the same Donations as are in the main Donations page, and the filtering works the same way.
You can filter by any of:
- Storage Location
- Source (i.e. Manufacturer, Product Drive, or Misc. Donation)
- Product Drive
- Product Drive Participant
- Manufacturer
- date range (we recommend you use the calendar-style selection rather than typing it in, as the format is a bit fussy.)

When you have selected your filters,  click "Filter", then "Export Donations"

### Contents of the Donations export
For each of the Donations in the filtered list:
- Source
- Date (this is the date you enter in the donation, rather than the date it was put into the system)
- Details (this is the manufacturer name or the Product Drive)
- Storage Location,
- Quantity of Items (the total quantity of Items)
- Variety of Items (the number of different Items)
- In-Kind Value,
- Comments, 
- and the quantity of each of your organization's Items in the Donations.

## Donation Sites
### Navigating to export Donation Sites
Click "Community", then "Donation Sites" in the left hand menu.   Then click "Export Donation Sites"
### Contents of the Donation Sites export
For each active Donation Site:
- site name
- address
- contact name
- e-mail
- phone







## Items
### Navigating to export Items
Click "Inventory", then "Items & Inventory" in the left hand menu.  Then click "Export Items"
### Filtering the Item export
By default, the export will contain all active Items.
You can filter it differently by only including the Items for a specific base Item,
or by also including inactive Items.
Select what you wish to filter by,than click "Filter".

### Contents of the Item export
For each filtered Item, the export includes:
- Name,
- Barcodes (each barcode associated with that Item),
- Base Item,
- Quantity (across your entire bank)

## Partners
The partners export contains high level information about the partner.  It does not contain the information in the partner profile.

### Navigating to export partners
Click "Partner Agencies", then "All Partners" in the left-hand menu.  Then click "Export Partner Agencies"
### Filtering the partner export
By default, the partner export shows all the active partners.
You can export different groups of partners by clicking the partner filters which exist for the various statuses:
- Uninvited
- Invited
- Awaiting review
- Approved
- Error 
- Recertification required
- Decactivated
- Active

### Partner Export contents
For each partner in the filtered list:
- Agency Name,
- Agency Email,
- Agency Address,
- Agency City,
- Agency State,
- Agency Zip Code,
- Agency Website,
- Agency Type,
- Contact Name,
- Contact Phone,
- Contact Email,
- Notes

## Product Drives
### Navigating to export Product Drives
Click 'Community', then 'All Product Drives' in the left hand menu,  then click "Export Product Drives"
### Filtering the Product Drives
The Product Drives can be filtered by 
- name, 
- Item category, and 
- date range.  

It is defaulted to all drives that overlap the default time period of 60 days back, 30 days forward.
To filter the export, make your selections, then click "Filter" before clicking "Export Product Drives".

### Product Drive Export content
For each filtered Product Drive, the export will contain:
- Product Drive Name,
- Start Date,
- End Date,
- Held Virtually?,
- Quantity of Items,
- Variety of Items,
- In Kind Value, and 
- the quantity donated for each Item in alphabetical order.
- 
## Product Drive Participants
### Navigating to export Product Drive participants
Click 'Community', then 'Product Drive Participants' in the left hand menu,  then click "Export Product Drive Participants"
### Product Drive Participant Export content
- Business Name,
- Contact Name,
- Phone,
- Email,
- Total Diapers
  - The title for this should be Total Items, as that is what is shown.  We have an issue in the queue to fix that
## Purchases
### Navigating to export Purchases
Click 'Purchases', then 'All Purchases' in the left hand menu.  Then click "Export Purchases"
### Filtering exported Purchases
You can filter the Purchases by:
- Storage location
- Vendor
- Purchase date

The default is all Storage Locations and vendors, and the default period of 60 days prior, 30 days forward from today's date.

Make your selection and click "Filter"  before clicking "Export Purchases"
### Content of Purchases Export
For each Purchase in the filtered list:
- Purchases from (the Vendor name) 
- Storage Location,
- Purchased Date,
- Quantity of Items,
- Variety of Items,
- Amount Spent (all currency amounts are in dollars),
- Spent on Diapers,
- Spent on Adult Incontinence,
- Spent on Period Supplies,
- Spent on Other,
- Comment, and
- the quantity of each Item included in the Purchase.

## Requests
### Navigating to export Requests
Click 'Requests' in the left-hand menu, then "Export Requests"
### Filtering exported Requests
You can filter the exported Requests by the following:
- Item
- Partner
- Status (Pending, Started, Fulfilled, Discarded)
- Date Range
Make your selection, then click 'Filter' before clicking 'Export Requests'

The default is all Requests in the last 60 days

### Contents of Requests export
For each filtered Request,
- Date,
- Requestor (i.e. partner)
- Status, and
- the quantity of each Item requested.  
  - Note: If you have packs enabled (upcoming feature), there will be a column for each unit that you have enabled for each Item.  Otherwise, one column per Item.

## Storage Locations
### Navigating to export Storage Locations
Click "Inventory", then "Storage Locations" in the left-hand menu. Then click "Export Storage Locations"
### Filtering exported Storage Locations
You can filter the exported list by Item.  This will give all Storage Locations that have ever had that Item, *not* just those with current inventory.
(Note:  including inactive Storage Locations is not working at time of writing)

The default is all active Storage Locations.

Make your selections, then click "Filter" before clicking "Export Storage Locations"
### Contents of Storage Location exports
For each Storage Location in the filtered list:
- Name,
- Address,
- Square Footage,
- Warehouse Type,
- Total Inventory, and 
- Quantity for each of the organization's Items.

## Transfers
### Navigating to export Transfers
Click "Inventory", then "Transfers" in the left-hand menu. Then click "Export Storage Locations"
### Filtering exported Transfers
You can filter the Transfers by:
- From location
- To location
- date range.  
  - Note that this is the date the Transfer was entered in the system, which may or may not be when it happened.

The default is all the Transfers for the period of 60 days prior, 30 days forward from today.

Make you selection and click 'Filter' before clicking "Export Transfers".

### Contents of Transfers export
For each selected Transfer:
- From,
- To,
- Comment,
- Total Moved
[! NOTE] We have an issue in the queue to provide the total moved for each Item.

## Vendors
### Navigating to Export Vendors
Click "Community", then "Vendors" in the left-hand menu.  Then click "Export Vendors"
### Contents of vendors export
- Business name
- Contact name
- phone
- email
- address

[Prior: Manufacturers](community_manufacturers.md) [Next: Summary reports](reports_summary_reports.md)

