![GitHub release](https://img.shields.io/github/release/rubjo/victor-mono.svg)
![GitHub Release Date](https://img.shields.io/github/release-date/rubjo/victor-mono.svg)
![Travis (.org)](https://img.shields.io/travis/rubjo/victor-mono.svg?logo=travis)
![GitHub](https://img.shields.io/github/license/rubjo/victor-mono.svg)
![GitHub stars](https://img.shields.io/github/stars/rubjo/victor-mono.svg?style=social)

[![Stand With Ukraine](https://raw.githubusercontent.com/vshymanskyy/StandWithUkraine/main/banner2-direct.svg)](https://vshymanskyy.github.io/StandWithUkraine)
***

![Intro image](https://github.com/rubjo/victor-mono/raw/master/public/twitter.png)
![carbon (3)](https://user-images.githubusercontent.com/42270947/117447088-53e03300-af3d-11eb-84e2-df1713e77019.png)

### More information and download: [rubjo.github.io/victor-mono](https://rubjo.github.io/victor-mono). If you like it and want to say thanks, [donations](https://www.paypal.com/donate?hosted_button_id=T8Q8AHYNNXELW) are welcome. ❤️

***

## How to use

### In code editors:
1. [Download](https://rubjo.github.io/victor-mono/VictorMonoAll.zip) the font
2. Unpack the ZIP
3. [Install](https://www.google.com/search?q=how+to+install+fonts) the font (all styles or the ones you want)
4. [Change the font settings in your code editor / IDE of choice](https://www.google.com/search?q=how+to+change+font+settings+in+VS+Code) to "Victor Mono"
5. _Optional_ [Set the code theme](https://www.google.com/search?q=how+to+change+theme+in+VS+Code) to one you like.
Check out [https://themer.dev/victor-mono](https://themer.dev/victor-mono), where you can download the official theme for your favourite terminals, editors and apps.
6. _Optional_ [Modify the theme](https://www.google.com/search?q=how+to+modify+themes+in+VS+Code) colours and its application of normal/italic/bold styles

### In apps, web pages or other projects:
1. `npm i victormono` (installs Regular, Italic, Bold and Bold Italic styles)
2. `import 'victormono'` (in a typical modern JS setup, eg. Webpack/Vite)
3. Style classes with `font-family: 'Victor Mono'`, `font-weight` and `font-style`

#### Alternative CDN hosting, best for online editors like [CodePen](https://codepen.io/tomByrer/pen/MWWagVp):
1. `<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/victormono@latest/dist/index.min.css">` in `<head>` or top of `<body>`
2. Style classes with `font-family: 'Victor Mono', monospace`


***


### Font stylistics

#### Available stylistics
- ss01: Single-storey a
- ss02: Slashed zero, variant 1
- ss03: Slashed zero, variant 2
- ss04: Slashed zero, variant 3
- ss05: Slashed zero, variant 4
- ss06: Slashed seven
- ss07: Straighter 6 and 9
- ss08: More fishlike turbofish (previous default ::< ligature)

#### Configuration

- Sublime:
	```json
	"font_options": ["ss01"]
	```

- VScode:
	```json
	"editor.fontLigatures": "'ss01'"
	```

- Kitty:
	```
	font_features VictorMono-Medium +ss01
	```

***


### Example code previews

![carbon](https://user-images.githubusercontent.com/42270947/117446571-8ccbd800-af3c-11eb-8f34-bd8250e1920b.png)
![carbon (1)](https://user-images.githubusercontent.com/42270947/117447058-46c34400-af3d-11eb-8c2d-007ae5d686cb.png)
![carbon (2)](https://user-images.githubusercontent.com/42270947/117447070-4cb92500-af3d-11eb-9254-4ee5628170c6.png)
![carbon (4)](https://user-images.githubusercontent.com/42270947/117447095-56db2380-af3d-11eb-89fe-2bcb873cd112.png)
![carbon (5)](https://user-images.githubusercontent.com/42270947/117447107-5b074100-af3d-11eb-8101-69fb61e6c402.png)
![carbon (6)](https://user-images.githubusercontent.com/42270947/117447119-5f335e80-af3d-11eb-9952-e745a7ddafac.png)
![carbon (7)](https://user-images.githubusercontent.com/42270947/117447143-6490a900-af3d-11eb-87a5-6d1fe2e7a9ca.png)




