<?php

declare(strict_types = 1);

namespace RTCKit\Pcap\Stream\FFI;

class StreamOpen extends \PHPUnit\Framework\TestCase {
    /** @test */
    public function shouldOpenDevicesFromNet_get_interfaces() {
        foreach (array_keys(net_get_interfaces()) as $dev) {
            $fp = fopen('pcap://' . $dev, 'r');

            $this->assertIsResource($fp);

            fclose($fp);
        }
    }

    /** @test */
    public function shouldNotOpenBogusDevices() {
        $this->expectWarning();

        $fp = fopen('pcap://' . uniqid('bogus'), 'r');
    }

    /** @test */
    public function shouldNotOpenInvalidSchemeURLs() {
        $dev = $this->getNetDevice();

        $this->expectWarning();

        $fp = fopen('pcap.bogus://' . $dev, 'r');
    }

    /** @test */
    public function shouldNotOpenInvalidPathURLs() {
        $dev = $this->getNetDevice();

        $this->expectWarning();

        $fp = fopen('pcap://' . $dev . '/path', 'r');
    }

    /** @test */
    public function shouldNotOpenInvalidQueryStringURLs() {
        $dev = $this->getNetDevice();

        $this->expectWarning();

        $fp = fopen('pcap://' . $dev . '?query=string', 'r');
    }

    /**
        @test
        @requires extension sockets
    */
    public function shouldNotOpenWithoutPrivileges() {
        if (posix_getuid()) {
            $this->markTestSkipped('Not running as root');
        }
        $dev = $this->getNetDevice();

        $user = posix_getpwnam('daemon');

        $this->assertNotNull($user['uid']);
        $this->assertGreaterThan(0, $user['uid']);

        posix_setuid($user['uid']);
        posix_seteuid($user['uid']);
        posix_setgid($user['gid']);
        posix_setegid($user['gid']);

        $this->expectWarning();

        $fp = fopen('pcap://' . $dev, 'r');
    }

    private function getNetDevice(): string {
        $dev = current(array_keys(net_get_interfaces()));

        $this->assertNotNull($dev);

        return $dev;
    }
}
