/**
 * 人人站CMS
 * ============================================================================
 * 版权所有 2015-2030 山东康程信息科技有限公司，并保留所有权利。
 * 网站地址: http://www.rrzcms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 */
var BrowserCheck = {};
BrowserCheck.toString = function (c) {
    var b = [];
    for (var a in c) {
        b.push(a + "-" + c[a])
    }
    return b.join(";")
}
;
BrowserCheck.parse = function (e) {
    var c = {};
    var b = e.split(";");
    var d;
    for (var a in b) {
        d = b[a].split("-");
        c[d[0]] = d[1]
    }
    return c
}
;
BrowserCheck.uaMatch = function (b) {
    b = b.toLowerCase();
    var a = /(chrome)[ \/]([\w.]+)/.exec(b) || /(webkit)[ \/]([\w.]+)/.exec(b) || /(opera)(?:.*version|)[ \/]([\w.]+)/.exec(b) || /(msie) ([\w.]+)/.exec(b) || /(trident).*rv:([\w.]+)/.exec(b) || /(firefox)\/([\w.]+)/.exec(b) || b.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(b) || b.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(b) || [];
    return {
        browser: (a[1] === "trident" ? "msie" : a[1]) || "",
        version: a[2] || "0"
    }
}
;
BrowserCheck.isLower = function (b, d, a) {
    if (!a) {
        a = BrowserCheck.uaMatch(navigator.userAgent)
    }
    if (a.browser === b) {
        d = parseInt(d);
        if (isNaN(d)) {
            return true
        } else {
            var c = parseInt(a.version);
            if (!isNaN(c) && c < d) {
                return true
            }
        }
    }
    return false
}
;
BrowserCheck.checkBrowsers = function (a) {
    var b = BrowserCheck.uaMatch(navigator.userAgent);
    for (var d in a) {
        if (BrowserCheck.isLower(d, a[d], b)) {
            var c = encodeURIComponent(location.pathname + location.search);
            var e = "/Public/kill-IE.html?url=" + c + "&browserArgs=" + BrowserCheck.toString(a);
            window.location.href = e;
            return
        }
    }
}
;
BrowserCheck.checkJumpBack = function (e, c) {
    var a = BrowserCheck.parse(e);
    var b = BrowserCheck.uaMatch(navigator.userAgent);
    for (var d in a) {
        if (BrowserCheck.isLower(d, a[d], b)) {
            BrowserCheck.show();
            return
        }
    }
    window.location.href = c
}
;
BrowserCheck.getNavigatorInfo = function () {
    var e = {}
      , g = navigator.userAgent.toLowerCase()
      , a = BrowserCheck.uaMatch(navigator.userAgent)
      , d = {};
    if (a.browser) {
        d[a.browser] = true;
        d.version = a.version
    }
    if (d.chrome) {
        d.webkit = true
    } else {
        if (d.webkit) {
            d.safari = true
        }
    }
    e.name = undefined;
    if (d.msie) {
        if (d.version == "6.0") {
            e.isIE6 = true;
            e.shell = "IE6"
        } else {
            if (d.version == "7.0") {
                e.isIE7 = true;
                e.shell = "IE7"
            } else {
                if (d.version == "8.0") {
                    e.isIE8 = true;
                    e.shell = "IE8"
                } else {
                    if (d.version == "9.0") {
                        e.isIE9 = true;
                        e.shell = "IE9"
                    } else {
                        if (d.version == "10.0") {
                            e.isIE10 = true;
                            e.shell = "IE10"
                        } else {
                            if (d.version == "11.0") {
                                e.isIE11 = true;
                                e.shell = "IE11"
                            }
                        }
                    }
                }
            }
        }
    }
    var b = ["firefox", "360se", "aoyou", "maxthon", "theworld", "qqbrowser", "bidubrowser", "lbbrowser", "ubrowser", "2345Explorer", "se"];
    for (var f = 0, c = b.length; f < c; f++) {
        if (g.indexOf(b[f]) > -1) {
            e.shell = b[f];
            break
        }
    }
    if (!e.shell) {
        e.shell = "xxxxxx"
    }
    return e
}
;
BrowserCheck.show = function () {
    var a = {
        firefox: {
            name: "火狐浏览器",
            tips: "建议您下载Chrome浏览器或360极速浏览器",
            image: "no-image"
        },
        IE6: {
            name: "IE6",
            tips: "建议您下载Chrome浏览器或360极速浏览器",
            image: "img-ie78_360"
        },
        IE7: {
            name: "IE7",
            tips: "建议您下载Chrome浏览器或360极速浏览器<br>（若您使用的是双核浏览器，请切换至极速模式）",
            image: "img-ie78_360"
        },
        IE8: {
            name: "IE8",
            tips: "建议您下载Chrome浏览器或360极速浏览器<br>（若您使用的是双核浏览器，请切换至极速模式）",
            image: "img-ie78_360"
        },
        IE9: {
            name: "IE9",
            tips: "建议您下载Chrome浏览器或360极速浏览器<br>（若您使用的是双核浏览器，请切换至极速模式）",
            image: "img-ie78_360"
        },
        IE10: {
            name: "IE10",
            tips: "建议您下载Chrome浏览器或360极速浏览器<br>（若您使用的是双核浏览器，请切换至极速模式）",
            image: "img-ie78_360"
        },
        IE11: {
            name: "IE11",
            tips: "建议您下载Chrome浏览器或360极速浏览器<br>（若您使用的是双核浏览器，请切换至极速模式）",
            image: "img-ie78_360"
        },
        aoyou: {
            name: "遨游浏览器",
            tips: "请切换到极速模式，操作如下图：",
            image: "img-aoyou"
        },
        bidubrowser: {
            name: "百度浏览器",
            tips: "请切换到极速模式，操作如下图：",
            image: "img-baidu"
        },
        "360se": {
            name: "360浏览器",
            tips: "请切换到极速模式，操作如下图：",
            image: "img-ie78_360"
        },
        lbbrowser: {
            name: "猎豹浏览器",
            tips: "请切换到极速模式，操作如下图：",
            image: "img-liebao"
        },
        qqbrowser: {
            name: "QQ浏览器",
            tips: "请切换到极速模式，操作如下图：",
            image: "img-qq"
        },
        theworld: {
            name: "世界之窗浏览器",
            tips: "请切换到极速模式，操作如下图：",
            image: "img-sjzc"
        },
        ubrowser: {
            name: "UC浏览器",
            tips: "请切换到极速模式，操作如下图：",
            image: "img-uc"
        },
        "2345Explorer": {
            name: "2345浏览器",
            tips: "请切换到超速模式，操作如下图：",
            image: "img-2345"
        },
        se: {
            name: "搜狗浏览器",
            tips: "请切换到高速模式，操作如下图：",
            image: "img-sougou"
        },
        xxxxxx: {
            name: "xxxxxx",
            tips: "无法兼容您的浏览器版本，建议您下载最新版Chrome浏览器或360极速浏览<br>（若您使用的是双核浏览器，请切换至极速模式）",
            image: "no-image"
        }
    };
    var b = BrowserCheck.getNavigatorInfo();
    var f, e, i, h;
    var g = true;
    if (b.shell == "firefox" || b.shell == "IE6" || b.shell == "IE7" || b.shell == "IE8" || b.shell == "IE9" || b.shell == "IE10" || b.shell == "IE11") {
        f = a[b.shell].name;
        e = a[b.shell].tips
    } else {
        if (b.shell == "xxxxxx") {
            i = a[b.shell].tips
        } else {
            g = false;
            f = a[b.shell].name;
            e = a[b.shell].tips;
            h = a[b.shell].image
        }
    }
    var c = [];
    c.push('	<div class="guideContent"' + (g ? ">" : ' style="margin-top:50px;top:50px;">'));
    c.push('		<div class="tipsImg" title="推荐下载最新版浏览器"></div>');
    c.push('		<h4 class="tipsText">');
    c.push(i ? i : "检测到您的浏览器为<span>" + f + '</span>，<span class="tips">' + e + "</span>");
    c.push("		</h4>");
    if (g) {
        c.push('		<!--<div class="downloadBtn">');
        c.push("			<p>或下载Chrome浏览器</p>");
        c.push('			<a href="https://www.baidu.com/s?wd=chrome" title="下载" target="_blank">下载</a>');
        c.push("		</div>-->");
        c.push('		<div class="f-splitLine"></div>');
        c.push('		<div class="f-browserDown">');
        c.push('			<!--<span class="f-browserTip">更多推荐：</span>-->');
        c.push('			<a href="https://www.baidu.com/s?wd=chrome" title="谷歌" target="_blank" class="f-browserLink">Chrome浏览器下载</a>');
        c.push('			<a href="https://www.baidu.com/s?wd=360极速浏览器" title="360极速浏览器" target="_blank" class="f-browserLink">360极速浏览器下载</a>');
        c.push("		</div>")
    } else {
        c.push('		<div class="otherImg ' + h + '"></div>')
    }
    c.push("	</div>");
    var d = document.body;
    d.className = "lowBrowser";
    d.innerHTML = c.join("")
};