-- ----------------------------------------
-- RRZCMS MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.5.53
-- Database       : rrzcms
-- 
-- Part : #1
-- Version : #v1.1.5
-- Date : 2020-07-24 10:37:14
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for `rrz_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin`;
CREATE TABLE `rrz_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) unsigned DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) unsigned DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) unsigned DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- -----------------------------
-- Records of `rrz_admin`
-- -----------------------------
INSERT INTO `rrz_admin` VALUES ('1', 'admin', '', 'admin', '', '', 'e10adc3949ba59abbe56e057f20f883e', '/static/images/dfboy.png', '1595556934', '114.239.14.158', '53', '', '0', '1', 'cn', '1', '1', '1586479354', '1588751715');

-- ----------------------------
-- Table structure for `rrz_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_log`;
CREATE TABLE `rrz_admin_log` (
  `id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员日志表';

-- ----------------------------
-- Table structure for `rrz_admin_role`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_role`;
CREATE TABLE `rrz_admin_role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户角色表';

-- -----------------------------
-- Records of `rrz_admin_role`
-- -----------------------------
INSERT INTO `rrz_admin_role` VALUES ('1', '超级管理员', 'all', '管理全站');

-- ----------------------------
-- Table structure for `rrz_article_nodes`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_article_nodes`;
CREATE TABLE `rrz_article_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '栏目深度',
  `sort` smallint(6) unsigned DEFAULT '50' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章类目';

-- -----------------------------
-- Records of `rrz_article_nodes`
-- -----------------------------
INSERT INTO `rrz_article_nodes` (`id`, `name`, `dir_name`, `parent_id`, `img`, `id_path`, `depth`, `sort`, `path`, `tmpl_path`, `tmpl_view`, `seo_title`, `seo_description`, `seo_keywords`, `content`, `wap_content`, `ifpub`, `uptime`) 
VALUES ('1', '师资团队', '', '0', '', '1', '1', '1', '1001', 'team', '', '', '', '', '', '', 'true', '1592477759'),
('2', '成功案例', '', '0', '', '2', '1', '2', '1002', 'case', '', '', '', '', '', '', 'true', '1592478228'),
('3', '相关服务', '', '0', '', '3', '1', '3', '1003', 'service', '', '', '', '', '', '', 'true', '1592478756'),
('4', '通知资讯', '', '0', '', '4', '1', '4', '1004', '', '', '', '', '', '', '', 'true', '1592464530'),
('5', '教学环境', '', '0', '', '5', '1', '5', '1005', '', '', '', '', '', '', '', 'true', '1592466446'),
('6', '合作伙伴', '', '0', '', '6', '1', '6', '1006', '', '', '', '', '', '', '', 'true', '1592466458'),
('7', '我们的优势', '', '0', '', '7', '1', '7', '1007', '', '', '', '', '', '', '', 'true', '1592467570'),
('8', '发展历程', '', '0', '', '8', '1', '8', '1008', '', '', '', '', '', '', '', 'true', '1592467577'),
('9', '校区', '', '0', '', '9', '1', '9', '1009', '', '', '', '', '', '', '', 'true', '1592467608');

-- ----------------------------
-- Table structure for `rrz_articles`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_articles`;
CREATE TABLE `rrz_articles` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `node_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '文章配图',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `uptime` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  `pubtime` int(10) unsigned DEFAULT '0' COMMENT '文章发布时间',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '发布',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '文章创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_node_id` (`node_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章';

-- -----------------------------
-- Records of `rrz_articles`
-- -----------------------------
INSERT INTO `rrz_articles` VALUES ('1', '1', '陈老师', '/storage/images/20200618/1-200211095G40-L.jpg', '', '<p>对教师招聘考试和资格证考试均有深入研究，理论功底扎实，授课思路清晰，深受学生欢迎。</p>', '  ', '', '', '1592464799', '1592464799', 'true', '', '北京理工大学会计学本科', '高级讲师', '3', '1592464799', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('2', '1', '李老师', '/storage/images/20200618/1-200211095P20-L.jpg', '', '<p>对教师招聘考试和资格证考试均有深入研究，理论功底扎实，授课思路清晰，深受学生欢迎。</p>', '  ', '', '', '1592464854', '1592464854', 'true', '', '北京理工大学会计学本科', '高级讲师', '3', '1592464854', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('3', '1', '周老师', '/storage/images/20200618/1-200211095R00-L.jpg', '', '<p>对教师招聘考试和资格证考试均有深入研究，理论功底扎实，授课思路清晰，深受学生欢迎。</p>', '  ', '', '', '1592464902', '1592464902', 'true', '', '北京理工大学会计学本科', '高级讲师', '3', '1592464902', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('4', '1', '张老师', '/storage/images/20200618/1-200211095S60-L.jpg', '', '<p>对教师招聘考试和资格证考试均有深入研究，理论功底扎实，授课思路清晰，深受学生欢迎。</p>', '  ', '', '', '1592464937', '1592464937', 'true', '', '北京理工大学会计学本科', '高级讲师', '6', '1592464937', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('5', '1', '胡老师', '/storage/images/20200618/1-200211095U90-L.jpg', '', '<p>对教师招聘考试和资格证考试均有深入研究，理论功底扎实，授课思路清晰，深受学生欢迎。</p>', '  ', '', '', '1592464974', '1592464974', 'true', '', '北京理工大学会计学本科', '高级讲师', '5', '1592464974', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('6', '1', '羊老师', '/storage/images/20200618/1-2002110959140-L.jpg', '', '<p>对教师招聘考试和资格证考试均有深入研究，理论功底扎实，授课思路清晰，深受学生欢迎。</p>', '  ', '', '', '1592465009', '1592465009', 'true', '', '北京理工大学会计学本科', '高级讲师', '8', '1592465009', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('7', '1', '杨老师', '/storage/images/20200618/1-2002111029440-L.jpg', '', '<p>对教师招聘考试和资格证考试均有深入研究，理论功底扎实，授课思路清晰，深受学生欢迎。</p>', '  ', '', '', '1592465047', '1592465047', 'true', '', '广州理工大学会计学本科', '高级讲师', '8', '1592465047', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('8', '1', '谢老师', '/storage/images/20200618/1-2002111030510-L.jpg', '', '<p>对教师招聘考试和资格证考试均有深入研究，理论功底扎实，授课思路清晰，深受学生欢迎。</p>', '  ', '', '', '1592465080', '1592465080', 'true', '', '北京大学会计学本科', '高级教授', '7', '1592465080', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('9', '2', '陈同学', '/storage/images/20200618/1-2002110930210-L.jpg', '', '<p style=\"text-align: center;\"><img src=\"/storage/images/20200618/1-2002110930210-L.jpg\"/></p>', '    ', '', '', '1592465327', '1592465241', 'true', '', '因为家庭条件不好，高中毕业就没有在读了，感谢育德会计给予我的帮助，有了技能就不愁了。', '6000', '3', '1592465241', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('10', '2', '李同学', '/storage/images/20200618/1-20021109310b02.jpg', '', '<p style=\"text-align:center\"><img src=\"/storage/images/20200618/1-20021109310b02.jpg\"/></p>', '  ', '', '', '1592465315', '1592465315', 'true', '', '因为家庭条件不好，高中毕业就没有在读了，感谢育德会计给予我的帮助，有了技能就不愁了。', '8000', '3', '1592465315', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('11', '2', '张同学', '/storage/images/20200618/1-20021109313K19.jpg', '', '<p style=\"text-align:center\"><img src=\"/storage/images/20200618/1-20021109313K19.jpg\"/></p>', '  ', '', '', '1592465372', '1592465372', 'true', '', '因为家庭条件不好，高中毕业就没有在读了，感谢育德会计给予我的帮助，有了技能就不愁了。', '12000', '4', '1592465372', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('12', '2', '周同学', '/storage/images/20200618/1-200211093233L0.jpg', '', '<p style=\"text-align:center\"><img src=\"/storage/images/20200618/1-200211093233L0.jpg\"/></p>', '  ', '', '', '1592465442', '1592465442', 'true', '', '因为家庭条件不好，高中毕业就没有在读了，感谢育德会计给予我的帮助，有了技能就不愁了。', '8800', '3', '1592465442', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('13', '2', '王同学', '/storage/images/20200618/1-20021109330VK.jpg', '', '<p style=\"text-align:center\"><img src=\"/storage/images/20200618/1-20021109330VK.jpg\"/></p>', '    ', '', '', '1592465485', '1592465478', 'true', '', '因为家庭条件不好，高中毕业就没有在读了，感谢育德会计给予我的帮助，有了技能就不愁了。', '9800', '3', '1592465478', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('14', '2', '林同学', '/storage/images/20200618/1-200211093211109.jpg', '', '<p style=\"text-align:center\"><img src=\"/storage/images/20200618/1-200211093211109.jpg\"/></p>', '  ', '', '', '1592465567', '1592465567', 'true', '', '因为家庭条件不好，高中毕业就没有在读了，感谢育德会计给予我的帮助，有了技能就不愁了。', '9000', '6', '1592465567', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('15', '3', '相关服务一', '/storage/images/20200618/1-2002101646040-L.jpg', '', '<p>服务项目内容文字介绍说明，服务项目内容文字介绍说明服务项目内容文字介绍说明。服务项目内容文字介绍说，明服务项目内容文字介绍说明服务项目。内容文字介绍说明服务项目内容，文字介绍说明服务项目内容文字介绍说明。</p>', '  ', '', '', '1592465675', '1592465675', 'true', '', '服务项目内容文字介绍说明，服务项目内容文字介绍说明服务项目内容文字介绍说明。服务项目内容文字介绍说，明服务项目内容文字介绍说明服务项目。内容文字介绍说明服务项目内容，文字介绍说明服务项目内容文字介绍说明。', '相关,服务,一,服务项目,内容,文字,介绍,说明,', '0', '1592465675', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('16', '3', '相关服务二', '/storage/images/20200618/1-2002101645470-L.jpg', '', '<p>服务项目内容文字介绍说明，服务项目内容文字介绍说明服务项目内容文字介绍说明。服务项目内容文字介绍说，明服务项目内容文字介绍说明服务项目。内容文字介绍说明服务项目内容，文字介绍说明服务项目内容文字介绍说明。</p>', '  ', '', '', '1592465734', '1592465734', 'true', '', '服务项目内容文字介绍说明，服务项目内容文字介绍说明服务项目内容文字介绍说明。服务项目内容文字介绍说，明服务项目内容文字介绍说明服务项目。内容文字介绍说明服务项目内容，文字介绍说明服务项目内容文字介绍说明。', '相关,服务,二,服务项目,内容,文字,介绍,说明,', '0', '1592465734', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('17', '3', '相关服务三', '/storage/images/20200618/1-2002101645260-L.jpg', '', '<p>服务项目内容文字介绍说明，服务项目内容文字介绍说明服务项目内容文字介绍说明。服务项目内容文字介绍说，明服务项目内容文字介绍说明服务项目。内容文字介绍说明服务项目内容，文字介绍说明服务项目内容文字介绍说明。</p>', '  ', '', '', '1592465773', '1592465773', 'true', '', '服务项目内容文字介绍说明，服务项目内容文字介绍说明服务项目内容文字介绍说明。服务项目内容文字介绍说，明服务项目内容文字介绍说明服务项目。内容文字介绍说明服务项目内容，文字介绍说明服务项目内容文字介绍说明。', '相关,服务,三,服务项目,内容,文字,介绍,说明,', '0', '1592465773', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('18', '3', '相关服务四', '/storage/images/20200618/1-2002101645120-L.jpg', '', '<p>服务项目内容文字介绍说明，服务项目内容文字介绍说明服务项目内容文字介绍说明。服务项目内容文字介绍说，明服务项目内容文字介绍说明服务项目。内容文字介绍说明服务项目内容，文字介绍说明服务项目内容文字介绍说明。</p>', '  ', '', '', '1592465814', '1592465814', 'true', '', '服务项目内容文字介绍说明，服务项目内容文字介绍说明服务项目内容文字介绍说明。服务项目内容文字介绍说，明服务项目内容文字介绍说明服务项目。内容文字介绍说明服务项目内容，文字介绍说明服务项目内容文字介绍说明。', '相关,服务,四,服务项目,内容,文字,介绍,说明,', '0', '1592465814', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('19', '4', '建立共享理解，打通家庭学校社会教育', '/storage/images/20200618/1-200210160044b8.jpg', '', '<p>家庭教育、学校教育、社会教育的结合是一部交响乐。但不得不说，现在的家庭教育、学校教育和社会教育，各着各的调的状况，并没有得到明显改观。家庭教育和社会教育怎么与学校教育相结合？三种教育是否需要再重新精准定位？怎么实现制度化而形成校内校外相协调的现代教育制度？需要在价值定位、制度定位、实施战略和评估标准多方面做好系统工作。而其中，建立一个突破学校教育局限，贯通“家校社结合”的大教育理论，打通儿童在家庭、学校和社区成长的发展逻辑脉络，是一项重要的基础性工作。</p><p>　　儿童在经历中成长</p><p>　　教育的本质是促进儿童发展。儿童及其发展，本质上是由其在家庭、学校和社区的经历构成的，是生活经历和学习间接经验经历的结果。这是所有人生经历具有潜在教育性所决定的。横贯家庭、学校和社区的大教育理论，是一个围绕儿童经历，从家庭、学校和社区的社会互动，到儿童心理内化的理论体系。在最基础、最本质的水平上，尽一切可能确保儿童经历他们所需要的经历的机会，释放他们的潜能这一根本目的。</p><p>　　古代教育的重心在于生活教育，主要在家庭完成。近代意义上的学校，重心在于间接经验的传授，主要在学校系统完成。现代社会中，科学技术高度融入社会生活，教育重心在于生活教育和间接经验传授相结合，学校的生活教育色彩趋浓，而家长对于科学教育和智力培养介入加大。因此，家庭和学校儿童经历的性质，既有区别又出现了较多的重叠，成为家校合作的客观土壤。</p><p>　　父母、教师是至关重要的文化传递者</p><p>　　社会性是儿童经历的基本特点，儿童是在一定的社会关系中得到成长的。老师、家长等成年人，作为儿童成长的代理人，不是要按照成年人的想法去改变孩子的基因习性，但却可以将这些基因习性向着所期望的德智体美劳方向作出修改，特别是当懂得如何教育孩子的有效知识并在孩子成长的早期，就可以对引导孩子的成长施加更好影响。由此形成了家庭和学校，在培养儿童语言与交流能力，对他人情感和需要的感受性，在家庭内外和学校内外与他人共处的能力，学校学业成就以及价值观、信仰和态度的引导等方面，可以发挥环境源头和系统平台的作用。</p><p>　　父母和老师一道，作为儿童成长压力的缓冲器，通过亲密的亲子关系和师生关系，为孩子提供在复杂世界免遭威胁的保护，以抵御生活压力与条件的影响，引导儿童掌握认知和社会能力来应对逆境，培养出应对困难的弹性。</p><p>　　家庭和学校一道，作为儿童接受外部影响的看门人，为儿童经历的可能性打开一些门，同时又关闭很多扇门。这些经历包括玩具、书籍、电视、电脑，参加培训班、周末外出、与祖辈和其他家庭成员相处，以及托儿所、上学和父母所选择居住小区的邻里关系，包括选择什么样的课程和课外活动等等。父母和老师在以上作用的发挥中，成为至关重要的文化传递者。这种文化传递，是通过直接的态度和价值观教导，通过弥漫性地渗透文化于他们向儿童提供的情景和活动之中来达成的。</p><p><br/></p>', '  ', '', '', '1592465949', '1592465949', 'true', '', '家庭教育、学校教育、社会教育的结合是一部交响乐。但不得不说，现在的家庭教育、学校教育和社会教育，各着各的调的状况，并没有得到明显改观。家庭教育和社会教育怎么与学校', '建立,共享,理解,打通,家庭,学校,社会教育,', '3', '1592465949', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('20', '4', '学校应如何落实家庭教育指导责任', '/storage/images/20200618/1-200210160053637.jpg', '', '<p>近年来，“家庭教育指导”日渐成为学校的一项重要职能。2015年10月，教育部发布《关于加强家庭教育工作的指导意见》，提出“充分发挥学校在家庭教育中的重要作用”，指出各地教育部门要切实加强对行政区域内中小学幼儿园家庭教育工作的指导，推动形成政府主导、部门协作、家长参与、学校组织、社会支持的家庭教育工作格局。2016年以来，重庆、贵州、山西、江西以及江苏等地先后出台家庭教育促进条例，其中无一例外地规定，学校在家庭教育中应承担“指导”责任，要求幼儿园、中小学、中等职业学校建立健全家庭教育工作制度，开展家庭教育指导活动，将家庭教育指导工作纳入学校工作计划。</p><p>　　从家校关系的历史来看，家庭教育指导于学校而言并非新事物，传统的家访、家长会都属于学校自发开展的家庭教育指导的范畴。然而，当前教育政策中强调“充分发挥学校在家庭教育中的重要作用”，则意在引导学校家庭指导工作从自发上升到自觉。在“家庭教育指导”成为我国学校应自觉承担的一项新职能的背景之下，我们有必要反思一下，学校家庭教育指导责任边界该如何界定？</p><p>　　学校家庭教育指导能力面临现实困境</p><p>　　学校属于公共领域，学校在教育教学过程中，通过不断建构自身的公共领域属性，发展和完善自由、平等、协商对话以及理性批判的特性，从而更有效地促进学生的公共理性、公共品德以及公共行动能力的发展。家庭属于私人领域，家庭教育具有私人属性，家风、家教、家训构建起多样化的家庭教育情景，通过家庭潜移默化的教养，孩子成就鲜明的个性。</p><p>　　因此，学校和家庭相对独立，对个体成长而言，学校教育和家庭教育各具独特价值。然而，学校家庭教育指导本质而言是公共领域对私人领域的介入。因此，学校家庭教育指导需要在公共领域与私人领域之间寻求平衡，相关指导须有度。</p><p><br/></p>', '  ', '', '', '1592466003', '1592466003', 'true', '', '近年来，家庭教育指导日渐成为学校的一项重要职能。2015年10月，教育部发布《关于加强家庭教育工作的指导意见》，提出充分发挥学校在家庭教育中的重要作用，指出各地教育部门要', '学校,应,如何,落实,家庭,教育指导,责任,', '3', '1592466003', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('21', '4', '中小学要知道的急救知识', '/storage/images/20200618/1-200210160102328.jpg', '', '<p>让学生掌握正确的突发灾害逃生要领，不仅可以保证灾害发生时学生的逃离速度，也能提高对学生生命安全的保障。</p><p>　　1.地震逃生攻略</p><p>　　(1)室内：当地震发生时，如不能紧急撤离去往室外，就呆在里面，将火熄灭，远离玻璃特别是大的窗户(包括镜子)。室内的角落或有好的支撑的内部门道是最好的避难处，也可以躲在桌底或别的坚固的家具下，这样不仅能提供防护，而且还有较大的呼吸空间。但在商店时要远离大的货物展厅。在多层楼房且装有电梯的办公室里时，千万不要进入电梯。</p><p>　　(2)室外：在室外时不要往地下走或进入坑道，这会导致被困，要远离高大建筑物，不要跑动，最好平躺在地面。地震结束后不要立即进入建筑物内，首次地震使任何建筑物都不太牢固，如果接着再发生余震，建筑物有可能倒塌。</p><p>　　2.火灾逃生攻略</p><p>　　(1)火灾刚发生时，可趁火势很小，用灭火器、自来水等在第一时间灭火，同时呼喊周围人员参与灭火和报警。如有多人灭火，应进行分工，一部分人负责灭火，另一部分人清除火焰周围的可燃物，防止、减缓火势蔓延，切不可置小火于不顾而酿成大灾。</p><p>　　(2)火已及身，切勿惊跑。当身上衣服着火时，应赶紧设法脱掉衣服或就地打滚，压灭火苗;及时跳进水中或让人向身上浇水，可用湿被子盖灭火苗。</p><p>　　(3)逃生开门前应触摸门锁。若门锁温度很高或有浓烟从门缝中往里钻，则说明大火或烟雾已封锁房门出口，此时切不可打开房门。应退守房间，关闭房内所有门窗，用毛巾、被子等堵塞门缝，并泼水降温。同时利用手机等通讯工具报警。此外，滚到墙边也可防止房屋塌落砸伤自己。</p><p>　　(4)若门锁温度正常或门缝没有浓烟进来，说明大火离自己尚有一段距离，此时可开门观察外面通道的情况。开门时要用一只脚抵住门的下框，以防热气浪将门冲开。在确信大火未到时，应尽快逃出火场。通过浓烟区时要以最低姿势快速前进，并用湿毛巾捂住口鼻。</p><p>　　(5)逃生勿入电梯。火场逃生要迅速，动作越快越好，但是，千万不要轻易乘坐普通电梯。因为发生火灾后，都会断电而造成电梯“卡壳”，这样逃生者会困在电梯中，反而处于更危险的境地，给救援工作增加难度;另外，电梯口直通大楼各层，火场上烟气涌入电梯并极易形成“烟囱效应”，人在电梯里随时会被浓烟毒气熏呛而窒息。</p><p>　　(6)楼梯可以救急，逃生时应尽量利用建筑物内的防烟楼梯间、封闭楼梯间、有外窗的通廊、避难层和室内设置的缓降器、救生袋、安全绳等设施。</p><p>　　(7)不可钻床底、衣橱、阁楼。切记千万不可钻到床底下、衣橱内、阁楼上躲避，这是火灾现场中最危险的地方，而且又不易被消防人员发觉，难以获得及时的营救。</p><p>　　(8)不可盲目跳楼。在得不到及时救援，又身居高层的情况下切不可盲目跳楼，可用房间内的床单、被里、窗帘等织物撕成能负重的布条连成绳索，系在窗户或阳台的构件上滑向楼下。</p><p>　　(9)如果着火点位于自己所处位置的上层，此时应向楼下逃去，直至到达安全地点;如果着火点位于自己所处位置的下层，且火和烟雾已封锁向下逃生的通道，应尽快往楼上逃生、楼顶平台是一个比较安全的场所，如楼顶有水箱，可用水浇湿自己的衣服，以抵御火焰的高温熏烤;如果在向楼顶平台逃生的过程中，发现自己被火、烟追上且又封锁了向上的道路，此时应果断地改选横向逃生路线，从另一层楼的走廊通道逃生，或退守到该层有利于逃避的房间内。</p><p><br/></p>', '  ', '', '', '1592466064', '1592466064', 'true', '', '让学生掌握正确的突发灾害逃生要领，不仅可以保证灾害发生时学生的逃离速度，也能提高对学生生命安全的保障。 1.地震逃生攻略 (1)室内：当地震发生时，如不能紧急撤离去往室外，', '中小学,要,知道,的,急救,知识,让,学生,掌握,', '3', '1592466064', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('22', '4', '家庭是孩子真正的起跑线', '/storage/images/20200618/1-200210160111154.jpg', '', '<p>为人父母，都希望自己的孩子学有所成。起跑线确实存在，只不过既不是小升初，也不在幼儿园，而是他们的父母。</p><p>　　孩子的成长背后，是家长的成长，要培养出类拔萃的孩子，家长要先把自己变得更好。</p><p>　　站在年轮切换的节点，罗振宇“时间的朋友”跨年演讲如约而至，在4个多小时的演讲中，这个笑眯眯的中年男子以“基本盘”为主题，分享了对过去一年的观察和心得。提起教育这个话题，罗振宇给出这样的数据：2019年1月1日到12月30日，在微信公众号，同时有“教育”和“焦虑”两个关键词的文章里，有3470篇，阅读量超过10万+，平均每天将近10篇：“家长”“父母”和“焦虑”连在一起的10万+，有6751篇，每天18篇。对此，罗振宇的感受是：这代父母确实很焦虑。</p><p>　　教育是家庭乃至全社会的关注热点，尤其是在这个竞争激烈的环境下，家长们深陷“输在起跑线上”的担忧。为了让孩子“成龙”“成凤”，“虎妈”“狼爸”不计成本地对子女进行“超前教育”，从好工作顺序倒推到好小学，以至诞生的那一刻。逼着孩子去上英语、奥数、书法各种培训班，琴棋书画各种才艺一个不落，在“鸡娃”的路上一往无前。微信圈曾疯传这样的段子：襁褓中的小朋友枕边戳着一张卡片，上面写着“距离高考还有6414天”。这个纸尿裤里的宝宝，还没来得及睁眼看世界，就无辜地被加入奔跑的行列。</p><p>　　为人父母，都希望自己的孩子学有所成，将来有份好工作，但好工作并不等于好生活，孩子拥有健全的人格，成为一个大写的人更重要。起跑线确实存在，只不过既不是小升初，也不在幼儿园，而是他们的父母，正所谓“人莫不爱其子孙，爱而不知教之，犹弗爱也。”孩子从呱呱坠地到长大成人，和父母在一起的时间最长。每个孩子生下来如同一张白纸，不同家庭的经济条件、教育方式、文化程度、道德素养，对孩子的影响至深至远。所以，苏霍姆林斯基才会把孩子比作一块大理石，坦承要将其塑造成一座雕像需要六位雕塑家，排在首位的就是家庭。因为，家庭教育是孩子成长过程中最基础、最关键的环节，父母是孩子一生中最重要，且不可代替的教育者。</p><p>　　成功之路不限于进名校，起跑线当然也不是成绩单。前不久，9岁成都女孩黎子琳的全英文演讲视频上了热搜，在马德里召开的第25届联合国气候变化大会上，她以熊猫保护为切入点，介绍了中国青少年在气候变化中所做的努力，号召大家“珍爱熊猫，珍爱地球”。小姑娘流利的英语表达、自信大方的举止，让家长们感叹“赢在起跑线上”。殊不知，这个“别人家的孩子”父母都是英语老师，从黎子琳出生开始，家里就通过英语儿歌和动画片等打造语言环境，是不折不扣“别人家的父母”。</p><p>　　家庭是孩子的第一所学校，家长是孩子的第一任老师，无论职位高低，薪酬几多，身为父母都是孩子的榜样，他们的言传身教对子女具有“润物细无声”的作用。父母的习惯、喜好、脾性像一面镜子，投射到孩子的身上，照耀着他们的未来。如果你手不释卷，孩子牙牙学语就会把翻书当游戏，整日沉迷麻将无法自拔的父母，别指望孩子能平心静气埋头苦读。央视曾播出一则公益广告：年幼的儿子看见妈妈为老人洗脚，也憨态可掬地给妈妈端来一盆热水。广告很短，寓意很深——父母的样子，就是孩子将来的样子。</p><p>　　当我们看清了起跑线的所在，也就能领会这个道理，孩子的成长背后，是家长的成长，要培养出类拔萃的孩子，家长要先把自己变得更好。只有家长以身作则，才能为孩子营造潜移默化的学习氛围；只有家长视野开阔，才能为孩子谋划更远大的未来；只有掌握儿童成长规律，才能遵循科学的教子方法；只有懂得保护儿童权利和尊严，孩子们才能幸福地度日，合理地做人，就像鲁迅先生所言：觉醒的父母，完全应该是义务的，利他的，牺牲的。</p><p><br/></p>', '  ', '', '', '1592466110', '1592466110', 'true', '', '为人父母，都希望自己的孩子学有所成。起跑线确实存在，只不过既不是小升初，也不在幼儿园，而是他们的父母。 孩子的成长背后，是家长的成长，要培养出类拔萃的孩子，家长要先', '家庭,是,孩子,真正,的,起跑线,为人,父母,都,', '5', '1592466110', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('23', '4', '家教指南：教考时评 辅导千万条 耐心第一条', '/storage/images/20200618/1-200210160121591.jpg', '', '<p>“不做作业，充满欢笑。一做作业，鸡飞狗跳。”不少家长吐槽自己得了“辅导作业恐惧症”，更有家长或“无可奈何”或“黔驴技穷”或“暴跳如雷”的视频疯传网络。曾几何时，辅导孩子作业竟成了令家长心力交瘁的苦差事？</p><p>　　看起来这种现象很简单，其实不然。既涉及作业量是否合理、难度是否适度、形式是否恰当等细节事宜，又牵扯到教师授课的教学效果和教学质量问题，当然和家长是否具备辅导能力和水平、了解孩子学习心理和特点等有密切联系。因此，首先要仔细分析出现障碍的诱因、关键在哪里。</p><p>　　家庭作业是课堂教学和学校学习的补充和延伸、拓展。其难度应以学生基本独立完成为宜。如果真的是家长费尽心机还难以辅导校方作业的话，教师和学校都脱不了干系。家长最多起个监督、检查、适度引导的作用，而不能把教学的主要担子推给家长。</p><p>　　作业是教学的重要环节之一，显然有其自身的规律和技巧。辅导作业既需要熟知教学内容和要求，更需要较高的能力和水平。有本事的人可以用简单、通俗的语言，把复杂的问题讲清楚。相反，无能的人则易把简单的问题弄复杂，把孩子越说越糊涂。这和家长的文化程度有关，更和其是否懂得教学规律有关联。因此，家长辅导是门学问，也需要认真学习。</p><p>　　有的家长对我说，当老师多好啊，有假期，还可以给学生、家长提要求。我却说：“您连自己的一两个孩子都搞不定，当老师的能让那么多孩子老老实实听课、学习，能简单得了吗？没有几手，恐怕早就被气跑了！”</p><p>　　众多因素中，孩子做作业的兴趣问题尤为重要。家长辅导不得法，作业没完成还是小事，伤害了孩子的自尊心、挫伤了学习积极性和主动性，进而影响了学习情绪和热情，就真的是因小失大、得不偿失了。</p><p><br/></p>', '  ', '', '', '1592466153', '1592466153', 'true', '', '不做作业，充满欢笑。一做作业，鸡飞狗跳。不少家长吐槽自己得了辅导作业恐惧症，更有家长或无可奈何或黔驴技穷或暴跳如雷的视频疯传网络。曾几何时，辅导孩子作业竟成了令家', '家教,指南,教考,时评,辅导,千,万条,耐心,第,', '3', '1592466153', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('24', '4', '孩子沉迷于网络游戏 家长一味施高压效果未必佳', '/storage/images/20200618/1-200210160134Z4.jpg', '', '<p>管孩子不是钉钉子，只管敲就行。钉子没自我意识，孩子可有自己的主意。孩子沉迷于网络游戏，茶不思饭不想，耽误了学习、损害了身体——相信但凡是做家长的，谁也不想这样的情况出现。可是，光有愿望没用，关键在于怎样做才有效。</p><p>　　实话实说，不少家长的做法，并不能实现帮孩子远离网络沉迷的目标。</p><p>　　有的家长轻信一些来历可疑、没有正规资质的戒网瘾中心，把孩子送了进去，发生过不少悲剧。让人联想起《笑林广记》里头说的黑色笑话：为了治驼背，拿俩木板夹着病人使劲踩。“医生”还振振有词：我治的是罗锅，还管人死不死？</p><p>　　更多的家长是自己上马，劳心费力，没少折腾，但是效果总不令人满意。和一些困惑的家长交流后，我梳理了一下他们的管理过程，往往是这样：家长发现苗头，马上陷入焦虑，采取高压政策：全面禁网禁手机！然而，互联网社会里，维系这样一个全方位的“真空”状态非常困难，自己加班、爷爷奶奶心软、小伙伴互通有无……不知哪个环节有漏洞，就使管理变成旷日持久的猫鼠游戏。</p><p>　　管孩子不是钉钉子，只管敲就行。钉子没自我意识，孩子可有自己的主意。尤其在青春期，这是建立自我意识的关键时期，逆反心理强烈。家长一坚决反对，孩子反而觉得，不玩是听家长的，玩是“做自己”，对自主的渴求压倒了自制，事情于是棘手。</p><p>　　管理要想有效，就不能忽视孩子的心理特点。先要取信于子女，别扣道德帽子。然后，靶向治理，精准施策。与其全面禁网，不如摸清楚，到底哪一款游戏最让孩子沉迷、沉迷点在什么地方，进行重点管理。和孩子一起认识危害、讨论办法，让孩子自己拿出防沉迷举措，家长督促落实，尊重孩子的自主心理。孩子假如给自己留了继续玩游戏的空间，只要保证可控制、有分寸，比如完成作业玩半个小时，可以开个小口，毕竟危害在于丧失自制。另外，“自然界讨厌真空”，抽走网络游戏这一块，就要考虑填上什么。踢球、遛狗、家庭名著读书会……只有另一种有意思，才能替代一种有意思。</p><p>　　防止沉迷，也不能光让家长使劲。制定更精准的政策、有效识别青少年、不设“玩得越长奖励越多”式的激励、定时强制下线……这些措施，期待游戏公司和管理部门的继续发力。</p><p><br/></p>', '  ', '', '', '1592466194', '1592466194', 'true', '', '管孩子不是钉钉子，只管敲就行。钉子没自我意识，孩子可有自己的主意。孩子沉迷于网络游戏，茶不思饭不想，耽误了学习、损害了身体相信但凡是做家长的，谁也不想这样的情况出', '孩子,沉,迷于,网络游戏,家长,一味,施高压,施,', '16', '1592466194', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('25', '4', '如何利用寒假给中学生补补亲情课', '/storage/images/20200618/1-200210160150443.jpg', '', '<p>　眼下正值寒假，满满的时间表、叠加的辅导班和无数的作业，成为学生假期必备的三大件。这么多的功课，这么紧的安排，却有一类很重要的课程被严重忽略了，那就是：亲情课。假期，是以家庭为中心进行交流、活动的最好时机，补补亲情这一课，有利于增进家庭成员之间的理解和沟通，增强家庭凝聚力和向心力，使家庭氛围更为和谐、融洽，找回日渐淡化的“年味”和“家味”。</p><p>　　那么，亲情课怎么补呢?不妨从以下方面着手吧。</p><p>　　策划一场家庭活动 怎么有趣就怎么来</p><p>　　父母多久没有陪孩子“玩儿”了?不是聚餐看电影，不是游乐场里的等候，不是把孩子扔给电子产品，而是真正参与到孩子玩耍的过程中。似乎，随着孩子的长大，父母的“童心”也渐渐被抛弃。于是，陪伴变得稀缺，或者毫无质量可言。</p><p>　　在假期，在周末，策划一次全家参与的家庭活动吧。孩子放下学业负担，父母放开工作压力和生活琐事，来一场家庭“嘉年华”，怎么有趣怎么来。那些健身的户外活动，如爬山、追逐、滑雪、定向越野……让全家人一起一边呼吸着冬天清冷的空气，一边笑着、叫着，重新找回自己、认识彼此。那些有趣的室内活动，密室逃脱、桌游、棋类博弈、球类竞赛……让我们在智力比拼中获得乐趣和力量，在亲子交融中变得更为亲密和相互欣赏。这样的家庭活动最好由孩子来策划，从活动主题、时间安排，到出行方式、路线选择，放手让孩子做主，相信孩子会给大家一个惊喜。</p><p>　　这，就是张弛有度的“活动课”。</p><p>　　组织一趟家庭旅游 留下家庭共同记忆</p><p>　　生活，总是在琐碎不堪、一地鸡毛的日子中悄然滑过。年年岁岁花相似，岁岁年年人不同。我们留不住自己光鲜靓丽、自信张扬的芳华，留不住孩子那攥着奶香味的胖乎乎的小手，更留不住父母那撑起整片天空的厚实的肩头。在假期里，组织一次家庭旅游，换一个环境，换一种方式，让紧张的节奏慢下来，让生活的压力缓下来，让家庭的欢笑与温馨在镜头里自然流淌，让美妙与尴尬的瞬间在回忆中历久弥新。</p><p>　　你有没有这样的经历?想找一个山清水秀、空气清新的地方度假，却没想到来到一个蚊虫众多、污水横流的“世外桃源”;跋山涉水不远万里到遥远的陌生国度猎奇，却不想买回一堆“中国制造”;披星戴月驱车上千里“自驾游”，却由于导航失灵迷失在茫茫戈壁滩上……这些旅行中的尴尬和困难，以及解决这些问题过程中的勇气和智慧，甚至家庭成员中彼此的争吵和帮助，都是家庭成长中的独特DNA。</p><p><br/></p>', '  ', '', '', '1592466246', '1592466246', 'true', '', '眼下正值寒假，满满的时间表、叠加的辅导班和无数的作业，成为学生假期必备的三大件。这么多的功课，这么紧的安排，却有一类很重要的课程被严重忽略了，那就是：亲情课。假期', '如何,利用,寒假,给,中学生,补补,亲情,课,眼下,', '17', '1592466246', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('26', '4', '学习 请把孩子“挂”起来', '/storage/images/20200618/1-200210160200950.jpg', '', '<p>几乎所有的专家名人都会告诉你，学习不是最重要的，而是全面发展，是身心健康。道理大家都赞同，但是对于绝大多数家长，最现实的，或者说最重视的，都回到了学习。</p><p>　　我非常理解，学习是显性的，马上可以看到，关键是大家都这样评价孩子，还涉及脸面问题。而成长是隐性的，是阶段结果，任何人都很难在显性　　的结果面前淡定，我们就先谈学习吧。</p><p>　　写下这个题目，我就知道没有任何人有灵丹妙药，或者说标准答案，我只能分享一些经验供大家参考。</p><p>　　首先需要有正确的认知。国家主席只有一个，省长只有一个，两院院士也仅仅1000多人。2017年高考报名940万人，招生735万人，清华北大每年招收的学生总数也只有7000余人，10万分之一。每一个人都先需要有一个清醒的认识，对自己有一个恰当的定位与期盼，实际上绝大多数孩子成不了“牛孩”的。但是，每一个人都可以达到自己的最高度，如果这样看，当然是有办法的。</p><p>　　其中最有效的一个办法，就是启动孩子的“发动机”，把他“挂”起来。</p><p>什么意思？曾经有名师总结经验说，优秀是一种习惯！这句话说的比较到位，让孩子一开始就习惯于优秀，让他无法容忍自己的不优秀很重要。</p><p>我们回顾一下自己的成长过程，就会发现，经常会有一门或者几门功课比较厉害，老师同学也都会说你在这方面有天赋。但仔细想想，无非是我们因缘巧合，或是因为提前学过，或是偏巧知道了，让老师同学惊艳，赞叹，自己虚荣心也得到了前所未有的满足，于是你就不自觉地在这个学科上花了很多　　　　时间，因为你希望一直保持这种优秀，也怕辜负老师同学的赞叹，于是就产生了无穷的动力，于是就变成了兴趣，爱好，甚至是天赋。</p><p>　　说穿了，实际是自己在这方面得到了大家的认可，虚荣心得到了极大的满足而已。久而久之，你自己都相信自己的确有这方面天赋，感觉自己没有花多少时间，但实际上，你一定比别人花的多，用心琢磨的多，只是没有察觉而已。更重要的是，时间一长，你习惯于这种崇拜，这种天赋，你都很难容忍自己不够优秀，你就会在这条路上狂奔，开挂了。</p><p>　　正因为此，你可以在一开始，有意识地给孩子多做一点准备。这需要根据孩子的特性特质，选择不同的领域，一般情况下，我尤其赞同在语言文学方面早学，多发展一些。</p><p>　　在小学阶段，语文英语数学这三科中，数学一旦开窍，容易上来，但语文英语不同，这是一个需要积累的学科，需要一些死功夫，需要大量阅读基础，不是短期可以提高的。但语文与英语往往容易获得更多表现机会。为什么不在孩子很小，还没有较大的学习负担之前让他每天学习背诵一些知识，既是传统文化的熏陶，也是提前的准备与铺垫。处理巧妙一些，这些东西绝不会成为负担，而是让孩子有无穷的乐趣与斗志。想提醒一点，你不必在意孩子是否真的懂了，背下来，必有喷涌的一天，就是古人所说的“熟读唐诗三百首”的道理。</p><p>　　等到开始孩子需要大量去学习，去背诵，感受到负担的时候，这已经成为他的兴趣与爱好，家长就不用天天敦促操心了，孩子的感受也早已发生了巨大变化，变被动为主动了。</p><p>　　记得我儿子当初回国，中文已经说不利落了，万般无奈之下，我采取了简单的激励办法：读一页中文书给1块钱。孩子就选了白话历史，或者字大行稀的唐诗宋词，尤其是宋词。久而久之，他在中文上的水平得到了很大的提高，尤其喜欢填词。在初三紧张的复习备考期间，他最喜欢的解压方式之一就是填首词。</p><p>　　有一点小窍门给大家，很多人都在教孩子三字经，唐诗宋词，你完全可以考虑让他背四书五经，这样就区别于人了。同时，扎实的文言文训练，会让孩子在思考与行文上与别人有明显区别。一旦有机会，他可能会让老师、同学惊艳，也就奠定了他最基本的开始，把他“开挂”了。</p><p><br/></p>', '  ', '', '', '1592466287', '1592466287', 'true', '', '几乎所有的专家名人都会告诉你，学习不是最重要的，而是全面发展，是身心健康。道理大家都赞同，但是对于绝大多数家长，最现实的，或者说最重视的，都回到了学习。 我非常理解', '学习,请,把,孩子,“,挂,”,起来,几乎,所,有的,', '14', '1592466287', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('27', '4', '挫折，孩子不可或缺的“生长素”', '/storage/images/20200618/1-200210160210C1.jpg', '', '<p>近段时间，连续发生几起孩子轻生事件，让人心头沉重。最让人唏嘘的是其出事原因，“因为爸爸不让看电视”“因为老师没收了手机”。</p><p>　　看似难以置信的理由，可能包含着很多复杂隐情，比如青春期叛逆、亲子沟通不畅、心理隐患作祟……但其中一个重要因素不容忽视，就是现在很多孩子缺乏“挫折教育”，心理承受能力太差。</p><p>　　很长一段时间来，“好孩子是夸出来的”深入人心，变着花样夸孩子已成为很多人的习惯。认字了，真棒！会数数了，太厉害了！会背古诗了，简直是小天才！本来就是6个大人围着转的“心肝宝贝”，再在夸奖的蜜罐子中长大，倘若哪天遇到一点不顺心，能不成为“天大的委屈”吗？</p><p>　　不幸的是，人生不是“夸”出来的。正如一年有春夏秋冬，人生路上遇到一些不如意，简直再正常不过。那么问题来了，温室中长大的小苗，如何能傲霜斗雪？有趣的是，农民早就给出了答案：移栽幼苗前，先给温室逐渐降温，让小苗接受“耐寒锻炼”。比如，让番茄苗在10℃的环境中“锻炼”几天，出去就能抗5℃左右的低温。</p><p>　　孩子的成长，也需要“耐寒锻炼”。搭的积木塌了，做的功课错了，考试成绩砸了……先别忙着“代办”，最好趁势引导孩子直面问题，正视困难，让孩子学会处变不惊，重整旗鼓。试想，如果一个孩子能对日常遇到的挫折等闲视之，还会“一言不合”就受不了吗？反之，如果长着“玻璃心”，即使被拦下了一时冲动，等到以后遇到比“不让看电视”更大的问题时，能平和对待吗？</p><p>　　对孩子进行挫折教育，家长要把握好时度效。比如，孩子跌倒了先别着急扶，提出非分要求应果断拒绝，撒泼胡闹立马批评教育……特别是对青春期的孩子，一定要让他知道，世界不为你而存在，别人不为你而活着，社会不为你而构建，这个世界上没有那么多“理所当然”。</p><p>　　多些磋磨，不是坏事，对成长中的孩子尤为如此。从这个意义上讲，挫折是孩子不可或缺的“生长素”。</p><p><br/></p>', '  ', '', '', '1592466339', '1592466339', 'true', '', '近段时间，连续发生几起孩子轻生事件，让人心头沉重。最让人唏嘘的是其出事原因，因为爸爸不让看电视因为老师没收了手机。 看似难以置信的理由，可能包含着很多复杂隐情，比如', '挫折,孩子,不可或缺,的,“,生长素,”,近,', '17', '1592466339', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('28', '4', '财经素养教育必要且急迫', '/storage/images/20200618/1-200210160219A5.jpg', '', '<p>财经素养的培育更重要的是丰富学生的价值观、人生观，尤其是帮助其正确认识金钱、使用金钱，这将有助于提高他们成年之后个人和家庭的生活质量。</p><p>　　财经素养教育应该是跨学科的学科教育，如金融知识与语文、数学等其他学科相融合，通过呈现真实的场景，让金融知识和技能在场景中得以运用</p><p>　　厄尔尼诺现象引起的全球降水分布变化，会影响哪些产业？如果你是一名设计师，如何巧妙选择材料建设一座新型生态农场？生活中肥皂种类繁多，价格区间较大，那么制作一块肥皂的成本究竟是多少，市场前景如何？……进入暑假，杨浦区的中小学生围绕财经素养相关的话题，展开了一系列跨学科的实践探索和课题研究。</p><p>　　这种实践探索必要且急迫。在上海师范大学国际与比较教育研究院助理研究员朱小虎看来，随着生活环境不断变化，中小学生面对的金融环境日益复杂，如何提高学生财经素养已成全球性话题。</p><p>　　据记者了解，在上海，围绕如何提高青少年的财经素养，东昌中学、上海财经大学附属中学、平凉路第三小学等学校正在开展相关教学实践。相关专家呼吁，财经素养的培育应该形成体系，并有成熟的配套教材，让财商教育渗透到中小学生学习生活的方方面面。</p><p>　　金融触角的延伸，对学生财经素养提出更高要求</p><p>　　随着经济社会发展和家庭财富增长，青少年参与金融活动、进行金融决策的比例逐年递增。调查显示，上海15岁学生拥有个人账户的比例达55.8%。与此同时，青少年可支配的金钱数额也越来越大：2017年我国十个城市中小学生收到压岁钱的平均值在2469至5137元之间；在重庆，一名小学生过年收到的压岁钱相当于当地人均1.4个月的收入。</p><p>　　金融触角在生活领域中的延伸拓展，对财富使用者的金融素养和能力提出了更高要求。然而，由于中小学生缺少相关知识和经验，并不具备对金融产品的辨别和使用能力，往往更容易遭受损失或伤害，诸如大学生“裸贷”、学生身陷金融和消费欺诈等事件屡见不鲜。朱小虎说：“我们应该看到，生活环境的变化已经对学生的财经素养提出了新的要求。培养青少年正确的金钱观，提高他们的理财能力，帮助他们合理使用可支配的收入，具有现实意义。”</p><p><br/></p>', '  ', '', '', '1592466381', '1592466381', 'true', '', '财经素养的培育更重要的是丰富学生的价值观、人生观，尤其是帮助其正确认识金钱、使用金钱，这将有助于提高他们成年之后个人和家庭的生活质量。 财经素养教育应该是跨学科的学', '财经,素养,教育,必要,且,急迫,财经,素养,的,', '21', '1592466381', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('29', '5', '教学环境一', '/storage/images/20200618/1-2002110913330-L.jpg', '', '  ', '  ', '', '', '1592466600', '1592466600', 'true', '', '', '', '0', '1592466600', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('30', '5', '教学环境二', '/storage/images/20200618/1-2002110911510-L.jpg', '', '  ', '  ', '', '', '1592466630', '1592466630', 'true', '', '', '', '0', '1592466630', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('31', '5', '教学环境三', '/storage/images/20200618/1-2002110912000-L.jpg', '', '  ', '  ', '', '', '1592466659', '1592466659', 'true', '', '', '', '0', '1592466659', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('32', '5', '教学环境四', '/storage/images/20200618/1-2002110912080-L.jpg', '', '  ', '  ', '', '', '1592466684', '1592466684', 'true', '', '', '', '0', '1592466684', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('33', '5', '教学环境五', '/storage/images/20200618/1-2002110912180-L.jpg', '', '  ', '  ', '', '', '1592466703', '1592466703', 'true', '', '', '', '0', '1592466703', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('34', '5', '教学环境六', '/storage/images/20200618/1-2002110912280-L.jpg', '', '  ', '  ', '', '', '1592466725', '1592466725', 'true', '', '', '', '0', '1592466725', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('35', '5', '教学环境七', '/storage/images/20200618/1-2002110912400-L.jpg', '', '  ', '  ', '', '', '1592466753', '1592466753', 'true', '', '', '', '0', '1592466753', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('36', '5', '教学环境八', '/storage/images/20200618/1-2002110912490-L.jpg', '', '    ', '    ', '', '', '1592466824', '1592466778', 'true', '', '', '', '0', '1592466778', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('37', '5', '教学环境九', '/storage/images/20200618/1-2002110912590-L.jpg', '', '  ', '  ', '', '', '1592466817', '1592466817', 'true', '', '', '', '0', '1592466817', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('38', '5', '教学环境十', '/storage/images/20200618/1-200211091321260.jpg', '', '  ', '  ', '', '', '1592466874', '1592466874', 'true', '', '', '', '0', '1592466874', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('39', '5', '教学环境十一', '/storage/images/20200618/1-2002110911260-L.jpg', '', '  ', '  ', '', '', '1592466892', '1592466892', 'true', '', '', '', '0', '1592466892', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('40', '5', '教学环境十二', '/storage/images/20200618/1-2002110913460-L.jpg', '', '  ', '  ', '', '', '1592466910', '1592466910', 'true', '', '', '', '0', '1592466910', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('41', '6', '合作伙伴一', '/storage/images/20200618/1-2002110ZG30-L.jpg', '', '  ', '  ', '', '', '1592467007', '1592467007', 'true', '', '', '', '0', '1592467007', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('42', '6', '合作伙伴二', '/storage/images/20200618/1-2002110ZH10-L.jpg', '', '  ', '  ', '', '', '1592467024', '1592467024', 'true', '', '', '', '0', '1592467024', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('43', '6', '合作伙伴三', '/storage/images/20200618/1-2002110ZH90-L.jpg', '', '  ', '  ', '', '', '1592467041', '1592467041', 'true', '', '', '', '0', '1592467041', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('44', '6', '合作伙伴四', '/storage/images/20200618/1-2002110ZI80-L.jpg', '', '  ', '  ', '', '', '1592467061', '1592467061', 'true', '', '', '', '0', '1592467061', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('45', '6', '合作伙伴五', '/storage/images/20200618/1-2002110ZJ80-L.jpg', '', '  ', '  ', '', '', '1592467082', '1592467082', 'true', '', '', '', '0', '1592467082', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('46', '6', '合作伙伴六', '/storage/images/20200618/1-2002110ZK70-L.jpg', '', '  ', '  ', '', '', '1592467100', '1592467100', 'true', '', '', '', '0', '1592467100', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('47', '6', '合作伙伴七', '/storage/images/20200618/1-2002110ZQ00-L.jpg', '', '  ', '  ', '', '', '1592467124', '1592467124', 'true', '', '', '', '0', '1592467124', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('48', '6', '合作伙伴八', '/storage/images/20200618/1-2002110ZQ90-L.jpg', '', '  ', '  ', '', '', '1592467144', '1592467144', 'true', '', '', '', '0', '1592467144', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('49', '6', '	 合作伙伴九', '/storage/images/20200618/1-2002110ZR90-L.jpg', '', '  ', '  ', '', '', '1592467163', '1592467163', 'true', '', '', '', '0', '1592467163', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('50', '6', '合作伙伴十', '/storage/images/20200618/1-2002110ZS90-L.jpg', '', '  ', '  ', '', '', '1592467189', '1592467189', 'true', '', '', '', '0', '1592467189', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('51', '6', '合作伙伴十一', '/storage/images/20200618/1-2002110ZU30-L.jpg', '', '  ', '  ', '', '', '1592467206', '1592467206', 'true', '', '', '', '0', '1592467206', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('52', '6', '合作伙伴十二', '/storage/images/20200618/1-2002110ZZ00-L.jpg', '', '  ', '  ', '', '', '1592467221', '1592467221', 'true', '', '', '', '0', '1592467221', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('53', '0', '关于我们', '', 'about', '<p>广州某某在线教育有限公司用名字践行自己理想，用实际行动谱写教育真谛。在会计领域多年工作中，我们发现财务<br/>知识必须普及的重要性以及高端财务领域人才匮缺的必然性。在一群资深财务专家推动下，某某教育诞生了，从此开始了会计培训领域追梦之旅<br/>演绎一个教育品牌千锤万炼终成金非凡历程。</p>', '    ', '', '', '1592479331', '1592467523', 'true', '', '广州某某在线教育有限公司用名字践行自己理想，用实际行动谱写教育真谛。在会计领域多年工作中，我们发现财务知识必须普及的重要性以及高端财务领域人才匮缺的必然性。在一群资深财务专家推动下，某某教育诞生了，从此开始了会计培训领域追梦之旅演绎一个教育品牌千锤万', '广州本土专业会计培训机构', '29', '1592467523', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('54', '7', '完善优质的服务', '', '', '    ', '    ', '', '', '1592467668', '1592467647', 'true', '', '模块化训练，个性化指导，针对性强，重量级突破表演，独特的三维一体强化阶段式训练。', '', '0', '1592467647', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('55', '7', '效果至上的理念', '', '', '  ', '  ', '', '', '1592467707', '1592467707', 'true', '', '以学员的改变为第一追求，敬业、用心全心全力协助学员突破自我，实现自己的目标。', '', '0', '1592467707', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('56', '7', '实用实效的原则', '', '', '  ', '  ', '', '', '1592467838', '1592467838', 'true', '', '以人为本的原则，浅显易懂、实用有效深入人心。在工作生活中能产生立竿见影的效果。', '', '0', '1592467838', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('57', '7', '情景化实战演练', '', '', '  ', '  ', '', '', '1592467851', '1592467851', 'true', '', '全参与式实战演练，学员现场演练，然后实践，从现场、行为、心态等全方面彻底改变。', '', '0', '1592467851', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('58', '7', '成熟科学的课程', '', '', '    ', '    ', '', '', '1592467913', '1592467863', 'true', '', '源于全球百年经典，国内18年磨砺，从训练理念、方式，到原则，都成熟科学合理。', '', '0', '1592467863', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('59', '7', '专家级资深师资', '', '', '    ', '    ', '', '', '1592467907', '1592467875', 'true', '', '专家级导师，十余年资深训练经验，二十余年工作经验，超过10000小时授课经历。', '', '0', '1592467875', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('60', '8', '2006年', '', '', '  ', '  ', '', '', '1592467901', '1592467901', 'true', '', 'xxxx集团成立，以代理记账及企业内训为主要业务，为培训事业积累了丰富的师资及教学素材；', '', '0', '1592467901', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('61', '8', '2010年', '', '', '  ', '  ', '', '', '1592467933', '1592467933', 'true', '', '公司开拓培训事业，并成立会计教学研发部，根据代帐企业账目进行课程研发；', '', '0', '1592467933', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('62', '8', '2011年', '', '', '  ', '  ', '', '', '1592467949', '1592467949', 'true', '', 'xxxx培训四方坪校区成立，依靠专业团队支撑及过硬的会计实操行业经验，迅速在长沙地区会计培训界获得良好口碑；', '', '0', '1592467949', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('63', '8', '2012年', '', '', '  ', '  ', '', '', '1592467964', '1592467964', 'true', '', 'xxxx培训红星校区成立，并正式开展就业指导及就业服务', '', '0', '1592467964', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('64', '8', '2015年', '', '', '  ', '  ', '', '', '1592467980', '1592467980', 'true', '', '浏阳校区和株洲醴陵校区相继开业，两个校区直接复制长沙校区的教学及就业合作模式，为花炮之乡和瓷城提供专业的人才培养/输送方式，为各中小型企业提供专业的财税解决方案，成为育德第一批进入地级市的校区！', '', '0', '1592467980', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('65', '8', '2016年', '', '', '  ', '  ', '', '', '1592467997', '1592467997', 'true', '', '我们还将成立二至三个培训中心，稳步发展的同时寻求突破。并着手成立会计教学质量部，对课程进行随时更新、与时俱进，对教学质量进行全程跟踪、对教学进行标准化流程管理。', '', '0', '1592467997', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('66', '9', '广州校区', '', '', '<p>地址: 广州市番禺经济开发区</p><p>联系电话：020—88888888</p><p>QQ：88888888</p><p><br/></p>', '  ', '', '', '1592468024', '1592468024', 'true', '', '地址:广州市番禺经济开发区联系电话：020—88888888QQ：88888888', '', '0', '1592468024', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('67', '9', '深圳校区', '', '', '<p>地址: 深圳市南山区经济开发区</p><p>联系电话：0755—88888888</p><p>QQ：99999999</p><p><br/></p>', '  ', '', '', '1592468046', '1592468046', 'true', '', '地址:深圳市南山区经济开发区联系电话：0755—88888888QQ：99999999', '', '0', '1592468046', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('68', '9', '东莞校区', '', '', '<p>地址: 东莞市莞城区经济开发区</p><p>联系电话：0769—88888888</p><p>QQ：77777777</p><p><br/></p>', '    ', '', '', '1592479893', '1592468065', 'true', '', '地址:东莞市莞城区经济开发区联系电话：0769—88888888QQ：77777777', '', '0', '1592468065', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('69', '0', '联系我们', '', 'contact', '    ', '    ', '', '', '1592479865', '1592468136', 'true', '', '', '', '18', '1592468136', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('70', '0', '在线报名', '', 'liuyan', '      ', '      ', '', '', '1592480071', '1592468196', 'true', '', '专业的师资团队给你系统的课程讲授和完整的贴心服务，只为你能轻松拿证', '', '60', '1592468196', '0', '0', '0', '100');

-- ----------------------------
-- Table structure for `rrz_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channelfield`;
CREATE TABLE `rrz_channelfield`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '所属模型id',
  `channel_type` enum('articles','goods') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `title` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '字段定义',
  `maxlength` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '默认值',
  `dfvalue_unit` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_filter` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否应用于条件筛选',
  `ifrequire` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否必填',
  `sort` int(5) UNSIGNED NOT NULL DEFAULT 100 COMMENT '排序',
  `add_time` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_channel_id`(`channel_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '自定义字段表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for rrz_channeltype
-- ----------------------------
DROP TABLE IF EXISTS `rrz_channeltype`;
CREATE TABLE `rrz_channeltype`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `type` enum('articles','goods') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `add_time` int(11) UNSIGNED NULL DEFAULT 0 COMMENT '新增时间',
  `update_time` int(11) UNSIGNED NULL DEFAULT 0 COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '文章（产品）类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for `rrz_config`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_config`;
CREATE TABLE `rrz_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置内容',
  `type` varchar(64) DEFAULT '' COMMENT '类型',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0：否，1：是）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统配置表';

-- -----------------------------
-- Records of `rrz_config`
-- -----------------------------
INSERT INTO `rrz_config` VALUES ('1', 'status', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('2', 'name', '响应式在线教育培训类网站(自适应手机端)', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('3', 'logo', '/storage/images/20200618/logo.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('4', 'wap_logo', '/storage/images/20200618/logo.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('5', 'favicon', '/storage/images/20200618/favicon.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('6', 'copyright', 'Copyright © 2002-2020 某某在线教育有限公司 版权所有', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('7', 'recordnum', '粤ICP备xxxxxxxx号', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('8', 'title', '响应式在线教育培训类网站(自适应手机端)', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('9', 'keywords', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('10', 'description', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('11', 'is_authorization', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('12', 'authortoken_code', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('13', 'popup_upgrade', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('14', 'wap_domain', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('15', 'is_https', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('16', 'logo', '/static/images/logo.png', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('17', 'sqldatapath', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('18', 'expiretime', '3600', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('19', 'name', '某某在线教育有限公司', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('20', 'telephone', '400-123-4567', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('21', 'fax', '020-99999999', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('22', 'qq', '88888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('23', 'email', 'admin@youweb.com', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('24', 'addr', '广东省广州市番禺经济开发区', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('25', 'coord', '22.94703,113.38555', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('26', 'thirdcode_pc', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('27', 'thirdcode_wap', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('28', 'inlet', '2', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('29', 'auto', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('30', 'filter_isurl', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('31', 'type', 'xml', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('32', 'index_changefreq', 'always', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('33', 'list_changefreq', 'hourly', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('34', 'view_changefreq', 'daily', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('35', 'index_priority', '1.0', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('36', 'list_priority', '0.8', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('37', 'view_priority', '0.5', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('38', 'articles_num', '100', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('39', 'zzbaidutoken', '', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('40', 'app_map', 'admin', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('41', 'status', '1', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('42', 'replace', '国家级|国际级|世界级|宇宙级|千万级|百万级|星级|甲级|超甲级|完美|唯一|一流|精确|顶级|顶尖|尖端|最|国际级产品|填补国内空白|带头|首个|首次|首发|首款|首家|首选|品牌|正品|金牌|名牌|优秀|顶级|独家|唯独|独有|独创|独据|开发者|缔造者|创始|发明者|领先|领头|领导|领跑|领袖|领先|引领|创领|领航|权威|先进|耀领|缔造者|极品|极佳|顶级|尖端|顶尖|终极|绝佳|绝对|绝版|终极|极致|极具|王牌|冠军|第一|极致|永久|王牌|掌门人|领袖|独一无二|绝无仅有|前无古人|史无前例|万能|绝对|绝顶|大牌|精确|超赚|巨星|至尊|巅峰|之王|巨星|王者|冠军|资深|至尊|著名|奢侈|百分之百|国家级产品|国家免检|国家领导人|填补国内空白|史无前例|前无古人|永久|永远|万能|祖传|特效|无敌|纯天然|超赚|国际品质|专家推荐|超强|全面|全网|全球|随时结束|仅此一次|空前绝后|随时涨价|马上降价|最后一波|包治百病|药到病除|特供|专供|专家推荐|热销|畅销|全效|标杆|精确|优秀|仅此|遥遥|高档|真皮|超赚|精准|指定|精品|特供|专供|军方|军事|国旗|国徽|党旗|驰名|秒杀|一步到位|', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('43', 'connector_title', '_', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('44', 'list_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('45', 'view_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('46', 'mobile', '138-0000-0000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('47', 'wx', 'WX8888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('48', 'qrcode', '/storage/images/20200618/qr.png', 'webinfo', '', 'cn', '0');

-- ----------------------------
-- Table structure for `rrz_form_data`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_form_data`;
CREATE TABLE `rrz_form_data` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `form_id` int(10) unsigned DEFAULT '0' COMMENT '表单ID',
  `form_name` varchar(255) DEFAULT '' COMMENT '表单名称',
  `content` longtext COMMENT '提交内容',
  `ip` varchar(255) DEFAULT '' COMMENT '提交人IP',
  `add_time` int(10) unsigned DEFAULT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_forms`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_forms`;
CREATE TABLE `rrz_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `config` longtext COMMENT '表单配置',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '删除(0=否，1=是)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_is_del` (`is_del`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- -----------------------------
-- Records of `rrz_forms`
-- -----------------------------
INSERT INTO `rrz_forms` VALUES ('1', '在线留言', 'a:4:{i:0;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:12:\"真实姓名\";s:8:\"required\";s:1:\"1\";}i:1;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:12:\"手机号码\";s:8:\"required\";s:1:\"1\";}i:2;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:8:\"QQ号码\";s:8:\"required\";s:1:\"0\";}i:3;a:4:{s:4:\"type\";s:5:\"radio\";s:4:\"name\";s:6:\"性别\";s:8:\"required\";s:1:\"0\";s:6:\"option\";a:2:{i:0;s:6:\"男生\";i:1;s:6:\"女生\";}}}', '1590663479', '0');

-- ----------------------------
-- Table structure for `rrz_goods`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods`;
CREATE TABLE `rrz_goods` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `brief` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '商品简介',
  `cat_id` mediumint(8) unsigned DEFAULT NULL COMMENT '产品分类id',
  `def_img` varchar(500) DEFAULT '' COMMENT '产品默认图片路径',
  `imgs` longtext COMMENT '产品图片集合',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `del_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品划线价格',
  `store` int(8) unsigned DEFAULT '0' COMMENT '产品库存',
  `is_presell` enum('true','false') DEFAULT 'false' COMMENT '是否预售（是否定金付款）',
  `presell_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '预售价格（定金）',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '产品规格',
  `content` longtext COMMENT '产品详情',
  `wap_content` longtext COMMENT '手机端详情',
  `sales` int(11) unsigned DEFAULT '0' COMMENT '产品销量',
  `addtime` int(11) unsigned DEFAULT '0' COMMENT '创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_news` tinyint(1) unsigned DEFAULT '0' COMMENT '新品（0=否，1=是）',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cat_id` (`cat_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_is_news` (`is_news`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品管理';

-- -----------------------------
-- Records of `rrz_goods`
-- -----------------------------
INSERT INTO `rrz_goods` VALUES ('1', '语文培训课程体系【2020】零基础入门班', '很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分', '1', '/storage/images/20200618/1-2002101456370-L.jpg', '/storage/images/20200618/1-2002101456370-L.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p><img src=\"/storage/images/20200618/1-200210145FV12.jpg\"/></p><p>很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分掌握对冠词这类看似简单词类的牢固掌握；介词和代词这两类词类，老师通过具体例题对易混易错知识的讲解，帮助同学系统复习零散的知识。轻松复习，稳拿高分。</p><p><br/></p>', '  ', '1000', '1592463912', '0', '0', '0', '0', '8', '100', '');
INSERT INTO `rrz_goods` VALUES ('2', '数学培训课程体系【2020】零基础入门班', '很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分', '1', '/storage/images/20200618/1-200211100R10-L.jpg', '/storage/images/20200618/1-200211100R10-L.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p><img src=\"/storage/images/20200618/1-200210145FV12.jpg\"/></p><p>很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分掌握对冠词这类看似简单词类的牢固掌握；介词和代词这两类词类，老师通过具体例题对易混易错知识的讲解，帮助同学系统复习零散的知识。轻松复习，稳拿高分。</p><p><br/></p>', '  ', '5262', '1592463995', '0', '0', '0', '0', '9', '100', '');
INSERT INTO `rrz_goods` VALUES ('3', '英语培训课程体系【2020】零基础入门班', '很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分', '1', '/storage/images/20200618/1-2002111010440-L.jpg', '/storage/images/20200618/1-2002111010440-L.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p><img src=\"/storage/images/20200618/1-200210145FV12.jpg\"/></p><p>很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分掌握对冠词这类看似简单词类的牢固掌握；介词和代词这两类词类，老师通过具体例题对易混易错知识的讲解，帮助同学系统复习零散的知识。轻松复习，稳拿高分。</p><p><br/></p>', '  ', '5000', '1592464086', '0', '0', '0', '0', '9', '100', '');
INSERT INTO `rrz_goods` VALUES ('4', '历史培训课程体系【2020】零基础入门班', '很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分', '2', '/storage/images/20200618/1-2002111011490-L.jpg', '/storage/images/20200618/1-2002111011490-L.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p><img src=\"/storage/images/20200618/1-200210145FV12.jpg\"/></p><p>很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分掌握对冠词这类看似简单词类的牢固掌握；介词和代词这两类词类，老师通过具体例题对易混易错知识的讲解，帮助同学系统复习零散的知识。轻松复习，稳拿高分。</p><p><br/></p>', '  ', '2000', '1592464168', '0', '0', '0', '0', '8', '100', '');
INSERT INTO `rrz_goods` VALUES ('5', '政治培训课程体系【2020】零基础入门班', '很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分', '2', '/storage/images/20200618/1-2002111012070-L.jpg', '/storage/images/20200618/1-2002111012070-L.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p><img src=\"/storage/images/20200618/1-200210145FV12.jpg\"/></p><p>很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分掌握对冠词这类看似简单词类的牢固掌握；介词和代词这两类词类，老师通过具体例题对易混易错知识的讲解，帮助同学系统复习零散的知识。轻松复习，稳拿高分。</p><p><br/></p>', '  ', '1263', '1592464216', '0', '0', '0', '0', '8', '100', '');
INSERT INTO `rrz_goods` VALUES ('6', '生物培训课程体系【2020】零基础入门班', '很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分', '2', '/storage/images/20200618/1-2002111012560-L.jpg', '/storage/images/20200618/1-2002111012560-L.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p><img src=\"/storage/images/20200618/1-200210145FV12.jpg\"/></p><p>很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分掌握对冠词这类看似简单词类的牢固掌握；介词和代词这两类词类，老师通过具体例题对易混易错知识的讲解，帮助同学系统复习零散的知识。轻松复习，稳拿高分。</p><p><br/></p>', '  ', '4241', '1592464252', '0', '0', '0', '0', '8', '100', '');
INSERT INTO `rrz_goods` VALUES ('7', '口语培训课程体系【2020】零基础入门班', '很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分', '3', '/storage/images/20200618/1-2002111013420-L.jpg', '/storage/images/20200618/1-2002111013420-L.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p><img src=\"/storage/images/20200618/1-200210145FV12.jpg\"/></p><p>很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分掌握对冠词这类看似简单词类的牢固掌握；介词和代词这两类词类，老师通过具体例题对易混易错知识的讲解，帮助同学系统复习零散的知识。轻松复习，稳拿高分。</p><p><br/></p>', '  ', '4542', '1592464294', '0', '0', '0', '0', '8', '100', '');
INSERT INTO `rrz_goods` VALUES ('8', '高数培训课程体系【2020】零基础入门班', '很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分', '3', '/storage/images/20200618/1-2002111014330-L.jpg', '/storage/images/20200618/1-2002111014330-L.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p><img src=\"/storage/images/20200618/1-200210145FV12.jpg\"/></p><p>很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分掌握对冠词这类看似简单词类的牢固掌握；介词和代词这两类词类，老师通过具体例题对易混易错知识的讲解，帮助同学系统复习零散的知识。轻松复习，稳拿高分。</p><p><br/></p>', '  ', '3651', '1592464330', '0', '0', '0', '0', '10', '100', '');
INSERT INTO `rrz_goods` VALUES ('9', '力学培训课程体系【2020】零基础入门班', '很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分', '3', '/storage/images/20200618/1-2002111015040-L.jpg', '/storage/images/20200618/1-2002111015040-L.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p><img src=\"/storage/images/20200618/1-200210145FV12.jpg\"/></p><p>很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分掌握对冠词这类看似简单词类的牢固掌握；介词和代词这两类词类，老师通过具体例题对易混易错知识的讲解，帮助同学系统复习零散的知识。轻松复习，稳拿高分。</p><p><br/></p>', '  ', '9562', '1592464361', '0', '0', '0', '0', '9', '100', '');
INSERT INTO `rrz_goods` VALUES ('10', '营销培训课程体系【2020】零基础入门班', '很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分', '4', '/storage/images/20200618/1-2002111016100-L.jpg', '/storage/images/20200618/1-2002111016100-L.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p><img src=\"/storage/images/20200618/1-200210145FV12.jpg\"/></p><p>很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分掌握对冠词这类看似简单词类的牢固掌握；介词和代词这两类词类，老师通过具体例题对易混易错知识的讲解，帮助同学系统复习零散的知识。轻松复习，稳拿高分。</p><p><br/></p>', '  ', '6256', '1592464397', '0', '0', '0', '0', '8', '100', '');
INSERT INTO `rrz_goods` VALUES ('11', '音乐培训课程体系【2020】零基础入门班', '很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分', '4', '/storage/images/20200618/1-2002111016390-L.jpg', '/storage/images/20200618/1-2002111016390-L.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p><img src=\"/storage/images/20200618/1-200210145FV12.jpg\"/></p><p>很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分掌握对冠词这类看似简单词类的牢固掌握；介词和代词这两类词类，老师通过具体例题对易混易错知识的讲解，帮助同学系统复习零散的知识。轻松复习，稳拿高分。</p><p><br/></p>', '  ', '9568', '1592464427', '0', '0', '0', '0', '14', '100', '');
INSERT INTO `rrz_goods` VALUES ('12', '美术培训课程体系【2020】零基础入门班', '很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分', '4', '/storage/images/20200618/1-200211101G30-L.jpg', '/storage/images/20200618/1-200211101G30-L.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p><img src=\"/storage/images/20200618/1-200210145FV12.jpg\"/></p><p>很多童鞋觉得名词、冠词、介词代词很简单，但实际应用中，却总是丢分。这些知识琐碎难记。本课程老师通过考点梳理词义辨析、固定搭配用法、名词所有格及熟词生义的讲解，夯实同学对名词的掌握；通过对冠词考点梳理、基础用法抽象名词具体化及特殊用法的讲解，让同学充分掌握对冠词这类看似简单词类的牢固掌握；介词和代词这两类词类，老师通过具体例题对易混易错知识的讲解，帮助同学系统复习零散的知识。轻松复习，稳拿高分。</p><p><br/></p>', '  ', '4895', '1592464456', '0', '0', '0', '0', '17', '100', '');

-- ----------------------------
-- Table structure for `rrz_goods_cat`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_cat`;
CREATE TABLE `rrz_goods_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) DEFAULT '' COMMENT '分类名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '分类图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '节点深度',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类排序',
  `path` varchar(255) DEFAULT '' COMMENT '节点路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品分类';

-- -----------------------------
-- Records of `rrz_goods_cat`
-- -----------------------------
INSERT INTO `rrz_goods_cat`(`id`, `name`, `dir_name`, `parent_id`, `img`, `id_path`, `depth`, `sort`, `path`, `tmpl_path`, `tmpl_view`, `seo_title`, `seo_description`, `seo_keywords`, `uptime`)
VALUES ('1', '分类一', '', '0', '', '1', '1', '1', '1001', '', '', '', '', '', '1592477300'),
('2', '分类二', '', '0', '', '2', '1', '2', '1002', '', '', '', '', '', '1592477305'),
('3', '分类三', '', '0', '', '3', '1', '3', '1003', '', '', '', '', '', '1592477311'),
('4', '分类四', '', '0', '', '4', '1', '4', '1004', '', '', '', '', '', '1592477315');

-- ----------------------------
-- Table structure for `rrz_goods_skus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_skus`;
CREATE TABLE `rrz_goods_skus` (
  `sku_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品规格id',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '规格明细',
  PRIMARY KEY (`sku_id`) USING BTREE,
  KEY `idx_goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品规格详情';


-- ----------------------------
-- Table structure for `rrz_goods_spec_values`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_spec_values`;
CREATE TABLE `rrz_goods_spec_values` (
  `spec_value_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规格值ID',
  `spec_id` bigint(15) unsigned NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值',
  PRIMARY KEY (`spec_value_id`) USING BTREE,
  KEY `idx_spec_id` (`spec_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格值';


-- ----------------------------
-- Table structure for `rrz_goods_specification`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_specification`;
CREATE TABLE `rrz_goods_specification` (
  `spec_id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `spec_name` varchar(50) DEFAULT NULL COMMENT '规格名',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序顺序',
  PRIMARY KEY (`spec_id`) USING BTREE,
  KEY `idx_sort` (`sort`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格表';


-- ----------------------------
-- Table structure for `rrz_search_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_search_keywords`;
CREATE TABLE `rrz_search_keywords` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `keywords` text COMMENT '关键词',
  `ip` varchar(100) DEFAULT NULL COMMENT '搜索客户端的ip地址',
  `hot` int(10) unsigned DEFAULT '0' COMMENT '关键词搜索量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '搜索时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_hot` (`hot`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_site_links`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_links`;
CREATE TABLE `rrz_site_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `url` varchar(255) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) unsigned DEFAULT '0' COMMENT '是否新窗口打开',
  `email` varchar(50) DEFAULT '',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接表';

-- -----------------------------
-- Records of `rrz_site_links`
-- -----------------------------
INSERT INTO `rrz_site_links` VALUES ('1', '企业建站系统', 'http://www.rrzcms.com/', '', '100', '1', '', '', '1', 'cn', '1590481203', '1590481203');
INSERT INTO `rrz_site_links` VALUES ('2', '淘进微信', 'http://taobao.kbstore.cn/', '', '100', '1', '', '', '1', 'cn', '1590481246', '1591322028');
INSERT INTO `rrz_site_links` VALUES ('3', '人人站CMS', 'http://www.rrzcms.com/', '', '100', '1', '', '', '1', 'cn', '1590481266', '1590481266');
INSERT INTO `rrz_site_links` VALUES ('4', '百度', 'http://www.baidu.com', '', '100', '1', '', '', '1', 'cn', '1590822377', '1590822377');

-- ----------------------------
-- Table structure for `rrz_site_menus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_menus`;
CREATE TABLE `rrz_site_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单深度',
  `url` varchar(200) DEFAULT '' COMMENT '自定义链接',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '上下级路径',
  `target_blank` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '是否新开窗口',
  `config` longtext COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='导航菜单表';

-- -----------------------------
-- Records of `rrz_site_menus`
-- -----------------------------
INSERT INTO `rrz_site_menus` VALUES ('1', '关于我们', 'guanyuwomen', '0', '1', '1', '/article/53.html', '1', '1001', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('2', '培训课程', 'peixunkecheng', '0', '2', '1', '/cats.html', '2', '1002', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('3', '师资团队', 'shizituandui', '0', '3', '1', '/node/1.html', '3', '1003', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('4', '成功案例', 'chenggonganli', '0', '4', '1', '/node/2.html', '4', '1004', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('5', '在线报名', 'zaixianbaoming', '0', '5', '1', '/article/70.html', '5', '1005', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('6', '相关服务', 'xiangguanfuwu', '0', '6', '1', '/node/3.html', '6', '1006', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('7', '通知资讯', 'tongzhizixun', '0', '7', '1', '/node/4.html', '7', '1007', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('8', '联系我们', 'lianxiwomen', '0', '8', '1', '/article/69.html', '8', '1008', 'false', '');
