-- ----------------------------------------
-- RRZCMS MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.5.53
-- Database       : rrzcms
-- 
-- Part : #1
-- Version : #v1.3.5
-- Date : 2021-11-29 17:10:53
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for `rrz_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin`;
CREATE TABLE `rrz_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) unsigned DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) unsigned DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) unsigned DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- -----------------------------
-- Records of `rrz_admin`
-- -----------------------------
INSERT INTO `rrz_admin` VALUES ('1', 'admin', '', 'admin', '', '', 'e10adc3949ba59abbe56e057f20f883e', '/static/images/dfboy.png', '1638164915', '127.0.0.1', '229', '', '0', '1', 'cn', '1', '1', '1586479354', '1636420548');

-- ----------------------------
-- Table structure for `rrz_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_log`;
CREATE TABLE `rrz_admin_log` (
  `id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员日志表';


-- ----------------------------
-- Table structure for `rrz_admin_role`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_role`;
CREATE TABLE `rrz_admin_role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户角色表';

-- -----------------------------
-- Records of `rrz_admin_role`
-- -----------------------------
INSERT INTO `rrz_admin_role` VALUES ('1', '超级管理员', 'all', '管理全站');

-- ----------------------------
-- Table structure for `rrz_article_nodes`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_article_nodes`;
CREATE TABLE `rrz_article_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '栏目深度',
  `sort` smallint(6) unsigned DEFAULT '50' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章类目';

-- -----------------------------
-- Records of `rrz_article_nodes`
-- -----------------------------
INSERT INTO `rrz_article_nodes` VALUES ('1', '0', '公司简介', '', 'about', '0', '', '1', '1', '1', '1001', 'single_about', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;某某搬家公司是一家集居民搬家、企事业搬迁、商品配送、长短途运输、临时（长期）仓储、物品包装、家具拆装、钢琴搬运、重 型设备吊装，迁移，就位，小时工服务、服务器搬迁等多种项目为一体的大型搬家、物流企业。我公司在各地设有搬家分部，就近派车，方便快捷。\r\n<p>\r\n	&nbsp;</p>\r\n我们的服务宗旨：消除搬家烦恼，给客户温暖、快乐、可信赖的搬家体验。', '', 'true', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('2', '0', '核心业务', '', 'business', '0', '', '2', '1', '2', '1002', 'single_yewu', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;某某搬家公司是一家集居民搬家、企事业搬迁、商品配送、长短途运输、临时（长期）仓储、物品包装、家具拆装、钢琴搬运、重型设备吊装，迁移，就 位，小时工服务、服务器搬迁等多种项目为一体的大型搬家、物流企业。', '', 'true', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('6', '0', '居民搬家', '', 'business/jiminbanjia', '2', '/storage/images/20211129/1-1F619103053B5.jpg', '2,6', '2', '1', '10021001', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">专业精致服务，您的爱家之选</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">服务介绍</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">针对不同家庭，设计专业搬家方案，满足个性化搬家需求，让您尊享高端、精致的搬家体验。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">服务优势</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">专业团队</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">某某精品搬家团队，均为有着10年以上丰富搬家经验的专业搬家师傅。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">精细化服务</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">某某</span><span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">精品搬家设计专业搬家方案，提供打包、搬家、保洁一站式服务，让你尊享零劳累搬家。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">专业打包</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">某某</span><span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">精品搬家，免去打包劳累，根据不同物品，提供专业打包服务，保证物品在搬运过程中零损坏。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">方便快捷</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">某某</span><span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">精品搬家，客户只需告知搬出地和搬入地，把钥匙交给我们，即可实现搬家，无需现场查看、指挥，更加方便、快捷，尊享无忧型精致搬家。</span>', '', 'true', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('7', '0', '办公室搬迁', '', 'business/bangongshibanqian', '2', '/storage/images/20211129/1-1F619103342592.jpg', '2,7', '2', '2', '10021002', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">办公室搬迁</strong><span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp; &nbsp;</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">凭借您对力洋办公室搬迁的信任，助您轻松实现办公室搬运。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">服务介绍</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">力洋办公室搬迁，搬家顾问支招，相关行业专业人员进行现场勘查，综合的评估，制定个性化搬迁方案，为企事业单位量身定制的一种优质搬运服务。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">服务优势</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">专业搬家车队&nbsp;</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">力洋搬家自有专业搬家厢式货车1000多台，能承接各种规模的办公室搬迁。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">专业搬家工人</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">力洋搬家的工人师傅均为经过充分培训，有一定搬家经验的师傅，现场能熟练的进行各种拆装、搬运作业。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">专业工具</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">力洋搬家为每个车组均配有专业拆装、保护工具，能将物品损坏降到最低。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">高效现场指挥</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">办公室搬迁现场，力洋搬家主要负责人及中队干部均会提前做好搬迁部署，并亲临现场指挥协调，保证搬运效率。</span>', '', 'true', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('8', '0', '厂房搬迁', '', 'business/changfangbanqian', '2', '/storage/images/20211129/1-1F61ZRH92B.jpg', '2,8', '2', '3', '10021003', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">搬迁流程</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">充分的准备工作和标准化的操作流程是顺利搬迁的先决条件，我们经验丰富的团队会充分了解客户需求，积极完成各方沟通，顺畅梳理搬迁方案，合理制定时间计划，高效安全实施整体的搬迁流流程。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">搬迁细则</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	服务流程：上门勘查 &rarr; 报价 &rarr; 签定合同 &rarr; 对客户负责搬迁人员进行专门沟通 &rarr; 对客户设备提前一天进行包装对客户硬件设施进行保护（电梯间、地面、墙角等） &rarr; 现场运作。</p>\r\n<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	</p>\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">公司确定办公室搬迁后需要成立搬家统筹小组，合理规划、统一指挥，搬迁前会同搬迁公司给各部门主管及员工开搬迁统筹会议，告知哪部分物品需员工自行打包，哪部分由搬家公司负责，装箱规则及箱唛填写方式等，在搬家公司进场前，自行打包工作应全部完成，搬家公司会按照规划，对各部门物品打包搬运。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">专业现场督导员监督指挥整个搬迁过程，运作包含：旧址物品包装、运输、新址拆包装、包装物料清扫等步骤; &rarr; 客户验收; &rarr; 费用结算。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">注意事项</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">所有的公司文件都属于公司的内部资料，涉及公司的信息安全和经营活动，因此建议公司所有的资料由各部门员工自行整理，对于整理出来过期无用的资料要及时销毁，其他比较重要的文件资料，仔细分类装箱贴标，待到达目的地办公室后，由各部门员工自行拆包装整理。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">在搬家公司进场前，各部门务必要通知部门员工将私人财物，如首饰、手机等贵重物品随身带走，将公司的贵重物品及重要资料锁入保险柜，各部门要检查所有的办公家具，避免遗漏个人和公司的贵重物品。</span>', '', 'true', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('9', '0', '物品包装', '', 'business/wupinbaozhuang', '2', '/storage/images/20211129/1-1F61910323RL.jpg', '2,9', '2', '4', '10021004', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">凭借您对力洋物品包装的信任，让您尊享不一样的包装服务</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	不同产品包装的讲究肯定不一样。选材要针对商 品，高端的产品，包装材料一定要好，用料要细腻。中端的看成本而定。至于低端 的，以美观大方为根本，对于易碎和精密商品一定要特别保护。因为通过包装不仅 可以看到我们商铺的专业性，还可以体现我们的做事态度。</p>\r\n<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	&nbsp;</p>\r\n<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	<strong style=\"box-sizing: border-box;\">商品包装的技巧以及注意事项</strong><strong style=\"box-sizing: border-box;\">：</strong></p>\r\n<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	1.易变形、易碎的产品 这一类产品包括瓷器、玻璃饰品、CD、茶具、字画、工艺笔等。 对于这类产品，包装时要多用些报纸、泡沫塑料或者泡绵、泡沫网，这些东 西重量轻，而且可以缓和撞击。另外，一般易碎怕压的东西四周都应用填充物进行 充分填充，这些填充物也比较容易收集，比如包水果的小塑料袋、平时购物带回来 的方便袋、水果外面的泡沫软包装以及一些买电器带回来的泡沫等。尽量多用聚乙 烯的材料而少用纸壳、纸团，因为纸要重一些，而塑料的东西膨胀效果好，自身 又轻。&nbsp;<br style=\"box-sizing: border-box;\" />\r\n	<br style=\"box-sizing: border-box;\" />\r\n	2.衣服、皮包、鞋子类产品 这类产品 在包装时可以用不同种类的纸张（牛皮纸、白纸等）单独包好，以防止脏污。如 果要用报纸的话，里面还应加一层塑料袋。遇到形状不规则的商品，如皮包 等，可预先用胶带封好口，再用纸包住手提带并贴胶带固定，以减少磨损。<br style=\"box-sizing: border-box;\" />\r\n	<br style=\"box-sizing: border-box;\" />\r\n	3.首饰类产品 首饰产品一般都需要附 送首饰袋或首饰盒，选择包装要看首饰的价格以及利润空间，通过精美的首饰盒可以让你的服务显得更贴心。<br style=\"box-sizing: border-box;\" />\r\n	<br style=\"box-sizing: border-box;\" />\r\n	4.液体类 产品 邮寄液体类产品时，先用棉花裹好，再用胶带缠 好。在包裹时一定要封好割口处，可以用透明胶带使劲绕上几圈，然后再用棉花整 个包住，可以包厚一点，最后再包一层塑料袋，这样即使液体漏出来也会被棉花吸 收，并有塑料袋做最后的保护，不会流到纸盒外面污染到别人的包裹。还可以买 一些透明的气泡纸，在瓶子上多裹几圈，然后用透明胶带纸紧紧封住。为了确保 安全，应该把裹好的瓶子放进小纸箱里，同时塞些泡沫塑料或者报纸。<br style=\"box-sizing: border-box;\" />\r\n	<br style=\"box-sizing: border-box;\" />\r\n	5.书刊类 书刊类商品通常的都是牛皮纸，具体包装 ：1千克以上要打“井”字绳，否则不给邮寄。不论要不要打井字绳， 四周都要用胶带贴好，因为邮寄途中经常会有人试图打开看看，有了胶带就不容易 打开了。<br style=\"box-sizing: border-box;\" />\r\n	<br style=\"box-sizing: border-box;\" />\r\n	6.贵重的精密电子产品 贵重的精密电子产品包 括电话、手机、电脑荧屏等。在对这类怕震动的产品进行包装时，可以用泡绵、 气泡布、防静电袋等包装材料把物品包装好，用瓦楞纸在商品边角或者容易磨损的 地方加强包装保护，并且用填充物（如报纸、海绵或者防震气泡布这类有弹力的材 料）将纸箱空隙填满，这些填充物可以阻隔及支撑商品，吸收撞击力，避免物品 在纸箱中摇晃受损。</p>\r\n', '', 'true', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('10', '0', '起重搬运', '', 'business/qizhongbanyun', '2', '/storage/images/20211129/1-1F61910330BT.jpg', '2,10', '2', '5', '10021005', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">搬迁流程</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp;&nbsp; 充分的准备工作和标准化的操作流程是顺利搬迁的先决条件，我们经验丰富的团队会充分了解客户需求，积极完成各方沟通，顺畅梳理搬迁方案，合理制定时间计划，高效安全实施整体的搬迁流程。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">搬迁细则</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp; 1、所有零碎货物，我们建议客户用纸箱分类整理包装；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp; 2、了解自己/公司准备托运的详细货物，准备足够的纸箱和包装胶带；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp; 3、书/资料等不怕压的重货，用小纸箱包装并控制在20公斤左右；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp; 4、衣服和其他物品应分类码放整个纸箱，避免货物过多或过少情况；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp; 5、减少小件货物，将其集中后包装到大纸箱内&nbsp;</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp; 6、银行卡、各类证件、贵重金属、公司重要资料等，请自行保管，以免丢失；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp; 7、所有货物必须包扎结实，轻重匀开；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp; 8、提前将托运的大件物品的名称、尺寸、数量电话告知我公司，以便安排拆卸和选择适合的包装方式；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp; 9、在外包装写上，到货城市、收货人姓名、收货人联系电话。、怕压，易碎物品请单独码放。&nbsp;</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp;&nbsp; 随着起重机行业的不断发展越来越多的企业加入到起重机行业中来。高满指出，工程机械的风险包括技术风险、供求风险和经济波动风险等。当前工程机械部分产品的核心技术主要体现在总体设计和技术集成方面，如果企业不能及时研究开发新技术、新工艺及新产品，满足市场的要求，产品可能面临被淘汰的风险。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp; 由于我国工程机械行业竞争十分激烈，特别是国际工程机械巨头大举进入我国市场。与国外竞争对手相比，我国企业在产品种类、研发实力、技术水平、资本规模及品牌影响力等方面还有较大差距。此外，世界经济的波动也或将给该行业带来一定的不可控风险。工程机械行业作为基础建设项目投资拉动型行业，如果未来国民经济增长速度的放缓，起重搬运越来越占据很大的市场。&nbsp;</span>', '', 'true', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('11', '0', '长短途运输', '', 'business/changduantuyunshu', '2', '/storage/images/20211129/1-1F6191031534V.jpg', '2,11', '2', '6', '10021006', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">1、搬家说明&nbsp;</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp; 长途运输搬运不同于本市搬运，在出发地和目的地，均需提供具有统一标准的专业服务。力洋搬家公司在北京、上海、广州、深圳，及全国各大省会城市，拥有正规分支机构或资质完备的合作代理，完全有能力承接长途搬家的服务需求并令客户体验“门到门”全程如一的高水准搬家服务。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">* 富有丰富经验的高级项目顾问，亲自上门拜访，听取您个性化需求；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">* 根据您的需求，制定完备的搬家方案，并最终取得您对方案的认可；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">* 根据方案，出具详细的服务项目费用清单，确保全程无任何附加费用；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">* 提前确定包装及运输形式，确保搬家时间不拖沓；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">2、开始搬家</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; * 针对省际搬家“路途远、用时久”的特点，为实现我们向您郑重承诺的“全程无忧”，力洋搬家将为您提供详细时间表，让您随时掌握搬家最新进展；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">* “长途跋涉”会令家居物品承受一定风险，力洋搬家全程使用封闭式厢式罐车，并由经验丰富的专业包装及搬运团队，会为您的心爱之物，提供妥善措施；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">3、搬入新家</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp;&nbsp; * 搬入物品前，首先对新居进行地板、墙壁、角落的专业保护；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">* 搬入新家后，按照您的要求，确保物品完满归位；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">* 采用国际先进标准，仔细清理新居环境，确保为您还原一个舒适、熟悉的新家；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">* 可根据您及家人的需要，由力洋搬家“健康家居”服务项目，继续为您提供更为全面高端的绿色家居健康服务，详情可前往相关服务页面，了解更多内容。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">4、售后服务</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp;&nbsp; * 免费回收包装材料；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">* “零破损率”是力洋搬家的最高目标，我们采用高标准的包装技术，以确保这一目标的实现，但意外有时候难以避免，一旦发生损害赔偿问题，力洋搬家客户服务经理会及时与您联系，在收到损害赔偿报告后的2个工作日进行解决。 &nbsp;&nbsp;</span>', '', 'true', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('12', '0', '拆装家具', '', 'business/chaizhuangjiaju', '2', '/storage/images/20211129/1-1F61ZRA42c.jpg', '2,12', '2', '7', '10021007', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">凭借您对力洋拆装的信任，让您尊享不一样的拆装服务</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">服务介绍</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">在搬家或家具搬运过程中，由于电梯、门或其他各种各样的原因，家具无法直接搬运进屋，需要拆装，力洋搬家拆装队伍随时等候您的差遣，为您提供优质的家居拆装服务。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">服务优势</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">专业拆装工具</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">力洋搬家拆装队伍均配有拆装工具箱，里面包含各种家具拆装所有工具，让您尊享高效、安全的拆装服务。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">专业拆装队伍</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">力洋搬家建立了一整套家居拆装培训体系，培养了一大批专业拆装人员，让您尊享专业化家居拆装服务家居拆装培训</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">优质实惠</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">力洋搬家的搬家师傅均是经过专业培训的拆装好手，结合物品实际搬运情况，能更好的为您进行家居拆装，价格方面也更加优惠。</span>', '', 'true', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('13', '0', '钢琴搬运', '', 'business/gangqinbanyun', '2', '/storage/images/20211129/1-1F619103120295.jpg', '2,13', '2', '8', '10021008', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	钢琴是一种贵重物品，搬运起来当然比较麻烦，而且保护措施一般搬家公司无法做的很到 位。钢琴搬运不同于家具搬家，其搬运并不是普通搬运公司所能完成的，力洋搬家整合了广州各大琴行的运送队伍，旨在为您提供专业的钢琴搬运服务，让您与广州的各大琴 行共享一支优秀的钢琴搬运队队伍。</p>\r\n<strong style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">搬运流程注意事项：</strong><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">钢琴是贵重乐器，其重量一般在200公斤左右，运输时最好有外包装，在搬运过程中要根 据箱体图案的指示进行作业。搬运时要检查包装箱体是否结实，防止箱体松散造成钢琴损 坏。&nbsp;</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	钢琴主要的重量便后，即在铁排弦列部位。因此在搬运钢琴时一定要防止后倾。）。在钢琴搬运时最好不要拆下钢琴部件。如果由于搬运场地限制，最多拆 下顶盖、上门、下门和击弦机。（拆装时必须请有经验的专业人员进行）搬运时先要检查上下门轧头是否卡住，以防止跌落。</p>\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">平地推琴前进时遇到地面高低不平，切忌用力猛推，以免琴轮折断。在上下楼梯时，琴与地面的倾斜角度不要大于70度，并防止倾斜搬运。禁止钢琴露天摆放和雨天运输用户在冬天购买钢琴，应注意在打开包装箱前先将钢琴于室内静置一昼夜使琴体温度 接近室温，避免琴体温度骤然变化。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">优秀的团队保证您财产不会受丝毫损失，这也是我们的服务宗旨。有需求电话联系我们。</span>', '', 'true', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('3', '0', '案例展示', '', 'anlizhanshi', '0', '', '3', '1', '3', '1003', 'img', 'img', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;<span style=\"color: rgb(169, 169, 169); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px; text-align: center;\">我们的服务宗旨：消除搬家烦恼，给客户温暖、快乐、可信赖的搬家体验。</span>', '', 'true', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('4', '0', '搬家知识', '', 'article', '0', '', '4', '1', '4', '1004', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;我们的服务宗旨：消除搬家烦恼，给客户温暖、快乐、可信赖的搬家体验。', '', 'true', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('5', '0', '联系我们', '', 'contact', '0', '', '5', '1', '5', '1005', 'single_contact', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', 'Contact us', '    公司联系方式    联系人：张先生电话：4000-000-000/020-000000邮箱：admin@rrzcms.com地址：某某市某某区某某路某某地址', '', '<h3>    \r\n	公司联系方式</h3><p>    \r\n	联系人：张先生<br/>电话：4000-000-000/020-000000<br/>邮箱：admin@rrzcms.com<br/>地址：某某市某某区某某路某某地址</p>', '', 'true', '1638176297');
INSERT INTO `rrz_article_nodes` VALUES ('16', '0', '在线预约', '', 'contact/feedback', '5', '', '5,16', '2', '2', '10051002', 'single_feedback', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;', '', 'true', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('14', '0', '高效的服务', '', 'gaoxiaodefuwu', '0', '', '14', '1', '6', '1006', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', 'EFFICIENT SERVICE', '', '', '&nbsp;', '', 'false', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('17', '0', 'bannter', '', 'banner', '0', '', '17', '1', '7', '1007', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;', '', 'false', '1638172647');
INSERT INTO `rrz_article_nodes` VALUES ('18', '0', '我们的承诺', '', 'womendechengnuo', '0', '', '18', '1', '8', '1008', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;', '', 'true', '1638172647');

-- ----------------------------
-- Table structure for `rrz_articles`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_articles`;
CREATE TABLE `rrz_articles` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `node_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '文章配图',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `uptime` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  `pubtime` int(10) unsigned DEFAULT '0' COMMENT '文章发布时间',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '发布',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '文章创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `source` varchar(100) NOT NULL DEFAULT '' COMMENT '来源',
  `source_url` varchar(255) NOT NULL DEFAULT '' COMMENT '来源URL',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_node_id` (`node_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章';

-- -----------------------------
-- Records of `rrz_articles`
-- -----------------------------
INSERT INTO `rrz_articles` VALUES ('1', '3', '家庭搬家', '', '/storage/images/20211129/1-1F6191105150-L.png', '', '<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	力洋搬家公司是一家集居民搬家、企事业搬迁、商品配送、长短途运输、临时（长期）仓储、物品包装、家具拆装、钢琴搬运、重 型设备吊装，迁移，就位，小时工服务、服务器搬迁等多种项目为一体的大型搬家、物流企业。我公司在各地设有搬家分部，就近派车，方便快捷。</p>\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">我们的服务宗旨：消除搬家烦恼，给客户温暖、快乐、可信赖的搬家体验。</span>', '', 'admin', '', '1497841532', '1497841532', 'true', '', '力洋搬家公司是一家集居民搬家、企事业搬迁、商品配送、长短途运输、临时（长期）仓储、物品包装、家具拆装、钢琴搬运、重 型设备吊装，迁移，就位，小时工服务、服务器搬迁等', '家庭,搬家,力洋,搬家公司,是,一家,集,居民,', '170', '1497841468', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('2', '3', '物品打包', '', '/storage/images/20211129/1-1F6191340360-L.png', '', '<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	力洋搬家公司是一家集居民搬家、企事业搬迁、商品配送、长短途运输、临时（长期）仓储、物品包装、家具拆装、钢琴搬运、重 型设备吊装，迁移，就位，小时工服务、服务器搬迁等多种项目为一体的大型搬家、物流企业。我公司在各地设有搬家分部，就近派车，方便快捷。</p>\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">我们的服务宗旨：消除搬家烦恼，给客户温暖、快乐、可信赖的搬家体验。</span>', '', 'admin', '', '1497850854', '1497850854', 'true', '', '力洋搬家公司是一家集居民搬家、企事业搬迁、商品配送、长短途运输、临时（长期）仓储、物品包装、家具拆装、钢琴搬运、重 型设备吊装，迁移，就位，小时工服务、服务器搬迁等', '物品,打包,力洋,搬家公司,是,一家,集,居民,', '177', '1497850826', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('3', '3', '办公室搬迁', '', '/storage/images/20211129/1-1F6191345420-L.png', '', '<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	力洋搬家公司是一家集居民搬家、企事业搬迁、商品配送、长短途运输、临时（长期）仓储、物品包装、家具拆装、钢琴搬运、重 型设备吊装，迁移，就位，小时工服务、服务器搬迁等多种项目为一体的大型搬家、物流企业。我公司在各地设有搬家分部，就近派车，方便快捷。</p>\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">我们的服务宗旨：消除搬家烦恼，给客户温暖、快乐、可信赖的搬家体验。</span>', '', 'admin', '', '1497851155', '1497851155', 'true', '', '力洋搬家公司是一家集居民搬家、企事业搬迁、商品配送、长短途运输、临时（长期）仓储、物品包装、家具拆装、钢琴搬运、重 型设备吊装，迁移，就位，小时工服务、服务器搬迁等', '办公室,搬迁,力洋,搬家公司,是,一家,集,居民,', '192', '1497851129', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('4', '3', '居民搬家', '', '/storage/images/20211129/1-1F6191346210-L.png', '', '<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	力洋搬家公司是一家集居民搬家、企事业搬迁、商品配送、长短途运输、临时（长期）仓储、物品包装、家具拆装、钢琴搬运、重 型设备吊装，迁移，就位，小时工服务、服务器搬迁等多种项目为一体的大型搬家、物流企业。我公司在各地设有搬家分部，就近派车，方便快捷。</p>\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">我们的服务宗旨：消除搬家烦恼，给客户温暖、快乐、可信赖的搬家体验。</span>', '', 'admin', '', '1497851194', '1497851194', 'true', '', '力洋搬家公司是一家集居民搬家、企事业搬迁、商品配送、长短途运输、临时（长期）仓储、物品包装、家具拆装、钢琴搬运、重 型设备吊装，迁移，就位，小时工服务、服务器搬迁等', '居民,搬家,力洋,搬家公司,是,一家,集,居民,', '146', '1497851164', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('5', '3', '办公室搬迁2', '', '/storage/images/20211129/1-1F619134J30-L.png', '', '<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	力洋搬家公司是一家集居民搬家、企事业搬迁、商品配送、长短途运输、临时（长期）仓储、物品包装、家具拆装、钢琴搬运、重 型设备吊装，迁移，就位，小时工服务、服务器搬迁等多种项目为一体的大型搬家、物流企业。我公司在各地设有搬家分部，就近派车，方便快捷。</p>\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">我们的服务宗旨：消除搬家烦恼，给客户温暖、快乐、可信赖的搬家体验。</span>', '', 'admin', '', '1497851276', '1497851276', 'true', '', '力洋搬家公司是一家集居民搬家、企事业搬迁、商品配送、长短途运输、临时（长期）仓储、物品包装、家具拆装、钢琴搬运、重 型设备吊装，迁移，就位，小时工服务、服务器搬迁等', '办公室,搬迁,力洋,搬家公司,是,一家,集,居民,', '200', '1497851248', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('6', '3', '办公室搬迁3', '', '/storage/images/20211129/1-1F619134R70-L.png', '', '<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	力洋搬家公司是一家集居民搬家、企事业搬迁、商品配送、长短途运输、临时（长期）仓储、物品包装、家具拆装、钢琴搬运、重 型设备吊装，迁移，就位，小时工服务、服务器搬迁等多种项目为一体的大型搬家、物流企业。我公司在各地设有搬家分部，就近派车，方便快捷。</p>\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">我们的服务宗旨：消除搬家烦恼，给客户温暖、快乐、可信赖的搬家体验。</span>', '', 'admin', '', '1497851312', '1497851312', 'true', '', '力洋搬家公司是一家集居民搬家、企事业搬迁、商品配送、长短途运输、临时（长期）仓储、物品包装、家具拆装、钢琴搬运、重 型设备吊装，迁移，就位，小时工服务、服务器搬迁等', '办公室,搬迁,力洋,搬家公司,是,一家,集,居民,', '166', '1497851281', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('7', '4', '五大妙招十条原则 搬家不再是头疼事', '', '/storage/images/20211129/1-1F6191105150-L.png', '', '<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">“搬家”这个词听起来真让人头疼，如何选择搬家公司？怎么保证家里的大件、小件都能打包完好不遗漏不损坏、如何打包能最好的将所有空间利用上？搬家中出现的问题林林总总。其实，搬家小窍门是很多的，只要提前了解了，并且按照其方法去做，那么，搬家并不仅仅是顺利而已，还可能会为你节省一大笔呢！让我们一起来学习一下搬家的5大妙招10条原则，让搬家轻轻松松。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">1、怎样做到节省搬家费用?</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">要节省搬家费用，首先要选择正规的搬家公司，千万不要找街头贴小广告的搬家公司，以免被黑。事先可以咨询2～3家，从中选择一家有一定知名度或信誉较好的搬家公司。其次要做好准备工作，以免因为自己的原因造成时间或金钱上的浪费。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">2、怎样节省搬家时间?</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">要节省搬家时间，首先准备工作要充分，把所有零散东西都收进箱子或打包，化零为整。其次，可以要求搬家公司多派些人手。后，要合理安排时间和行程，错过堵车高峰和堵车路线。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">3、省心的搬家你要不要?</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">要避免大张旗鼓搬家的繁琐，好的办法是卖掉所有旧家俱和不必要的日常用品，在新家重新置办一套家俱。虽然这种做法有些奢侈，但会给您一种全新的感受。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">4、居住程流动性该怎么办?</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">有些家庭由于某种原因需要频繁搬家。对于这种家庭，好避免购买一些大件家俱，而是尽量利用房东提供的设备。搬家用过的纸箱子好不要扔掉，以备下次再用。好不要预定一些长期服务，如订报、定奶等服务，这样可以避免很多麻烦。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">5、搬家物品很多怎样避免碰撞?</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">一定要向搬家公司的人员指明哪个箱子或那件物品属于重点保护，可能的话在箱子上加醒目标识或提示语；一些易碎的物品或贵重的物品好自己搬运；亲自监督大件家用电器的搬放；有些很沉或体积庞大的家俱(如柜子、钢琴等)应该多找几个工人搬运，并有人在旁边指挥；易碎或怕压的物品应放在上边，后装车，先卸货；有些旧楼过道比较狭长，并且经常堆满杂物，要当心不要碰到邻家的东西。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">居民搬家当天需要注意什么呢?搬家过程非常的繁琐，无论是搬家前的准备还是搬家过程中的细心，以及搬家后的收拾都需要我们认真的对待。在搬家当天更是最忙上加忙的一天。为了搬家顺利，为了不损坏您的东西，也为了搬家事情简单化，10条原则一定要认真的看一看：</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">1.搬运的时候要有条不紊， 避免物品碰撞</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">2.最好是将重点保护物品加上标示，一定要向搬家公司的人指明哪个箱子或那件物品属于重点保护。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">3.对于一些易碎的物品或贵重的物品最好自己搬运。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">4.家用电器搬运的时候要格外小心，不要认为给钱一切就交给搬家公司了，自己一定要亲自监督工人轻拿轻放。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">5.事先对自己所需搬运的物品大致进行统计告诉搬运公司，以便准备好足够的人员。比如有些很沉或体积庞大的家具如柜子、钢琴等应该多找几个工人搬运，并有人在旁边组织。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">6.对于易碎或怕压的物品应放在最上边，最后装车，最先卸货。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">7.有些旧楼过道比较狭长，并且经常对满杂物，要当心不要碰到邻家的东西。&nbsp;</span>', '', 'admin', '', '1497852428', '1497852428', 'true', '', '搬家这个词听起来真让人头疼，如何选择搬家公司？怎么保证家里的大件、小件都能打包完好不遗漏不损坏、如何打包能最好的将所有空间利用上？搬家中出现的问题林林总总。其实，', '五大,妙招,十条,原则,搬家,不再,是,头疼,事,', '84', '1497852409', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('8', '4', '搬家要注意什么 有哪些注意事项？', '', '/storage/images/20211129/1-1F6191105150-L.png', '', '<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">高房价时代，很多人都买不起房子，只有租房居住。房子不是自己的，搬家换房是不可避免的。大家搬家的理由是多样化，变态的房东，嘈杂的环境，工作变动等等诸多因素导致。那我们在搬家时要注意什么呢？有哪些事项需注意？</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">第一，租房居住搬家要选对时机。一般来说，年底很多人回家过年，退租的人比较多，房子就比较便宜，这个时候搬家就比较好。节后大量人员返城，房租就比较贵，这个时候不适宜搬家。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">第二，搬家时要把房子恢复原样。租房的时候一般都会有一笔押金，退房的时候很多房东都会找借口不退还押金。作为租客一定要把房子恢复原样，让房东找不到借口。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">第三，搬家时如果找搬家公司记着找小车。现在很多广州好的搬家公司的货车都是为满足家庭搬家的，车辆都比较大，租房的人一般都没有什么家具家电，一辆小面包车就足够了，面包车比起大货车要便宜很多。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">第四，租房搬家不要购买一些大件的家具家电以及订购一些长期的服务。租房居住有很多不确定性，搬家可能性比较大，搬一次家就脱一层皮，东西多搬家不方便，费用还高，损失也会比较大。租房要尽量使用房东提供的家具家电。</span>', '', 'admin', '', '1497852453', '1497852453', 'true', '', '高房价时代，很多人都买不起房子，只有租房居住。房子不是自己的，搬家换房是不可避免的。大家搬家的理由是多样化，变态的房东，嘈杂的环境，工作变动等等诸多因素导致。那我', '搬家,要,注意,什么,有,哪些,注意事项,高房价,', '131', '1497852432', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('9', '4', '租房搬家应注意哪些问题', '', '/storage/images/20211129/1-1F6191105150-L.png', '', '<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">租房搬家是大部分人都会经历的事情，若能讲究风水，财运与事业运都会得到改善。那么，租房和搬家有哪些需要注意的问题呢？</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp; 一、租房需注意哪些问题</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">租房居住是目前很普遍的现象，不要因为是租房就觉得风水不重要，任何一所房子对居住其中的人的影响都是很大的。租的房子必然都是旧房，而且居住的人员不固定，相对于二手房，磁场就更乱了。所以，一定要注意房屋的风水朝向，选择磁场最好的房屋租赁。同一小区的房子价格有高、有低，差别可能就在于风水问题，比如有些房屋太旧，里面阴气过重。还有不要选择太过偏僻的房屋，会导致人生病或者是运势走下坡路。所以，租房时不要挑太过便宜的房子，这样的房屋风水肯定不好，反而会得不偿失。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp; 二、租房风水问题如何解决</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp; 对于那些不可逆转的租房风水问题，有哪些可以化解的方法呢？例如所租房间对着厕所，造成房门与厕所门相冲，这样厕所的秽气会直接影响到房间内。这种情况就一定要把厕所门随时保持关闭，加挂门帘，保持厕所的干净整洁。而自己房间的床铺位置要远离此地，或者做个隔断。有的租来的房间比较小，那就要勤收拾屋子，处理不必要的杂物。房内的灯光要明亮，以增加空间感觉，也有助于运势。同时，床和房门间要有足够的活动空间，不能感觉挤压。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">三、房屋风水不好，会导致家道中落</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">家道中落固然不好，却好像是没法避免的，正如俗话说的“人间没有千年富，世上哪有万年贫”。但是，房屋的风水不好的话，也会导致家道中落的加速。如果你觉得家里最近走背字儿，不妨看看是不是风水问题。比如，屋顶是不是长杂草了。因为屋顶是吸收阳光的，可以驱魔除邪，如果屋顶上长了杂草，就会影响到阳光的吸收作用，致使邪气肆虐，家道败落。同时，庭院有枯树、杂草也是衰亡的征兆，所以一定要勤打扫，以免影响家人的运气。还有，大门是家庭的第一开口，大门的设计有问题会让风水出现问题。很多人把门做得很大，和屋子不成比例，这样屋内气流无法留住。也有很多家庭喜欢供奉神位，但是神位放的地方不对也是有问题的。不要因为是神位就藏之深宅中，这样越是见不到天日，越容易导致气势衰亡。另外，要记住，祖先神位应验女性，神灵神位应验男性，要区别对待。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">四、搬家应该注意哪些问题</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">&nbsp;&nbsp;&nbsp;&nbsp; 在一个地方住得久了，大家就会想换换环境，寻找新的住宅。搬家当然是件喜事了，不过也要按风水理论来操作，搬家的时间十分重要。传统风水讲究吉时，一般说来阴历三月和七月都不适合搬家，因为，这两个月份都和“鬼”有关，一个是清明节，一个是盂兰节（中六节），搬迁容易惊动亡灵，带来麻烦。当然，现代社会没有很严格的要求，只要不在两个节日的前后一周搬家就行了。黄道吉日的选定一般是根据旧皇历的，大原则就是五行属水的日子比较好，而五行属火的日子是坚决不能搬家的。此外，还要根据屋主的生辰八字，新房子的朝向等来判断最后的黄道吉日。而入宅的时间最好在早晨和中午，夜间入住容易冲撞晦气。</span>', '', 'admin', '', '1497852476', '1497852476', 'true', '', '租房搬家是大部分人都会经历的事情，若能讲究风水，财运与事业运都会得到改善。那么，租房和搬家有哪些需要注意的问题呢？ 一、租房需注意哪些问题 租房居住是目前很普遍的现', '租房,搬家,应注意,哪些,问题,租房,搬家,是,', '157', '1497852463', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('10', '4', '寻求良好的风水格局,工厂搬家注意事项', '', '/storage/images/20211129/1-1F6191105150-L.png', '', '<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">工厂的主要目的就是招揽生意，招财，因此，工厂的风水还是很重要的，工厂搬家也并不是随便搬就可以了，也是要依据 。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">工厂搬家注意事项：</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">1、地段良否：良好的建筑物，附近的左右的建筑物是否有协调或消化，而且地段要良好，交通要便利。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">2、建筑物外观的气：如门面落落大方，外壁瓷砖颜色得体合宜，玻璃亮丽，而且建物具有高贵大方之风格。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">3、精神壁：大楼之取名宜高雅富贵，而且大楼之标志或名号，要保持清新亮丽。入门之大厅及精神壁，要立体而有朝气。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">4、室内布局：隔间要大小合宜，通路运线宜顺畅。采光宜充足，灯光除日光灯外，角落宜用灯泡辅助以使气流通全室。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">5、地下室：一般地下室较合适当仓库、工厂、餐厅，不合适设董事长室、总经理室、股票公司等。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">公司租用的办公室千万不要位于走廊的尽头，我建议最佳换一间办公室，由于位于路的的尽头是很大的忌讳，如果是写字楼做为长楼道尽头的开间则最佳设计成杂物间，卫生间，由于如果做为经营用，会代表公司发展是在一个阶段的末势，接下来会有一个崭新的开始，或者变很好或者很差。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">门对门冲突内耗多，公司选择租用一些小开间的办公室，是走廊的两端，而且是好多的同级别的部门是门对着门，这样极容易使这些部门之间产生意见冲突，出现内耗的情况，长此以往不利于公司的长远的发展。</span>', '', 'admin', '', '1497852501', '1497852501', 'true', '', '工厂的主要目的就是招揽生意，招财，因此，工厂的风水还是很重要的，工厂搬家也并不是随便搬就可以了，也是要依据 。 工厂搬家注意事项： 1、地段良否：良好的建筑物，附近的左', '寻求,良,好的,风水,格局,工厂,搬家,注意事项,', '148', '1497852488', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('11', '4', '让搬家不再烦恼的九点妙招', '', '/storage/images/20211129/1-1F6191105150-L.png', '', '<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">（一） 易碎、易损、易溢、贵重、精密及家用零散杂碎的物品要妥善装箱，并设明显标识。热水瓶、气压瓶倒净余水，冰箱水格内的水应清除。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">（二）衣柜、冰箱、书柜及较大件的家俱内的衣物物品拿出打包或装箱。玻璃组合柜、玻璃移门和玻璃搁板台板应拆卸，实在无法拆卸的可用胶带纸固定。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">（三）电视机、录像机、收录音机、影碟机、组合音响最好用原包箱包装。书画、古玩、文物、工艺品、瓷器要用纸或布包裹再装入箱内。书籍可扎成捆或装箱。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">（四）用户不必去搬家公司引车，他们会如约按登记的地址到达。车辆到后，请向搬家领班介绍需要搬走的物品及需特别注意的事项。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">（五）搬到新址后及时检查清点自己的物品，如有损坏和失少即应与领班提出索赔要求（最迟不超过24小时向搬家公司提出），并在工单上注明损坏程度和失少数量。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">（六）不必再请朋友约亲属帮忙搬，您尽可“君子动口不动手”、“袖手旁观”。装车、卸车时最好能派一人照看自己的物品，从旧址到新址用户可派一人押车及导向。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	（七）搬前请设计好您的新居家俱布放方案，以便为您大件物品一次就位。</p>\r\n<p style=\"box-sizing: border-box; margin: 0px 0px 16px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 14px; line-height: 2; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(90, 90, 90);\">\r\n	&nbsp;</p>\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">（八）凡金银、首饰、珠宝、货币、有价证券、票证、古玩、古书、字画、文件、帐册、技术资料、图表、工艺美术品、玻璃及制品和其它无法鉴定价值的物品均不属于搬家货物保险范围内。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">（九）搬家应有足够的空间，如大件物品不能搬出或搬入时，用户应事先将窗户和门卸下。楼层住户搬前应清理楼道及楼梯拐弯处堆入的杂物。您搬家时如对邻居有可能造成不便时，请打好招呼。光线不足时，请准备好临时光源。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">让搬家不再烦恼的九点妙招迁新居对于每个家庭和单位来说都是非要重要的大喜事,工作繁重而琐碎。如果大家都按照上面提出的几点注意事项去准备，我相信搬家不会再是个大烦恼，而是彻头彻尾的大喜事。</span>', '', 'admin', '', '1497852539', '1497852539', 'true', '', '（一） 易碎、易损、易溢、贵重、精密及家用零散杂碎的物品要妥善装箱，并设明显标识。热水瓶、气压瓶倒净余水，冰箱水格内的水应清除。 （二）衣柜、冰箱、书柜及较大件的家', '让,搬家,不再,烦恼,的,九点,妙招,一,易碎,、,', '73', '1497852516', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('12', '4', '搬家看力气更是技术活', '', '/storage/images/20211129/1-1F6191410230-L.jpg', '', '<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">近日，科韵路的小江乔迁新居，她的家当不多，但有一台卧式钢琴，重达310公斤，没有一个搬家公司愿意帮忙。幸好，好友帮她找到了中信搬家团队。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">搬家前，张师傅特意查看了天气预报，躲开了雨天搬运钢琴。当天，他带来三个伙计帮忙，先用软布、纸皮包好边角，检查包装箱体是否结实，防止箱体松散造成钢琴损坏。遇到门槛、台阶时，他们小心翼翼，生怕用力过猛，钢琴会震动颠簸，造成琴体倾斜、琴轮折断。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">忙了一上午，总算把钢琴运到新家，小江松了口气。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">其实，搬家不只是力气活，更是技术活，尤其是搬运衣橱柜、双开门冰箱、钢琴等大家具，够力气够细心够技巧才搞得定。为此，找个专业团队，您才能放心把贵重家具交给搬家师傅。</span>', '', 'admin', '', '1497852637', '1497852637', 'true', '', '近日，科韵路的小江乔迁新居，她的家当不多，但有一台卧式钢琴，重达310公斤，没有一个搬家公司愿意帮忙。幸好，好友帮她找到了中信搬家团队。 搬家前，张师傅特意查看了天气预', '搬家,看,力气,更是,技术,活,近日,科韵路,的,', '174', '1497852608', '0', '0', '1', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('13', '4', '搬家如何搬出吉祥 搬家仪式禁忌不可不知', '', '/storage/images/20211129/1-1F619141130595.jpg', '', '<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">传统社会，对搬家极为重视，不仅要选择一个黄道吉日，还有严格的礼仪，以确保搬入新宅后能吉祥如意、人丁兴旺、幸福安康。而现代社会，特别是在城市，这些礼仪渐渐地被人遗忘。从民俗的角度来说，很多传统习俗，虽然未被传承，但适当地了解或遵循，对搬家之后的运势会有相应的助旺功效。那么，搬家时，到底该注意哪些问题呢？</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">一、择吉日搬家</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">一般说来，搬家最好选择水日为佳，少用火日，时辰则阳日有阴时，阴日及用时。其次，新宅如果坐东，不看巳酉丑三合金局之日；坐西，不用亥卯末三合木局之日；坐南，不看申子辰三水局之日；坐北，不看寅午戌三合火局之日。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">除了与家中所有人的生肖不相冲之外，还要注意天罡四杀，和回头贡杀。所谓天罡四杀，是指寅午戌日戌时，酉丑命，辰日辰时。所谓回头贡杀，是指丑命人，不可见寅午戌四柱中三字金；戌命人，不可见酉丑四柱中三字金；未命人，不可见申子辰四柱中三字金；戌命人，不可见亥卯未四柱中三字金。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">只要合乎以上这些原则，那么，就算是理想的搬家日子。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">二、搬家旺运仪式</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">搬家时应准备的六组物品：</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">1、米：用米桶装八分满的米；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">2、红包：放在米桶的上面；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">3、箕畚和新的扫帚一对，上面绑红布；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">4、水：用水桶装三分满的水；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">5、碗筷：双数较好，放在水桶中；</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">6、火炉。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">以上这六种物品，全是每日生活必须使用的东西。搬家的时候，要先把这六样东西搬进厨房，然后，其他的东西才能搬进屋子。有些人还要带一块泥土过去，可以避免水土不服的毛病。远行出国的人，要带米和泥土，可以治水土不服的毛病，颇为灵验。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">三、要注意的搬家禁忌</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">如果家中有怀孕的女人，搬家时要特别留意，严防动了胎神，同时尽量不搬家，万一非搬不可，要让孕妇离开现场，而且在旧地方每搬动一物，先用新扫把扫一扫，如此亦可避免惊动胎神。除此之外，还有一些其他方面的禁忌：</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">1、搬家当天，不可骂小孩，不可生气。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">2、搬家当天，尽量说些吉利的话。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">3、搬家时不可和别人打招呼。</span><br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<br style=\"box-sizing: border-box; color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\" />\r\n<span style=\"color: rgb(90, 90, 90); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 25.2px;\">4、搬家当天不可在新宅午睡，否则以后容易生病。</span>', '', 'admin', '', '1497852664', '1497852664', 'true', '', '传统社会，对搬家极为重视，不仅要选择一个黄道吉日，还有严格的礼仪，以确保搬入新宅后能吉祥如意、人丁兴旺、幸福安康。而现代社会，特别是在城市，这些礼仪渐渐地被人遗忘', '搬家,如何,搬出,吉祥,仪式,禁忌,不可,不知,', '189', '1497852677', '0', '0', '1', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('14', '14', '咨询服务', '', '/storage/images/20211129/1-1F6191432250-L.png', '', '<span style=\"color: rgb(61, 60, 60); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 24px; text-align: center;\">欢迎您拨打我司24小时客服电话咨询有关搬家事宜，我司客服人员将为您细心解答所有问题，文明用语、礼貌待人；</span>', '', 'admin', '', '1497853951', '1497853951', 'true', '', '欢迎您拨打我司24小时客服电话咨询有关搬家事宜，我司客服人员将为您细心解答所有问题，文明用语、礼貌待人；', '咨询服务,欢迎,您拨,打我,司,24小时,客服,', '181', '1497853925', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('15', '14', '预约服务', '', '/storage/images/20211129/1-1F6191436220-L.png', '', '<span style=\"color: rgb(61, 60, 60); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 24px; text-align: center;\">如果您是小型搬家、学生搬家请您预约金杯车搬家；如果您是大型搬家、住宅搬家请您预约厢式货车搬家；</span>', '', 'admin', '', '1497854189', '1497854189', 'true', '', '如果您是小型搬家、学生搬家请您预约金杯车搬家；如果您是大型搬家、住宅搬家请您预约厢式货车搬家；', '预约,服务,如果,您是,小型,搬家,、,学生,请您,', '97', '1497854169', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('16', '14', '准时服务', '', '/storage/images/20211129/1-1F6191436490-L.png', '', '<span style=\"color: rgb(61, 60, 60); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 24px; text-align: center;\">准时准点到达搬家现场，高质量完成本次搬家任务，轻拿轻放，文明装卸车，为您提供安全、快捷的搬家服务；</span>', '', 'admin', '', '1497854223', '1497854223', 'true', '', '准时准点到达搬家现场，高质量完成本次搬家任务，轻拿轻放，文明装卸车，为您提供安全、快捷的搬家服务；', '准时,服务,准时,准点,到达,搬家,现场,高质量,', '64', '1497854193', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('17', '14', '勘察服务', '', '/storage/images/20211129/1-1F619143G90-L.png', '', '<h5 style=\"box-sizing: border-box; margin: 20px 0px; padding: 0px; border: 0px; font-weight: inherit; font-stretch: inherit; font-size: 20px; font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; vertical-align: baseline; color: rgb(61, 60, 60); white-space: nowrap; overflow: hidden;\">\r\n	<span style=\"font-size: 14px; line-height: 24px; text-align: center;\">选择还原服务是用户对搬家公司的最高信任，细心耐心的清洁摆放每一件细小的物品。</span></h5>\r\n', '', 'admin', '', '1497854261', '1497854261', 'true', '', '选择还原服务是用户对搬家公司的最高信任，细心耐心的清洁摆放每一件细小的物品。', '勘察,服务,选择,还原,服务,是,用户,对,', '64', '1497854232', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('18', '17', '广告1', 'http://www.rrzcms.com', '/storage/images/20211129/1-1F619152H60-L.jpg', '', '', '', 'admin', '', '1638174738', '1497857254', 'true', '', '', '广告,广告,', '96', '1497857298', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('19', '17', '广告2', 'http://www.rrzcms.com', '/storage/images/20211129/1-1F619152K30-L.jpg', '', '', '', 'admin', '', '1638174734', '1497857282', 'true', '', '', '广告,广告,', '161', '1497857261', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('20', '18', '先服务后付款', '', '/storage/images/20211129/1-1F6191105150-L.png', '', '<span style=\"color: rgb(255, 255, 255); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 18px; text-align: justify;\">保证先服务后付</span><span style=\"color: rgb(255, 255, 255); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 18px; text-align: justify;\">保证先服</span><span style=\"color: rgb(255, 255, 255); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 18px; text-align: justify;\">保证先服务后付款，中间无任何隐形收费</span><span style=\"color: rgb(255, 255, 255); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 18px; text-align: justify;\">务后付款，中间无任何隐形收费</span><span style=\"color: rgb(255, 255, 255); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 18px; text-align: justify;\">款，中间无任何</span><span style=\"color: rgb(255, 255, 255); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 18px; text-align: justify;\">保证先服务后付款，中间无任何隐形收费</span><span style=\"color: rgb(255, 255, 255); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 18px; text-align: justify;\">隐形收费</span>', '', 'admin', '', '1497860537', '1497860537', 'true', '', '保证先服务后付 保证先服 保证先服务后付款，中间无任何隐形收费 务后付款，中间无任何隐形收费 款，中间无任何 保证先服务后付款，中间无任何隐形收费 隐形收费', '先,服务,后付款,保证,先,服务,后付,先服,', '144', '1497860508', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('21', '18', '安全高效', '', '/storage/images/20211129/1-1F6191105150-L.png', '', '<span style=\"color: rgb(255, 255, 255); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 18px; text-align: justify;\">保证客户指定时间内安全高效完成服务</span>', '', 'admin', '', '1497860568', '1497860568', 'true', '', '保证客户指定时间内安全高效完成服务', '安全,高效,保证,客户,指,定时,间内,安全,高效,', '193', '1497860540', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('22', '18', '先服务后付款不甩单', '', '/storage/images/20211129/1-1F6191105150-L.png', '', '<span style=\"color: rgb(255, 255, 255); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 18px; text-align: justify;\">保证接单后不无缘无故取消订单，不会甩单</span>', '', 'admin', '', '1497860616', '1497860616', 'true', '', '保证接单后不无缘无故取消订单，不会甩单', '先,服务,后付款,不甩,单,保证,接单,后,不,', '84', '1497860580', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('23', '18', '费用低', '', '/storage/images/20211129/1-1F6191105150-L.png', '', '<span style=\"color: rgb(255, 255, 255); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 18px; text-align: justify;\">保证收费标准不比同行高</span>', '', 'admin', '', '1497860934', '1497860934', 'true', '', '保证收费标准不比同行高', '费用低,保证,收费标准,不比,同行,高,', '149', '1497860923', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('24', '18', '款损坏率低', '', '/storage/images/20211129/1-1F6191105150-L.png', '', '<p>\r\n	<span style=\"color: rgb(255, 255, 255); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 18px; text-align: justify;\">搬迁过程中零投诉、零损坏率、零丢失率</span></p>\r\n', '', 'admin', '', '1497860976', '1497860976', 'true', '', '搬迁过程中零投诉、零损坏率、零丢失率', '款,损坏率,低,搬迁,过程中,零,投诉,、,损坏率,', '162', '1497860944', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('25', '18', '时间：延时赔款', '', '/storage/images/20211129/1-1F6191105150-L.png', '', '<span style=\"color: rgb(255, 255, 255); font-family: 微软雅黑, arail, \'Microsoft YaHei\', Tahoma, Verdana, Simsun; font-size: 14px; line-height: 18px; text-align: justify;\">搬家延误1小时赔偿客户50元，延误2小时赔偿客户100元</span>', '', 'admin', '', '1497860999', '1497860999', 'true', '', '搬家延误1小时赔偿客户50元，延误2小时赔偿客户100元', '时间,延时,赔款,搬家,延误,1小时,赔偿,客户,', '119', '1497860987', '0', '0', '0', '100', '未知', '');

-- ----------------------------
-- Table structure for `rrz_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channelfield`;
CREATE TABLE `rrz_channelfield` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `channel_type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` longtext COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `ifrequire` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `sort` int(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='自定义字段表';


-- ----------------------------
-- Table structure for `rrz_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channeltype`;
CREATE TABLE `rrz_channeltype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章（产品）类型';


-- ----------------------------
-- Table structure for `rrz_config`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_config`;
CREATE TABLE `rrz_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置内容',
  `type` varchar(64) DEFAULT '' COMMENT '类型',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0：否，1：是）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统配置表';

-- -----------------------------
-- Records of `rrz_config`
-- -----------------------------
INSERT INTO `rrz_config` VALUES ('1', 'status', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('2', 'name', '某某网站', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('3', 'logo', '/storage/images/20211129/logo.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('4', 'wap_logo', '/storage/images/20211129/logo.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('5', 'favicon', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('6', 'copyright', 'Copyright © 2012-2050 某某网站 版权所有', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('7', 'recordnum', 'ICP备*******号', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('8', 'title', '响应式搬家家政服务类网站人人站模板(自适应手机端)', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('9', 'keywords', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('10', 'description', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('49', 'hide_plugin', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('11', 'is_authorization', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('12', 'authortoken_code', '1e71ca64986dec963bd66fb3663077d3', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('13', 'popup_upgrade', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('14', 'wap_domain', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('15', 'is_https', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('16', 'logo', '/static/images/logo.png', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('17', 'sqldatapath', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('18', 'expiretime', '3600', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('19', 'name', '某某某公司', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('20', 'telephone', '020-00000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('21', 'fax', '020-00000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('22', 'qq', '00000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('23', 'email', 'email@rrzcms.com', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('24', 'addr', '某某省某某市某某区某某地', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('25', 'coord', '39.903970449129694,116.39786991534426', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('26', 'thirdcode_pc', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('27', 'thirdcode_wap', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('28', 'inlet', '2', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('29', 'auto', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('30', 'filter_isurl', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('31', 'type', 'xml', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('32', 'index_changefreq', 'always', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('33', 'list_changefreq', 'hourly', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('34', 'view_changefreq', 'daily', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('35', 'index_priority', '1.0', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('36', 'list_priority', '0.8', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('37', 'view_priority', '0.5', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('38', 'articles_num', '100', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('39', 'zzbaidutoken', '', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('40', 'app_map', 'admin', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('41', 'status', '1', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('42', 'replace', '国家级|国际级|世界级|宇宙级|千万级|百万级|星级|甲级|超甲级|完美|唯一|一流|精确|顶级|顶尖|尖端|最|国际级产品|填补国内空白|带头|首个|首次|首发|首款|首家|首选|金牌|名牌|优秀|顶级|独家|唯独|独有|独创|独据|开发者|缔造者|创始|发明者|领先|领头|领导|领跑|领袖|领先|引领|创领|领航|权威|先进|耀领|缔造者|极品|极佳|顶级|尖端|顶尖|终极|绝佳|绝对|绝版|终极|极致|极具|王牌|冠军|第一|极致|永久|王牌|掌门人|领袖|独一无二|绝无仅有|前无古人|史无前例|万能|绝对|绝顶|大牌|精确|超赚|巨星|至尊|巅峰|之王|巨星|王者|冠军|资深|至尊|著名|奢侈|百分之百|国家级产品|国家免检|国家领导人|填补国内空白|史无前例|前无古人|永久|永远|万能|祖传|特效|无敌|纯天然|超赚|国际品质|专家推荐|超强|全面|全网|随时结束|仅此一次|空前绝后|随时涨价|马上降价|最后一波|包治百病|药到病除|特供|专供|专家推荐|畅销|全效|标杆|精确|优秀|仅此|遥遥|高档|真皮|超赚|精准|指定|特供|专供|军方|军事|国旗|国徽|党旗|驰名|秒杀|一步到位|', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('43', 'connector_title', '_', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('44', 'list_title', '2', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('45', 'view_title', '3', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('46', 'mobile', '1300000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('47', 'wx', 'wx000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('48', 'qrcode', 'http://g.kbscdn.cn/kbcms/Public/images/wxaqrrrz.png', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('50', 'url_suffix', 'html', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('51', 'nav_hide_suffix', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('52', 'url_level_dir', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('53', 'app_debug', '2', 'admin', '', 'cn', '0');

-- ----------------------------
-- Table structure for `rrz_form_data`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_form_data`;
CREATE TABLE `rrz_form_data` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `form_id` int(10) unsigned DEFAULT '0' COMMENT '表单ID',
  `form_name` varchar(255) DEFAULT '' COMMENT '表单名称',
  `content` longtext COMMENT '提交内容',
  `ip` varchar(255) DEFAULT '' COMMENT '提交人IP',
  `add_time` int(10) unsigned DEFAULT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_forms`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_forms`;
CREATE TABLE `rrz_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `config` longtext COMMENT '表单配置',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '删除(0=否，1=是)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_is_del` (`is_del`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- -----------------------------
-- Records of `rrz_forms`
-- -----------------------------
INSERT INTO `rrz_forms` VALUES ('1', '在线留言', 'a:4:{i:0;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"姓名\";s:8:\"required\";i:1;}i:1;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"电话\";s:8:\"required\";i:1;}i:2;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"邮箱\";s:8:\"required\";i:1;}i:3;a:3:{s:4:\"type\";s:8:\"textarea\";s:4:\"name\";s:6:\"内容\";s:8:\"required\";i:0;}}', '1638173754', '0');

-- ----------------------------
-- Table structure for `rrz_goods`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods`;
CREATE TABLE `rrz_goods` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `brief` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '商品简介',
  `cat_id` mediumint(8) unsigned DEFAULT NULL COMMENT '产品分类id',
  `brand_id` int(10) unsigned DEFAULT '0' COMMENT '产品品牌id',
  `def_img` varchar(500) DEFAULT '' COMMENT '产品默认图片路径',
  `imgs` longtext COMMENT '产品图片集合',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `del_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品划线价格',
  `store` int(8) unsigned DEFAULT '0' COMMENT '产品库存',
  `is_presell` enum('true','false') DEFAULT 'false' COMMENT '是否预售（是否定金付款）',
  `presell_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '预售价格（定金）',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '产品规格',
  `content` longtext COMMENT '产品详情',
  `wap_content` longtext COMMENT '手机端详情',
  `sales` int(11) unsigned DEFAULT '0' COMMENT '产品销量',
  `addtime` int(11) unsigned DEFAULT '0' COMMENT '创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_news` tinyint(1) unsigned DEFAULT '0' COMMENT '新品（0=否，1=是）',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '上架',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cat_id` (`cat_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_is_news` (`is_news`) USING BTREE,
  KEY `idx_brand_id` (`brand_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品管理';


-- ----------------------------
-- Table structure for `rrz_goods_attr`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attr`;
CREATE TABLE `rrz_goods_attr` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_value` text COMMENT '属性值',
  `attr_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `goods_id` (`goods_id`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性关联表';


-- ----------------------------
-- Table structure for `rrz_goods_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attribute`;
CREATE TABLE `rrz_goods_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型（0 单行文本框 1下拉式列表 2多行文本框）',
  `values` text COMMENT '属性值集合',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性';


-- ----------------------------
-- Table structure for `rrz_goods_brand`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_brand`;
CREATE TABLE `rrz_goods_brand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌表',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌logo',
  `desc` text COMMENT '备注介绍',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌地址',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品品牌';


-- ----------------------------
-- Table structure for `rrz_goods_cat`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_cat`;
CREATE TABLE `rrz_goods_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) DEFAULT '' COMMENT '分类名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '分类英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '分类图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '节点深度',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类排序',
  `path` varchar(255) DEFAULT '' COMMENT '节点路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `attrs` longtext COMMENT '参数列表',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品分类';


-- ----------------------------
-- Table structure for `rrz_goods_skus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_skus`;
CREATE TABLE `rrz_goods_skus` (
  `sku_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品规格id',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '规格明细',
  PRIMARY KEY (`sku_id`) USING BTREE,
  KEY `idx_goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品规格详情';


-- ----------------------------
-- Table structure for `rrz_goods_spec_values`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_spec_values`;
CREATE TABLE `rrz_goods_spec_values` (
  `spec_value_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规格值ID',
  `spec_id` bigint(15) unsigned NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值',
  PRIMARY KEY (`spec_value_id`) USING BTREE,
  KEY `idx_spec_id` (`spec_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格值';


-- ----------------------------
-- Table structure for `rrz_goods_specification`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_specification`;
CREATE TABLE `rrz_goods_specification` (
  `spec_id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `spec_name` varchar(50) DEFAULT NULL COMMENT '规格名',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序顺序',
  PRIMARY KEY (`spec_id`) USING BTREE,
  KEY `idx_sort` (`sort`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格表';


-- ----------------------------
-- Table structure for `rrz_plugin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_plugin`;
CREATE TABLE `rrz_plugin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `version` varchar(20) NOT NULL DEFAULT '' COMMENT '版本号',
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '作者',
  `isadmin` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否存在后台（0否1是）',
  `ishome` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否存在前台（0否1是）',
  `isload` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动加载（0手动加载、1自动加载）',
  `loadtemp` text COMMENT '自动加载在指定模板，空白默认全部',
  `config` text COMMENT '额外参数',
  `data` text COMMENT '配置存储数据，简单插件可以不创建表',
  `saflag` varchar(500) DEFAULT NULL COMMENT '标示内容',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0未安装、1启用、2禁用）',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='插件表';


-- ----------------------------
-- Table structure for `rrz_search_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_search_keywords`;
CREATE TABLE `rrz_search_keywords` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `keywords` text COMMENT '关键词',
  `type` varchar(50) DEFAULT 'article' COMMENT '搜索类型',
  `ip` varchar(100) DEFAULT NULL COMMENT '搜索客户端的ip地址',
  `hot` int(10) unsigned DEFAULT '0' COMMENT '关键词搜索量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '搜索时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_hot` (`hot`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_site_links`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_links`;
CREATE TABLE `rrz_site_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `url` varchar(255) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) unsigned DEFAULT '0' COMMENT '是否新窗口打开',
  `email` varchar(50) DEFAULT '',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接表';

-- -----------------------------
-- Records of `rrz_site_links`
-- -----------------------------
INSERT INTO `rrz_site_links` VALUES ('1', '企业建站系统', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481203', '1627543172');
INSERT INTO `rrz_site_links` VALUES ('2', '淘进微信', 'http://taobao.kbstore.cn/', 'http://taobao.kbstore.cn/Public/images/logo-1.png', '100', '1', '', '', '1', 'cn', '1590481246', '1627543144');
INSERT INTO `rrz_site_links` VALUES ('3', '人人站CMS', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481266', '1627543178');
INSERT INTO `rrz_site_links` VALUES ('4', '抖进微信', 'http://dou.kbstore.cn/', 'http://dou.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244482', '1627543197');
INSERT INTO `rrz_site_links` VALUES ('5', '淘进微博', 'http://weibo.kbstore.cn/', 'http://weibo.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244551', '1631698452');

-- ----------------------------
-- Table structure for `rrz_site_menus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_menus`;
CREATE TABLE `rrz_site_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `en_title` varchar(100) NOT NULL DEFAULT '' COMMENT '英文标题',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单深度',
  `url` varchar(200) DEFAULT '' COMMENT '自定义链接',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '上下级路径',
  `target_blank` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '是否新开窗口',
  `config` longtext COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='导航菜单表';

-- -----------------------------
-- Records of `rrz_site_menus`
-- -----------------------------
INSERT INTO `rrz_site_menus` VALUES ('1', '首页', 'Home', 'index', '0', '1', '1', '/', '1', '1001', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('2', '公司简介', '', 'about', '0', '2', '1', '/node/1.html', '2', '1002', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('3', '核心业务', '', 'business', '0', '3', '1', '/node/2.html', '3', '1003', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('4', '案例展示', '', 'anlizhanshi', '0', '4', '1', '/node/3.html', '4', '1004', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('5', '搬家知识', '', 'article', '0', '5', '1', '/node/4.html', '5', '1005', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('6', '联系我们', '', 'contact', '0', '6', '1', '/node/5.html', '6', '1006', 'false', '');
