# Overview

Credo is a static code analysis tool for the Elixir language with a focus on teaching and code consistency.

![Credo](https://raw.github.com/rrrene/credo/master/assets/screenshot.png)

`credo` can show you refactoring opportunities in your code, complex code fragments, warn you about common mistakes, show inconsistencies in your naming scheme and - if needed - help you enforce a desired coding style.

The basic functionality will be familiar to you if you used a linter like JavaScript's [ESLint](https://eslint.org/), Ruby's [RuboCop](https://github.com/rubocop-hq/rubocop) or C#'s [Stylecop](https://github.com/StyleCop/StyleCop) before.

Contrary to the aforementioned tools, Credo puts a strong emphasis on teaching and code consistency.

To get started, you might want to check out these guides:

* [Installation](../introduction/installation.md)
* [Basic usage](../introduction/basic_usage.md)
* [Configuration via `.credo.exs`](../configuration/config_file.md)

Once you are familiar with the basics, look into these topics:

* [Adding custom checks](../custom_checks/adding_checks.md)
* [Testing custom checks](../custom_checks/testing_checks.md)
* [Plugins](../plugins/creating_plugins.md)

Any incorrect or unclear information in these docs should be considered a bug.
In case you find something, you can help maintaining these docs by [filing an issue on GitHub](https://github.com/rrrene/credo/issues) and/or opening a pull request.
