// Arduino9x_RX
// -*- mode: C++ -*-
// Example sketch showing how to create a simple messaging client (receiver)
// with the RH_RF95 class. RH_RF95 class does not provide for addressing or
// reliability, so you should only use RH_RF95 if you do not need the higher
// level messaging abilities.
// It is designed to work with the other example Arduino9x_TX

#if (ARDUINO >= 100)
#include <Arduino.h>
#else
#include <WProgram.h>
#endif

#include <stdlib.h> 
#include <SPI.h>
#include <RHRouter.h>
#include <RHMesh.h>
#include <RH_RF95.h>
#include <EEPROM.h>
 
#define RH_HAVE_SERIAL
#define LED 9
#define N_NODES 3

/*// Arduino
#define RFM95_CS 10
#define RFM95_RST 9
#define RFM95_INT 2 //*/

// ESP32
#define RFM95_CS 5
#define RFM95_RST 14
#define RFM95_INT 2 //*/

// Change to 434.0 or other frequency, must match RX's freq!
#define RF95_FREQ 915.0
 
// Singleton instance of the radio driver
RH_RF95 rf95(RFM95_CS, RFM95_INT);
 
uint8_t nodeId;
uint8_t routes[N_NODES]; // full routing table for mesh
int16_t rssi[N_NODES]; // signal strength info

// Singleton instance of the radio driver

// Class to manage message delivery and receipt, using the driver declared above
RHMesh *manager;

// message buffer
char buf[RH_MESH_MAX_MESSAGE_LEN];

// int freeMem() {
//   extern int __heap_start, *__brkval;
//   int v;
//   return (int) &v - (__brkval == 0 ? (int) &__heap_start : (int) __brkval);
// }

void setup() {
  randomSeed(analogRead(0));
  pinMode(LED, OUTPUT);
  Serial.begin(115200);
  while (!Serial) ; // Wait for serial port to be available

  nodeId = EEPROM.read(0);
  if (nodeId > 10) { // ROY: maksimal 10 node, ubah bagian ini kalau butuh lebih banyak
    Serial.print(F("EEPROM nodeId invalid: "));
    Serial.println(nodeId);
    nodeId = 1;
  }
  Serial.print(F("initializing node "));
  Serial.print((String) nodeId);
  Serial.print(" ");

  manager = new RHMesh(rf95, nodeId);

  if (!manager->init()) {
    Serial.println(F("init failed"));
  } else {
    Serial.println("done");
  }
  rf95.setTxPower(23, false);
  rf95.setFrequency(RF95_FREQ);
  rf95.setCADTimeout(500);

  // Possible configurations:
  // Bw125Cr45Sf128 (the chip default)
  // Bw500Cr45Sf128
  // Bw31_25Cr48Sf512
  // Bw125Cr48Sf4096

  // long range configuration requires for on-air time
  boolean longRange = false;
  if (longRange) {
    RH_RF95::ModemConfig modem_config = {
      0x78, // Reg 0x1D: BW=125kHz, Coding=4/8, Header=explicit
      0xC4, // Reg 0x1E: Spread=4096chips/symbol, CRC=enable
      0x08  // Reg 0x26: LowDataRate=On, Agc=Off.  0x0C is LowDataRate=ON, ACG=ON
    };
    rf95.setModemRegisters(&modem_config);
    /* // error, jadi di sembunyikan terlebih dahulu
    if (!rf95.setModemConfig(RH_RF95::Bw125Cr48Sf 4096)) {
      Serial.println(F("set config failed"));
    }*/
  }

  Serial.println("RF95 ready");

  // kosongkan table
  for(uint8_t n=1;n<=N_NODES;n++) {
    routes[n-1] = 0;
    rssi[n-1] = 0;
  }

  // Serial.print(F("mem = "));
  // Serial.println(freeMem());
}

const __FlashStringHelper* getErrorString(uint8_t error) {
  switch(error) {
    case 1: return F("invalid length");
    break;
    case 2: return F("no route");
    break;
    case 3: return F("timeout");
    break;
    case 4: return F("no reply");
    break;
    case 5: return F("unable to deliver");
    break;
  }
  return F("unknown");
}

void updateRoutingTable() {
  for(uint8_t n=1;n<=N_NODES;n++) {
    RHRouter::RoutingTableEntry *route = manager->getRouteTo(n);
    Serial.println("ROY:Sentinel Checkpoint");
  while(1);
    if (n == nodeId) {
      routes[n-1] = 255; // self
    } else {
      routes[n-1] = route->next_hop;
      if (routes[n-1] == 0) {
        // if we have no route to the node, reset the received signal strength
        rssi[n-1] = 0;
      }
    }
  }
}

// Create a JSON string with the routing info to each node
void getRouteInfoString(char *p, size_t len) {
  p[0] = '\0';
  strcat(p, "[");
  for(uint8_t n=1;n<=N_NODES;n++) {
    strcat(p, "{\"n\":");
    sprintf(p+strlen(p), "%d", routes[n-1]);
    strcat(p, ",");
    strcat(p, "\"r\":");
    sprintf(p+strlen(p), "%d", rssi[n-1]);
    strcat(p, "}");
    if (n<N_NODES) {
      strcat(p, ",");
    }
  }
  strcat(p, "]");
}

void printNodeInfo(uint8_t node, char *s) {
  Serial.print(F("node: "));
  Serial.print(F("{"));
  Serial.print(F("\""));
  Serial.print(node);
  Serial.print(F("\""));
  Serial.print(F(": "));
  Serial.print(s);
  Serial.println(F("}"));
}

void loop() {

  for(uint8_t n=1;n<=N_NODES;n++) { // ROY: iterasi untuk memeriksa semua node
    if (n == nodeId) continue; // self

    updateRoutingTable();
    getRouteInfoString(buf, RH_MESH_MAX_MESSAGE_LEN);

    Serial.print(F("->"));
    Serial.print(n);
    Serial.print(F(" :"));
    Serial.print(buf);

    // // send an acknowledged message to the target node
    // uint8_t error = manager->sendtoWait((uint8_t *)buf, strlen(buf), n);
    // if (error != RH_ROUTER_ERROR_NONE) {
    //   Serial.println();
    //   Serial.print(F(" ! "));
    //   Serial.println(getErrorString(error));
    // } else {
    //   Serial.println(F(" OK"));
    //   // we received an acknowledgement from the next hop for the node we tried to send to.
    //   RHRouter::RoutingTableEntry *route = manager->getRouteTo(n);
    //   if (route->next_hop != 0) {
    //     rssi[route->next_hop-1] = rf95.lastRssi();
    //   }
    // }
    // if (nodeId == 1) printNodeInfo(nodeId, buf); // debugging

    // // listen for incoming messages. Wait a random amount of time before we transmit again to the next node
    // unsigned long nextTransmit = millis() + random(3000, 5000);
    // while (nextTransmit > millis()) {
    //   int waitTime = nextTransmit - millis();
    //   uint8_t len = sizeof(buf);
    //   uint8_t from;
    //   if (manager->recvfromAckTimeout((uint8_t *)buf, &len, waitTime, &from)) {
    //     buf[len] = '\0'; // null terminate string
    //     Serial.print(from);
    //     Serial.print(F("->"));
    //     Serial.print(F(" :"));
    //     Serial.println(buf);
    //     if (nodeId == 1) printNodeInfo(from, buf); // debugging
    //     // we received data from node 'from', but it may have actually come from an intermediate node
    //     RHRouter::RoutingTableEntry *route = manager->getRouteTo(from);
    //     if (route->next_hop != 0) {
    //       rssi[route->next_hop-1] = rf95.lastRssi();
    //     }
    //   }
    // }
  }
}
