// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    /// <summary>
    /// Represents a thread that contains [messages](/docs/api-reference/messages).
    /// </summary>
    internal class ThreadObject : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>The Unix timestamp (in seconds) for when the thread was created.</summary>
        public int? CreatedAt { get; set; }
        /// <summary>The identifier, which can be referenced in API endpoints.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Id { get; set; }
#nullable restore
#else
        public string Id { get; set; }
#endif
        /// <summary>Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public ThreadObject_metadata? Metadata { get; set; }
#nullable restore
#else
        public ThreadObject_metadata Metadata { get; set; }
#endif
        /// <summary>The object type, which is always `thread`.</summary>
        public ThreadObject_object? Object { get; set; }
        /// <summary>
        /// Instantiates a new ThreadObject and sets the default values.
        /// </summary>
        public ThreadObject() {
            AdditionalData = new Dictionary<string, object>();
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static ThreadObject CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new ThreadObject();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"created_at", n => { CreatedAt = n.GetIntValue(); } },
                {"id", n => { Id = n.GetStringValue(); } },
                {"metadata", n => { Metadata = n.GetObjectValue<ThreadObject_metadata>(ThreadObject_metadata.CreateFromDiscriminatorValue); } },
                {"object", n => { Object = n.GetEnumValue<ThreadObject_object>(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteIntValue("created_at", CreatedAt);
            writer.WriteStringValue("id", Id);
            writer.WriteObjectValue<ThreadObject_metadata>("metadata", Metadata);
            writer.WriteEnumValue<ThreadObject_object>("object", Object);
            writer.WriteAdditionalData(AdditionalData);
        }
    }
}

