// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    /// <summary>
    /// Represents an execution run on a [thread](/docs/api-reference/threads).
    /// </summary>
    internal class RunObject : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>The ID of the [assistant](/docs/api-reference/assistants) used for execution of this run.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? AssistantId { get; set; }
#nullable restore
#else
        public string AssistantId { get; set; }
#endif
        /// <summary>The Unix timestamp (in seconds) for when the run was cancelled.</summary>
        public int? CancelledAt { get; set; }
        /// <summary>The Unix timestamp (in seconds) for when the run was completed.</summary>
        public int? CompletedAt { get; set; }
        /// <summary>The Unix timestamp (in seconds) for when the run was created.</summary>
        public int? CreatedAt { get; set; }
        /// <summary>The Unix timestamp (in seconds) for when the run will expire.</summary>
        public int? ExpiresAt { get; set; }
        /// <summary>The Unix timestamp (in seconds) for when the run failed.</summary>
        public int? FailedAt { get; set; }
        /// <summary>The list of [File](/docs/api-reference/files) IDs the [assistant](/docs/api-reference/assistants) used for this run.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<string>? FileIds { get; set; }
#nullable restore
#else
        public List<string> FileIds { get; set; }
#endif
        /// <summary>The identifier, which can be referenced in API endpoints.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Id { get; set; }
#nullable restore
#else
        public string Id { get; set; }
#endif
        /// <summary>The instructions that the [assistant](/docs/api-reference/assistants) used for this run.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Instructions { get; set; }
#nullable restore
#else
        public string Instructions { get; set; }
#endif
        /// <summary>The last error associated with this run. Will be `null` if there are no errors.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public RunObject_last_error? LastError { get; set; }
#nullable restore
#else
        public RunObject_last_error LastError { get; set; }
#endif
        /// <summary>Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public RunObject_metadata? Metadata { get; set; }
#nullable restore
#else
        public RunObject_metadata Metadata { get; set; }
#endif
        /// <summary>The model that the [assistant](/docs/api-reference/assistants) used for this run.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Model { get; set; }
#nullable restore
#else
        public string Model { get; set; }
#endif
        /// <summary>The object type, which is always `thread.run`.</summary>
        public RunObject_object? Object { get; set; }
        /// <summary>Details on the action required to continue the run. Will be `null` if no action is required.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public RunObject_required_action? RequiredAction { get; set; }
#nullable restore
#else
        public RunObject_required_action RequiredAction { get; set; }
#endif
        /// <summary>The Unix timestamp (in seconds) for when the run was started.</summary>
        public int? StartedAt { get; set; }
        /// <summary>The status of the run, which can be either `queued`, `in_progress`, `requires_action`, `cancelling`, `cancelled`, `failed`, `completed`, or `expired`.</summary>
        public RunObject_status? Status { get; set; }
        /// <summary>The ID of the [thread](/docs/api-reference/threads) that was executed on as a part of this run.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? ThreadId { get; set; }
#nullable restore
#else
        public string ThreadId { get; set; }
#endif
        /// <summary>The list of tools that the [assistant](/docs/api-reference/assistants) used for this run.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<RunObject_tools>? Tools { get; set; }
#nullable restore
#else
        public List<RunObject_tools> Tools { get; set; }
#endif
        /// <summary>
        /// Instantiates a new RunObject and sets the default values.
        /// </summary>
        public RunObject() {
            AdditionalData = new Dictionary<string, object>();
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static RunObject CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new RunObject();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"assistant_id", n => { AssistantId = n.GetStringValue(); } },
                {"cancelled_at", n => { CancelledAt = n.GetIntValue(); } },
                {"completed_at", n => { CompletedAt = n.GetIntValue(); } },
                {"created_at", n => { CreatedAt = n.GetIntValue(); } },
                {"expires_at", n => { ExpiresAt = n.GetIntValue(); } },
                {"failed_at", n => { FailedAt = n.GetIntValue(); } },
                {"file_ids", n => { FileIds = n.GetCollectionOfPrimitiveValues<string>()?.ToList(); } },
                {"id", n => { Id = n.GetStringValue(); } },
                {"instructions", n => { Instructions = n.GetStringValue(); } },
                {"last_error", n => { LastError = n.GetObjectValue<RunObject_last_error>(RunObject_last_error.CreateFromDiscriminatorValue); } },
                {"metadata", n => { Metadata = n.GetObjectValue<RunObject_metadata>(RunObject_metadata.CreateFromDiscriminatorValue); } },
                {"model", n => { Model = n.GetStringValue(); } },
                {"object", n => { Object = n.GetEnumValue<RunObject_object>(); } },
                {"required_action", n => { RequiredAction = n.GetObjectValue<RunObject_required_action>(RunObject_required_action.CreateFromDiscriminatorValue); } },
                {"started_at", n => { StartedAt = n.GetIntValue(); } },
                {"status", n => { Status = n.GetEnumValue<RunObject_status>(); } },
                {"thread_id", n => { ThreadId = n.GetStringValue(); } },
                {"tools", n => { Tools = n.GetCollectionOfObjectValues<RunObject_tools>(RunObject_tools.CreateFromDiscriminatorValue)?.ToList(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteStringValue("assistant_id", AssistantId);
            writer.WriteIntValue("cancelled_at", CancelledAt);
            writer.WriteIntValue("completed_at", CompletedAt);
            writer.WriteIntValue("created_at", CreatedAt);
            writer.WriteIntValue("expires_at", ExpiresAt);
            writer.WriteIntValue("failed_at", FailedAt);
            writer.WriteCollectionOfPrimitiveValues<string>("file_ids", FileIds);
            writer.WriteStringValue("id", Id);
            writer.WriteStringValue("instructions", Instructions);
            writer.WriteObjectValue<RunObject_last_error>("last_error", LastError);
            writer.WriteObjectValue<RunObject_metadata>("metadata", Metadata);
            writer.WriteStringValue("model", Model);
            writer.WriteEnumValue<RunObject_object>("object", Object);
            writer.WriteObjectValue<RunObject_required_action>("required_action", RequiredAction);
            writer.WriteIntValue("started_at", StartedAt);
            writer.WriteEnumValue<RunObject_status>("status", Status);
            writer.WriteStringValue("thread_id", ThreadId);
            writer.WriteCollectionOfObjectValues<RunObject_tools>("tools", Tools);
            writer.WriteAdditionalData(AdditionalData);
        }
        /// <summary>
        /// Composed type wrapper for classes AssistantToolsCode, AssistantToolsFunction, AssistantToolsRetrieval
        /// </summary>
        internal class RunObject_tools : IComposedTypeWrapper, IParsable {
            /// <summary>Composed type representation for type AssistantToolsCode</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsCode? AssistantToolsCode { get; set; }
#nullable restore
#else
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsCode AssistantToolsCode { get; set; }
#endif
            /// <summary>Composed type representation for type AssistantToolsFunction</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsFunction? AssistantToolsFunction { get; set; }
#nullable restore
#else
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsFunction AssistantToolsFunction { get; set; }
#endif
            /// <summary>Composed type representation for type AssistantToolsRetrieval</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsRetrieval? AssistantToolsRetrieval { get; set; }
#nullable restore
#else
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsRetrieval AssistantToolsRetrieval { get; set; }
#endif
            /// <summary>
            /// Creates a new instance of the appropriate class based on discriminator value
            /// </summary>
            /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
            public static RunObject_tools CreateFromDiscriminatorValue(IParseNode parseNode) {
                _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
                var mappingValue = parseNode.GetChildNode("")?.GetStringValue();
                var result = new RunObject_tools();
                if("AssistantToolsCode".Equals(mappingValue, StringComparison.OrdinalIgnoreCase)) {
                    result.AssistantToolsCode = new OpenAI.GeneratedKiotaClient.Models.AssistantToolsCode();
                }
                else if("AssistantToolsFunction".Equals(mappingValue, StringComparison.OrdinalIgnoreCase)) {
                    result.AssistantToolsFunction = new OpenAI.GeneratedKiotaClient.Models.AssistantToolsFunction();
                }
                else if("AssistantToolsRetrieval".Equals(mappingValue, StringComparison.OrdinalIgnoreCase)) {
                    result.AssistantToolsRetrieval = new OpenAI.GeneratedKiotaClient.Models.AssistantToolsRetrieval();
                }
                return result;
            }
            /// <summary>
            /// The deserialization information for the current model
            /// </summary>
            public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
                if(AssistantToolsCode != null) {
                    return AssistantToolsCode.GetFieldDeserializers();
                }
                else if(AssistantToolsFunction != null) {
                    return AssistantToolsFunction.GetFieldDeserializers();
                }
                else if(AssistantToolsRetrieval != null) {
                    return AssistantToolsRetrieval.GetFieldDeserializers();
                }
                return new Dictionary<string, Action<IParseNode>>();
            }
            /// <summary>
            /// Serializes information the current object
            /// </summary>
            /// <param name="writer">Serialization writer to use to serialize this model</param>
            public virtual void Serialize(ISerializationWriter writer) {
                _ = writer ?? throw new ArgumentNullException(nameof(writer));
                if(AssistantToolsCode != null) {
                    writer.WriteObjectValue<OpenAI.GeneratedKiotaClient.Models.AssistantToolsCode>(null, AssistantToolsCode);
                }
                else if(AssistantToolsFunction != null) {
                    writer.WriteObjectValue<OpenAI.GeneratedKiotaClient.Models.AssistantToolsFunction>(null, AssistantToolsFunction);
                }
                else if(AssistantToolsRetrieval != null) {
                    writer.WriteObjectValue<OpenAI.GeneratedKiotaClient.Models.AssistantToolsRetrieval>(null, AssistantToolsRetrieval);
                }
            }
        }
    }
}

