// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    /// <summary>
    /// The `File` object represents a document that has been uploaded to OpenAI.
    /// </summary>
    internal class OpenAIFile : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>The size of the file, in bytes.</summary>
        public int? Bytes { get; set; }
        /// <summary>The Unix timestamp (in seconds) for when the file was created.</summary>
        public int? CreatedAt { get; set; }
        /// <summary>The name of the file.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Filename { get; set; }
#nullable restore
#else
        public string Filename { get; set; }
#endif
        /// <summary>The file identifier, which can be referenced in the API endpoints.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Id { get; set; }
#nullable restore
#else
        public string Id { get; set; }
#endif
        /// <summary>The object type, which is always `file`.</summary>
        public OpenAIFile_object? Object { get; set; }
        /// <summary>The intended purpose of the file. Supported values are `fine-tune`, `fine-tune-results`, `assistants`, and `assistants_output`.</summary>
        public OpenAIFile_purpose? Purpose { get; set; }
        /// <summary>Deprecated. The current status of the file, which can be either `uploaded`, `processed`, or `error`.</summary>
        [Obsolete("")]
        public OpenAIFile_status? Status { get; set; }
        /// <summary>Deprecated. For details on why a fine-tuning training file failed validation, see the `error` field on `fine_tuning.job`.</summary>
        [Obsolete("")]
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? StatusDetails { get; set; }
#nullable restore
#else
        public string StatusDetails { get; set; }
#endif
        /// <summary>
        /// Instantiates a new OpenAIFile and sets the default values.
        /// </summary>
        public OpenAIFile() {
            AdditionalData = new Dictionary<string, object>();
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static OpenAIFile CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new OpenAIFile();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"bytes", n => { Bytes = n.GetIntValue(); } },
                {"created_at", n => { CreatedAt = n.GetIntValue(); } },
                {"filename", n => { Filename = n.GetStringValue(); } },
                {"id", n => { Id = n.GetStringValue(); } },
                {"object", n => { Object = n.GetEnumValue<OpenAIFile_object>(); } },
                {"purpose", n => { Purpose = n.GetEnumValue<OpenAIFile_purpose>(); } },
                {"status", n => { Status = n.GetEnumValue<OpenAIFile_status>(); } },
                {"status_details", n => { StatusDetails = n.GetStringValue(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteIntValue("bytes", Bytes);
            writer.WriteIntValue("created_at", CreatedAt);
            writer.WriteStringValue("filename", Filename);
            writer.WriteStringValue("id", Id);
            writer.WriteEnumValue<OpenAIFile_object>("object", Object);
            writer.WriteEnumValue<OpenAIFile_purpose>("purpose", Purpose);
            writer.WriteEnumValue<OpenAIFile_status>("status", Status);
            writer.WriteStringValue("status_details", StatusDetails);
            writer.WriteAdditionalData(AdditionalData);
        }
    }
}

