// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    /// <summary>
    /// Describes an OpenAI model offering that can be used with the API.
    /// </summary>
    internal class Model : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>The Unix timestamp (in seconds) when the model was created.</summary>
        public int? Created { get; set; }
        /// <summary>The model identifier, which can be referenced in the API endpoints.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Id { get; set; }
#nullable restore
#else
        public string Id { get; set; }
#endif
        /// <summary>The object type, which is always &quot;model&quot;.</summary>
        public Model_object? Object { get; set; }
        /// <summary>The organization that owns the model.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? OwnedBy { get; set; }
#nullable restore
#else
        public string OwnedBy { get; set; }
#endif
        /// <summary>
        /// Instantiates a new Model and sets the default values.
        /// </summary>
        public Model() {
            AdditionalData = new Dictionary<string, object>();
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static Model CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new Model();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"created", n => { Created = n.GetIntValue(); } },
                {"id", n => { Id = n.GetStringValue(); } },
                {"object", n => { Object = n.GetEnumValue<Model_object>(); } },
                {"owned_by", n => { OwnedBy = n.GetStringValue(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteIntValue("created", Created);
            writer.WriteStringValue("id", Id);
            writer.WriteEnumValue<Model_object>("object", Object);
            writer.WriteStringValue("owned_by", OwnedBy);
            writer.WriteAdditionalData(AdditionalData);
        }
    }
}

