// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    /// <summary>
    /// Represents a message within a [thread](/docs/api-reference/threads).
    /// </summary>
    internal class MessageObject : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>If applicable, the ID of the [assistant](/docs/api-reference/assistants) that authored this message.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? AssistantId { get; set; }
#nullable restore
#else
        public string AssistantId { get; set; }
#endif
        /// <summary>The content of the message in array of text and/or images.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<MessageObject_content>? Content { get; set; }
#nullable restore
#else
        public List<MessageObject_content> Content { get; set; }
#endif
        /// <summary>The Unix timestamp (in seconds) for when the message was created.</summary>
        public int? CreatedAt { get; set; }
        /// <summary>A list of [file](/docs/api-reference/files) IDs that the assistant should use. Useful for tools like retrieval and code_interpreter that can access files. A maximum of 10 files can be attached to a message.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<string>? FileIds { get; set; }
#nullable restore
#else
        public List<string> FileIds { get; set; }
#endif
        /// <summary>The identifier, which can be referenced in API endpoints.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Id { get; set; }
#nullable restore
#else
        public string Id { get; set; }
#endif
        /// <summary>Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public MessageObject_metadata? Metadata { get; set; }
#nullable restore
#else
        public MessageObject_metadata Metadata { get; set; }
#endif
        /// <summary>The object type, which is always `thread.message`.</summary>
        public MessageObject_object? Object { get; set; }
        /// <summary>The entity that produced the message. One of `user` or `assistant`.</summary>
        public MessageObject_role? Role { get; set; }
        /// <summary>If applicable, the ID of the [run](/docs/api-reference/runs) associated with the authoring of this message.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? RunId { get; set; }
#nullable restore
#else
        public string RunId { get; set; }
#endif
        /// <summary>The [thread](/docs/api-reference/threads) ID that this message belongs to.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? ThreadId { get; set; }
#nullable restore
#else
        public string ThreadId { get; set; }
#endif
        /// <summary>
        /// Instantiates a new MessageObject and sets the default values.
        /// </summary>
        public MessageObject() {
            AdditionalData = new Dictionary<string, object>();
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static MessageObject CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new MessageObject();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"assistant_id", n => { AssistantId = n.GetStringValue(); } },
                {"content", n => { Content = n.GetCollectionOfObjectValues<MessageObject_content>(MessageObject_content.CreateFromDiscriminatorValue)?.ToList(); } },
                {"created_at", n => { CreatedAt = n.GetIntValue(); } },
                {"file_ids", n => { FileIds = n.GetCollectionOfPrimitiveValues<string>()?.ToList(); } },
                {"id", n => { Id = n.GetStringValue(); } },
                {"metadata", n => { Metadata = n.GetObjectValue<MessageObject_metadata>(MessageObject_metadata.CreateFromDiscriminatorValue); } },
                {"object", n => { Object = n.GetEnumValue<MessageObject_object>(); } },
                {"role", n => { Role = n.GetEnumValue<MessageObject_role>(); } },
                {"run_id", n => { RunId = n.GetStringValue(); } },
                {"thread_id", n => { ThreadId = n.GetStringValue(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteStringValue("assistant_id", AssistantId);
            writer.WriteCollectionOfObjectValues<MessageObject_content>("content", Content);
            writer.WriteIntValue("created_at", CreatedAt);
            writer.WriteCollectionOfPrimitiveValues<string>("file_ids", FileIds);
            writer.WriteStringValue("id", Id);
            writer.WriteObjectValue<MessageObject_metadata>("metadata", Metadata);
            writer.WriteEnumValue<MessageObject_object>("object", Object);
            writer.WriteEnumValue<MessageObject_role>("role", Role);
            writer.WriteStringValue("run_id", RunId);
            writer.WriteStringValue("thread_id", ThreadId);
            writer.WriteAdditionalData(AdditionalData);
        }
        /// <summary>
        /// Composed type wrapper for classes MessageContentImageFileObject, MessageContentTextObject
        /// </summary>
        internal class MessageObject_content : IComposedTypeWrapper, IParsable {
            /// <summary>Composed type representation for type MessageContentImageFileObject</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public OpenAI.GeneratedKiotaClient.Models.MessageContentImageFileObject? MessageContentImageFileObject { get; set; }
#nullable restore
#else
            public OpenAI.GeneratedKiotaClient.Models.MessageContentImageFileObject MessageContentImageFileObject { get; set; }
#endif
            /// <summary>Composed type representation for type MessageContentTextObject</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public OpenAI.GeneratedKiotaClient.Models.MessageContentTextObject? MessageContentTextObject { get; set; }
#nullable restore
#else
            public OpenAI.GeneratedKiotaClient.Models.MessageContentTextObject MessageContentTextObject { get; set; }
#endif
            /// <summary>
            /// Creates a new instance of the appropriate class based on discriminator value
            /// </summary>
            /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
            public static MessageObject_content CreateFromDiscriminatorValue(IParseNode parseNode) {
                _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
                var mappingValue = parseNode.GetChildNode("")?.GetStringValue();
                var result = new MessageObject_content();
                if("MessageContentImageFileObject".Equals(mappingValue, StringComparison.OrdinalIgnoreCase)) {
                    result.MessageContentImageFileObject = new OpenAI.GeneratedKiotaClient.Models.MessageContentImageFileObject();
                }
                else if("MessageContentTextObject".Equals(mappingValue, StringComparison.OrdinalIgnoreCase)) {
                    result.MessageContentTextObject = new OpenAI.GeneratedKiotaClient.Models.MessageContentTextObject();
                }
                return result;
            }
            /// <summary>
            /// The deserialization information for the current model
            /// </summary>
            public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
                if(MessageContentImageFileObject != null) {
                    return MessageContentImageFileObject.GetFieldDeserializers();
                }
                else if(MessageContentTextObject != null) {
                    return MessageContentTextObject.GetFieldDeserializers();
                }
                return new Dictionary<string, Action<IParseNode>>();
            }
            /// <summary>
            /// Serializes information the current object
            /// </summary>
            /// <param name="writer">Serialization writer to use to serialize this model</param>
            public virtual void Serialize(ISerializationWriter writer) {
                _ = writer ?? throw new ArgumentNullException(nameof(writer));
                if(MessageContentImageFileObject != null) {
                    writer.WriteObjectValue<OpenAI.GeneratedKiotaClient.Models.MessageContentImageFileObject>(null, MessageContentImageFileObject);
                }
                else if(MessageContentTextObject != null) {
                    writer.WriteObjectValue<OpenAI.GeneratedKiotaClient.Models.MessageContentTextObject>(null, MessageContentTextObject);
                }
            }
        }
    }
}

