// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    /// <summary>
    /// The `fine_tuning.job` object represents a fine-tuning job that has been created through the API.
    /// </summary>
    internal class FineTuningJob : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>The Unix timestamp (in seconds) for when the fine-tuning job was created.</summary>
        public int? CreatedAt { get; set; }
        /// <summary>For fine-tuning jobs that have `failed`, this will contain more information on the cause of the failure.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public FineTuningJob_error? Error { get; set; }
#nullable restore
#else
        public FineTuningJob_error Error { get; set; }
#endif
        /// <summary>The name of the fine-tuned model that is being created. The value will be null if the fine-tuning job is still running.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? FineTunedModel { get; set; }
#nullable restore
#else
        public string FineTunedModel { get; set; }
#endif
        /// <summary>The Unix timestamp (in seconds) for when the fine-tuning job was finished. The value will be null if the fine-tuning job is still running.</summary>
        public int? FinishedAt { get; set; }
        /// <summary>The hyperparameters used for the fine-tuning job. See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public FineTuningJob_hyperparameters? Hyperparameters { get; set; }
#nullable restore
#else
        public FineTuningJob_hyperparameters Hyperparameters { get; set; }
#endif
        /// <summary>The object identifier, which can be referenced in the API endpoints.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Id { get; set; }
#nullable restore
#else
        public string Id { get; set; }
#endif
        /// <summary>The base model that is being fine-tuned.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Model { get; set; }
#nullable restore
#else
        public string Model { get; set; }
#endif
        /// <summary>The object type, which is always &quot;fine_tuning.job&quot;.</summary>
        public FineTuningJob_object? Object { get; set; }
        /// <summary>The organization that owns the fine-tuning job.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? OrganizationId { get; set; }
#nullable restore
#else
        public string OrganizationId { get; set; }
#endif
        /// <summary>The compiled results file ID(s) for the fine-tuning job. You can retrieve the results with the [Files API](/docs/api-reference/files/retrieve-contents).</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<string>? ResultFiles { get; set; }
#nullable restore
#else
        public List<string> ResultFiles { get; set; }
#endif
        /// <summary>The current status of the fine-tuning job, which can be either `validating_files`, `queued`, `running`, `succeeded`, `failed`, or `cancelled`.</summary>
        public FineTuningJob_status? Status { get; set; }
        /// <summary>The total number of billable tokens processed by this fine-tuning job. The value will be null if the fine-tuning job is still running.</summary>
        public int? TrainedTokens { get; set; }
        /// <summary>The file ID used for training. You can retrieve the training data with the [Files API](/docs/api-reference/files/retrieve-contents).</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? TrainingFile { get; set; }
#nullable restore
#else
        public string TrainingFile { get; set; }
#endif
        /// <summary>The file ID used for validation. You can retrieve the validation results with the [Files API](/docs/api-reference/files/retrieve-contents).</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? ValidationFile { get; set; }
#nullable restore
#else
        public string ValidationFile { get; set; }
#endif
        /// <summary>
        /// Instantiates a new FineTuningJob and sets the default values.
        /// </summary>
        public FineTuningJob() {
            AdditionalData = new Dictionary<string, object>();
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static FineTuningJob CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new FineTuningJob();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"created_at", n => { CreatedAt = n.GetIntValue(); } },
                {"error", n => { Error = n.GetObjectValue<FineTuningJob_error>(FineTuningJob_error.CreateFromDiscriminatorValue); } },
                {"fine_tuned_model", n => { FineTunedModel = n.GetStringValue(); } },
                {"finished_at", n => { FinishedAt = n.GetIntValue(); } },
                {"hyperparameters", n => { Hyperparameters = n.GetObjectValue<FineTuningJob_hyperparameters>(FineTuningJob_hyperparameters.CreateFromDiscriminatorValue); } },
                {"id", n => { Id = n.GetStringValue(); } },
                {"model", n => { Model = n.GetStringValue(); } },
                {"object", n => { Object = n.GetEnumValue<FineTuningJob_object>(); } },
                {"organization_id", n => { OrganizationId = n.GetStringValue(); } },
                {"result_files", n => { ResultFiles = n.GetCollectionOfPrimitiveValues<string>()?.ToList(); } },
                {"status", n => { Status = n.GetEnumValue<FineTuningJob_status>(); } },
                {"trained_tokens", n => { TrainedTokens = n.GetIntValue(); } },
                {"training_file", n => { TrainingFile = n.GetStringValue(); } },
                {"validation_file", n => { ValidationFile = n.GetStringValue(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteIntValue("created_at", CreatedAt);
            writer.WriteObjectValue<FineTuningJob_error>("error", Error);
            writer.WriteStringValue("fine_tuned_model", FineTunedModel);
            writer.WriteIntValue("finished_at", FinishedAt);
            writer.WriteObjectValue<FineTuningJob_hyperparameters>("hyperparameters", Hyperparameters);
            writer.WriteStringValue("id", Id);
            writer.WriteStringValue("model", Model);
            writer.WriteEnumValue<FineTuningJob_object>("object", Object);
            writer.WriteStringValue("organization_id", OrganizationId);
            writer.WriteCollectionOfPrimitiveValues<string>("result_files", ResultFiles);
            writer.WriteEnumValue<FineTuningJob_status>("status", Status);
            writer.WriteIntValue("trained_tokens", TrainedTokens);
            writer.WriteStringValue("training_file", TrainingFile);
            writer.WriteStringValue("validation_file", ValidationFile);
            writer.WriteAdditionalData(AdditionalData);
        }
    }
}

